/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.server.business;

import ch.systemsx.cisd.cifex.rpc.server.SessionManager;
import ch.systemsx.cisd.cifex.server.business.IUserSessionInvalidator;
import ch.systemsx.cisd.cifex.server.business.dto.UserDTO;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class UserHttpSessionHolder
implements IUserSessionInvalidator {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, UserHttpSessionHolder.class);
    public static final String USER_SESSION_HOLDER_BEAN_NAME = "user-session-holder";
    private final Map<HttpSession, Object> activeSessions;
    private final SessionManager rpcSessionManager;
    private boolean isInvalidating;

    public UserHttpSessionHolder(SessionManager rpcSessionManager) {
        this.rpcSessionManager = rpcSessionManager;
        this.activeSessions = new WeakHashMap<HttpSession, Object>();
    }

    public final synchronized void addUserSession(HttpSession session) {
        assert (session != null) : "Unspecified HTTP session";
        this.activeSessions.put(session, ObjectUtils.NULL);
    }

    public final synchronized void removeUserSession(HttpSession session) {
        assert (session != null) : "Unspecified HTTP session";
        if (!this.isInvalidating) {
            this.activeSessions.remove(session);
        }
    }

    @Override
    public final synchronized void invalidateSessionWithUser(UserDTO userDTO) {
        assert (userDTO != null) : "Unspecified user";
        this.isInvalidating = true;
        Iterator<HttpSession> iterator = this.activeSessions.keySet().iterator();
        while (iterator.hasNext()) {
            HttpSession httpSession = iterator.next();
            try {
                UserDTO user = (UserDTO)httpSession.getAttribute("cifex-user");
                if (user == null || !user.getID().equals(userDTO.getID())) continue;
                httpSession.invalidate();
                iterator.remove();
                if (!operationLog.isInfoEnabled()) continue;
                String fullName = user.getUserFullName();
                String description = StringUtils.isBlank((String)fullName) ? user.getUserCode() : fullName;
                description = String.valueOf(description) + " <" + user.getEmail() + ">";
                operationLog.info((Object)("Currently logged in user [" + description + "] has been logged out."));
            }
            catch (IllegalStateException illegalStateException) {
                iterator.remove();
            }
        }
        this.rpcSessionManager.removeSessionsForUser(userDTO.getUserCode());
        this.isInvalidating = false;
    }
}

