/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.server.business;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.authentication.IAuthenticationService;
import ch.systemsx.cisd.authentication.NullAuthenticationService;
import ch.systemsx.cisd.authentication.Principal;
import ch.systemsx.cisd.cifex.server.business.AbstractManager;
import ch.systemsx.cisd.cifex.server.business.EMailBuilderForNewUser;
import ch.systemsx.cisd.cifex.server.business.IBusinessContext;
import ch.systemsx.cisd.cifex.server.business.IUserActionLog;
import ch.systemsx.cisd.cifex.server.business.IUserManager;
import ch.systemsx.cisd.cifex.server.business.UserUtils;
import ch.systemsx.cisd.cifex.server.business.bo.IBusinessObjectFactory;
import ch.systemsx.cisd.cifex.server.business.bo.IUserBO;
import ch.systemsx.cisd.cifex.server.business.dataaccess.IDAOFactory;
import ch.systemsx.cisd.cifex.server.business.dataaccess.IUserDAO;
import ch.systemsx.cisd.cifex.server.business.dto.UserDTO;
import ch.systemsx.cisd.cifex.server.business.exception.ExternalAuthenticationServiceNotConfiguredForExternalUsersException;
import ch.systemsx.cisd.cifex.server.business.exception.ExternalUserNotFoundInExternalAuthenticationServiceException;
import ch.systemsx.cisd.cifex.server.business.exception.UserNotFoundException;
import ch.systemsx.cisd.cifex.server.common.Password;
import ch.systemsx.cisd.common.collection.TableMap;
import ch.systemsx.cisd.common.collection.TableMapNonUniqueKey;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.security.PasswordGenerator;
import ch.systemsx.cisd.common.utilities.ITimeProvider;
import ch.systemsx.cisd.common.utilities.SystemTimeProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.transaction.annotation.Transactional;

class UserManager
extends AbstractManager
implements IUserManager {
    static final int PASSWORD_LENGTH = 20;
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, UserManager.class);
    private static final Logger notificationLog = LogFactory.getLogger((LogCategory)LogCategory.NOTIFY, UserManager.class);
    private final IAuthenticationService authenticationService;

    public UserManager(IDAOFactory daoFactory, IBusinessObjectFactory boFactory, IBusinessContext businessContext, IAuthenticationService authenticationService) {
        this(daoFactory, boFactory, businessContext, authenticationService, (ITimeProvider)SystemTimeProvider.SYSTEM_TIME_PROVIDER);
    }

    public UserManager(IDAOFactory daoFactory, IBusinessObjectFactory boFactory, IBusinessContext businessContext, IAuthenticationService authenticationService, ITimeProvider timeProvider) {
        super(daoFactory, boFactory, businessContext, timeProvider);
        assert (authenticationService != null);
        this.authenticationService = authenticationService;
    }

    private static final String getUserDescription(UserDTO user) {
        String fullName = user.getUserFullName();
        String description = StringUtils.isBlank((String)fullName) ? user.getUserCode() : fullName;
        description = String.valueOf(description) + " <" + user.getEmail() + ">";
        return description;
    }

    @Override
    @Transactional
    public final boolean isDatabaseEmpty() {
        return this.daoFactory.getUserDAO().getNumberOfUsers() == 0;
    }

    @Override
    @Transactional
    public final UserDTO tryFindUserByCode(String code) {
        assert (code != null) : "User Code is null!";
        UserDTO userOrNull = this.daoFactory.getUserDAO().tryFindUserByCode(code);
        this.fillInDefaultQuotaInformation(userOrNull);
        return userOrNull;
    }

    @Override
    public UserDTO getUser(long id) {
        try {
            UserDTO user = this.daoFactory.getUserDAO().getUserById(id);
            this.fillInDefaultQuotaInformation(user);
            return user;
        }
        catch (DataAccessException dataAccessException) {
            throw new IllegalArgumentException("User id=" + id + " not found in database.");
        }
    }

    @Override
    public List<UserDTO> findUserByEmail(String email) {
        assert (email != null) : "Given Email Address is null";
        List<UserDTO> users = this.daoFactory.getUserDAO().findUserByEmail(email.toLowerCase().toLowerCase());
        for (UserDTO user : users) {
            this.fillInDefaultQuotaInformation(user);
        }
        return users;
    }

    @Override
    @Transactional
    public final UserDTO createUser(UserDTO user, UserDTO registratorOrNull) throws UserFailureException {
        try {
            IUserBO userBO = this.boFactory.createUserBO();
            userBO.defineForCreate(user, registratorOrNull, false);
            userBO.save();
            return userBO.getUser();
        }
        catch (DataIntegrityViolationException ex) {
            Throwable rootCauseOrNull = ex.getRootCause();
            String msg = rootCauseOrNull != null && ex.getMessage().contains("value too long") ? "Cannot create user '" + user.getUserCode() + "': length constraint exceeded." : "Cannot create user '" + user.getUserCode() + "': user exists.";
            operationLog.error((Object)msg, (Throwable)ex);
            throw new UserFailureException(msg);
        }
    }

    @Override
    @Transactional
    public UserDTO createUserAndSendEmail(UserDTO user, String password, UserDTO registrator, String comment, String basicURL) throws UserFailureException, EnvironmentFailureException {
        String finalPassword = this.getFinalPassword(password);
        user.setPassword(new Password(finalPassword));
        UserDTO createdUser = this.createUser(user, registrator);
        this.sendEmailToNewUser(createdUser, registrator, comment, basicURL, finalPassword);
        return createdUser;
    }

    private void sendEmailToNewUser(UserDTO user, UserDTO registrator, String comment, String basicURL, String finalPassword) {
        if (StringUtils.isEmpty((String)user.getEmail())) {
            operationLog.warn((Object)String.format("Sending email to user '%s' not possible: email address is empty.", user));
            return;
        }
        try {
            EMailBuilderForNewUser builder = new EMailBuilderForNewUser(this.businessContext.getMailClient(), registrator, user);
            builder.setURL(this.getURLForEmail(basicURL));
            builder.setPassword(finalPassword);
            if (StringUtils.isNotBlank((String)comment)) {
                builder.setComment(comment);
            }
            builder.sendEMail();
        }
        catch (Exception ex) {
            String msg = "Sending email to email '" + user.getEmail() + "' failed: " + ex.getMessage();
            operationLog.error((Object)msg, (Throwable)ex);
            throw new EnvironmentFailureException(msg);
        }
    }

    private String getURLForEmail(String basicURL) {
        String overrideURL = this.businessContext.getOverrideURL();
        if (StringUtils.isBlank((String)overrideURL)) {
            return basicURL;
        }
        return overrideURL;
    }

    private String getFinalPassword(String password) {
        if (StringUtils.isBlank((String)password)) {
            PasswordGenerator passwordGenerator = this.businessContext.getPasswordGenerator();
            return passwordGenerator.generatePassword(20);
        }
        return password;
    }

    @Override
    @Transactional
    public final List<UserDTO> listUsers() {
        List<UserDTO> users = this.daoFactory.getUserDAO().listUsers();
        for (UserDTO user : users) {
            this.fillInDefaultQuotaInformation(user);
        }
        return users;
    }

    @Override
    @Transactional
    public void deleteExpiredUsers(IUserActionLog logOrNull) {
        IUserDAO userDAO = this.daoFactory.getUserDAO();
        List<UserDTO> expiredUsers = userDAO.listExpiredUsers();
        if (operationLog.isInfoEnabled() && expiredUsers.size() > 0) {
            operationLog.info((Object)("Found " + expiredUsers.size() + " expired users."));
        }
        RuntimeException firstExceptionOrNull = null;
        for (UserDTO user : expiredUsers) {
            try {
                boolean success = userDAO.deleteUser(user, null);
                if (success) {
                    this.businessContext.getUserSessionInvalidator().invalidateSessionWithUser(user);
                } else {
                    operationLog.warn((Object)("Expired user [" + UserManager.getUserDescription(user) + "] could not be found in the database."));
                }
                if (logOrNull == null) continue;
                logOrNull.logExpireUser(user, success);
            }
            catch (RuntimeException ex) {
                if (logOrNull != null) {
                    logOrNull.logExpireUser(user, false);
                }
                notificationLog.error((Object)("Error deleting user [" + UserManager.getUserDescription(user) + "]."), (Throwable)ex);
                if (firstExceptionOrNull != null) continue;
                firstExceptionOrNull = ex;
            }
        }
        if (firstExceptionOrNull != null) {
            throw firstExceptionOrNull;
        }
    }

    @Override
    @Transactional
    public final void deleteUser(long id, UserDTO requestUser, IUserActionLog logOrNull) throws IllegalArgumentException {
        UserDTO user = null;
        boolean success = false;
        try {
            try {
                IUserDAO userDAO = this.daoFactory.getUserDAO();
                user = userDAO.getUserById(id);
                success = userDAO.deleteUser(user, requestUser.getID());
                if (success) {
                    if (operationLog.isInfoEnabled()) {
                        operationLog.info((Object)("User [" + UserManager.getUserDescription(user) + "] deleted from user database."));
                    }
                    this.businessContext.getUserSessionInvalidator().invalidateSessionWithUser(user);
                } else {
                    operationLog.warn((Object)("Could not delete user [" + UserManager.getUserDescription(user) + "] from user database."));
                }
            }
            catch (DataAccessException dataAccessException) {
                String msg = String.format("Could not delete user id=%s (id not found)", id);
                operationLog.warn((Object)msg);
                throw new IllegalArgumentException(msg);
            }
        }
        finally {
            if (user != null && logOrNull != null) {
                logOrNull.logDeleteUser(user, success);
            }
        }
    }

    @Override
    @Transactional
    public final UserDTO updateUser(UserDTO userToUpdate, Password passwordOrNull, UserDTO requestUserOrNull, IUserActionLog logOrNull) throws UserFailureException, IllegalArgumentException {
        return this.updateUser(null, userToUpdate, passwordOrNull, requestUserOrNull, logOrNull);
    }

    @Override
    @Transactional
    public final UserDTO updateUser(UserDTO oldUserToUpdateOrNull, UserDTO userToUpdate, Password passwordOrNull, UserDTO requestUserOrNull, IUserActionLog logOrNull) throws UserFailureException, IllegalArgumentException {
        UserDTO userDTO;
        UserDTO existingUser;
        boolean success;
        block6: {
            assert (userToUpdate != null) : "Unspecified user";
            success = false;
            existingUser = null;
            try {
                IUserBO userBO = this.boFactory.createUserBO();
                userBO.defineForUpdate(oldUserToUpdateOrNull, userToUpdate, passwordOrNull, requestUserOrNull);
                existingUser = userBO.getOldUser();
                userBO.save();
                success = true;
                userDTO = userBO.getUser();
                if (existingUser != null) break block6;
                UserDTO userDTO2 = existingUser = oldUserToUpdateOrNull != null ? oldUserToUpdateOrNull : userToUpdate;
            }
            catch (Throwable throwable) {
                if (existingUser == null) {
                    UserDTO userDTO3 = existingUser = oldUserToUpdateOrNull != null ? oldUserToUpdateOrNull : userToUpdate;
                }
                if (logOrNull != null) {
                    logOrNull.logUpdateUser(existingUser, userToUpdate, success);
                }
                throw throwable;
            }
        }
        if (logOrNull != null) {
            logOrNull.logUpdateUser(existingUser, userToUpdate, success);
        }
        return userDTO;
    }

    @Override
    @Transactional
    public final List<UserDTO> listUsersRegisteredBy(long userId) {
        IUserDAO userDAO = this.daoFactory.getUserDAO();
        List<UserDTO> usersRegisteredBy = userDAO.listUsersRegisteredBy(userId);
        for (UserDTO user : usersRegisteredBy) {
            this.fillInDefaultQuotaInformation(user);
        }
        return usersRegisteredBy;
    }

    @Override
    @Transactional
    public List<UserDTO> listUsersFileSharedWith(long fileId) throws UserFailureException {
        IUserDAO userDAO = this.daoFactory.getUserDAO();
        return userDAO.listUsersFileSharedWith(fileId);
    }

    @Override
    @Transactional
    public void refreshQuotaInformation(UserDTO user) {
        IUserDAO userDAO = this.daoFactory.getUserDAO();
        userDAO.refreshQuotaInformation(user);
        this.fillInDefaultQuotaInformation(user);
    }

    private void fillInDefaultQuotaInformation(UserDTO userOrNull) {
        if (userOrNull == null) {
            return;
        }
        userOrNull.setCustomMaxFileRetention(userOrNull.getMaxFileRetention() != null);
        if (userOrNull.getMaxFileRetention() == null) {
            userOrNull.setMaxFileRetention(this.businessContext.getMaxFileRetention());
        }
        userOrNull.setCustomMaxUserRetention(userOrNull.getMaxUserRetention() != null);
        if (userOrNull.getMaxUserRetention() == null) {
            userOrNull.setMaxUserRetention(this.businessContext.getMaxUserRetention());
        }
        userOrNull.setCustomMaxFileCountPerQuotaGroup(userOrNull.getMaxFileCountPerQuotaGroup() != null);
        if (userOrNull.getMaxFileCountPerQuotaGroup() == null) {
            userOrNull.setMaxFileCountPerQuotaGroup(this.businessContext.getMaxFileCountPerQuotaGroup());
        } else if (userOrNull.getMaxFileCountPerQuotaGroup() <= 0) {
            userOrNull.setMaxFileCountPerQuotaGroup(null);
        }
        userOrNull.setCustomMaxFileSizePerQuotaGroup(userOrNull.getMaxFileSizePerQuotaGroupInMB() != null);
        if (userOrNull.getMaxFileSizePerQuotaGroupInMB() == null) {
            userOrNull.setMaxFileSizePerQuotaGroupInMB(this.businessContext.getMaxFileSizePerQuotaGroupInMB());
        } else if (userOrNull.getMaxFileSizePerQuotaGroupInMB() <= 0L) {
            userOrNull.setMaxFileSizePerQuotaGroupInMB(null);
        }
    }

    @Override
    @Transactional
    public boolean hasUserFilesForDownload(UserDTO user) {
        return this.daoFactory.getUserDAO().hasUserFilesForDownload(user.getID());
    }

    @Override
    @Transactional
    public void changeUserCode(String before, String after) throws UserFailureException {
        if (StringUtils.isBlank((String)before) || StringUtils.isBlank((String)after)) {
            throw new UserFailureException("User code cannot be empty.");
        }
        UserDTO oldUserOrNull = null;
        UserDTO newUserOrNull = null;
        IUserDAO userDAO = this.daoFactory.getUserDAO();
        oldUserOrNull = userDAO.tryFindUserByCode(before);
        if (oldUserOrNull == null) {
            throw new UserFailureException(String.format("User with code %s doesn't exist.", before));
        }
        if (oldUserOrNull.isExternallyAuthenticated()) {
            throw new UserFailureException(String.format("User with code %s is externally authenticated.", before));
        }
        newUserOrNull = userDAO.tryFindUserByCode(after);
        if (newUserOrNull != null) {
            throw new UserFailureException(String.format("User with code %s already exist.", before));
        }
        userDAO.changeUserCode(before, after);
    }

    @Override
    @Transactional
    public Collection<UserDTO> getUsers(List<String> userCodesOrNull, List<String> emailAddressesOrNull, IUserActionLog logOrNull) {
        Collection<UserDTO> usersByCodes = this.getUsersByCodes(userCodesOrNull, logOrNull);
        Collection<UserDTO> usersByEmails = this.getUsersByEmails(emailAddressesOrNull, logOrNull);
        LinkedHashSet<UserDTO> users = new LinkedHashSet<UserDTO>();
        users.addAll(usersByCodes);
        users.addAll(usersByEmails);
        return users;
    }

    private Collection<UserDTO> getUsersByCodes(List<String> userCodesOrNull, IUserActionLog logOrNull) {
        if (userCodesOrNull == null || userCodesOrNull.isEmpty()) {
            return new LinkedList<UserDTO>();
        }
        if (this.authenticationService instanceof NullAuthenticationService) {
            return this.getUsersByCodesWithNullAuthenticationService(userCodesOrNull, logOrNull);
        }
        return this.getUsersByCodesWithNotNullAuthenticationService(userCodesOrNull, logOrNull);
    }

    private Collection<UserDTO> getUsersByCodesWithNullAuthenticationService(List<String> userCodesOrNull, IUserActionLog logOrNull) {
        Collection<UserDTO> usersFromLocalDB = this.getUsersByCodesFromLocalDB(userCodesOrNull);
        TreeSet<String> externallyAuthenticatedUsersCodes = new TreeSet<String>();
        for (UserDTO userFromLocalDB : usersFromLocalDB) {
            if (!userFromLocalDB.isExternallyAuthenticated()) continue;
            externallyAuthenticatedUsersCodes.add(userFromLocalDB.getUserCode());
        }
        if (!externallyAuthenticatedUsersCodes.isEmpty()) {
            throw new ExternalAuthenticationServiceNotConfiguredForExternalUsersException(externallyAuthenticatedUsersCodes);
        }
        return usersFromLocalDB;
    }

    private Collection<UserDTO> getUsersByCodesWithNotNullAuthenticationService(List<String> userCodesOrNull, IUserActionLog logOrNull) {
        LinkedHashSet<UserDTO> users = new LinkedHashSet<UserDTO>();
        Collection<UserDTO> usersFromLocalDB = this.getUsersByCodesFromLocalDB(userCodesOrNull);
        TableMap<String, UserDTO> usersFromLocalDBMap = null;
        if (usersFromLocalDB != null && !usersFromLocalDB.isEmpty()) {
            usersFromLocalDBMap = UserUtils.createTableMapOfExistingUsersWithUserCodeAsKey(usersFromLocalDB);
        }
        for (String userCode : userCodesOrNull) {
            UserDTO userFromLocalDB;
            UserDTO userDTO = userFromLocalDB = usersFromLocalDBMap != null ? (UserDTO)usersFromLocalDBMap.tryGet((Object)userCode) : null;
            if (userFromLocalDB != null) {
                this.addModifiedUser(users, userFromLocalDB, null);
                continue;
            }
            UserDTO userFromExternalAuthenticationService = this.getUserByCodeFromExternalAuthenticationService(userCode);
            if (userFromExternalAuthenticationService != null) {
                UserDTO newUser = this.createLocalUserFromExternalUser(userFromExternalAuthenticationService, logOrNull);
                users.add(newUser);
                continue;
            }
            throw new UserNotFoundException(userCode);
        }
        return users;
    }

    private Collection<UserDTO> getUsersByEmails(List<String> emailAddressesOrNull, IUserActionLog logOrNull) {
        if (emailAddressesOrNull == null || emailAddressesOrNull.isEmpty()) {
            return new LinkedList<UserDTO>();
        }
        if (this.authenticationService instanceof NullAuthenticationService) {
            return this.getUsersByEmailsWithNullAuthenticationService(emailAddressesOrNull, logOrNull);
        }
        return this.getUsersByEmailsWithNotNullAuthenticationService(emailAddressesOrNull, logOrNull);
    }

    private Collection<UserDTO> getUsersByEmailsWithNullAuthenticationService(List<String> emailAddressesOrNull, IUserActionLog logOrNull) {
        Collection<UserDTO> usersFromLocalDB = this.getUsersByEmailsFromLocalDB(emailAddressesOrNull);
        TreeSet<String> externallyAuthenticatedUsersCodes = new TreeSet<String>();
        for (UserDTO userFromLocalDB : usersFromLocalDB) {
            if (!userFromLocalDB.isExternallyAuthenticated()) continue;
            externallyAuthenticatedUsersCodes.add(userFromLocalDB.getUserCode());
        }
        if (!externallyAuthenticatedUsersCodes.isEmpty()) {
            throw new ExternalAuthenticationServiceNotConfiguredForExternalUsersException(externallyAuthenticatedUsersCodes);
        }
        return usersFromLocalDB;
    }

    private Collection<UserDTO> getUsersByEmailsWithNotNullAuthenticationService(List<String> emailAddressesOrNull, IUserActionLog logOrNull) {
        LinkedHashSet<UserDTO> users = new LinkedHashSet<UserDTO>();
        Collection<UserDTO> usersFromLocalDB = this.getUsersByEmailsFromLocalDB(emailAddressesOrNull);
        TableMapNonUniqueKey<String, UserDTO> usersFromLocalDBMap = null;
        if (usersFromLocalDB != null && !usersFromLocalDB.isEmpty()) {
            usersFromLocalDBMap = UserUtils.createTableMapOfExistingUsersWithEmailAsKey(usersFromLocalDB);
        }
        for (String emailAddress : emailAddressesOrNull) {
            Set usersFromLocalDBForEmail;
            Set set = usersFromLocalDBForEmail = usersFromLocalDBMap != null ? usersFromLocalDBMap.tryGet((Object)emailAddress) : null;
            if (usersFromLocalDBForEmail == null || usersFromLocalDBForEmail.isEmpty()) {
                UserDTO userFromExternalAuthenticationService = this.getUserByEmailFromExternalAuthenticationService(emailAddress);
                if (userFromExternalAuthenticationService == null) continue;
                this.setEmailAliasIfEmailNotEquals(userFromExternalAuthenticationService, emailAddress);
                Collection<UserDTO> usersFromLocalDBForCode = this.getUsersByCodesFromLocalDB(Collections.singletonList(userFromExternalAuthenticationService.getUserCode()));
                if (usersFromLocalDBForCode == null || usersFromLocalDBForCode.isEmpty()) {
                    UserDTO newUser = this.createLocalUserFromExternalUser(userFromExternalAuthenticationService, logOrNull);
                    users.add(newUser);
                    continue;
                }
                UserDTO userFromLocalDBForCode = usersFromLocalDBForCode.iterator().next();
                this.mergeLocalAndExternalUsers(userFromLocalDBForCode, userFromExternalAuthenticationService);
                users.add(userFromLocalDBForCode);
                continue;
            }
            for (UserDTO userFromLocalDBForEmail : usersFromLocalDBForEmail) {
                this.addModifiedUser(users, userFromLocalDBForEmail, emailAddress);
            }
        }
        return users;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addModifiedUser(LinkedHashSet<UserDTO> users, UserDTO user, String emailAliasOrNull) {
        if (user.isExternallyAuthenticated()) {
            UserDTO userFromExternalAuthenticationService = this.getUserByCodeFromExternalAuthenticationService(user.getUserCode());
            if (userFromExternalAuthenticationService == null) throw new ExternalUserNotFoundInExternalAuthenticationServiceException(user.getUserCode());
            this.setEmailAliasIfEmailNotEquals(userFromExternalAuthenticationService, emailAliasOrNull);
            this.mergeLocalAndExternalUsers(user, userFromExternalAuthenticationService);
            users.add(user);
            return;
        } else {
            users.add(user);
        }
    }

    private Collection<UserDTO> getUsersByCodesFromLocalDB(List<String> userCodes) {
        return this.daoFactory.getUserDAO().listUsersByCode(userCodes.toArray(new String[userCodes.size()]));
    }

    private Collection<UserDTO> getUsersByEmailsFromLocalDB(List<String> emailAddresses) {
        return this.daoFactory.getUserDAO().listUsersByEmail(emailAddresses.toArray(new String[emailAddresses.size()]));
    }

    private UserDTO getUserByCodeFromExternalAuthenticationService(String userCode) {
        return this.asUserOrNull(this.authenticationService.tryGetAndAuthenticateUser(userCode, null));
    }

    private UserDTO getUserByEmailFromExternalAuthenticationService(String emailAddress) {
        if (!this.authenticationService.supportsListingByEmail()) {
            return null;
        }
        return this.asUserOrNull(this.authenticationService.tryGetAndAuthenticateUserByEmail(emailAddress, null));
    }

    private void setEmailAliasIfEmailNotEquals(UserDTO userFromExternalAuthenticationService, String emailAddress) {
        if (emailAddress != null && !emailAddress.equals(userFromExternalAuthenticationService.getEmail())) {
            userFromExternalAuthenticationService.setEmailAlias(emailAddress);
        }
    }

    private void mergeLocalAndExternalUsers(UserDTO localUser, UserDTO externalUser) {
        localUser.setUserFullName(externalUser.getUserFullName());
        localUser.setEmail(externalUser.getEmail());
        localUser.setEmailAlias(externalUser.getEmailAlias());
    }

    private UserDTO createLocalUserFromExternalUser(UserDTO externalUser, IUserActionLog logOrNull) {
        UserDTO newUser = null;
        boolean success = false;
        try {
            newUser = this.createUser(externalUser, null);
            this.mergeLocalAndExternalUsers(newUser, externalUser);
            success = true;
        }
        finally {
            if (logOrNull != null) {
                logOrNull.logCreateUser(newUser, success);
            }
        }
        return newUser;
    }

    private UserDTO asUserOrNull(Principal principalOrNull) {
        if (principalOrNull == null) {
            return null;
        }
        return UserManager.createExternalUser(principalOrNull.getUserId(), UserUtils.extractDisplayName(principalOrNull), principalOrNull.getEmail(), this.businessContext.isNewExternallyAuthenticatedUserStartActive());
    }

    @Private
    static UserDTO createExternalUser(String code, String displayName, String email, boolean isNewExternallyAuthenticatedUserStartActive) {
        UserDTO userDTO = new UserDTO();
        userDTO.setUserCode(code);
        userDTO.setUserFullName(displayName);
        userDTO.setEmail(email);
        userDTO.setPassword(null);
        userDTO.setExternallyAuthenticated(true);
        userDTO.setAdmin(false);
        userDTO.setActive(isNewExternallyAuthenticatedUserStartActive);
        return userDTO;
    }

    @Private
    static UserDTO createLocalUser(String code, String displayName, String email) {
        UserDTO userDTO = new UserDTO();
        userDTO.setUserCode(code);
        userDTO.setUserFullName(displayName);
        userDTO.setEmail(email);
        userDTO.setPassword(null);
        userDTO.setExternallyAuthenticated(false);
        userDTO.setAdmin(false);
        return userDTO;
    }
}

