/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.server.business;

import ch.systemsx.cisd.authentication.Principal;
import ch.systemsx.cisd.cifex.server.business.dto.UserDTO;
import ch.systemsx.cisd.cifex.shared.basic.Constants;
import ch.systemsx.cisd.common.collection.IKeyExtractor;
import ch.systemsx.cisd.common.collection.IMultiKeyExtractor;
import ch.systemsx.cisd.common.collection.TableMap;
import ch.systemsx.cisd.common.collection.TableMapNonUniqueKey;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;

public class UserUtils {
    static final Pattern USER_CODE_WITH_ID_PREFIX_PATTERN = Pattern.compile(Constants.USER_CODE_WITH_ID_PREFIX_REGEX, 2);
    static final Pattern EMAIL_PATTERN = Pattern.compile("^([a-zA-Z0-9_\\.\\-])+\\@(([a-zA-Z0-9\\-])+\\.)+([a-zA-Z0-9]{2,4})+$");
    static final String USER_ID_PREFIX = "id:";
    private static final String DISPLAY_NAME_PROPERTY = "displayName";

    static TableMap<String, UserDTO> createTableMapOfExistingUsersWithUserCodeAsKey(Collection<UserDTO> users) {
        return new TableMap(users, (IKeyExtractor)new IKeyExtractor<String, UserDTO>(){

            public String getKey(UserDTO user) {
                return user.getUserCode();
            }
        });
    }

    static TableMapNonUniqueKey<String, UserDTO> createTableMapOfExistingUsersWithEmailAsKey(Collection<UserDTO> users) {
        return new TableMapNonUniqueKey(users, (IMultiKeyExtractor)new IMultiKeyExtractor<String, UserDTO>(){

            public Collection<String> getKey(UserDTO user) {
                if (user.getEmailAlias() == null) {
                    return Collections.singleton(user.getEmail());
                }
                return Arrays.asList(user.getEmail(), user.getEmailAlias());
            }
        });
    }

    static boolean isUserCodeWithIdPrefix(String identifier) {
        return USER_CODE_WITH_ID_PREFIX_PATTERN.matcher(identifier).matches();
    }

    static boolean isEmail(String identifier) {
        return EMAIL_PATTERN.matcher(identifier).matches();
    }

    static String extractUserCode(String lowerCaseIdentifier) {
        assert (UserUtils.isUserCodeWithIdPrefix(lowerCaseIdentifier));
        return lowerCaseIdentifier.substring(USER_ID_PREFIX.length());
    }

    public static String extractDisplayName(Principal principal) {
        String displayName = principal.getProperty(DISPLAY_NAME_PROPERTY) != null ? principal.getProperty(DISPLAY_NAME_PROPERTY) : String.valueOf(principal.getFirstName()) + " " + principal.getLastName();
        return displayName;
    }
}

