/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.server.business.dataaccess.db;

import ch.systemsx.cisd.cifex.server.business.dataaccess.IDAOFactory;
import ch.systemsx.cisd.cifex.server.business.dataaccess.IFileDAO;
import ch.systemsx.cisd.cifex.server.business.dataaccess.IUserDAO;
import ch.systemsx.cisd.cifex.server.business.dataaccess.db.FileDAO;
import ch.systemsx.cisd.cifex.server.business.dataaccess.db.UserDAO;
import ch.systemsx.cisd.common.db.ISequencerHandler;
import ch.systemsx.cisd.dbmigration.DBMigrationEngine;
import ch.systemsx.cisd.dbmigration.DatabaseConfigurationContext;
import ch.systemsx.cisd.dbmigration.DatabaseEngine;
import javax.sql.DataSource;

public class DAOFactory
implements IDAOFactory {
    public static final String DATABASE_VERSION = "013";
    private final IUserDAO userDAO;
    private final IFileDAO fileDAO;

    public DAOFactory(DatabaseConfigurationContext context) {
        DBMigrationEngine.createOrMigrateDatabaseAndGetScriptProvider((DatabaseConfigurationContext)context, (String)DATABASE_VERSION);
        DataSource dataSource = context.getDataSource();
        ISequencerHandler sequencerHandler = context.getSequencerHandler();
        boolean supportsAnyOperator = !DatabaseEngine.H2.equals((Object)context.getDatabaseEngine());
        this.userDAO = new UserDAO(dataSource, sequencerHandler, supportsAnyOperator);
        this.fileDAO = new FileDAO(dataSource, sequencerHandler, supportsAnyOperator);
    }

    @Override
    public final IUserDAO getUserDAO() {
        return this.userDAO;
    }

    @Override
    public IFileDAO getFileDAO() {
        return this.fileDAO;
    }
}

