/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.server.business.dataaccess.db;

import ch.systemsx.cisd.cifex.server.business.dataaccess.IUserDAO;
import ch.systemsx.cisd.cifex.server.business.dataaccess.db.AbstractDAO;
import ch.systemsx.cisd.cifex.server.business.dataaccess.db.SimpleSQLLongArray;
import ch.systemsx.cisd.cifex.server.business.dataaccess.db.SimpleSQLStringArray;
import ch.systemsx.cisd.cifex.server.business.dto.UserDTO;
import ch.systemsx.cisd.cifex.server.common.Password;
import ch.systemsx.cisd.common.db.DBUtils;
import ch.systemsx.cisd.common.db.ISequencerHandler;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

final class UserDAO
extends AbstractDAO
implements IUserDAO {
    private static final String SELECT_USERS_WITH_QUOTA_INFO = "select u.*,q.file_count,q.file_size,q.quota_file_count,q.quota_file_size,q.file_retention,q.user_retention from users u join quota_groups q on q.id = u.quota_group_id";

    UserDAO(DataSource dataSource, ISequencerHandler sequencerHandler, boolean supportsAnyOperator) {
        super(dataSource, sequencerHandler, supportsAnyOperator);
    }

    private long createID() {
        return this.getNextValueOf("USER_ID_SEQ");
    }

    @Override
    public int getNumberOfUsers() throws DataAccessException {
        JdbcTemplate template = this.getJdbcTemplate();
        return template.queryForInt("select count(*) from users");
    }

    @Override
    public boolean isMainUserOfQuotaGroup(UserDTO user) throws DataAccessException {
        long id = user.getID();
        long quotaGroupId = user.getQuotaGroupId();
        return this.getSimpleJdbcTemplate().queryForInt("select count(*) from users where quota_group_id = ? and id != ? and (user_id_registrator != ? or user_id_registrator is null)", new Object[]{quotaGroupId, id, id}) == 0;
    }

    @Override
    public List<UserDTO> listUsers() throws DataAccessException {
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        List list = template.query(SELECT_USERS_WITH_QUOTA_INFO, (ParameterizedRowMapper)new UserRowMapperWithQuotaInfo(), new Object[0]);
        this.fillInRegistrators(list);
        return list;
    }

    @Override
    public List<UserDTO> listUsersById(long ... userIds) throws DataAccessException {
        if (this.supportsAnyOperator) {
            List<UserDTO> list = this.query("select u.*,q.file_count,q.file_size,q.quota_file_count,q.quota_file_size,q.file_retention,q.user_retention from users u join quota_groups q on q.id = u.quota_group_id where u.id = any(?)", new Object[]{new SimpleSQLLongArray(userIds)}, new int[]{2003}, new UserRowMapperWithQuotaInfo());
            return list;
        }
        HashSet<Long> uniqueIdSet = new HashSet<Long>();
        ArrayList<UserDTO> list = new ArrayList<UserDTO>(userIds.length);
        long[] lArray = userIds;
        int n = userIds.length;
        int n2 = 0;
        while (n2 < n) {
            long id = lArray[n2];
            if (!uniqueIdSet.contains(id)) {
                uniqueIdSet.add(id);
                list.addAll(this.getSimpleJdbcTemplate().query("select u.*,q.file_count,q.file_size,q.quota_file_count,q.quota_file_size,q.file_retention,q.user_retention from users u join quota_groups q on q.id = u.quota_group_id where u.id = ?", (ParameterizedRowMapper)new UserRowMapperWithQuotaInfo(), new Object[]{id}));
            }
            ++n2;
        }
        return list;
    }

    @Override
    public List<UserDTO> listUsersByCode(String ... userCodes) throws DataAccessException {
        if (this.supportsAnyOperator) {
            List<UserDTO> list = this.query("select u.*,q.file_count,q.file_size,q.quota_file_count,q.quota_file_size,q.file_retention,q.user_retention from users u join quota_groups q on q.id = u.quota_group_id where u.user_code = any(?)", new Object[]{new SimpleSQLStringArray(userCodes)}, new int[]{2003}, new UserRowMapperWithQuotaInfo());
            return list;
        }
        HashSet<String> uniqueIdSet = new HashSet<String>();
        ArrayList<UserDTO> list = new ArrayList<UserDTO>(userCodes.length);
        String[] stringArray = userCodes;
        int n = userCodes.length;
        int n2 = 0;
        while (n2 < n) {
            String code = stringArray[n2];
            if (!uniqueIdSet.contains(code)) {
                uniqueIdSet.add(code);
                list.addAll(this.getSimpleJdbcTemplate().query("select u.*,q.file_count,q.file_size,q.quota_file_count,q.quota_file_size,q.file_retention,q.user_retention from users u join quota_groups q on q.id = u.quota_group_id where u.user_code = ?", (ParameterizedRowMapper)new UserRowMapperWithQuotaInfo(), new Object[]{code}));
            }
            ++n2;
        }
        return list;
    }

    @Override
    public List<UserDTO> listUsersByEmail(String ... emailAddresses) throws DataAccessException {
        if (this.supportsAnyOperator) {
            List<UserDTO> list = this.query("select u.*,q.file_count,q.file_size,q.quota_file_count,q.quota_file_size,q.file_retention,q.user_retention from users u join quota_groups q on q.id = u.quota_group_id where u.email = any(?)", new Object[]{new SimpleSQLStringArray(emailAddresses)}, new int[]{2003}, new UserRowMapperWithQuotaInfo());
            return list;
        }
        HashSet<String> uniqueIdSet = new HashSet<String>();
        ArrayList<UserDTO> list = new ArrayList<UserDTO>(emailAddresses.length);
        String[] stringArray = emailAddresses;
        int n = emailAddresses.length;
        int n2 = 0;
        while (n2 < n) {
            String email = stringArray[n2];
            if (!uniqueIdSet.contains(email)) {
                uniqueIdSet.add(email);
                list.addAll(this.getSimpleJdbcTemplate().query("select u.*,q.file_count,q.file_size,q.quota_file_count,q.quota_file_size,q.file_retention,q.user_retention from users u join quota_groups q on q.id = u.quota_group_id where u.email = ?", (ParameterizedRowMapper)new UserRowMapperWithQuotaInfo(), new Object[]{email}));
            }
            ++n2;
        }
        return list;
    }

    private <T> List<T> query(String sql, Object[] args, int[] argTypes, ParameterizedRowMapper<T> rowMapper) throws DataAccessException {
        return this.getSimpleJdbcTemplate().getJdbcOperations().query(sql, args, argTypes, rowMapper);
    }

    @Override
    public List<UserDTO> listUsersRegisteredBy(long userId) throws DataAccessException {
        UserDTO registrator = this.getUserById(userId);
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        List list = template.query("select u.*,q.file_count,q.file_size,q.quota_file_count,q.quota_file_size,q.file_retention,q.user_retention from users u join quota_groups q on q.id = u.quota_group_id where user_id_registrator = ?", (ParameterizedRowMapper)new UserRowMapperWithQuotaInfo(), new Object[]{userId});
        for (UserDTO user : list) {
            user.setRegistrator(registrator);
        }
        return list;
    }

    private void fillInRegistrator(UserDTO user) {
        assert (user != null) : "User can not be null";
        Long registratorIdOrNull = this.tryGetRegistratorId(user);
        if (registratorIdOrNull != null) {
            user.setRegistrator(this.primGetUserById(registratorIdOrNull));
        }
    }

    private void fillInRegistrators(List<UserDTO> usersToFill, List<UserDTO> allUsers) {
        HashMap<Long, UserDTO> idToUserMap = new HashMap<Long, UserDTO>();
        for (UserDTO user : allUsers) {
            idToUserMap.put(user.getID(), user);
        }
        for (UserDTO user : usersToFill) {
            UserDTO registratorOrNull = user.getRegistrator();
            if (registratorOrNull == null) continue;
            user.setRegistrator((UserDTO)idToUserMap.get(registratorOrNull.getID()));
        }
    }

    @Override
    public void fillInRegistrators(List<UserDTO> users) {
        this.fillInRegistrators(users, users);
    }

    @Override
    public UserDTO tryFindUserByCode(String userCode) throws DataAccessException {
        assert (StringUtils.isNotBlank((String)userCode)) : "No code specified!";
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        try {
            UserDTO user = (UserDTO)template.queryForObject("select u.*,q.file_count,q.file_size,q.quota_file_count,q.quota_file_size,q.file_retention,q.user_retention from users u join quota_groups q on q.id = u.quota_group_id where user_code = ?", (ParameterizedRowMapper)new UserRowMapperWithQuotaInfo(), new Object[]{userCode});
            this.fillInRegistrator(user);
            return user;
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            return null;
        }
    }

    @Override
    public UserDTO getUserById(long id) throws DataAccessException {
        UserDTO user = this.primGetUserById(id);
        this.fillInRegistrator(user);
        return user;
    }

    private UserDTO primGetUserById(long id) {
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        UserDTO user = (UserDTO)template.queryForObject("select u.*,q.file_count,q.file_size,q.quota_file_count,q.quota_file_size,q.file_retention,q.user_retention from users u join quota_groups q on q.id = u.quota_group_id where u.id = ?", (ParameterizedRowMapper)new UserRowMapperWithQuotaInfo(), new Object[]{id});
        return user;
    }

    @Override
    public String tryFindUserCodeById(long id) throws DataAccessException {
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        try {
            String userCode = (String)template.queryForObject("select user_code from users where id = ?", String.class, new Object[]{id});
            return userCode;
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            return null;
        }
    }

    @Override
    public boolean hasUserCode(String code) throws DataAccessException {
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        int count = template.queryForInt("select count(*) from users where user_code = ? limit 1", new Object[]{code});
        return count > 0;
    }

    @Override
    public List<UserDTO> findUserByEmail(String email) throws DataAccessException {
        assert (StringUtils.isNotBlank((String)email)) : "No email specified!";
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        List list = template.query("select u.*,q.file_count,q.file_size,q.quota_file_count,q.quota_file_size,q.file_retention,q.user_retention from users u join quota_groups q on q.id = u.quota_group_id where email = ?", (ParameterizedRowMapper)new UserRowMapperWithQuotaInfo(), new Object[]{email});
        this.fillInRegistrators(list, this.listUsers());
        return list;
    }

    @Override
    public List<UserDTO> listExpiredUsers() throws DataAccessException {
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        List list = template.query("select * from users where expiration_timestamp < now() ", (ParameterizedRowMapper)new UserRowMapper(), new Object[0]);
        return list;
    }

    @Override
    public List<UserDTO> listUsersFileSharedWith(long fileId) throws DataAccessException {
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        List list = template.query("select u.* from file_shares fs, users u where u.id = fs.user_id and fs.file_id = ?", (ParameterizedRowMapper)new UserRowMapper(), new Object[]{fileId});
        this.fillInRegistrators(list, this.listUsers());
        return list;
    }

    @Override
    public void refreshQuotaInformation(UserDTO user) throws DataAccessException {
        this.getSimpleJdbcTemplate().query("select * from quota_groups where id = ?", (ParameterizedRowMapper)new QuotaRowMapper(user), new Object[]{user.getQuotaGroupId()});
    }

    @Override
    public boolean hasUserFilesForDownload(long id) {
        return !this.getSimpleJdbcTemplate().queryForList("select id from file_shares where user_id = ? limit 1", new Object[]{id}).isEmpty();
    }

    @Override
    public void createUser(UserDTO user) throws DataAccessException {
        assert (user != null) : "Given user can not be null.";
        long id = this.createID();
        Long registratorIdOrNull = this.tryGetRegistratorId(user);
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        if (Password.isEmpty(user.getPassword())) {
            template.update("insert into users (id, user_code, email, full_name,is_externally_authenticated, is_admin,is_active, user_id_registrator, quota_group_id,expiration_timestamp) values (?,?,?,?,?,?,?,?,?,?)", new Object[]{id, user.getUserCode(), user.getEmail(), user.getUserFullName(), user.isExternallyAuthenticated(), user.isAdmin(), user.isActive(), registratorIdOrNull, user.getQuotaGroupId(), user.getExpirationDate()});
        } else {
            template.update("insert into users (id, user_code, email, full_name, password_hash,is_externally_authenticated, is_admin,is_active, user_id_registrator, quota_group_id,expiration_timestamp) values (?,?,?,?,?,?,?,?,?,?,?)", new Object[]{id, user.getUserCode(), user.getEmail(), user.getUserFullName(), user.getPassword().createPasswordHash(), user.isExternallyAuthenticated(), user.isAdmin(), user.isActive(), registratorIdOrNull, user.getQuotaGroupId(), user.getExpirationDate()});
        }
        user.setID(id);
        this.updateCustomQuotaInformation(user, template);
    }

    private Long tryGetRegistratorId(UserDTO user) {
        assert (user != null);
        UserDTO registratorOrNull = user.getRegistrator();
        if (registratorOrNull == null) {
            return null;
        }
        Long registratorId = registratorOrNull.getID();
        if (registratorId == null && (registratorOrNull = this.tryFindUserByCode(registratorOrNull.getUserCode())) != null) {
            registratorId = registratorOrNull.getID();
        }
        return registratorId;
    }

    @Override
    public boolean deleteUser(UserDTO user, Long requestUserIdOrNull) {
        int affectedRows;
        assert (user != null);
        Long registratorIdOrNull = this.tryGetRegistratorId(user);
        Long newOwnerIdOrNull = registratorIdOrNull == null ? requestUserIdOrNull : registratorIdOrNull;
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        if (newOwnerIdOrNull != null) {
            template.update("update users set user_id_registrator = ? where user_id_registrator = ?", new Object[]{newOwnerIdOrNull, user.getID()});
            template.update("update files set user_id = ? where user_id = ?", new Object[]{newOwnerIdOrNull, user.getID()});
        }
        return (affectedRows = template.update("delete from users where id = ?", new Object[]{user.getID()})) > 0;
    }

    @Override
    public void updateUser(UserDTO user) {
        assert (user.getID() != null) : "User needs an ID, otherwise it can't be updated";
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        template.update("update users set email = ?, user_code = ?, full_name = ?, is_externally_authenticated = ?, is_admin = ?, is_active = ?, quota_group_id = ?, expiration_timestamp = ? where id = ?", new Object[]{user.getEmail(), user.getUserCode(), user.getUserFullName(), user.isExternallyAuthenticated(), user.isAdmin(), user.isActive(), user.getQuotaGroupId(), user.getExpirationDate(), user.getID()});
        if (!Password.isEmpty(user.getPassword())) {
            template.update("update users set password_hash = ? where id = ?", new Object[]{user.getPassword().createPasswordHash(), user.getID()});
        }
        if (user.getRegistrator() != null && user.getRegistrator().getID() != null) {
            template.update("update users set user_id_registrator = ? where id = ?", new Object[]{user.getRegistrator().getID(), user.getID()});
        }
        this.updateCustomQuotaInformation(user, template);
    }

    private void updateCustomQuotaInformation(UserDTO user, SimpleJdbcTemplate template) {
        Integer maxFileCountPerQuotaGroup = null;
        if (user.isCustomMaxFileCountPerQuotaGroup()) {
            maxFileCountPerQuotaGroup = user.getMaxFileCountPerQuotaGroup() == null ? 0 : user.getMaxFileCountPerQuotaGroup();
        }
        Long maxFileSizePerQuotaGroupInMB = null;
        if (user.isCustomMaxFileSizePerQuotaGroup()) {
            maxFileSizePerQuotaGroupInMB = user.getMaxFileSizePerQuotaGroupInMB() == null ? 0L : user.getMaxFileSizePerQuotaGroupInMB();
        }
        Integer fileRetention = null;
        if (user.isCustomMaxFileRetention()) {
            fileRetention = user.getMaxFileRetention() == null ? 0 : user.getMaxFileRetention();
        }
        Integer userRetention = null;
        if (user.isCustomMaxUserRetention()) {
            userRetention = user.getMaxUserRetention() == null ? 0 : user.getMaxUserRetention();
        }
        long quotaGroupId = user.getQuotaGroupId() == null ? (long)template.queryForInt("select quota_group_id from users where id = ?", new Object[]{user.getID()}) : user.getQuotaGroupId();
        template.update("update quota_groups set quota_file_count = ?, quota_file_size = ?, file_retention = ?, user_retention = ? where id = ?", new Object[]{maxFileCountPerQuotaGroup, maxFileSizePerQuotaGroupInMB, fileRetention, userRetention, quotaGroupId});
        user.setQuotaGroupId(quotaGroupId);
    }

    @Override
    public void changeUserCode(String before, String after) {
        this.getSimpleJdbcTemplate().update("update users set user_code = ? where user_code = ? ", new Object[]{after, before});
    }

    private static final class QuotaRowMapper
    implements ParameterizedRowMapper<UserDTO> {
        private final UserDTO user;

        QuotaRowMapper(UserDTO user) {
            this.user = user;
        }

        public UserDTO mapRow(ResultSet rs, int rowNum) throws SQLException {
            this.user.setMaxFileRetention(rs.getInt("file_retention"));
            if (rs.wasNull()) {
                this.user.setMaxFileRetention(null);
            }
            this.user.setMaxUserRetention(rs.getInt("user_retention"));
            if (rs.wasNull()) {
                this.user.setMaxUserRetention(null);
            }
            this.user.setCurrentFileCount(rs.getInt("file_count"));
            this.user.setCurrentFileSize(rs.getLong("file_size"));
            this.user.setMaxFileCountPerQuotaGroup(rs.getInt("quota_file_count"));
            if (rs.wasNull()) {
                this.user.setMaxFileCountPerQuotaGroup(null);
            }
            this.user.setMaxFileSizePerQuotaGroupInMB(rs.getLong("quota_file_size"));
            if (rs.wasNull()) {
                this.user.setMaxFileSizePerQuotaGroupInMB(null);
            }
            return this.user;
        }
    }

    public static class UserRowMapper
    implements ParameterizedRowMapper<UserDTO> {
        public UserDTO mapRow(ResultSet rs, int rowNum) throws SQLException {
            UserDTO user = this.fillUserFromResultSet(rs);
            return user;
        }

        protected UserDTO fillUserFromResultSet(ResultSet rs) throws SQLException {
            UserDTO user = new UserDTO();
            UserDTO registrator = new UserDTO();
            user.setID(rs.getLong("id"));
            user.setUserCode(rs.getString("user_code"));
            user.setEmail(rs.getString("email"));
            user.setUserFullName(rs.getString("full_name"));
            user.setPasswordHash(rs.getString("password_hash"));
            user.setExternallyAuthenticated(rs.getBoolean("is_externally_authenticated"));
            user.setAdmin(rs.getBoolean("is_admin"));
            user.setActive(rs.getBoolean("is_active"));
            user.setRegistrationDate(DBUtils.tryToTranslateTimestampToDate((Timestamp)rs.getTimestamp("registration_timestamp")));
            user.setExpirationDate(DBUtils.tryToTranslateTimestampToDate((Timestamp)rs.getTimestamp("expiration_timestamp")));
            registrator.setID(rs.getLong("user_id_registrator"));
            if (!rs.wasNull()) {
                user.setRegistrator(registrator);
            }
            user.setQuotaGroupId(rs.getLong("quota_group_id"));
            return user;
        }
    }

    public static final class UserRowMapperWithQuotaInfo
    extends UserRowMapper {
        @Override
        public UserDTO mapRow(ResultSet rs, int rowNum) throws SQLException {
            UserDTO user = this.fillUserFromResultSet(rs);
            return user;
        }

        @Override
        protected UserDTO fillUserFromResultSet(ResultSet rs) throws SQLException {
            UserDTO user = super.fillUserFromResultSet(rs);
            int fileRetention = rs.getInt("file_retention");
            if (!rs.wasNull()) {
                user.setMaxFileRetention(fileRetention);
                user.setCustomMaxFileRetention(true);
            }
            int userRetention = rs.getInt("user_retention");
            if (!rs.wasNull()) {
                user.setMaxUserRetention(userRetention);
                user.setCustomMaxUserRetention(true);
            }
            user.setCurrentFileCount(rs.getInt("file_count"));
            user.setCurrentFileSize(rs.getLong("file_size"));
            int maxFileCountPerQuotaGroup = rs.getInt("quota_file_count");
            if (!rs.wasNull()) {
                user.setMaxFileCountPerQuotaGroup(maxFileCountPerQuotaGroup);
            }
            user.setCustomMaxFileCountPerQuotaGroup(true);
            long maxFileSizePerQuotaGroupInMB = rs.getLong("quota_file_size");
            if (!rs.wasNull()) {
                user.setMaxFileSizePerQuotaGroupInMB(maxFileSizePerQuotaGroupInMB);
            }
            user.setCustomMaxFileSizePerQuotaGroup(true);
            return user;
        }
    }
}

