/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.server.util;

import ch.systemsx.cisd.common.time.DateTimeUtils;
import java.util.Date;
import org.apache.commons.lang.time.DateUtils;

public class ExpirationUtilities {
    public static Date fixExpiration(Date now, Date proposedExpirationDateOrNull, Date registrationDateOrNull, Integer maxRetentionDaysOrNull, int defaultRetentionDays) {
        Date proposedExpirationDate;
        assert (defaultRetentionDays >= 0);
        Date registrationDate = registrationDateOrNull == null ? now : registrationDateOrNull;
        Date date = proposedExpirationDate = proposedExpirationDateOrNull == null ? DateUtils.addDays((Date)registrationDate, (int)defaultRetentionDays) : proposedExpirationDateOrNull;
        if (maxRetentionDaysOrNull == null) {
            return DateTimeUtils.extendUntilEndOfDay((Date)proposedExpirationDate);
        }
        Date maxExpirationDate = DateUtils.addDays((Date)registrationDate, (int)maxRetentionDaysOrNull);
        if (proposedExpirationDate.getTime() > maxExpirationDate.getTime()) {
            return DateTimeUtils.extendUntilEndOfDay((Date)maxExpirationDate);
        }
        return DateTimeUtils.extendUntilEndOfDay((Date)proposedExpirationDate);
    }

    private static Date min(Date date1, Date date2) {
        return date1.compareTo(date2) < 0 ? date1 : date2;
    }

    public static Date tryExtendExpiration(Date now, Date currentExpirationDateOrNull, Date registrationDateOrNull, Date fileRetentionDate, Integer maxRetentionDaysOrNull) {
        if (currentExpirationDateOrNull == null) {
            return null;
        }
        Date registrationDate = registrationDateOrNull == null ? now : registrationDateOrNull;
        Date maxExpirationDate = DateUtils.addDays((Date)registrationDate, (int)maxRetentionDaysOrNull);
        Date minRetentionTimeForDownload = ExpirationUtilities.min(fileRetentionDate, maxExpirationDate);
        if (currentExpirationDateOrNull.getTime() < minRetentionTimeForDownload.getTime()) {
            return DateTimeUtils.extendUntilEndOfDay((Date)minRetentionTimeForDownload);
        }
        return null;
    }
}

