/*
 * Decompiled with CFR 0.152.
 */
package com.marathon.util.spring;

import com.marathon.util.spring.StreamSupportingHttpInvokerRequestExecutor;
import com.marathon.util.spring.StreamSupportingRemoteInvocation;
import com.marathon.util.spring.StreamSupportingRemoteInvocationResult;
import java.io.BufferedOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.remoting.httpinvoker.HttpInvokerServiceExporter;
import org.springframework.remoting.support.RemoteInvocation;
import org.springframework.remoting.support.RemoteInvocationResult;

public class StreamSupportingHttpInvokerServiceExporter
extends HttpInvokerServiceExporter {
    private static final Log log = LogFactory.getLog(StreamSupportingHttpInvokerServiceExporter.class);
    private boolean emptyInputStreamParameterBeforeReturn = false;

    protected RemoteInvocation readRemoteInvocation(HttpServletRequest request, InputStream is) throws IOException, ClassNotFoundException {
        StreamSupportingRemoteInvocation ssri;
        RemoteInvocation ret = super.readRemoteInvocation(request, (InputStream)new StreamSupportingHttpInvokerRequestExecutor.CloseShieldedInputStream(is));
        boolean closeIs = true;
        if (ret instanceof StreamSupportingRemoteInvocation && (ssri = (StreamSupportingRemoteInvocation)ret).getInputStreamParam() >= 0 && !ssri.isInputStreamParamNull()) {
            ssri.getArguments()[ssri.getInputStreamParam()] = new ParameterInputStream(is);
            closeIs = false;
        }
        if (closeIs) {
            is.close();
        }
        return ret;
    }

    protected void writeRemoteInvocationResult(HttpServletRequest request, HttpServletResponse response, RemoteInvocationResult result) throws IOException {
        if (this.hasStreamResult(result)) {
            response.setContentType("application/x-java-serialized-object-with-stream");
        } else {
            response.setContentType("application/x-java-serialized-object");
        }
        this.writeRemoteInvocationResult(request, response, result, (OutputStream)response.getOutputStream());
    }

    protected void writeRemoteInvocationResult(HttpServletRequest request, HttpServletResponse response, RemoteInvocationResult result, OutputStream os) throws IOException {
        if (this.hasStreamResult(result)) {
            response.setHeader("Transfer-Encoding", "chunked");
            try (OutputStream decoratedOut = this.decorateOutputStream(request, response, os);){
                try (ObjectOutputStream oos = new ObjectOutputStream(new CloseShieldedOutputStream(new BufferedOutputStream(decoratedOut, 4096)));){
                    this.doWriteRemoteInvocationResult(result, oos);
                    oos.flush();
                }
                this.doWriteReturnInputStream((StreamSupportingRemoteInvocationResult)result, decoratedOut);
            }
        }
        super.writeRemoteInvocationResult(request, response, result, os);
    }

    protected RemoteInvocationResult invokeAndCreateResult(RemoteInvocation invocation, Object targetObject) {
        try {
            Object value = this.invoke(invocation, targetObject);
            if (invocation instanceof StreamSupportingRemoteInvocation) {
                Boolean closedInputStreamParam = this.getParameterInputStreamClosedFlag(invocation);
                if (value instanceof InputStream) {
                    StreamSupportingRemoteInvocationResult streamSupportingRemoteInvocationResult = new StreamSupportingRemoteInvocationResult((InputStream)value, closedInputStreamParam);
                    return streamSupportingRemoteInvocationResult;
                }
                StreamSupportingRemoteInvocationResult streamSupportingRemoteInvocationResult = new StreamSupportingRemoteInvocationResult(value, closedInputStreamParam);
                return streamSupportingRemoteInvocationResult;
            }
            RemoteInvocationResult remoteInvocationResult = new RemoteInvocationResult(value);
            return remoteInvocationResult;
        }
        catch (Throwable ex) {
            if (invocation instanceof StreamSupportingRemoteInvocation) {
                StreamSupportingRemoteInvocationResult streamSupportingRemoteInvocationResult = new StreamSupportingRemoteInvocationResult(ex, this.getParameterInputStreamClosedFlag(invocation));
                return streamSupportingRemoteInvocationResult;
            }
            RemoteInvocationResult remoteInvocationResult = new RemoteInvocationResult(ex);
            return remoteInvocationResult;
        }
        finally {
            ParameterInputStream pi = this.getParameterInputStreamFrom(invocation);
            if (pi != null) {
                try {
                    pi.doRealClose(this.getEmptyInputStreamParameterBeforeReturn());
                }
                catch (IOException e) {
                    log.warn((Object)("Error while attempting to close InputStream parameter for RemoteInvocation '" + invocation + "'"), (Throwable)e);
                }
            }
        }
    }

    public boolean getEmptyInputStreamParameterBeforeReturn() {
        return this.emptyInputStreamParameterBeforeReturn;
    }

    public void setEmptyInputStreamParameterBeforeReturn(boolean emptyInputStreamParameterBeforeReturn) {
        this.emptyInputStreamParameterBeforeReturn = emptyInputStreamParameterBeforeReturn;
    }

    protected boolean hasStreamResult(RemoteInvocationResult result) {
        return result instanceof StreamSupportingRemoteInvocationResult && ((StreamSupportingRemoteInvocationResult)result).getHasReturnStream();
    }

    protected void doWriteReturnInputStream(StreamSupportingRemoteInvocationResult result, OutputStream unbufferedChunkedOut) throws IOException {
        InputStream isResult = result.getServerSideInputStream();
        if (isResult != null) {
            try {
                int read;
                byte[] buffer = new byte[4096];
                while ((read = isResult.read(buffer)) != -1) {
                    unbufferedChunkedOut.write(buffer, 0, read);
                }
            }
            finally {
                result.setServerSideInputStream(null);
                isResult.close();
            }
        }
    }

    protected ParameterInputStream getParameterInputStreamFrom(RemoteInvocation invocation) {
        StreamSupportingRemoteInvocation ssri;
        if (invocation instanceof StreamSupportingRemoteInvocation && (ssri = (StreamSupportingRemoteInvocation)invocation).getInputStreamParam() >= 0 && !ssri.isInputStreamParamNull()) {
            return (ParameterInputStream)ssri.getArguments()[ssri.getInputStreamParam()];
        }
        return null;
    }

    protected Boolean getParameterInputStreamClosedFlag(RemoteInvocation invocation) {
        ParameterInputStream pi = this.getParameterInputStreamFrom(invocation);
        if (pi != null) {
            return pi.isClosed() ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    public static class CloseShieldedOutputStream
    extends FilterOutputStream {
        public CloseShieldedOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void close() throws IOException {
            this.flush();
        }
    }

    public static class ParameterInputStream
    extends FilterInputStream {
        private boolean fullyRead = false;
        private boolean erroredOut = false;
        private boolean closed = false;

        public ParameterInputStream(InputStream in) {
            super(in);
        }

        public boolean isFullyRead() {
            return this.fullyRead;
        }

        public boolean isErroredOut() {
            return this.erroredOut;
        }

        public boolean isClosed() {
            return this.closed;
        }

        public void doRealClose(boolean emptyStream) throws IOException {
            if (!this.isClosed() && log.isInfoEnabled()) {
                log.info((Object)"Service method failed to close InputStream parameter from remote invocation.  Will perform the close anyway.");
            }
            if (!this.isFullyRead() && emptyStream && !this.isErroredOut()) {
                byte[] buf = new byte[4096];
                while (this.read(buf) != -1) {
                }
            }
            super.close();
        }

        protected int checkEos(int read) {
            if (read == -1) {
                this.fullyRead = true;
            }
            return read;
        }

        protected IOException checkException(IOException ioe) {
            this.erroredOut = true;
            return ioe;
        }

        protected void assertOpen() throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
        }

        @Override
        public int read() throws IOException {
            this.assertOpen();
            try {
                return this.checkEos(super.read());
            }
            catch (IOException e) {
                throw this.checkException(e);
            }
        }

        @Override
        public int read(byte[] b) throws IOException {
            this.assertOpen();
            try {
                return this.checkEos(super.read(b));
            }
            catch (IOException e) {
                throw this.checkException(e);
            }
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.assertOpen();
            try {
                return this.checkEos(super.read(b, off, len));
            }
            catch (IOException e) {
                throw this.checkException(e);
            }
        }

        @Override
        public long skip(long n) throws IOException {
            this.assertOpen();
            try {
                return super.skip(n);
            }
            catch (IOException e) {
                throw this.checkException(e);
            }
        }

        @Override
        public int available() throws IOException {
            this.assertOpen();
            try {
                return super.available();
            }
            catch (IOException e) {
                throw this.checkException(e);
            }
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
        }
    }
}

