/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis;

import ch.systemsx.cisd.common.http.JettyHttpClientFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Base64;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.WordprocessingML.AlternativeFormatInputPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.wml.CTAltChunk;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class DOCXBuilder {
    private static final String START_RICH_TEXT = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<html><head></head><body>";
    private static final String END_RICH_TEXT = "</body></html>";
    private StringBuffer doc;
    private String closedDoc;
    private boolean closed;

    public static void main(String[] args) throws Exception {
        DOCXBuilder docx = new DOCXBuilder();
        docx.addTitle("TitleA");
        docx.addHeader("MetaA");
        docx.addProperty("PropertyA", "ValueA");
        docx.addProperty("PropertyB", "ValueB");
        docx.addProperty("PropertyC", "<p>I am normal</p><p style=\"color:red;\">I am red</p><p style=\"color:blue;\">I am blue</p><p style=\"font-size:36px;\">I am big</p>");
        FileOutputStream out = new FileOutputStream(new File("wordFromHTML.docx"));
        out.write(docx.getDocBytes());
        out.close();
    }

    public DOCXBuilder() {
        System.setProperty("javax.xml.transform.TransformerFactory", "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
        this.closed = false;
        this.doc = new StringBuffer();
        this.startDoc();
    }

    public void setDocument(String doc) {
        this.doc = new StringBuffer(doc);
        this.closed = true;
    }

    private void startDoc() {
        if (!this.closed) {
            this.doc.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">");
            this.doc.append("<html xmlns=\"http://www.w3.org/1999/xhtml\">");
            this.doc.append("<head></head>");
            this.doc.append("<body>");
        }
    }

    private void endDoc() {
        if (!this.closed) {
            this.doc.append("</body>");
            this.doc.append("</html>");
            this.closed = true;
            this.closedDoc = this.fixImages(this.doc);
        }
    }

    public void addProperty(String key, String value) {
        if (!this.closed) {
            this.doc.append("<p>").append("<b>").append(key).append(": ").append("</b>").append("</p>");
            this.addParagraph(value);
        }
    }

    public void addParagraph(String value) {
        if (!this.closed) {
            value = this.cleanXMLEnvelope(value);
            this.doc.append("<p>").append(value).append("</p>");
        }
    }

    public void addTitle(String title) {
        if (!this.closed) {
            this.doc.append("<h1>").append(title).append("</h1>");
        }
    }

    public void addHeader(String header) {
        if (!this.closed) {
            this.doc.append("<h2>").append(header).append("</h2>");
        }
    }

    public byte[] getHTMLBytes() throws Exception {
        if (!this.closed) {
            this.endDoc();
        }
        return this.closedDoc.getBytes();
    }

    public byte[] getDocBytes() throws Exception {
        if (!this.closed) {
            this.endDoc();
        }
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.createPackage();
        AlternativeFormatInputPart afiPart = new AlternativeFormatInputPart(new PartName("/hw.html"));
        afiPart.setBinaryData(this.closedDoc.getBytes());
        afiPart.setContentType(new ContentType("text/html"));
        Relationship altChunkRel = wordMLPackage.getMainDocumentPart().addTargetPart((Part)afiPart);
        CTAltChunk ac = Context.getWmlObjectFactory().createCTAltChunk();
        ac.setId(altChunkRel.getId());
        wordMLPackage.getMainDocumentPart().addObject((Object)ac);
        wordMLPackage.getContentTypeManager().addDefaultContentType("html", "text/html");
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        wordMLPackage.save((OutputStream)outStream);
        return outStream.toByteArray();
    }

    private String cleanXMLEnvelope(String value) {
        if (value.startsWith(START_RICH_TEXT) && value.endsWith(END_RICH_TEXT)) {
            value = value.substring(START_RICH_TEXT.length(), value.length() - END_RICH_TEXT.length());
        }
        return value;
    }

    private String fixImages(StringBuffer buffer) {
        Document jsoupDoc = Jsoup.parse((String)buffer.toString());
        jsoupDoc.outputSettings().syntax(Document.OutputSettings.Syntax.xml);
        Elements elements = jsoupDoc.select("img");
        for (Element element : elements) {
            String[] rules;
            String style = element.attr("style");
            if (style != null && (rules = style.split(";")) != null) {
                for (int rIdx = 0; rIdx < rules.length; ++rIdx) {
                    String rule = rules[rIdx];
                    String[] ruleElements = rule.split(":");
                    if (ruleElements == null || ruleElements.length != 2) continue;
                    String ruleKey = ruleElements[0].trim();
                    String ruleValue = ruleElements[1].trim();
                    if (!ruleKey.toLowerCase().equals("width") && !ruleKey.toLowerCase().equals("height") || !ruleValue.endsWith("px")) continue;
                    element.attr(ruleKey, ruleValue.substring(0, ruleValue.length() - 2));
                }
            }
            String src = element.attr("src");
            try {
                element.attr("src", DOCXBuilder.getDataUriFromUri(src));
            }
            catch (Exception exception) {}
        }
        return jsoupDoc.html();
    }

    private static String getDataUriFromUri(String url) throws Exception {
        HttpClient client = JettyHttpClientFactory.getHttpClient();
        Request requestEntity = client.newRequest(url).method("GET");
        ContentResponse contentResponse = requestEntity.send();
        return "data:" + contentResponse.getMediaType() + ";base64," + Base64.getEncoder().encodeToString(contentResponse.getContent());
    }
}

