/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.dss.plugins;

import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.maintenance.IMaintenanceTask;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.utilities.ITimeProvider;
import ch.systemsx.cisd.common.utilities.SystemTimeProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.SegmentedStoreUtils;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.log4j.Logger;

public class PreStagingCleanUpMaintenanceTask
implements IMaintenanceTask {
    public static final String DEFAULT_MAINTENANCE_TASK_NAME = "pre-staging-clean-up-task";
    public static final int DEFAULT_MAINTENANCE_TASK_INTERVAL = 86400;
    public static final String MINIMUM_AGE_IN_DAYS = "minimum-age-in-days";
    public static final int DEFAULT_MINIMUM_AGE_IN_DAYS = 30;
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, PreStagingCleanUpMaintenanceTask.class);
    private long minimumAge;
    private File storeRoot;
    private ITimeProvider timeProvider;

    public PreStagingCleanUpMaintenanceTask() {
    }

    PreStagingCleanUpMaintenanceTask(File storeRoot, ITimeProvider timeProvider) {
        this.storeRoot = storeRoot;
        this.timeProvider = timeProvider;
    }

    public void setUp(String pluginName, Properties properties) {
        this.minimumAge = (long)PropertyUtils.getInt((Properties)properties, (String)MINIMUM_AGE_IN_DAYS, (int)30) * 86400000L;
    }

    public void execute() {
        File[] shares;
        long now = this.getTimeProvider().getTimeInMilliseconds();
        for (File share : shares = SegmentedStoreUtils.getShares(this.getStoreRoot())) {
            File[] files = new File(share, "pre-staging").listFiles();
            if (files == null) continue;
            for (File file : files) {
                String dateStamp = file.getName().split("_")[0];
                try {
                    Date date = new SimpleDateFormat("yyyy-MM-dd").parse(dateStamp);
                    if (date.getTime() + this.minimumAge >= now) continue;
                    FileUtilities.deleteRecursively((File)file);
                    operationLog.info((Object)("Stale folder deleted: " + file.getAbsolutePath()));
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
    }

    private File getStoreRoot() {
        if (this.storeRoot == null) {
            this.storeRoot = ServiceProvider.getConfigProvider().getStoreRoot();
        }
        return this.storeRoot;
    }

    private ITimeProvider getTimeProvider() {
        if (this.timeProvider == null) {
            this.timeProvider = SystemTimeProvider.SYSTEM_TIME_PROVIDER;
        }
        return this.timeProvider;
    }
}

