/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.dss.plugins.sync.common;

import ch.ethz.sis.openbis.generic.asapi.v3.IApplicationServerApi;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.ICodeHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.SearchResult;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.DataSet;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.fetchoptions.DataSetFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.Experiment;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.fetchoptions.ExperimentFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.Material;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.fetchoptions.MaterialFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.search.MaterialSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.Project;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.fetchoptions.ProjectFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.search.ProjectSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.Sample;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.fetchoptions.SampleFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.search.SampleSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.Space;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.fetchoptions.SpaceFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.id.SpacePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.search.SpaceSearchCriteria;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.common.MasterDataExtractor;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.common.entitygraph.Edge;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.common.entitygraph.EntityGraph;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.common.entitygraph.IEntityRetriever;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.common.entitygraph.INode;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.common.entitygraph.Node;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.common.entitygraph.NodeIdentifier;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IMasterDataRegistrationTransaction;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Logger;

public class EntityRetriever
implements IEntityRetriever {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, EntityRetriever.class);
    private EntityGraph<INode> graph = new EntityGraph();
    private final IApplicationServerApi v3Api;
    private final IMasterDataRegistrationTransaction masterDataRegistrationTransaction;
    private final String sessionToken;
    private boolean ponging;
    private boolean pongingFinished;

    private EntityRetriever(IApplicationServerApi v3Api, String sessionToken, IMasterDataRegistrationTransaction masterDataRegistrationTransaction) {
        this.v3Api = v3Api;
        this.sessionToken = sessionToken;
        this.masterDataRegistrationTransaction = masterDataRegistrationTransaction;
    }

    public static EntityRetriever createWithMasterDataRegistationTransaction(IApplicationServerApi v3Api, String sessionToken, IMasterDataRegistrationTransaction masterDataRegistrationTransaction) {
        return new EntityRetriever(v3Api, sessionToken, masterDataRegistrationTransaction);
    }

    public static EntityRetriever createWithSessionToken(IApplicationServerApi v3Api, String sessionToken) {
        return new EntityRetriever(v3Api, sessionToken, null);
    }

    public void start(final PrintWriter writer) {
        operationLog.info((Object)"Start");
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                EntityRetriever.this.ponging = true;
                while (EntityRetriever.this.ponging) {
                    try {
                        Thread.sleep(5000L);
                        writer.print(" ");
                        writer.flush();
                        operationLog.info((Object)"pong");
                    }
                    catch (InterruptedException interruptedException) {}
                }
                EntityRetriever.this.pongingFinished = true;
                operationLog.info((Object)"ponging finished");
                EntityRetriever entityRetriever = EntityRetriever.this;
                synchronized (entityRetriever) {
                    EntityRetriever.this.notifyAll();
                }
            }
        }, "Pong").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        operationLog.info((Object)"Finish");
        this.ponging = false;
        EntityRetriever entityRetriever = this;
        synchronized (entityRetriever) {
            try {
                while (!this.pongingFinished) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EntityGraph<INode> getEntityGraph(String spaceId) {
        long t0 = System.currentTimeMillis();
        try {
            this.buildEntityGraph(spaceId);
            EntityGraph<INode> entityGraph = this.graph;
            return entityGraph;
        }
        finally {
            this.logTime(t0, "getEntityGraph(" + spaceId + ")");
        }
    }

    public boolean spaceExists(String spaceId) {
        SpacePermId spacePermId = new SpacePermId(spaceId);
        Map map = this.v3Api.getSpaces(this.sessionToken, Arrays.asList(spacePermId), new SpaceFetchOptions());
        return map.get(spacePermId) != null;
    }

    public List<Space> getSpaces() {
        return this.v3Api.searchSpaces(this.sessionToken, new SpaceSearchCriteria(), new SpaceFetchOptions()).getObjects();
    }

    private void buildEntityGraph(String spaceId) {
        this.graph = new EntityGraph();
        this.addSharedSamples();
        ProjectSearchCriteria criteria = new ProjectSearchCriteria();
        criteria.withSpace().withCode().thatEquals(spaceId);
        List projects = this.v3Api.searchProjects(this.sessionToken, criteria, this.createProjectFetchOptions()).getObjects();
        for (Project project : projects) {
            Node<Project> prjNode = new Node<Project>(project);
            this.graph.addNode(prjNode);
            this.addExperiments(prjNode);
            this.addSamplesForProject(prjNode);
        }
        this.addSpaceSamples(spaceId);
    }

    private void addSharedSamples() {
        SampleSearchCriteria criteria = new SampleSearchCriteria();
        criteria.withoutSpace();
        List samples = this.v3Api.searchSamples(this.sessionToken, criteria, this.createSampleFetchOptions()).getObjects();
        for (Sample sample : samples) {
            if (sample.getSpace() != null) {
                throw new RuntimeException("Expected a shared sample but got " + sample);
            }
            Node<Sample> sampleNode = new Node<Sample>(sample);
            this.graph.addNode(sampleNode);
            this.addChildAndComponentSamples(sampleNode);
            this.addDataSetsForSample(sampleNode);
        }
    }

    private void addSpaceSamples(String spaceCode) {
        SampleSearchCriteria criteria = new SampleSearchCriteria();
        criteria.withSpace().withCode().thatEquals(spaceCode);
        criteria.withoutProject();
        criteria.withoutExperiment();
        criteria.withAndOperator();
        List samples = this.v3Api.searchSamples(this.sessionToken, criteria, this.createSampleFetchOptions()).getObjects();
        for (Sample sample : samples) {
            Node<Sample> sampleNode = new Node<Sample>(sample);
            this.graph.addNode(sampleNode);
            this.addChildAndComponentSamples(sampleNode);
            this.addDataSetsForSample(sampleNode);
        }
    }

    private void addExperiments(Node<Project> prjNode) {
        for (Experiment exp : prjNode.getEntity().getExperiments()) {
            Node<Experiment> expNode = new Node<Experiment>(exp);
            this.graph.addEdge(prjNode, expNode, new Edge("Connection"));
            this.addSamplesForExperiment(expNode);
            this.addDataSetsForExperiment(expNode);
        }
    }

    private void addSamplesForExperiment(Node<Experiment> expNode) {
        for (Sample sample : expNode.getEntity().getSamples()) {
            Node<Sample> sampleNode = new Node<Sample>(sample);
            this.graph.addEdge(expNode, sampleNode, new Edge("Connection"));
            this.addDataSetsForSample(sampleNode);
            this.addChildAndComponentSamples(sampleNode);
        }
    }

    private void addSamplesForProject(Node<Project> prjNode) {
        for (Sample sample : prjNode.getEntity().getSamples()) {
            if (sample.getExperiment() != null) continue;
            Node<Sample> sampleNode = new Node<Sample>(sample);
            this.graph.addEdge(prjNode, sampleNode, new Edge("Connection"));
            this.addDataSetsForSample(sampleNode);
            this.addChildAndComponentSamples(sampleNode);
        }
    }

    private void addDataSetsForExperiment(Node<Experiment> expNode) {
        for (DataSet dataSet : expNode.getEntity().getDataSets()) {
            Node<DataSet> dataSetNode = new Node<DataSet>(dataSet);
            this.graph.addEdge(expNode, dataSetNode, new Edge("Connection"));
            this.addChildAndContainedDataSets(dataSetNode);
        }
    }

    private void addDataSetsForSample(Node<Sample> sampleNode) {
        for (DataSet dataSet : sampleNode.getEntity().getDataSets()) {
            Node<DataSet> dataSetNode = new Node<DataSet>(dataSet);
            this.graph.addEdge(sampleNode, dataSetNode, new Edge("Connection"));
            this.addChildAndContainedDataSets(dataSetNode);
        }
    }

    private void addChildAndComponentSamples(Node<Sample> sampleNode) {
        NodeIdentifier identifier = sampleNode.getIdentifier();
        if (!this.graph.isVisitedAsParent(identifier)) {
            this.graph.markAsVisitedAsParent(identifier);
            this.addChildSamples(sampleNode);
        }
        if (!this.graph.isVisitedAsContainer(identifier)) {
            this.graph.markAsVisitedAsContainer(identifier);
            this.addComponentSamples(sampleNode);
        }
    }

    private void addComponentSamples(Node<Sample> sampleNode) {
        for (Sample sample : sampleNode.getEntity().getComponents()) {
            Node<Sample> subSampleNode = new Node<Sample>(sample);
            this.graph.addEdge(sampleNode, subSampleNode, new Edge("Component"));
            this.addDataSetsForSample(subSampleNode);
            this.addChildAndComponentSamples(subSampleNode);
        }
    }

    private void addChildSamples(Node<Sample> sampleNode) {
        for (Sample sample : sampleNode.getEntity().getChildren()) {
            Node<Sample> subSampleNode = new Node<Sample>(sample);
            this.graph.addEdge(sampleNode, subSampleNode, new Edge("Child"));
            this.addDataSetsForSample(subSampleNode);
            this.addChildAndComponentSamples(subSampleNode);
        }
    }

    private void addChildAndContainedDataSets(Node<DataSet> dsNode) {
        NodeIdentifier identifier = dsNode.getIdentifier();
        if (!this.graph.isVisitedAsParent(identifier)) {
            this.graph.markAsVisitedAsParent(identifier);
            this.addChildDataSets(dsNode);
        }
        if (!this.graph.isVisitedAsContainer(identifier)) {
            this.graph.markAsVisitedAsContainer(identifier);
            this.addComponentDataSets(dsNode);
        }
    }

    private void addComponentDataSets(Node<DataSet> dsNode) {
        for (DataSet ds : dsNode.getEntity().getComponents()) {
            Node<DataSet> containedDsNode = new Node<DataSet>(ds);
            this.graph.addEdge(dsNode, containedDsNode, new Edge("Component"));
            this.addChildAndContainedDataSets(containedDsNode);
        }
    }

    private void addChildDataSets(Node<DataSet> dsNode) {
        for (DataSet ds : dsNode.getEntity().getChildren()) {
            Node<DataSet> childDsNode = new Node<DataSet>(ds);
            this.graph.addEdge(dsNode, childDsNode, new Edge("Child"));
            this.addChildAndContainedDataSets(childDsNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Material> fetchMaterials() {
        long t0 = System.currentTimeMillis();
        try {
            MaterialSearchCriteria criteria = new MaterialSearchCriteria();
            MaterialFetchOptions fetchOptions = new MaterialFetchOptions();
            fetchOptions.withRegistrator();
            fetchOptions.withType();
            fetchOptions.withProperties();
            SearchResult searchResult = this.v3Api.searchMaterials(this.sessionToken, criteria, fetchOptions);
            List list = searchResult.getObjects();
            return list;
        }
        finally {
            this.logTime(t0, "fetchMaterials");
        }
    }

    private void logTime(long t0, String method) {
        long duration = System.currentTimeMillis() - t0;
        operationLog.info((Object)(method + ": " + duration + " msec"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String fetchMasterDataAsXML() throws ParserConfigurationException, TransformerException {
        long t0 = System.currentTimeMillis();
        try {
            MasterDataExtractor masterDataExtractor = new MasterDataExtractor(this.v3Api, this.sessionToken, this.masterDataRegistrationTransaction);
            String string = masterDataExtractor.fetchAsXmlString();
            return string;
        }
        finally {
            this.logTime(t0, "fetchMasterDataAsXML");
        }
    }

    protected List<String> extractCodes(List<? extends ICodeHolder> codeHolders) {
        ArrayList<String> codes = new ArrayList<String>();
        for (ICodeHolder iCodeHolder : codeHolders) {
            codes.add(iCodeHolder.getCode());
        }
        return codes;
    }

    private ProjectFetchOptions createProjectFetchOptions() {
        ProjectFetchOptions fo = new ProjectFetchOptions();
        fo.withRegistrator();
        fo.withModifier();
        fo.withSpace();
        fo.withAttachments();
        fo.withExperimentsUsing(this.createExperimentFetchOptions());
        fo.withSamplesUsing(this.createSampleFetchOptions());
        return fo;
    }

    private ExperimentFetchOptions createExperimentFetchOptions() {
        ExperimentFetchOptions fo = new ExperimentFetchOptions();
        fo.withRegistrator();
        fo.withModifier();
        fo.withProperties();
        fo.withProject().withSpace();
        fo.withType();
        fo.withAttachments();
        fo.withSamplesUsing(this.createSampleFetchOptions());
        fo.withDataSetsUsing(this.createDataSetFetchOptions());
        return fo;
    }

    private SampleFetchOptions createSampleFetchOptions() {
        SampleFetchOptions fo = new SampleFetchOptions();
        fo.withRegistrator();
        fo.withModifier();
        fo.withProperties();
        fo.withDataSets();
        fo.withType();
        fo.withExperiment();
        fo.withProject();
        fo.withSpace();
        fo.withAttachments();
        fo.withChildrenUsing(fo);
        fo.withComponentsUsing(fo);
        fo.withDataSetsUsing(this.createDataSetFetchOptions());
        return fo;
    }

    private DataSetFetchOptions createDataSetFetchOptions() {
        DataSetFetchOptions fo = new DataSetFetchOptions();
        fo.withRegistrator();
        fo.withModifier();
        fo.withType();
        fo.withSample();
        fo.withExperiment();
        fo.withProperties();
        fo.withChildrenUsing(fo);
        fo.withComponentsUsing(fo);
        fo.withLinkedData().withExternalDms();
        return fo;
    }
}

