/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.dss.plugins.sync.common;

import ch.ethz.sis.openbis.generic.asapi.v3.IApplicationServerApi;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.ICodeHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IDescriptionHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.DataSetType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.fetchoptions.DataSetTypeFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.search.DataSetTypeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.EntityKind;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.ExperimentType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.fetchoptions.ExperimentTypeFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.search.ExperimentTypeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.externaldms.ExternalDms;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.externaldms.fetchoptions.ExternalDmsFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.externaldms.search.ExternalDmsSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.MaterialType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.fetchoptions.MaterialTypeFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.search.MaterialTypeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.plugin.Plugin;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.plugin.fetchoptions.PluginFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.plugin.search.PluginSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.PropertyAssignment;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.PropertyType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.fetchoptions.PropertyTypeFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.search.PropertyTypeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.SampleType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.fetchoptions.SampleTypeFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.search.SampleTypeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.Vocabulary;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.VocabularyTerm;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.fetchoptions.VocabularyFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.search.VocabularySearchCriteria;
import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.shared.basic.string.CommaSeparatedListBuilder;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.DataType;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IFileFormatTypeImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IMasterDataRegistrationTransaction;
import ch.systemsx.cisd.openbis.generic.shared.basic.BasicConstant;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeConverter;
import java.io.StringWriter;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.TransformerException;

public class MasterDataExtractor {
    private static final VocabularySearchCriteria VOCABULARY_SEARCH_CRITERIA = new VocabularySearchCriteria();
    private static final PropertyTypeSearchCriteria PROPERTY_TYPE_SEARCH_CRITERIA = new PropertyTypeSearchCriteria();
    private static final ExperimentTypeSearchCriteria EXPERIMENT_TYPE_SEARCH_CRITERIA = new ExperimentTypeSearchCriteria();
    private static final MaterialTypeSearchCriteria MATERIAL_TYPE_SEARCH_CRITERIA = new MaterialTypeSearchCriteria();
    private static final SampleTypeSearchCriteria SAMPLE_TYPE_SEARCH_CRITERIA = new SampleTypeSearchCriteria();
    private static final DataSetTypeSearchCriteria DATA_SET_TYPE_SEARCH_CRITERIA = new DataSetTypeSearchCriteria();
    private final IMasterDataRegistrationTransaction masterDataRegistrationTransaction;
    private final IApplicationServerApi v3Api;
    private final String sessionToken;

    public MasterDataExtractor(IApplicationServerApi v3Api, String sessionToken, IMasterDataRegistrationTransaction masterDataRegistrationTransaction) {
        this.v3Api = v3Api;
        this.sessionToken = sessionToken;
        this.masterDataRegistrationTransaction = masterDataRegistrationTransaction;
    }

    public String fetchAsXmlString() throws ParserConfigurationException, TransformerException {
        StringWriter writer = new StringWriter();
        try {
            XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
            XMLStreamWriter xmlStreamWriter = xmlOutputFactory.createXMLStreamWriter(writer);
            xmlStreamWriter.writeStartElement("xmd:masterData");
            xmlStreamWriter.writeAttribute("xmlns:xmd", "https://sis.id.ethz.ch/software/#openbis/xmdterms/");
            this.appendFileFormatTypes(xmlStreamWriter);
            this.appendValidationPlugins(xmlStreamWriter);
            this.appendVocabularies(xmlStreamWriter);
            this.appendPropertyTypes(xmlStreamWriter);
            this.appendSampleTypes(xmlStreamWriter);
            this.appendExperimentTypes(xmlStreamWriter);
            this.appendDataSetTypes(xmlStreamWriter);
            this.appendMaterialTypes(xmlStreamWriter);
            this.appendExternalDataManagementSystems(xmlStreamWriter);
            xmlStreamWriter.writeEndElement();
            return writer.toString();
        }
        catch (Exception e) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)e);
        }
    }

    private void appendExternalDataManagementSystems(XMLStreamWriter out) throws XMLStreamException {
        ExternalDmsSearchCriteria searchCriteria = new ExternalDmsSearchCriteria();
        ExternalDmsFetchOptions fetchOptions = new ExternalDmsFetchOptions();
        List externalDataManagementSystems = this.v3Api.searchExternalDataManagementSystems(this.sessionToken, searchCriteria, fetchOptions).getObjects();
        if (!externalDataManagementSystems.isEmpty()) {
            out.writeStartElement("xmd:externalDataManagementSystems");
            for (ExternalDms externalDms : externalDataManagementSystems) {
                out.writeStartElement("xmd:externalDataManagementSystem");
                this.writeAttributeIfNotNull(out, "code", externalDms.getCode());
                this.writeAttributeIfNotNull(out, "label", externalDms.getLabel());
                this.writeAttributeIfNotNull(out, "address", externalDms.getAddress());
                this.writeAttributeIfNotNull(out, "addressType", externalDms.getAddressType().toString());
                out.writeEndElement();
            }
            out.writeEndElement();
        }
    }

    private void writeAttributeIfNotNull(XMLStreamWriter out, String key, String value) throws XMLStreamException {
        if (value != null) {
            out.writeAttribute(key, value);
        }
    }

    private void appendValidationPlugins(XMLStreamWriter out) throws XMLStreamException {
        PluginFetchOptions fetchOptions = new PluginFetchOptions();
        fetchOptions.withScript();
        List plugins = this.v3Api.searchPlugins(this.sessionToken, new PluginSearchCriteria(), fetchOptions).getObjects();
        if (plugins.isEmpty()) {
            return;
        }
        out.writeStartElement("xmd:validationPlugins");
        for (Plugin plugin : plugins) {
            out.writeStartElement("xmd:validationPlugin");
            this.writeAttributeIfNotNull(out, "name", plugin.getName());
            this.writeAttributeIfNotNull(out, "description", plugin.getDescription());
            this.writeAttributeIfNotNull(out, "type", plugin.getPluginType().toString());
            this.writeAttributeIfNotNull(out, "entityKind", this.getEntityKind(plugin));
            this.writeAttributeIfNotNull(out, "isAvailable", String.valueOf(plugin.isAvailable()));
            if (plugin.getScript() != null) {
                out.writeCData(plugin.getScript());
            }
            out.writeEndElement();
        }
        out.writeEndElement();
    }

    private String getEntityKind(Plugin plugin) {
        String entityKind = "All";
        Set entityKinds = plugin.getEntityKinds();
        if (entityKinds != null) {
            CommaSeparatedListBuilder builder = new CommaSeparatedListBuilder();
            for (EntityKind kind : entityKinds) {
                builder.append((Object)kind.toString());
            }
            entityKind = builder.toString();
        }
        return entityKind;
    }

    private void appendFileFormatTypes(XMLStreamWriter out) throws XMLStreamException {
        List fileFormatTypes = this.masterDataRegistrationTransaction.listFileFormatTypes();
        if (fileFormatTypes.size() > 0) {
            out.writeStartElement("xmd:fileFormatTypes");
            for (IFileFormatTypeImmutable fileFormatType : fileFormatTypes) {
                out.writeStartElement("xmd:fileFormatType");
                this.writeAttributeIfNotNull(out, "code", fileFormatType.getCode());
                this.writeAttributeIfNotNull(out, "description", fileFormatType.getDescription());
                out.writeEndElement();
            }
            out.writeEndElement();
        }
    }

    private void appendPropertyTypes(XMLStreamWriter out) throws XMLStreamException {
        PropertyTypeFetchOptions fetchOptions = new PropertyTypeFetchOptions();
        fetchOptions.withMaterialType();
        fetchOptions.withVocabulary();
        List propertyTypes = this.v3Api.searchPropertyTypes(this.sessionToken, PROPERTY_TYPE_SEARCH_CRITERIA, fetchOptions).getObjects();
        if (propertyTypes.isEmpty()) {
            return;
        }
        out.writeStartElement("xmd:propertyTypes");
        for (PropertyType propertyType : propertyTypes) {
            Boolean managedInternally = propertyType.isManagedInternally();
            String code = managedInternally != false && propertyType.getCode().startsWith("$") ? CodeConverter.tryToDatabase((String)propertyType.getCode()) : propertyType.getCode();
            out.writeStartElement("xmd:propertyType");
            this.writeAttributeIfNotNull(out, "code", code);
            this.writeAttributeIfNotNull(out, "label", propertyType.getLabel());
            this.writeAttributeIfNotNull(out, "dataType", propertyType.getDataType().name());
            this.writeAttributeIfNotNull(out, "managedInternally", String.valueOf(managedInternally));
            this.writeAttributeIfNotNull(out, "description", propertyType.getDescription());
            if (propertyType.getDataType().name().equals(DataType.CONTROLLEDVOCABULARY.name())) {
                this.writeAttributeIfNotNull(out, "vocabulary", propertyType.getVocabulary().getCode());
            } else if (propertyType.getDataType().name().equals(DataType.MATERIAL.name())) {
                if (propertyType.getMaterialType() != null) {
                    this.writeAttributeIfNotNull(out, "material", propertyType.getMaterialType().getCode());
                } else {
                    this.writeAttributeIfNotNull(out, "material", "");
                }
            }
            out.writeEndElement();
        }
        out.writeEndElement();
    }

    private void appendVocabularies(XMLStreamWriter out) throws XMLStreamException {
        VocabularyFetchOptions fetchOptions = new VocabularyFetchOptions();
        fetchOptions.withTerms();
        List vocabularies = this.v3Api.searchVocabularies(this.sessionToken, VOCABULARY_SEARCH_CRITERIA, fetchOptions).getObjects();
        if (vocabularies.isEmpty()) {
            return;
        }
        out.writeStartElement("xmd:controlledVocabularies");
        for (Vocabulary vocabulary : vocabularies) {
            out.writeStartElement("xmd:controlledVocabulary");
            String code = vocabulary.isManagedInternally() && vocabulary.getCode().startsWith("$") ? CodeConverter.tryToDatabase((String)vocabulary.getCode()) : vocabulary.getCode();
            this.writeAttributeIfNotNull(out, "code", code);
            this.writeAttributeIfNotNull(out, "description", vocabulary.getDescription());
            String urlTemplate = vocabulary.getUrlTemplate();
            this.writeAttributeIfNotNull(out, "urlTemplate", urlTemplate);
            this.writeAttributeIfNotNull(out, "managedInternally", String.valueOf(vocabulary.isManagedInternally()));
            this.writeAttributeIfNotNull(out, "chosenFromList", String.valueOf(vocabulary.isChosenFromList()));
            for (VocabularyTerm term : vocabulary.getTerms()) {
                out.writeStartElement("xmd:term");
                this.writeAttributeIfNotNull(out, "code", term.getCode());
                this.writeAttributeIfNotNull(out, "label", term.getLabel());
                this.writeAttributeIfNotNull(out, "description", term.getDescription());
                this.writeAttributeIfNotNull(out, "ordinal", String.valueOf(term.getOrdinal()));
                this.writeAttributeIfNotNull(out, "url", this.createUrl(urlTemplate, term.getCode()));
                out.writeEndElement();
            }
            out.writeEndElement();
        }
        out.writeEndElement();
    }

    private String createUrl(String urlTemplate, String code) {
        if (urlTemplate == null) {
            return null;
        }
        String url = urlTemplate.replaceAll(BasicConstant.DEPRECATED_VOCABULARY_URL_TEMPLATE_TERM_PATTERN, code);
        return url.replaceAll(BasicConstant.VOCABULARY_URL_TEMPLATE_TERM_PATTERN, code);
    }

    private void appendMaterialTypes(XMLStreamWriter out) throws XMLStreamException {
        MaterialTypeFetchOptions fetchOptions = new MaterialTypeFetchOptions();
        fetchOptions.withPropertyAssignments().withPropertyType();
        fetchOptions.withPropertyAssignments().withPlugin();
        fetchOptions.withValidationPlugin();
        List types = this.v3Api.searchMaterialTypes(this.sessionToken, MATERIAL_TYPE_SEARCH_CRITERIA, fetchOptions).getObjects();
        if (types.isEmpty()) {
            return;
        }
        out.writeStartElement("xmd:materialTypes");
        for (MaterialType type : types) {
            this.writeTypeElement(out, "xmd:materialType", type);
            this.writeAttributeIfNotNull(out, "validationPlugin", type.getValidationPlugin() != null ? type.getValidationPlugin().getName() : null);
            this.appendPropertyAssignments(out, type.getPropertyAssignments());
            out.writeEndElement();
        }
        out.writeEndElement();
    }

    private void appendExperimentTypes(XMLStreamWriter out) throws XMLStreamException {
        ExperimentTypeFetchOptions fetchOptions = new ExperimentTypeFetchOptions();
        fetchOptions.withPropertyAssignments().withPropertyType();
        fetchOptions.withPropertyAssignments().withPlugin();
        fetchOptions.withValidationPlugin();
        List types = this.v3Api.searchExperimentTypes(this.sessionToken, EXPERIMENT_TYPE_SEARCH_CRITERIA, fetchOptions).getObjects();
        if (types.isEmpty()) {
            return;
        }
        out.writeStartElement("xmd:collectionTypes");
        for (ExperimentType type : types) {
            this.writeTypeElement(out, "xmd:collectionType", type);
            this.writeAttributeIfNotNull(out, "validationPlugin", type.getValidationPlugin() != null ? type.getValidationPlugin().getName() : null);
            this.appendPropertyAssignments(out, type.getPropertyAssignments());
            out.writeEndElement();
        }
        out.writeEndElement();
    }

    private void appendSampleTypes(XMLStreamWriter out) throws XMLStreamException {
        SampleTypeFetchOptions fetchOptions = new SampleTypeFetchOptions();
        fetchOptions.withPropertyAssignments().withPropertyType();
        fetchOptions.withPropertyAssignments().withPlugin();
        fetchOptions.withValidationPlugin();
        List types = this.v3Api.searchSampleTypes(this.sessionToken, SAMPLE_TYPE_SEARCH_CRITERIA, fetchOptions).getObjects();
        if (types.isEmpty()) {
            return;
        }
        out.writeStartElement("xmd:objectTypes");
        for (SampleType type : types) {
            this.writeTypeElement(out, "xmd:objectType", type);
            this.writeAttributeIfNotNull(out, "listable", String.valueOf(type.isListable()));
            this.writeAttributeIfNotNull(out, "showContainer", String.valueOf(type.isShowContainer()));
            this.writeAttributeIfNotNull(out, "showParents", String.valueOf(type.isShowParents()));
            this.writeAttributeIfNotNull(out, "showParentMetadata", String.valueOf(type.isShowParentMetadata()));
            this.writeAttributeIfNotNull(out, "subcodeUnique", String.valueOf(type.isSubcodeUnique()));
            this.writeAttributeIfNotNull(out, "autoGeneratedCode", String.valueOf(type.isAutoGeneratedCode()));
            this.writeAttributeIfNotNull(out, "generatedCodePrefix", type.getGeneratedCodePrefix());
            this.writeAttributeIfNotNull(out, "validationPlugin", type.getValidationPlugin() != null ? type.getValidationPlugin().getName() : null);
            this.appendPropertyAssignments(out, type.getPropertyAssignments());
            out.writeEndElement();
        }
        out.writeEndElement();
    }

    private void appendDataSetTypes(XMLStreamWriter out) throws XMLStreamException {
        DataSetTypeFetchOptions fetchOptions = new DataSetTypeFetchOptions();
        fetchOptions.withPropertyAssignments().withPropertyType();
        fetchOptions.withPropertyAssignments().withPlugin();
        fetchOptions.withValidationPlugin();
        List types = this.v3Api.searchDataSetTypes(this.sessionToken, DATA_SET_TYPE_SEARCH_CRITERIA, fetchOptions).getObjects();
        if (types.isEmpty()) {
            return;
        }
        out.writeStartElement("xmd:dataSetTypes");
        for (DataSetType type : types) {
            this.writeTypeElement(out, "xmd:dataSetType", type);
            this.writeAttributeIfNotNull(out, "mainDataSetPattern", type.getMainDataSetPattern());
            this.writeAttributeIfNotNull(out, "mainDataSetPath", type.getMainDataSetPath());
            this.writeAttributeIfNotNull(out, "deletionDisallowed", String.valueOf(type.isDisallowDeletion()));
            this.writeAttributeIfNotNull(out, "validationPlugin", type.getValidationPlugin() != null ? type.getValidationPlugin().getName() : null);
            this.appendPropertyAssignments(out, type.getPropertyAssignments());
            out.writeEndElement();
        }
        out.writeEndElement();
    }

    private <T extends ICodeHolder & IDescriptionHolder> void writeTypeElement(XMLStreamWriter out, String elementType, T type) throws XMLStreamException {
        out.writeStartElement(elementType);
        this.writeAttributeIfNotNull(out, "code", type.getCode());
        this.writeAttributeIfNotNull(out, "description", ((IDescriptionHolder)type).getDescription());
    }

    private void appendPropertyAssignments(XMLStreamWriter out, List<PropertyAssignment> propertyAssignments) throws XMLStreamException {
        out.writeStartElement("xmd:propertyAssignments");
        for (PropertyAssignment propertyAssignment : propertyAssignments) {
            out.writeStartElement("xmd:propertyAssignment");
            this.writeAttributeIfNotNull(out, "propertyTypeCode", propertyAssignment.getPropertyType().getCode());
            this.writeAttributeIfNotNull(out, "ordinal", String.valueOf(propertyAssignment.getOrdinal()));
            this.writeAttributeIfNotNull(out, "section", propertyAssignment.getSection());
            this.writeAttributeIfNotNull(out, "showInEdit", String.valueOf(propertyAssignment.isShowInEditView()));
            this.writeAttributeIfNotNull(out, "mandatory", String.valueOf(propertyAssignment.isMandatory()));
            this.writeAttributeIfNotNull(out, "showRawValueInForms", String.valueOf(propertyAssignment.isShowRawValueInForms()));
            Plugin plugin = propertyAssignment.getPlugin();
            if (plugin != null) {
                this.writeAttributeIfNotNull(out, "plugin", plugin.getPermId().getPermId());
                this.writeAttributeIfNotNull(out, "pluginType", plugin.getPluginType().toString());
            }
            out.writeEndElement();
        }
        out.writeEndElement();
    }
}

