/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.dss.plugins.sync.common;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.common.api.client.IServicePinger;
import ch.systemsx.cisd.openbis.common.api.client.ServiceFinder;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.EncapsulatedCommonServer;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.dto.SessionContextDTO;

public class ServiceFinderUtils {
    public static ICommonServer getCommonServer(String openBisServerUrl) {
        ServiceFinder finder = new ServiceFinder("openbis", "/rmi-common");
        ICommonServer commonServer = (ICommonServer)finder.createService(ICommonServer.class, openBisServerUrl, (IServicePinger)new IServicePinger<ICommonServer>(){

            public void ping(ICommonServer service) {
                service.getVersion();
            }
        });
        return commonServer;
    }

    public static String login(ICommonServer commonServer, String user, String password) {
        SessionContextDTO session = commonServer.tryAuthenticate(user, password);
        if (session == null) {
            throw UserFailureException.fromTemplate((String)("Invalid username/password combination for user:" + user), (Object[])new Object[0]);
        }
        return session.getSessionToken();
    }

    public static EncapsulatedCommonServer getEncapsulatedCommonServer(String sessionToken, String openBisServerUrl) {
        return EncapsulatedCommonServer.create((ICommonServer)ServiceFinderUtils.getCommonServer(openBisServerUrl), (String)sessionToken);
    }
}

