/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.dss.plugins.sync.common;

import ch.ethz.sis.openbis.generic.asapi.v3.IApplicationServerApi;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.ICodeHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.SearchResult;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.DataSet;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.fetchoptions.DataSetFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.DataSetPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.search.DataSetSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.Experiment;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.fetchoptions.ExperimentFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.ExperimentIdentifier;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.ExperimentPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.search.ExperimentSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.Material;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.fetchoptions.MaterialFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.search.MaterialSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.Project;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.fetchoptions.ProjectFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.search.ProjectSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.Sample;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.fetchoptions.SampleFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.SampleIdentifier;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.SamplePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.search.SampleSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.Space;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.fetchoptions.SpaceFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.id.SpacePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.search.SpaceSearchCriteria;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.common.MasterDataExtractor;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.common.entitygraph.Edge;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.common.entitygraph.EntityGraph;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.common.entitygraph.IEntityRetriever;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.common.entitygraph.INode;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.common.entitygraph.NodeIdentifier;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.common.entitygraph.SkinnyNode;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IMasterDataRegistrationTransaction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

public class SkinnyEntityRetriever
implements IEntityRetriever {
    private EntityGraph<INode> graph = new EntityGraph();
    private final IApplicationServerApi v3Api;
    private final IMasterDataRegistrationTransaction masterDataRegistrationTransaction;
    private final String sessionToken;

    private SkinnyEntityRetriever(IApplicationServerApi v3Api, String sessionToken, IMasterDataRegistrationTransaction masterDataRegistrationTransaction) {
        this.v3Api = v3Api;
        this.sessionToken = sessionToken;
        this.masterDataRegistrationTransaction = masterDataRegistrationTransaction;
    }

    public static SkinnyEntityRetriever createWithMasterDataRegistationTransaction(IApplicationServerApi v3Api, String sessionToken, IMasterDataRegistrationTransaction masterDataRegistrationTransaction) {
        return new SkinnyEntityRetriever(v3Api, sessionToken, masterDataRegistrationTransaction);
    }

    public static SkinnyEntityRetriever createWithSessionToken(IApplicationServerApi v3Api, String sessionToken) {
        return new SkinnyEntityRetriever(v3Api, sessionToken, null);
    }

    @Override
    public EntityGraph<INode> getEntityGraph(String spaceId) {
        this.buildEntityGraph(spaceId);
        return this.graph;
    }

    public boolean spaceExists(String spaceId) {
        SpacePermId spacePermId = new SpacePermId(spaceId);
        Map map = this.v3Api.getSpaces(this.sessionToken, Arrays.asList(spacePermId), new SpaceFetchOptions());
        return map.get(spacePermId) != null;
    }

    public List<Space> getSpaces() {
        return this.v3Api.searchSpaces(this.sessionToken, new SpaceSearchCriteria(), new SpaceFetchOptions()).getObjects();
    }

    public void buildEntityGraph(String spaceId) {
        this.graph = new EntityGraph();
        this.findSharedSamples();
        ProjectSearchCriteria prjCriteria = new ProjectSearchCriteria();
        prjCriteria.withSpace().withCode().thatEquals(spaceId);
        ProjectFetchOptions projectFetchOptions = new ProjectFetchOptions();
        projectFetchOptions.withSpace();
        List projects = this.v3Api.searchProjects(this.sessionToken, prjCriteria, projectFetchOptions).getObjects();
        for (Project project : projects) {
            SkinnyNode prjNode = new SkinnyNode(project.getPermId().toString(), NodeIdentifier.asNodeIdentifier(project), null, project.getSpace(), project.getCode());
            this.graph.addNode(prjNode);
            this.findExperiments(prjNode);
        }
        this.findSpaceSamples(spaceId);
    }

    private void findSharedSamples() {
        SampleFetchOptions fetchOptions = new SampleFetchOptions();
        fetchOptions.withType();
        fetchOptions.withSpace();
        List samples = this.v3Api.searchSamples(this.sessionToken, new SampleSearchCriteria(), fetchOptions).getObjects();
        for (Sample sample : samples) {
            if (sample.getSpace() != null) continue;
            SkinnyNode sampleNode = new SkinnyNode(sample.getPermId().toString(), NodeIdentifier.asNodeIdentifier(sample), sample.getType().getCode(), null, sample.getCode());
            this.graph.addNode(sampleNode);
            this.findChildAndComponentSamples(sampleNode);
            this.findAndAttachDataSets(sampleNode);
        }
    }

    private void findExperiments(INode prjNode) {
        ExperimentSearchCriteria criteria = new ExperimentSearchCriteria();
        criteria.withProject().withCode().thatEquals(prjNode.getCode());
        criteria.withProject().withSpace().withCode().thatEquals(prjNode.getSpace().getCode());
        ExperimentFetchOptions fetchOptions = new ExperimentFetchOptions();
        fetchOptions.withProject().withSpace();
        fetchOptions.withType();
        List experiments = this.v3Api.searchExperiments(this.sessionToken, criteria, fetchOptions).getObjects();
        for (Experiment exp : experiments) {
            SkinnyNode expNode = new SkinnyNode(exp.getPermId().toString(), NodeIdentifier.asNodeIdentifier(exp), exp.getType().getCode(), exp.getProject().getSpace(), exp.getCode());
            this.graph.addEdge(prjNode, expNode, new Edge("Connection"));
            this.findSamplesForExperiment(expNode);
            this.findAndAttachDataSetsForExperiment(expNode);
        }
    }

    private void findSpaceSamples(String spaceCode) {
        SampleSearchCriteria criteria = new SampleSearchCriteria();
        criteria.withSpace().withCode().thatEquals(spaceCode);
        criteria.withoutExperiment();
        criteria.withAndOperator();
        SampleFetchOptions fetchOptions = new SampleFetchOptions();
        fetchOptions.withType();
        fetchOptions.withSpace();
        List samples = this.v3Api.searchSamples(this.sessionToken, criteria, fetchOptions).getObjects();
        for (Sample sample : samples) {
            SkinnyNode sampleNode = new SkinnyNode(sample.getPermId().toString(), NodeIdentifier.asNodeIdentifier(sample), sample.getType().getCode(), sample.getSpace(), sample.getCode());
            this.graph.addNode(sampleNode);
            this.findChildAndComponentSamples(sampleNode);
            this.findAndAttachDataSets(sampleNode);
        }
    }

    private void findSamplesForExperiment(INode expNode) {
        SampleSearchCriteria criteria = new SampleSearchCriteria();
        criteria.withExperiment().withId().thatEquals((IObjectId)new ExperimentPermId(expNode.getPermId()));
        SampleFetchOptions fetchOptions = new SampleFetchOptions();
        fetchOptions.withDataSets();
        fetchOptions.withType();
        fetchOptions.withExperiment();
        fetchOptions.withSpace();
        List samples = this.v3Api.searchSamples(this.sessionToken, criteria, fetchOptions).getObjects();
        for (Sample sample : samples) {
            SkinnyNode sampleNode = new SkinnyNode(sample.getPermId().toString(), NodeIdentifier.asNodeIdentifier(sample), sample.getType().getCode(), sample.getSpace(), sample.getCode());
            this.graph.addEdge(expNode, sampleNode, new Edge("Connection"));
            this.findAndAttachDataSets(sampleNode);
            this.findChildAndComponentSamples(sampleNode);
        }
    }

    private void findAndAttachDataSetsForExperiment(INode expNode) {
        DataSetSearchCriteria dsCriteria = new DataSetSearchCriteria();
        dsCriteria.withExperiment().withId().thatEquals((IObjectId)new ExperimentIdentifier(expNode.getIdentifier().getEntityIdentifier()));
        DataSetFetchOptions dsFetchOptions = new DataSetFetchOptions();
        dsFetchOptions.withType();
        dsFetchOptions.withSample();
        dsFetchOptions.withExperiment();
        List dataSets = this.v3Api.searchDataSets(this.sessionToken, dsCriteria, dsFetchOptions).getObjects();
        for (DataSet dataSet : dataSets) {
            SkinnyNode dataSetNode = new SkinnyNode(dataSet.getPermId().toString(), NodeIdentifier.asNodeIdentifier(dataSet), dataSet.getType().getCode(), null, dataSet.getCode());
            this.graph.addEdge(expNode, dataSetNode, new Edge("Connection"));
            this.findChildAndContainedDataSets(dataSetNode);
        }
    }

    private void findAndAttachDataSets(INode sampleNode) {
        DataSetSearchCriteria dsCriteria = new DataSetSearchCriteria();
        dsCriteria.withSample().withId().thatEquals((IObjectId)new SampleIdentifier(sampleNode.getIdentifier().getEntityIdentifier()));
        DataSetFetchOptions dsFetchOptions = new DataSetFetchOptions();
        dsFetchOptions.withType();
        dsFetchOptions.withSample();
        dsFetchOptions.withExperiment();
        List dataSets = this.v3Api.searchDataSets(this.sessionToken, dsCriteria, dsFetchOptions).getObjects();
        for (DataSet dataSet : dataSets) {
            SkinnyNode dataSetNode = new SkinnyNode(dataSet.getPermId().toString(), NodeIdentifier.asNodeIdentifier(dataSet), dataSet.getType().getCode(), null, dataSet.getCode());
            this.graph.addEdge(sampleNode, dataSetNode, new Edge("Connection"));
            this.findChildAndContainedDataSets(dataSetNode);
        }
    }

    private void findChildAndComponentSamples(INode sampleNode) {
        SampleFetchOptions fetchOptions = new SampleFetchOptions();
        fetchOptions.withType();
        fetchOptions.withDataSets();
        fetchOptions.withExperiment();
        fetchOptions.withSpace();
        if (!this.graph.isVisitedAsParent(sampleNode.getIdentifier())) {
            this.graph.markAsVisitedAsParent(sampleNode.getIdentifier());
            this.findChildSamples(sampleNode, fetchOptions);
        }
        if (!this.graph.isVisitedAsContainer(sampleNode.getIdentifier())) {
            this.graph.markAsVisitedAsContainer(sampleNode.getIdentifier());
            this.findComponentSamples(sampleNode, fetchOptions);
        }
    }

    private void findComponentSamples(INode sampleNode, SampleFetchOptions fetchOptions) {
        SampleSearchCriteria criteria = new SampleSearchCriteria();
        criteria.withContainer().withId().thatEquals((IObjectId)new SamplePermId(sampleNode.getPermId()));
        List components = this.v3Api.searchSamples(this.sessionToken, criteria, fetchOptions).getObjects();
        for (Sample sample : components) {
            SkinnyNode subSampleNode = new SkinnyNode(sample.getPermId().toString(), NodeIdentifier.asNodeIdentifier(sample), sample.getType().getCode(), sample.getSpace(), sample.getCode());
            this.graph.addEdge(sampleNode, subSampleNode, new Edge("Component"));
            this.findAndAttachDataSets(subSampleNode);
            this.findChildAndComponentSamples(subSampleNode);
        }
    }

    private void findChildSamples(INode sampleNode, SampleFetchOptions fetchOptions) {
        SampleSearchCriteria criteria = new SampleSearchCriteria();
        criteria.withParents().withId().thatEquals((IObjectId)new SamplePermId(sampleNode.getPermId()));
        List children = this.v3Api.searchSamples(this.sessionToken, criteria, fetchOptions).getObjects();
        for (Sample sample : children) {
            SkinnyNode subSampleNode = new SkinnyNode(sample.getPermId().toString(), NodeIdentifier.asNodeIdentifier(sample), sample.getType().getCode(), sample.getSpace(), sample.getCode());
            this.graph.addEdge(sampleNode, subSampleNode, new Edge("Child"));
            this.findAndAttachDataSets(subSampleNode);
            this.findChildAndComponentSamples(subSampleNode);
        }
    }

    private void findChildAndContainedDataSets(INode dsNode) {
        DataSetFetchOptions dsFetchOptions = new DataSetFetchOptions();
        dsFetchOptions.withType();
        dsFetchOptions.withSample();
        dsFetchOptions.withExperiment();
        if (!this.graph.isVisitedAsParent(dsNode.getIdentifier())) {
            this.graph.markAsVisitedAsParent(dsNode.getIdentifier());
            this.findChildDataSets(dsNode, dsFetchOptions);
        }
        if (!this.graph.isVisitedAsContainer(dsNode.getIdentifier())) {
            this.graph.markAsVisitedAsContainer(dsNode.getIdentifier());
            this.findComponentDataSets(dsNode, dsFetchOptions);
        }
    }

    private void findComponentDataSets(INode dsNode, DataSetFetchOptions dsFetchOptions) {
        DataSetSearchCriteria criteria = new DataSetSearchCriteria();
        criteria.withContainer().withId().thatEquals((IObjectId)new DataSetPermId(dsNode.getPermId()));
        List components = this.v3Api.searchDataSets(this.sessionToken, criteria, dsFetchOptions).getObjects();
        for (DataSet ds : components) {
            SkinnyNode containedDsNode = new SkinnyNode(ds.getPermId().toString(), NodeIdentifier.asNodeIdentifier(ds), ds.getType().getCode(), null, ds.getCode());
            this.graph.addEdge(dsNode, containedDsNode, new Edge("Component"));
            this.findChildAndContainedDataSets(containedDsNode);
        }
    }

    private void findChildDataSets(INode dsNode, DataSetFetchOptions dsFetchOptions) {
        DataSetSearchCriteria criteria = new DataSetSearchCriteria();
        criteria.withParents().withId().thatEquals((IObjectId)new DataSetPermId(dsNode.getPermId()));
        List children = this.v3Api.searchDataSets(this.sessionToken, criteria, dsFetchOptions).getObjects();
        for (DataSet ds : children) {
            SkinnyNode childDsNode = new SkinnyNode(ds.getPermId().toString(), NodeIdentifier.asNodeIdentifier(ds), ds.getType().getCode(), null, ds.getCode());
            this.graph.addEdge(dsNode, childDsNode, new Edge("Child"));
            this.findChildAndContainedDataSets(childDsNode);
        }
    }

    @Override
    public List<Material> fetchMaterials() {
        MaterialSearchCriteria criteria = new MaterialSearchCriteria();
        MaterialFetchOptions fetchOptions = new MaterialFetchOptions();
        fetchOptions.withType();
        SearchResult searchResult = this.v3Api.searchMaterials(this.sessionToken, criteria, fetchOptions);
        return searchResult.getObjects();
    }

    public String fetchMasterDataAsXML() throws ParserConfigurationException, TransformerException {
        MasterDataExtractor masterDataExtractor = new MasterDataExtractor(this.v3Api, this.sessionToken, this.masterDataRegistrationTransaction);
        return masterDataExtractor.fetchAsXmlString();
    }

    protected List<String> extractCodes(List<? extends ICodeHolder> codeHolders) {
        ArrayList<String> codes = new ArrayList<String>();
        for (ICodeHolder iCodeHolder : codeHolders) {
            codes.add(iCodeHolder.getCode());
        }
        return codes;
    }
}

