/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.dss.plugins.sync.common.entitygraph;

import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.common.SyncEntityKind;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.common.entitygraph.Edge;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.common.entitygraph.EdgeNodePair;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.common.entitygraph.INode;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.common.entitygraph.NodeIdentifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EntityGraph<N extends INode> {
    private final Map<String, INode> nodes;
    private final Map<INode, List<EdgeNodePair>> adjacencyMap;
    private final Set<NodeIdentifier> visitedParents = new HashSet<NodeIdentifier>();
    private final Set<NodeIdentifier> visitedContainers = new HashSet<NodeIdentifier>();

    public EntityGraph() {
        this.nodes = new HashMap<String, INode>();
        this.adjacencyMap = new HashMap<INode, List<EdgeNodePair>>();
    }

    public boolean isVisitedAsParent(NodeIdentifier identifier) {
        return this.visitedParents.contains(identifier);
    }

    public boolean isVisitedAsContainer(NodeIdentifier identifier) {
        return this.visitedContainers.contains(identifier);
    }

    public void markAsVisitedAsParent(NodeIdentifier identifier) {
        this.visitedParents.add(identifier);
    }

    public void markAsVisitedAsContainer(NodeIdentifier identifier) {
        this.visitedContainers.add(identifier);
    }

    public void addEdge(INode startNode, INode endNode, Edge edge) {
        List<EdgeNodePair> adjacencyList = this.adjacencyMap.get(startNode);
        if (adjacencyList == null) {
            adjacencyList = new ArrayList<EdgeNodePair>();
            this.adjacencyMap.put(startNode, adjacencyList);
        } else {
            for (EdgeNodePair pair : adjacencyList) {
                if (!pair.getNode().equals(endNode)) continue;
                return;
            }
        }
        EdgeNodePair enPair = new EdgeNodePair(edge, endNode);
        startNode.addConnection(enPair);
        adjacencyList.add(enPair);
        this.addNode(endNode);
    }

    public void addNode(INode node) {
        String identifier = node.getIdentifier().toString();
        if (!this.nodes.containsKey(identifier)) {
            this.adjacencyMap.put(node, new ArrayList());
            this.nodes.put(identifier, node);
        }
    }

    public List<INode> getNodes() {
        return new ArrayList<INode>(this.nodes.values());
    }

    public String getEdgesForDOTRepresentation() {
        return this.getEdgesForNode(false);
    }

    public String getEdgesForTest() {
        return this.getEdgesForNode(true);
    }

    private String getEdgesForNode(boolean forTest) {
        StringBuffer sb = new StringBuffer();
        for (INode node : this.getNodes()) {
            List<EdgeNodePair> list = this.adjacencyMap.get(node);
            if (list.isEmpty() && !node.getEntityKind().equals((Object)SyncEntityKind.DATA_SET)) {
                sb.append(this.getRightHandNodeRep(node, forTest));
                sb.append(";");
                sb.append(System.getProperty("line.separator"));
                continue;
            }
            for (EdgeNodePair edgeNodePair : list) {
                INode neighbourNode = edgeNodePair.getNode();
                sb.append("\"" + node.getCode() + "(" + this.getDifferentiatorStr(node, forTest) + ")\" -> " + this.getRightHandNodeRep(neighbourNode, forTest));
                if (edgeNodePair.getEdge().getType().equals("Component")) {
                    sb.append(" [style=dotted, color=red]");
                } else if (edgeNodePair.getEdge().getType().equals("Child")) {
                    sb.append(" [style=dashed, color= blue]");
                }
                sb.append(";");
                sb.append(System.getProperty("line.separator"));
            }
        }
        return sb.toString();
    }

    private String getRightHandNodeRep(INode node, boolean forTest) {
        return "\"" + node.getCode() + "(" + this.getDifferentiatorStr(node, forTest) + ")\"";
    }

    private String getDifferentiatorStr(INode node, boolean forTest) {
        if (!forTest) {
            String differentiatorStr = "";
            differentiatorStr = node.getEntityKind().equals((Object)SyncEntityKind.EXPERIMENT) || node.getEntityKind().equals((Object)SyncEntityKind.PROJECT) ? node.getIdentifier().getEntityIdentifier() : node.getEntityKind().getAbbreviation();
            return differentiatorStr;
        }
        Map<String, String> propertiesOrNull = node.getPropertiesOrNull();
        String s = "props =";
        if (propertiesOrNull != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("props = ");
            for (String property : propertiesOrNull.keySet()) {
                sb.append(property);
                sb.append(":");
                sb.append(propertiesOrNull.get(property));
                sb.append(",");
            }
            s = new String(sb);
        }
        return s;
    }
}

