/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.dss.plugins.sync.common.entitygraph;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.attachment.Attachment;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IAttachmentsHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.ICodeHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IExperimentHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IPermIdHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IProjectHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IPropertiesHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IRegistrationDateHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.ISampleHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.ISpaceHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.DataSet;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.Experiment;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.Project;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.Sample;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.Space;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.common.SyncEntityKind;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.common.entitygraph.EdgeNodePair;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.common.entitygraph.INode;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.common.entitygraph.NodeIdentifier;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class Node<T extends IRegistrationDateHolder & IPermIdHolder>
implements INode {
    private final List<EdgeNodePair> connections;
    private final List<Attachment> attachments;
    protected final T entity;

    public T getEntity() {
        return this.entity;
    }

    public Node(T entity) {
        if (entity == null) {
            throw new IllegalArgumentException("Unspecified entity");
        }
        this.entity = entity;
        this.connections = new ArrayList<EdgeNodePair>();
        this.attachments = new ArrayList<Attachment>();
    }

    public int hashCode() {
        return this.getIdentifier().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Node)) {
            return false;
        }
        return this.getIdentifier().equals(((Node)obj).getIdentifier());
    }

    @Override
    public Map<String, String> getPropertiesOrNull() {
        if (!IPropertiesHolder.class.isAssignableFrom(this.entity.getClass())) {
            return null;
        }
        return ((IPropertiesHolder)this.entity).getProperties();
    }

    public String getSpaceOrNull() {
        Space space = this.getSpace();
        if (space == null) {
            return null;
        }
        return space.getCode();
    }

    public Experiment getExperimentOrNull() {
        if (!IExperimentHolder.class.isAssignableFrom(this.entity.getClass())) {
            return null;
        }
        return ((IExperimentHolder)this.entity).getExperiment();
    }

    public String getExperimentIdentifierOrNull() {
        Experiment exp = this.getExperimentOrNull();
        if (exp != null) {
            return exp.getIdentifier().toString();
        }
        return null;
    }

    public String getProjectOrNull() {
        if (!IProjectHolder.class.isAssignableFrom(this.entity.getClass())) {
            return null;
        }
        Project project = ((IProjectHolder)this.entity).getProject();
        return project != null ? project.getCode() : null;
    }

    public Sample getSampleOrNull() {
        if (!ISampleHolder.class.isAssignableFrom(this.entity.getClass())) {
            return null;
        }
        return ((ISampleHolder)this.entity).getSample();
    }

    public String getSampleIdentifierOrNull() {
        Sample sample = this.getSampleOrNull();
        if (sample != null) {
            return sample.getIdentifier().toString();
        }
        return null;
    }

    @Override
    public String getTypeCodeOrNull() {
        if (!IPropertiesHolder.class.isAssignableFrom(this.entity.getClass())) {
            return null;
        }
        if (this.entity instanceof Sample) {
            return ((Sample)this.entity).getType().getCode();
        }
        if (this.entity instanceof Experiment) {
            return ((Experiment)this.entity).getType().getCode();
        }
        if (this.entity instanceof DataSet) {
            return ((DataSet)this.entity).getType().getCode();
        }
        return null;
    }

    @Override
    public void addConnection(EdgeNodePair enPair) {
        this.connections.add(enPair);
    }

    @Override
    public List<EdgeNodePair> getConnections() {
        return this.connections;
    }

    public void setAttachments(List<Attachment> attachmentList) {
        this.attachments.clear();
        this.attachments.addAll(attachmentList);
    }

    public List<Attachment> getAttachmentsOrNull() {
        if (this.entity instanceof IAttachmentsHolder) {
            IAttachmentsHolder holder = (IAttachmentsHolder)this.entity;
            return holder.getAttachments();
        }
        return null;
    }

    @Override
    public String getPermId() {
        return ((IPermIdHolder)this.entity).getPermId().toString();
    }

    @Override
    public NodeIdentifier getIdentifier() {
        if (this.entity instanceof Project) {
            return new NodeIdentifier(SyncEntityKind.PROJECT, ((Project)this.entity).getIdentifier().getIdentifier());
        }
        if (this.entity instanceof Experiment) {
            return new NodeIdentifier(SyncEntityKind.EXPERIMENT, ((Experiment)this.entity).getIdentifier().getIdentifier());
        }
        if (this.entity instanceof Sample) {
            return new NodeIdentifier(SyncEntityKind.SAMPLE, ((Sample)this.entity).getIdentifier().getIdentifier());
        }
        if (this.entity instanceof DataSet) {
            return new NodeIdentifier(SyncEntityKind.DATA_SET, ((DataSet)this.entity).getPermId().toString());
        }
        throw new IllegalStateException("Entity " + this.entity + " is of invalid kind");
    }

    @Override
    public String getCode() {
        return ((ICodeHolder)this.entity).getCode();
    }

    public Date getRegistrationDate() {
        return this.entity.getRegistrationDate();
    }

    @Override
    public SyncEntityKind getEntityKind() {
        if (this.entity instanceof Project) {
            return SyncEntityKind.PROJECT;
        }
        if (this.entity instanceof Experiment) {
            return SyncEntityKind.EXPERIMENT;
        }
        if (this.entity instanceof Sample) {
            return SyncEntityKind.SAMPLE;
        }
        if (this.entity instanceof DataSet) {
            return SyncEntityKind.DATA_SET;
        }
        return null;
    }

    @Override
    public Space getSpace() {
        if (this.entity instanceof Experiment) {
            return ((Experiment)this.entity).getProject().getSpace();
        }
        if (!ISpaceHolder.class.isAssignableFrom(this.entity.getClass())) {
            return null;
        }
        return ((ISpaceHolder)this.entity).getSpace();
    }
}

