/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.dss.plugins.sync.common.entitygraph;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.DataSet;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.Experiment;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.Project;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.Sample;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.common.SyncEntityKind;

public class NodeIdentifier {
    private SyncEntityKind entityKind;
    private String entityIdentifier;

    public static NodeIdentifier asNodeIdentifier(Project project) {
        return new NodeIdentifier(SyncEntityKind.PROJECT, project.getIdentifier().getIdentifier());
    }

    public static NodeIdentifier asNodeIdentifier(Experiment experiment) {
        return new NodeIdentifier(SyncEntityKind.EXPERIMENT, experiment.getIdentifier().getIdentifier());
    }

    public static NodeIdentifier asNodeIdentifier(Sample sample) {
        return new NodeIdentifier(SyncEntityKind.SAMPLE, sample.getIdentifier().getIdentifier());
    }

    public static NodeIdentifier asNodeIdentifier(DataSet dataSet) {
        return new NodeIdentifier(SyncEntityKind.DATA_SET, dataSet.getPermId().getPermId());
    }

    public NodeIdentifier(SyncEntityKind entityKind, String entityIdentifier) {
        if (entityKind == null) {
            throw new IllegalArgumentException("Unspecified entity kind.");
        }
        if (entityIdentifier == null) {
            throw new IllegalArgumentException("Unspecified entity identifier.");
        }
        this.entityKind = entityKind;
        this.entityIdentifier = entityIdentifier;
    }

    public SyncEntityKind getEntityKind() {
        return this.entityKind;
    }

    public String getEntityIdentifier() {
        return this.entityIdentifier;
    }

    public int hashCode() {
        return 37 * this.entityKind.hashCode() + this.entityIdentifier.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof NodeIdentifier)) {
            return false;
        }
        NodeIdentifier that = (NodeIdentifier)obj;
        return this.entityKind == that.entityKind && this.entityIdentifier.equals(that.entityIdentifier);
    }

    public String toString() {
        return this.entityKind.getAbbreviation() + ":" + this.entityIdentifier;
    }
}

