/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource;

import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource.AbstractEntityDeliverer;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource.DeliveryContext;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource.DeliveryExecutionContext;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.IDataSourceQueryService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.lemnik.eodsql.DataSet;

abstract class AbstractEntityWithPermIdDeliverer
extends AbstractEntityDeliverer<String> {
    private final String databasePermIdColumn;
    private final String sql;

    AbstractEntityWithPermIdDeliverer(DeliveryContext context, String entityKind, String databaseTable) {
        this(context, entityKind, databaseTable, "perm_id");
    }

    AbstractEntityWithPermIdDeliverer(DeliveryContext context, String entityKind, String databaseTable, String databasePermIdColumn) {
        super(context, entityKind);
        this.databasePermIdColumn = databasePermIdColumn;
        this.sql = "select " + databasePermIdColumn + " from " + databaseTable + " order by " + databasePermIdColumn;
    }

    @Override
    protected List<String> getAllEntities(DeliveryExecutionContext executionContext, String sessionToken) {
        return this.getAllEntities(executionContext, sessionToken, this.sql);
    }

    protected List<String> getAllEntities(DeliveryExecutionContext executionContext, String sessionToken, String query) {
        IDataSourceQueryService queryService = executionContext.getQueryService();
        ArrayList<String> permIds = new ArrayList<String>();
        String dataSourceName = this.context.getOpenBisDataSourceName();
        DataSet<Map<String, Object>> select = queryService.select(dataSourceName, query);
        for (Map row : select) {
            permIds.add((String)row.get(this.databasePermIdColumn));
        }
        return permIds;
    }
}

