/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IPermIdHolder;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;

class ConnectionsBuilder {
    private List<Connection> connections = new ArrayList<Connection>();

    ConnectionsBuilder() {
    }

    void addChildren(List<? extends IPermIdHolder> entities) {
        this.addConnections(entities, ConnectionType.CHILD);
    }

    void addComponents(List<? extends IPermIdHolder> entities) {
        this.addConnections(entities, ConnectionType.COMPONENT);
    }

    void addConnections(List<? extends IPermIdHolder> entities) {
        this.addConnections(entities, ConnectionType.CONNECTION);
    }

    void writeTo(XMLStreamWriter writer) throws XMLStreamException {
        if (this.connections.isEmpty()) {
            return;
        }
        writer.writeStartElement("x:connections");
        for (Connection connection : this.connections) {
            writer.writeStartElement("x:connection");
            writer.writeAttribute("to", connection.permId);
            writer.writeAttribute("type", StringUtils.capitalize((String)connection.type.toString().toLowerCase()));
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void addConnections(List<? extends IPermIdHolder> entities, ConnectionType child) {
        for (IPermIdHolder iPermIdHolder : entities) {
            this.connections.add(new Connection(iPermIdHolder.getPermId().toString(), child));
        }
    }

    private static final class Connection {
        private String permId;
        private ConnectionType type;

        Connection(String permId, ConnectionType type) {
            this.permId = permId;
            this.type = type;
        }
    }

    private static enum ConnectionType {
        CONNECTION,
        CHILD,
        COMPONENT;

    }
}

