/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource;

import ch.ethz.sis.openbis.generic.asapi.v3.IApplicationServerApi;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.ICodeHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IModifierHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IRegistrationDateHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IRegistratorHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.ContentCopy;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.DataSet;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.LinkedData;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.PhysicalData;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.fetchoptions.DataSetFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.DataSetPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.EntityKind;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.Experiment;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource.AbstractEntityWithPermIdDeliverer;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource.ConnectionsBuilder;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource.DeliveryContext;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource.DeliveryExecutionContext;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class DataSetDeliverer
extends AbstractEntityWithPermIdDeliverer {
    DataSetDeliverer(DeliveryContext context) {
        super(context, "data set", "data", "code");
    }

    @Override
    protected void deliverEntities(DeliveryExecutionContext context, List<String> dataSets) throws XMLStreamException {
        XMLStreamWriter writer = context.getWriter();
        String sessionToken = context.getSessionToken();
        Set<String> spaces = context.getSpaces();
        IApplicationServerApi v3api = this.getV3Api();
        List permIds = dataSets.stream().map(DataSetPermId::new).collect(Collectors.toList());
        Collection fullDataSets = v3api.getDataSets(sessionToken, permIds, this.createDataSetFetchOptions()).values();
        int count = 0;
        for (DataSet dataSet : fullDataSets) {
            if (!this.accept(dataSet, spaces)) continue;
            String code = dataSet.getCode();
            this.startUrlElement(writer, "DATA_SET", code, dataSet.getModificationDate());
            this.startXdElement(writer);
            writer.writeAttribute("code", code);
            writer.writeAttribute("dsKind", dataSet.getKind().toString());
            this.addAttributeIfSet(writer, "frozen", dataSet.isFrozen());
            this.addAttributeIfSet(writer, "frozenForChildren", dataSet.isFrozenForChildren());
            this.addAttributeIfSet(writer, "frozenForParents", dataSet.isFrozenForParents());
            this.addAttributeIfSet(writer, "frozenForComponents", dataSet.isFrozenForComponents());
            this.addAttributeIfSet(writer, "frozenForContainers", dataSet.isFrozenForContainers());
            this.addExperiment(writer, dataSet.getExperiment());
            this.addKind(writer, EntityKind.DATA_SET);
            this.addModifier(writer, (IModifierHolder)dataSet);
            this.addRegistrationDate(writer, (IRegistrationDateHolder)dataSet);
            this.addRegistrator(writer, (IRegistratorHolder)dataSet);
            this.addSample(writer, dataSet.getSample());
            this.addType(writer, (ICodeHolder)dataSet.getType());
            this.addProperties(writer, dataSet.getProperties(), context);
            this.addPhysicalData(writer, dataSet, code);
            this.addLinkedData(writer, dataSet, code);
            ConnectionsBuilder connectionsBuilder = new ConnectionsBuilder();
            connectionsBuilder.addChildren(dataSet.getChildren());
            connectionsBuilder.addComponents(dataSet.getComponents());
            connectionsBuilder.writeTo(writer);
            writer.writeEndElement();
            writer.writeEndElement();
            ++count;
        }
        this.operationLog.info((Object)(count + " of " + dataSets.size() + " data sets have been delivered."));
    }

    private void addPhysicalData(XMLStreamWriter writer, DataSet dataSet, String code) throws XMLStreamException {
        PhysicalData physicalData = dataSet.getPhysicalData();
        if (physicalData != null) {
            this.startBinaryDataElement(writer);
            this.addFileNodes(writer, code, this.context.getContentProvider().asContent(code).getRootNode());
            writer.writeEndElement();
        }
    }

    private void addLinkedData(XMLStreamWriter writer, DataSet dataSet, String code) throws XMLStreamException {
        LinkedData linkedData = dataSet.getLinkedData();
        if (linkedData != null) {
            this.startBinaryDataElement(writer);
            List contentCopies = linkedData.getContentCopies();
            for (ContentCopy contentCopy : contentCopies) {
                writer.writeStartElement("x:contentCopy");
                this.addAttribute(writer, "externalCode", contentCopy.getExternalCode());
                this.addAttribute(writer, "externalDMS", contentCopy.getExternalDms(), edms -> edms.getCode());
                this.addAttribute(writer, "gitCommitHash", contentCopy.getGitCommitHash());
                this.addAttribute(writer, "gitRepositoryId", contentCopy.getGitRepositoryId());
                this.addAttribute(writer, "id", contentCopy.getId(), id -> id.getPermId());
                this.addAttribute(writer, "path", contentCopy.getPath());
                writer.writeEndElement();
            }
            IHierarchicalContent content = this.context.getContentProvider().asContent(code);
            if (content != null) {
                this.addFileNodes(writer, code, content.getRootNode());
            }
            writer.writeEndElement();
        }
    }

    private void addFileNodes(XMLStreamWriter writer, String dataSetCode, IHierarchicalContentNode node) throws XMLStreamException {
        if (node.isDirectory()) {
            List childNodes = node.getChildNodes();
            for (IHierarchicalContentNode childNode : childNodes) {
                this.addFileNodes(writer, dataSetCode, childNode);
            }
        } else {
            writer.writeStartElement("x:fileNode");
            this.addAttribute(writer, "checksum", node.getChecksum());
            if (node.isChecksumCRC32Precalculated()) {
                writer.writeAttribute("crc32checksum", Integer.toString(node.getChecksumCRC32()));
            }
            writer.writeAttribute("length", Long.toString(node.getFileLength()));
            writer.writeAttribute("path", this.context.getDownloadUrl() + "/datastore_server/" + dataSetCode + "/" + node.getRelativePath() + "?");
            writer.writeEndElement();
        }
    }

    private boolean accept(DataSet dataSet, Set<String> spaces) {
        Experiment experiment = dataSet.getExperiment();
        if (experiment != null) {
            return spaces.contains(experiment.getProject().getSpace().getCode());
        }
        return spaces.contains(dataSet.getSample().getSpace().getCode());
    }

    private DataSetFetchOptions createDataSetFetchOptions() {
        DataSetFetchOptions fo = new DataSetFetchOptions();
        fo.withRegistrator();
        fo.withModifier();
        fo.withType();
        fo.withSample().withSpace();
        fo.withExperiment().withProject().withSpace();
        fo.withProperties();
        fo.withChildren();
        fo.withComponents();
        fo.withPhysicalData();
        fo.withLinkedData().withExternalDms();
        fo.sortBy().code();
        return fo;
    }
}

