/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.Space;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.fetchoptions.SpaceFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.search.SpaceSearchCriteria;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource.DataSetDeliverer;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource.DataSourceUtils;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource.Deliverers;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource.DeliveryContext;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource.DeliveryExecutionContext;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource.ExperimentDeliverer;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource.FileDeliverer;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource.IDeliverer;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource.MasterDataDeliverer;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource.MaterialDeliverer;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource.ProjectDeliverer;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource.SampleDeliverer;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource.SpaceDeliverer;
import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.dss.generic.server.oaipmh.IRequestHandler;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSourceQueryService;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.IDataSourceQueryService;
import ch.systemsx.cisd.openbis.generic.shared.dto.SessionContextDTO;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.log4j.Logger;

public class DataSourceRequestHandler
implements IRequestHandler {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, DataSourceRequestHandler.class);
    private IDeliverer deliverer;
    private DeliveryContext deliveryContext;

    @Override
    public void init(Properties properties) {
        this.deliveryContext = new DeliveryContext();
        this.deliveryContext.setServletPath(new File(PropertyUtils.getMandatoryProperty((Properties)properties, (String)"path")).getParent());
        this.deliveryContext.setServerUrl(PropertyUtils.getMandatoryProperty((Properties)properties, (String)"server-url"));
        this.deliveryContext.setDownloadUrl(PropertyUtils.getMandatoryProperty((Properties)properties, (String)"download-url"));
        String fileServiceRepositoryPath = PropertyUtils.getMandatoryProperty((Properties)properties, (String)"file-service-repository-path");
        this.deliveryContext.setFileServiceRepository(new File(fileServiceRepositoryPath));
        this.deliveryContext.setV3api(ServiceProvider.getV3ApplicationService());
        this.deliveryContext.setContentProvider(ServiceProvider.getHierarchicalContentProvider());
        this.deliveryContext.setOpenBisDataSourceName(properties.getProperty("openbis-data-source-name", "openbis-db"));
        Deliverers deliverers = new Deliverers();
        deliverers.addDeliverer(new MasterDataDeliverer(this.deliveryContext));
        deliverers.addDeliverer(new MaterialDeliverer(this.deliveryContext));
        deliverers.addDeliverer(new SpaceDeliverer(this.deliveryContext));
        deliverers.addDeliverer(new ProjectDeliverer(this.deliveryContext));
        deliverers.addDeliverer(new ExperimentDeliverer(this.deliveryContext));
        deliverers.addDeliverer(new SampleDeliverer(this.deliveryContext));
        deliverers.addDeliverer(new DataSetDeliverer(this.deliveryContext));
        deliverers.addDeliverer(new FileDeliverer(this.deliveryContext));
        this.deliverer = deliverers;
    }

    @Override
    public void handle(SessionContextDTO session, HttpServletRequest request, HttpServletResponse response) {
        DataSourceQueryService queryService = new DataSourceQueryService();
        try {
            Map<String, List<String>> parameterMap = this.getParameterMap(request);
            XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
            XMLStreamWriter writer = xmlOutputFactory.createXMLStreamWriter(response.getWriter());
            writer.writeStartDocument();
            writer.writeStartElement("urlset");
            writer.writeAttribute("xmlns", "http://www.sitemaps.org/schemas/sitemap/0.9");
            writer.writeAttribute("xmlns:rs", "http://www.openarchives.org/rs/terms/");
            writer.writeAttribute("xmlns:xmd", "https://sis.id.ethz.ch/software/#openbis/xmdterms/");
            writer.writeAttribute("xmlns:x", "https://sis.id.ethz.ch/software/#openbis/xdterms/");
            writer.writeAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            writer.writeAttribute("xsi:schemaLocation", "https://sis.id.ethz.ch/software/#openbis/xdterms/ ./xml/xdterms.xsd https://sis.id.ethz.ch/software/#openbis/xmdterms/");
            String sessionToken = session.getSessionToken();
            Date requestTimestamp = this.getRequestTimestamp(queryService);
            HashSet<String> verbs = new HashSet<String>((Collection)parameterMap.get("verb"));
            Capability capability = this.findMatchingCapability(verbs);
            WritingContext writingContext = new WritingContext();
            writingContext.setWriter(writer);
            writingContext.setDeliveryContext(this.deliveryContext);
            writingContext.setQueryService(queryService);
            writingContext.setDeliverer(this.deliverer);
            writingContext.setParameterMap(parameterMap);
            writingContext.setSessionToken(sessionToken);
            writingContext.setRequestTimestamp(requestTimestamp);
            capability.write(writingContext);
            writer.writeEndElement();
            writer.writeEndDocument();
        }
        catch (Exception e) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)e);
        }
        finally {
            queryService.release();
        }
    }

    private Capability findMatchingCapability(Set<String> verbs) {
        if (verbs != null) {
            for (Capability capability : Capability.values()) {
                if (!capability.matchVerb(verbs)) continue;
                return capability;
            }
        }
        return Capability.ABOUT;
    }

    private Date getRequestTimestamp(IDataSourceQueryService queryService) {
        Date requestTimestamp = new Date();
        String query = "select xact_start FROM pg_stat_activity WHERE xact_start IS NOT NULL ORDER BY xact_start ASC LIMIT 1";
        for (Map map : queryService.select(this.deliveryContext.getOpenBisDataSourceName(), query)) {
            requestTimestamp = (Date)map.get("xact_start");
        }
        return requestTimestamp;
    }

    private Map<String, List<String>> getParameterMap(HttpServletRequest request) {
        Enumeration enumeration = request.getParameterNames();
        HashMap<String, List<String>> parameterMap = new HashMap<String, List<String>>();
        while (enumeration.hasMoreElements()) {
            String parameter = (String)enumeration.nextElement();
            parameterMap.put(parameter, Arrays.asList(request.getParameterValues(parameter)));
        }
        operationLog.info((Object)("Parameters: " + parameterMap));
        return parameterMap;
    }

    private static final class WritingContext {
        private XMLStreamWriter writer;
        private DeliveryContext context;
        private IDataSourceQueryService queryService;
        private IDeliverer deliverer;
        private Map<String, List<String>> parameterMap;
        private String sessionToken;
        private Date requestTimestamp;
        private Set<String> fileServicePaths = new TreeSet<String>();

        private WritingContext() {
        }

        public XMLStreamWriter getWriter() {
            return this.writer;
        }

        public void setWriter(XMLStreamWriter writer) {
            this.writer = writer;
        }

        public DeliveryContext getDeliveryContext() {
            return this.context;
        }

        public void setDeliveryContext(DeliveryContext context) {
            this.context = context;
        }

        public IDataSourceQueryService getQueryService() {
            return this.queryService;
        }

        public void setQueryService(IDataSourceQueryService queryService) {
            this.queryService = queryService;
        }

        public IDeliverer getDeliverer() {
            return this.deliverer;
        }

        public void setDeliverer(IDeliverer deliverer) {
            this.deliverer = deliverer;
        }

        public Map<String, List<String>> getParameterMap() {
            return this.parameterMap;
        }

        public void setParameterMap(Map<String, List<String>> parameterMap) {
            this.parameterMap = parameterMap;
        }

        public String getSessionToken() {
            return this.sessionToken;
        }

        public void setSessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
        }

        public Date getRequestTimestamp() {
            return this.requestTimestamp;
        }

        public void setRequestTimestamp(Date requestTimestamp) {
            this.requestTimestamp = requestTimestamp;
        }

        public Set<String> getFileServicePaths() {
            return this.fileServicePaths;
        }
    }

    private static enum Capability {
        ABOUT("about", "description", null, false),
        CAPABILITY_LIST("capabilitylist", ABOUT, false),
        RESOURCE_LIST("resourcelist", CAPABILITY_LIST, true){

            @Override
            void writeUrls(WritingContext context) throws XMLStreamException {
                SpaceSearchCriteria searchCriteria = new SpaceSearchCriteria();
                SpaceFetchOptions fetchOptions = new SpaceFetchOptions();
                DeliveryContext deliveryContext = context.getDeliveryContext();
                String sessionToken = context.getSessionToken();
                List spaces = deliveryContext.getV3api().searchSpaces(sessionToken, searchCriteria, fetchOptions).getObjects();
                List<String> spaceCodes = spaces.stream().map(Space::getCode).collect(Collectors.toList());
                Map<String, List<String>> parameterMap = context.getParameterMap();
                Set<String> requestedSpaces = DataSourceUtils.getRequestedAndAllowedSubSet(spaceCodes, parameterMap.get("white_list"), parameterMap.get("black_list"));
                operationLog.info((Object)("Requested spaces: " + requestedSpaces));
                IDeliverer deliverer = context.getDeliverer();
                IDataSourceQueryService queryService = context.getQueryService();
                DeliveryExecutionContext executionContext = new DeliveryExecutionContext();
                executionContext.setQueryService(queryService);
                executionContext.setRequestTimestamp(context.getRequestTimestamp());
                executionContext.setSessionToken(sessionToken);
                executionContext.setSpaces(requestedSpaces);
                executionContext.setWriter(context.getWriter());
                executionContext.setFileServicePaths(context.getFileServicePaths());
                deliverer.deliverEntities(executionContext);
            }
        };

        private String name;
        private Capability up;
        private Capability down;
        private String capabilityAttribute;
        private boolean withAt;

        private Capability(String name, Capability up, boolean withAt) {
            this(name, name, up, withAt);
        }

        private Capability(String name, String capabilityAttribute, Capability up, boolean withAt) {
            this.name = name;
            this.capabilityAttribute = capabilityAttribute;
            this.up = up;
            this.withAt = withAt;
        }

        boolean matchVerb(Set<String> verbs) {
            return verbs.contains(this.asVerb());
        }

        String asVerb() {
            return this.name + ".xml";
        }

        void write(WritingContext context) throws XMLStreamException {
            XMLStreamWriter writer = context.getWriter();
            writer.writeStartElement("rs:ln");
            String verb = this.up == null ? this.asVerb() : this.up.asVerb();
            writer.writeAttribute("href", this.createDownloadUrl(context.getDeliveryContext(), verb));
            writer.writeAttribute("rel", this.up == null ? "describedby" : "up");
            writer.writeEndElement();
            writer.writeStartElement("rs:md");
            if (this.withAt) {
                Date requestTimestamp = context.getRequestTimestamp();
                writer.writeAttribute("at", DataSourceUtils.convertToW3CDate(requestTimestamp));
            }
            writer.writeAttribute("capability", this.capabilityAttribute);
            writer.writeEndElement();
            this.writeUrls(context);
        }

        void writeUrls(WritingContext context) throws XMLStreamException {
            XMLStreamWriter writer = context.getWriter();
            writer.writeStartElement("url");
            writer.writeStartElement("loc");
            writer.writeCharacters(this.createDownloadUrl(context.getDeliveryContext(), this.down.asVerb()));
            writer.writeEndElement();
            writer.writeStartElement("rs:md");
            writer.writeAttribute("capability", this.down.name);
            writer.writeEndElement();
        }

        private String createDownloadUrl(DeliveryContext context, String verb) {
            return context.getDownloadUrl() + context.getServletPath() + "/?verb=" + verb;
        }

        static {
            Capability.ABOUT.down = CAPABILITY_LIST;
            Capability.CAPABILITY_LIST.down = RESOURCE_LIST;
        }
    }
}

