/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Pattern;

class DataSourceUtils {
    DataSourceUtils() {
    }

    static String convertToW3CDate(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.US);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        return format.format(date) + "Z";
    }

    static Set<String> getRequestedAndAllowedSubSet(Collection<String> fullSet, List<String> whiteLists, List<String> blackLists) {
        List<Pattern> allowedPatterns = DataSourceUtils.getRegexs(whiteLists);
        List<Pattern> disallowedPatterns = DataSourceUtils.getRegexs(blackLists);
        LinkedHashSet<String> subSet = new LinkedHashSet<String>();
        for (String item : fullSet) {
            if (DataSourceUtils.matchesARegex(disallowedPatterns, item) || !allowedPatterns.isEmpty() && !DataSourceUtils.matchesARegex(allowedPatterns, item)) continue;
            subSet.add(item);
        }
        return subSet;
    }

    private static boolean matchesARegex(List<Pattern> patterns, String item) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(item).matches()) continue;
            return true;
        }
        return false;
    }

    private static List<Pattern> getRegexs(List<String> lists) {
        ArrayList<Pattern> regexs = new ArrayList<Pattern>();
        if (lists != null) {
            for (String commaSeparatedList : lists) {
                String[] splitted;
                for (String string : splitted = commaSeparatedList.split(",")) {
                    regexs.add(Pattern.compile(string.trim()));
                }
            }
        }
        return regexs;
    }
}

