/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource;

import ch.ethz.sis.openbis.generic.asapi.v3.IApplicationServerApi;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.ICodeHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IModifierHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IRegistrationDateHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IRegistratorHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.EntityKind;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.Experiment;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.fetchoptions.ExperimentFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.ExperimentPermId;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource.AbstractEntityWithPermIdDeliverer;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource.DeliveryContext;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource.DeliveryExecutionContext;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class ExperimentDeliverer
extends AbstractEntityWithPermIdDeliverer {
    ExperimentDeliverer(DeliveryContext context) {
        super(context, "experiment", "experiments");
    }

    @Override
    protected void deliverEntities(DeliveryExecutionContext context, List<String> experiments) throws XMLStreamException {
        XMLStreamWriter writer = context.getWriter();
        String sessionToken = context.getSessionToken();
        Set<String> spaces = context.getSpaces();
        IApplicationServerApi v3api = this.getV3Api();
        List permIds = experiments.stream().map(ExperimentPermId::new).collect(Collectors.toList());
        Collection fullExperiments = v3api.getExperiments(sessionToken, permIds, this.createFullFetchOptions()).values();
        int count = 0;
        for (Experiment experiment : fullExperiments) {
            if (!spaces.contains(experiment.getProject().getSpace().getCode())) continue;
            String permId = experiment.getPermId().getPermId();
            this.startUrlElement(writer, "EXPERIMENT", permId, experiment.getModificationDate());
            this.startXdElement(writer);
            writer.writeAttribute("code", experiment.getCode());
            this.addKind(writer, EntityKind.EXPERIMENT);
            this.addAttributeIfSet(writer, "frozen", experiment.isFrozen());
            this.addAttributeIfSet(writer, "frozenForSamples", experiment.isFrozenForSamples());
            this.addAttributeIfSet(writer, "frozenForDataSets", experiment.isFrozenForDataSets());
            this.addModifier(writer, (IModifierHolder)experiment);
            this.addProject(writer, experiment.getProject());
            this.addRegistrationDate(writer, (IRegistrationDateHolder)experiment);
            this.addRegistrator(writer, (IRegistratorHolder)experiment);
            this.addSpace(writer, experiment.getProject().getSpace());
            this.addType(writer, (ICodeHolder)experiment.getType());
            this.addProperties(writer, experiment.getProperties(), context);
            this.addAttachments(writer, experiment.getAttachments());
            writer.writeEndElement();
            writer.writeEndElement();
            ++count;
        }
        this.operationLog.info((Object)(count + " of " + experiments.size() + " experiments have been delivered."));
    }

    private ExperimentFetchOptions createFullFetchOptions() {
        ExperimentFetchOptions fo = new ExperimentFetchOptions();
        fo.withRegistrator();
        fo.withModifier();
        fo.withProperties();
        fo.withProject().withSpace();
        fo.withType();
        fo.withAttachments();
        return fo;
    }
}

