/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource;

import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource.AbstractEntityDeliverer;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource.DeliveryContext;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource.DeliveryExecutionContext;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import java.io.File;
import java.util.Base64;
import java.util.Date;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class FileDeliverer
extends AbstractEntityDeliverer<String> {
    FileDeliverer(DeliveryContext context) {
        super(context, "file");
    }

    @Override
    public void deliverEntities(DeliveryExecutionContext context) throws XMLStreamException {
        Set<String> paths = context.getFileServicePaths();
        if (paths.isEmpty()) {
            return;
        }
        File repository = this.context.getFileServiceRepository();
        XMLStreamWriter writer = context.getWriter();
        int count = 0;
        long totalSize = 0L;
        for (String path : paths) {
            File file = new File(repository, path);
            if (file.isFile()) {
                this.startUrlElement(writer, "FILE", path, new Date(file.lastModified()));
                this.startXdElement(writer);
                this.addKind(writer, "FILE");
                writer.writeAttribute("path", path);
                byte[] content = FileUtilities.loadToByteArray((File)file);
                String contentAsBase64String = Base64.getEncoder().encodeToString(content);
                writer.writeCharacters(contentAsBase64String);
                writer.writeEndElement();
                writer.writeEndElement();
                ++count;
                totalSize += (long)content.length;
                continue;
            }
            this.operationLog.warn((Object)("File expected but does not exists: " + file.getAbsolutePath()));
        }
        this.operationLog.info((Object)(count + " files (total size: " + FileUtilities.byteCountToDisplaySize((long)totalSize) + ") have been delivered."));
    }
}

