/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.ICodeHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IDescriptionHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.DataSetType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.fetchoptions.DataSetTypeFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.search.DataSetTypeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.EntityKind;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.ExperimentType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.fetchoptions.ExperimentTypeFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.search.ExperimentTypeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.externaldms.ExternalDms;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.externaldms.fetchoptions.ExternalDmsFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.externaldms.search.ExternalDmsSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.MaterialType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.fetchoptions.MaterialTypeFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.search.MaterialTypeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.plugin.Plugin;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.plugin.fetchoptions.PluginFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.plugin.search.PluginSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.PropertyAssignment;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.PropertyType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.fetchoptions.PropertyTypeFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.search.PropertyTypeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.SampleType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.fetchoptions.SampleTypeFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.search.SampleTypeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.Vocabulary;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.VocabularyTerm;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.fetchoptions.VocabularyFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.search.VocabularySearchCriteria;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.common.ServiceFinderUtils;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource.AbstractEntityDeliverer;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource.DataSourceUtils;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource.DeliveryContext;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource.DeliveryExecutionContext;
import ch.systemsx.cisd.common.shared.basic.string.CommaSeparatedListBuilder;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.IDataSourceQueryService;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.DataType;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IFileFormatTypeImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IMasterDataRegistrationTransaction;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.EncapsulatedCommonServer;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.MasterDataRegistrationService;
import ch.systemsx.cisd.openbis.generic.shared.basic.BasicConstant;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeConverter;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class MasterDataDeliverer
extends AbstractEntityDeliverer<Object> {
    private static final VocabularySearchCriteria VOCABULARY_SEARCH_CRITERIA = new VocabularySearchCriteria();
    private static final PropertyTypeSearchCriteria PROPERTY_TYPE_SEARCH_CRITERIA = new PropertyTypeSearchCriteria();
    private static final ExperimentTypeSearchCriteria EXPERIMENT_TYPE_SEARCH_CRITERIA = new ExperimentTypeSearchCriteria();
    private static final MaterialTypeSearchCriteria MATERIAL_TYPE_SEARCH_CRITERIA = new MaterialTypeSearchCriteria();
    private static final SampleTypeSearchCriteria SAMPLE_TYPE_SEARCH_CRITERIA = new SampleTypeSearchCriteria();
    private static final DataSetTypeSearchCriteria DATA_SET_TYPE_SEARCH_CRITERIA = new DataSetTypeSearchCriteria();

    MasterDataDeliverer(DeliveryContext context) {
        super(context, "master data");
    }

    @Override
    public void deliverEntities(DeliveryExecutionContext context) throws XMLStreamException {
        XMLStreamWriter writer = context.getWriter();
        this.startUrlElement(writer);
        this.addLocation(writer, "MASTER_DATA", "MASTER_DATA");
        this.addLastModificationDate(writer, context.getRequestTimestamp());
        writer.writeStartElement("xmd:masterData");
        String sessionToken = context.getSessionToken();
        this.addFileFormatTypes(writer, context.getQueryService(), sessionToken);
        this.addValidationPlugins(context, writer, sessionToken);
        this.addVocabularies(context, writer, sessionToken);
        this.addPropertyTypes(context, writer, sessionToken);
        this.addSampleTypes(context, writer, sessionToken);
        this.addExperimentTypes(context, writer, sessionToken);
        this.addDataSetTypes(context, writer, sessionToken);
        this.addMaterialTypes(context, writer, sessionToken);
        this.addExternalDataManagementSystems(context, writer, sessionToken);
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private void addFileFormatTypes(XMLStreamWriter writer, IDataSourceQueryService queryService, String sessionToken) throws XMLStreamException {
        String openBisServerUrl = ServiceProvider.getConfigProvider().getOpenBisServerUrl();
        EncapsulatedCommonServer encapsulatedServer = ServiceFinderUtils.getEncapsulatedCommonServer(sessionToken, openBisServerUrl);
        MasterDataRegistrationService service = new MasterDataRegistrationService(encapsulatedServer);
        IMasterDataRegistrationTransaction masterDataRegistrationTransaction = service.transaction();
        List fileFormatTypes = masterDataRegistrationTransaction.listFileFormatTypes();
        if (fileFormatTypes.size() > 0) {
            writer.writeStartElement("xmd:fileFormatTypes");
            for (IFileFormatTypeImmutable fileFormatType : fileFormatTypes) {
                writer.writeStartElement("xmd:fileFormatType");
                this.addAttribute(writer, "code", fileFormatType.getCode());
                this.addAttribute(writer, "description", fileFormatType.getDescription());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void addValidationPlugins(DeliveryExecutionContext executionContext, XMLStreamWriter writer, String sessionToken) throws XMLStreamException {
        PluginFetchOptions fetchOptions = new PluginFetchOptions();
        fetchOptions.withScript();
        List plugins = this.context.getV3api().searchPlugins(sessionToken, new PluginSearchCriteria(), fetchOptions).getObjects();
        if (plugins.isEmpty()) {
            return;
        }
        writer.writeStartElement("xmd:validationPlugins");
        for (Plugin plugin : plugins) {
            writer.writeStartElement("xmd:validationPlugin");
            this.addAttributeAndExtractFilePaths(executionContext, writer, "description", plugin.getDescription());
            this.addAttribute(writer, "entityKind", this.getEntityKind(plugin));
            this.addAttribute(writer, "isAvailable", String.valueOf(plugin.isAvailable()));
            this.addAttribute(writer, "name", plugin.getName());
            this.addAttribute(writer, "type", plugin.getPluginType(), t -> t.toString());
            this.addAttribute(writer, "registration-timestamp", plugin.getRegistrationDate(), h -> DataSourceUtils.convertToW3CDate(h));
            this.addAttribute(writer, "modification-timestamp", plugin.getRegistrationDate(), h -> DataSourceUtils.convertToW3CDate(h));
            if (plugin.getScript() != null) {
                writer.writeCData(plugin.getScript());
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private String getEntityKind(Plugin plugin) {
        String entityKind = "All";
        Set entityKinds = plugin.getEntityKinds();
        if (entityKinds != null) {
            CommaSeparatedListBuilder builder = new CommaSeparatedListBuilder();
            for (EntityKind kind : entityKinds) {
                builder.append((Object)kind.toString());
            }
            entityKind = builder.toString();
        }
        return entityKind;
    }

    private void addVocabularies(DeliveryExecutionContext executionContext, XMLStreamWriter writer, String sessionToken) throws XMLStreamException {
        VocabularyFetchOptions fetchOptions = new VocabularyFetchOptions();
        fetchOptions.withTerms().withRegistrator();
        fetchOptions.withRegistrator();
        List vocabularies = this.context.getV3api().searchVocabularies(sessionToken, VOCABULARY_SEARCH_CRITERIA, fetchOptions).getObjects();
        if (vocabularies.isEmpty()) {
            return;
        }
        writer.writeStartElement("xmd:controlledVocabularies");
        for (Vocabulary vocabulary : vocabularies) {
            writer.writeStartElement("xmd:controlledVocabulary");
            String code = vocabulary.isManagedInternally() && vocabulary.getCode().startsWith("$") ? CodeConverter.tryToDatabase((String)vocabulary.getCode()) : vocabulary.getCode();
            this.addAttribute(writer, "chosenFromList", String.valueOf(vocabulary.isChosenFromList()));
            this.addAttribute(writer, "code", code);
            this.addAttribute(writer, "description", vocabulary.getDescription());
            this.addAttribute(writer, "managedInternally", String.valueOf(vocabulary.isManagedInternally()));
            this.addAttribute(writer, "urlTemplate", vocabulary.getUrlTemplate());
            this.addAttribute(writer, "registration-timestamp", vocabulary.getRegistrationDate(), h -> DataSourceUtils.convertToW3CDate(h));
            this.addAttribute(writer, "registrator", vocabulary.getRegistrator().getUserId());
            this.addAttribute(writer, "modification-timestamp", vocabulary.getModificationDate(), h -> DataSourceUtils.convertToW3CDate(h));
            for (VocabularyTerm term : vocabulary.getTerms()) {
                writer.writeStartElement("xmd:term");
                this.addAttribute(writer, "code", term.getCode());
                this.addAttributeAndExtractFilePaths(executionContext, writer, "description", term.getDescription());
                this.addAttribute(writer, "label", term.getLabel());
                this.addAttribute(writer, "ordinal", String.valueOf(term.getOrdinal()));
                this.addAttribute(writer, "registration-timestamp", term.getRegistrationDate(), h -> DataSourceUtils.convertToW3CDate(h));
                this.addAttribute(writer, "registrator", term.getRegistrator().getUserId());
                this.addAttribute(writer, "url", vocabulary.getUrlTemplate(), t -> t.replaceAll(BasicConstant.DEPRECATED_VOCABULARY_URL_TEMPLATE_TERM_PATTERN, code).replaceAll(BasicConstant.VOCABULARY_URL_TEMPLATE_TERM_PATTERN, code));
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void addPropertyTypes(DeliveryExecutionContext executionContext, XMLStreamWriter writer, String sessionToken) throws XMLStreamException {
        PropertyTypeFetchOptions fetchOptions = new PropertyTypeFetchOptions();
        fetchOptions.withMaterialType();
        fetchOptions.withVocabulary();
        fetchOptions.withRegistrator();
        List propertyTypes = this.context.getV3api().searchPropertyTypes(sessionToken, PROPERTY_TYPE_SEARCH_CRITERIA, fetchOptions).getObjects();
        if (propertyTypes.isEmpty()) {
            return;
        }
        writer.writeStartElement("xmd:propertyTypes");
        for (PropertyType propertyType : propertyTypes) {
            Boolean managedInternally = propertyType.isManagedInternally();
            String code = managedInternally != false && propertyType.getCode().startsWith("$") ? CodeConverter.tryToDatabase((String)propertyType.getCode()) : propertyType.getCode();
            writer.writeStartElement("xmd:propertyType");
            this.addAttribute(writer, "code", code);
            this.addAttribute(writer, "dataType", propertyType.getDataType(), t -> t.name());
            this.addAttributeAndExtractFilePaths(executionContext, writer, "description", propertyType.getDescription());
            this.addAttribute(writer, "label", propertyType.getLabel());
            this.addAttribute(writer, "managedInternally", managedInternally);
            this.addAttribute(writer, "registration-timestamp", propertyType.getRegistrationDate(), h -> DataSourceUtils.convertToW3CDate(h));
            this.addAttribute(writer, "registrator", propertyType.getRegistrator().getUserId());
            if (propertyType.getDataType().name().equals(DataType.CONTROLLEDVOCABULARY.name())) {
                this.addAttribute(writer, "vocabulary", propertyType.getVocabulary(), v -> v.getCode());
            } else if (propertyType.getDataType().name().equals(DataType.MATERIAL.name())) {
                if (propertyType.getMaterialType() != null) {
                    this.addAttribute(writer, "material", propertyType.getMaterialType(), t -> t.getCode());
                } else {
                    this.addAttribute(writer, "material", "");
                }
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void addSampleTypes(DeliveryExecutionContext executionContext, XMLStreamWriter writer, String sessionToken) throws XMLStreamException {
        SampleTypeFetchOptions fetchOptions = new SampleTypeFetchOptions();
        fetchOptions.withPropertyAssignments().withPropertyType();
        fetchOptions.withPropertyAssignments().withPlugin();
        fetchOptions.withValidationPlugin();
        List types = this.context.getV3api().searchSampleTypes(sessionToken, SAMPLE_TYPE_SEARCH_CRITERIA, fetchOptions).getObjects();
        if (types.isEmpty()) {
            return;
        }
        writer.writeStartElement("xmd:objectTypes");
        for (SampleType type : types) {
            this.writeTypeElement(executionContext, writer, "xmd:objectType", type);
            this.addAttribute(writer, "autoGeneratedCode", type.isAutoGeneratedCode());
            this.addAttribute(writer, "generatedCodePrefix", type.getGeneratedCodePrefix());
            this.addAttribute(writer, "listable", type.isListable());
            this.addAttribute(writer, "showContainer", type.isShowContainer());
            this.addAttribute(writer, "showParentMetadata", type.isShowParentMetadata());
            this.addAttribute(writer, "showParents", type.isShowParents());
            this.addAttribute(writer, "subcodeUnique", type.isSubcodeUnique());
            this.addAttribute(writer, "validationPlugin", type.getValidationPlugin(), p -> p.getName());
            this.addAttribute(writer, "modification-timestamp", type.getModificationDate(), h -> DataSourceUtils.convertToW3CDate(h));
            this.addPropertyAssignments(writer, type.getPropertyAssignments());
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void addExperimentTypes(DeliveryExecutionContext executionContext, XMLStreamWriter writer, String sessionToken) throws XMLStreamException {
        ExperimentTypeFetchOptions fetchOptions = new ExperimentTypeFetchOptions();
        fetchOptions.withPropertyAssignments().withPropertyType();
        fetchOptions.withPropertyAssignments().withPlugin();
        fetchOptions.withValidationPlugin();
        List types = this.context.getV3api().searchExperimentTypes(sessionToken, EXPERIMENT_TYPE_SEARCH_CRITERIA, fetchOptions).getObjects();
        if (types.isEmpty()) {
            return;
        }
        writer.writeStartElement("xmd:collectionTypes");
        for (ExperimentType type : types) {
            this.writeTypeElement(executionContext, writer, "xmd:collectionType", type);
            this.addAttribute(writer, "validationPlugin", type.getValidationPlugin(), p -> p.getName());
            this.addAttribute(writer, "modification-timestamp", type.getModificationDate(), h -> DataSourceUtils.convertToW3CDate(h));
            this.addPropertyAssignments(writer, type.getPropertyAssignments());
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void addDataSetTypes(DeliveryExecutionContext executionContext, XMLStreamWriter writer, String sessionToken) throws XMLStreamException {
        DataSetTypeFetchOptions fetchOptions = new DataSetTypeFetchOptions();
        fetchOptions.withPropertyAssignments().withPropertyType();
        fetchOptions.withPropertyAssignments().withPlugin();
        fetchOptions.withValidationPlugin();
        List types = this.context.getV3api().searchDataSetTypes(sessionToken, DATA_SET_TYPE_SEARCH_CRITERIA, fetchOptions).getObjects();
        if (types.isEmpty()) {
            return;
        }
        writer.writeStartElement("xmd:dataSetTypes");
        for (DataSetType type : types) {
            this.writeTypeElement(executionContext, writer, "xmd:dataSetType", type);
            this.addAttribute(writer, "deletionDisallowed", type.isDisallowDeletion());
            this.addAttribute(writer, "mainDataSetPath", type.getMainDataSetPath());
            this.addAttribute(writer, "mainDataSetPattern", type.getMainDataSetPattern());
            this.addAttribute(writer, "validationPlugin", type.getValidationPlugin(), p -> p.getName());
            this.addAttribute(writer, "modification-timestamp", type.getModificationDate(), h -> DataSourceUtils.convertToW3CDate(h));
            this.addPropertyAssignments(writer, type.getPropertyAssignments());
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void addMaterialTypes(DeliveryExecutionContext executionContext, XMLStreamWriter writer, String sessionToken) throws XMLStreamException {
        MaterialTypeFetchOptions fetchOptions = new MaterialTypeFetchOptions();
        fetchOptions.withPropertyAssignments().withPropertyType();
        fetchOptions.withPropertyAssignments().withPlugin();
        fetchOptions.withValidationPlugin();
        List types = this.context.getV3api().searchMaterialTypes(sessionToken, MATERIAL_TYPE_SEARCH_CRITERIA, fetchOptions).getObjects();
        if (types.isEmpty()) {
            return;
        }
        writer.writeStartElement("xmd:materialTypes");
        for (MaterialType type : types) {
            this.writeTypeElement(executionContext, writer, "xmd:materialType", type);
            this.addAttribute(writer, "validationPlugin", type.getValidationPlugin(), p -> p.getName());
            this.addAttribute(writer, "modification-timestamp", type.getModificationDate(), h -> DataSourceUtils.convertToW3CDate(h));
            this.addPropertyAssignments(writer, type.getPropertyAssignments());
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void addExternalDataManagementSystems(DeliveryExecutionContext executionContext, XMLStreamWriter writer, String sessionToken) throws XMLStreamException {
        ExternalDmsSearchCriteria searchCriteria = new ExternalDmsSearchCriteria();
        ExternalDmsFetchOptions fetchOptions = new ExternalDmsFetchOptions();
        List externalDataManagementSystems = this.context.getV3api().searchExternalDataManagementSystems(sessionToken, searchCriteria, fetchOptions).getObjects();
        if (!externalDataManagementSystems.isEmpty()) {
            writer.writeStartElement("xmd:externalDataManagementSystems");
            for (ExternalDms externalDms : externalDataManagementSystems) {
                writer.writeStartElement("xmd:externalDataManagementSystem");
                this.addAttribute(writer, "address", externalDms.getAddress());
                this.addAttribute(writer, "addressType", externalDms.getAddressType(), t -> t.toString());
                this.addAttribute(writer, "code", externalDms.getCode());
                this.addAttribute(writer, "label", externalDms.getLabel());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private <T extends ICodeHolder & IDescriptionHolder> void writeTypeElement(DeliveryExecutionContext executionContext, XMLStreamWriter writer, String elementType, T type) throws XMLStreamException {
        writer.writeStartElement(elementType);
        this.addAttribute(writer, "code", type.getCode());
        this.addAttributeAndExtractFilePaths(executionContext, writer, "description", ((IDescriptionHolder)type).getDescription());
    }

    private void addPropertyAssignments(XMLStreamWriter writer, List<PropertyAssignment> propertyAssignments) throws XMLStreamException {
        writer.writeStartElement("xmd:propertyAssignments");
        for (PropertyAssignment propertyAssignment : propertyAssignments) {
            writer.writeStartElement("xmd:propertyAssignment");
            this.addAttribute(writer, "mandatory", propertyAssignment.isMandatory());
            this.addAttribute(writer, "ordinal", propertyAssignment.getOrdinal(), i -> String.valueOf(i));
            this.addAttribute(writer, "plugin", propertyAssignment.getPlugin(), p -> p.getPermId().getPermId());
            this.addAttribute(writer, "pluginType", propertyAssignment.getPlugin(), p -> p.getPluginType().toString());
            this.addAttribute(writer, "propertyTypeCode", propertyAssignment.getPropertyType(), t -> t.getCode());
            this.addAttribute(writer, "section", propertyAssignment.getSection());
            this.addAttribute(writer, "showInEdit", propertyAssignment.isShowInEditView());
            this.addAttribute(writer, "showRawValueInForms", propertyAssignment.isShowRawValueInForms());
            this.addAttribute(writer, "registration-timestamp", propertyAssignment.getRegistrationDate(), h -> DataSourceUtils.convertToW3CDate(h));
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }
}

