/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource;

import ch.ethz.sis.openbis.generic.asapi.v3.IApplicationServerApi;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.ICodeHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IRegistrationDateHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IRegistratorHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.Material;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.fetchoptions.MaterialFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.search.MaterialSearchCriteria;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource.AbstractEntityDeliverer;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource.DeliveryContext;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource.DeliveryExecutionContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class MaterialDeliverer
extends AbstractEntityDeliverer<Material> {
    MaterialDeliverer(DeliveryContext context) {
        super(context, "material");
    }

    @Override
    protected List<Material> getAllEntities(DeliveryExecutionContext executionContext, String sessionToken) {
        MaterialSearchCriteria searchCriteria = new MaterialSearchCriteria();
        MaterialFetchOptions fetchOptions = new MaterialFetchOptions();
        fetchOptions.sortBy().permId();
        return this.context.getV3api().searchMaterials(sessionToken, searchCriteria, fetchOptions).getObjects();
    }

    @Override
    protected void deliverEntities(DeliveryExecutionContext context, List<Material> materials) throws XMLStreamException {
        XMLStreamWriter writer = context.getWriter();
        String sessionToken = context.getSessionToken();
        IApplicationServerApi v3api = this.getV3Api();
        List permIds = materials.stream().map(Material::getPermId).collect(Collectors.toList());
        Collection fullMaterials = v3api.getMaterials(sessionToken, permIds, this.createFullFetchOptions()).values();
        for (Material material : fullMaterials) {
            this.startUrlElement(writer);
            String type = material.getType().getCode();
            String code = material.getCode();
            this.addLocation(writer, type + "/" + code, "MATERIAL");
            this.addLastModificationDate(writer, material.getModificationDate());
            this.addLink(writer, "#action=VIEW&entity=MATERIAL&code=" + code + "&type=" + type);
            this.startXdElement(writer);
            writer.writeAttribute("code", code);
            writer.writeAttribute("kind", "MATERIAL");
            this.addRegistrationDate(writer, (IRegistrationDateHolder)material);
            this.addRegistrator(writer, (IRegistratorHolder)material);
            this.addType(writer, (ICodeHolder)material.getType());
            HashMap<String, String> allProperties = new HashMap<String, String>(material.getProperties());
            Map materialProperties = material.getMaterialProperties();
            Set entrySet = materialProperties.entrySet();
            for (Map.Entry entity : entrySet) {
                allProperties.put((String)entity.getKey(), ((Material)entity.getValue()).getPermId().toString());
            }
            this.addProperties(writer, allProperties, context);
            writer.writeEndElement();
            writer.writeEndElement();
        }
        this.operationLog.info((Object)(materials.size() + " of " + materials.size() + " materials have been delivered."));
    }

    private MaterialFetchOptions createFullFetchOptions() {
        MaterialFetchOptions fetchOptions = new MaterialFetchOptions();
        fetchOptions.withMaterialProperties();
        fetchOptions.withRegistrator();
        fetchOptions.withType();
        fetchOptions.withProperties();
        return fetchOptions;
    }
}

