/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource;

import ch.ethz.sis.openbis.generic.asapi.v3.IApplicationServerApi;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IModifierHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IRegistrationDateHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IRegistratorHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.Project;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.fetchoptions.ProjectFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.id.ProjectPermId;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource.AbstractEntityWithPermIdDeliverer;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource.DeliveryContext;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource.DeliveryExecutionContext;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class ProjectDeliverer
extends AbstractEntityWithPermIdDeliverer {
    ProjectDeliverer(DeliveryContext context) {
        super(context, "project", "projects");
    }

    @Override
    protected void deliverEntities(DeliveryExecutionContext context, List<String> projectPermIds) throws XMLStreamException {
        XMLStreamWriter writer = context.getWriter();
        String sessionToken = context.getSessionToken();
        Set<String> spaces = context.getSpaces();
        IApplicationServerApi v3api = this.getV3Api();
        List permIds = projectPermIds.stream().map(ProjectPermId::new).collect(Collectors.toList());
        Collection fullProjects = v3api.getProjects(sessionToken, permIds, this.createFullFetchOptions()).values();
        int count = 0;
        for (Project project : fullProjects) {
            if (!spaces.contains(project.getSpace().getCode())) continue;
            String permId = project.getPermId().getPermId();
            this.startUrlElement(writer, "PROJECT", permId, project.getModificationDate());
            this.startXdElement(writer);
            writer.writeAttribute("code", project.getCode());
            this.addAttributeAndExtractFilePaths(context, writer, "desc", project.getDescription());
            this.addAttributeIfSet(writer, "frozen", project.isFrozen());
            this.addAttributeIfSet(writer, "frozenForExperiments", project.isFrozenForExperiments());
            this.addAttributeIfSet(writer, "frozenForSamples", project.isFrozenForSamples());
            this.addKind(writer, "PROJECT");
            this.addModifier(writer, (IModifierHolder)project);
            this.addRegistrationDate(writer, (IRegistrationDateHolder)project);
            this.addRegistrator(writer, (IRegistratorHolder)project);
            this.addSpace(writer, project.getSpace());
            this.addAttachments(writer, project.getAttachments());
            writer.writeEndElement();
            writer.writeEndElement();
            ++count;
        }
        this.operationLog.info((Object)(count + " of " + projectPermIds.size() + " projects have been delivered."));
    }

    private ProjectFetchOptions createFullFetchOptions() {
        ProjectFetchOptions fetchOptions = new ProjectFetchOptions();
        fetchOptions.withAttachments();
        fetchOptions.withRegistrator();
        fetchOptions.withModifier();
        fetchOptions.withSpace();
        return fetchOptions;
    }
}

