/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource;

import ch.ethz.sis.openbis.generic.asapi.v3.IApplicationServerApi;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.ICodeHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IModifierHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IRegistrationDateHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IRegistratorHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.EntityKind;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.Sample;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.fetchoptions.SampleFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.SamplePermId;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource.AbstractEntityWithPermIdDeliverer;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource.ConnectionsBuilder;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource.DeliveryContext;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource.DeliveryExecutionContext;
import ch.systemsx.cisd.common.shared.basic.string.CommaSeparatedListBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class SampleDeliverer
extends AbstractEntityWithPermIdDeliverer {
    SampleDeliverer(DeliveryContext context) {
        super(context, "sample", "samples");
    }

    @Override
    protected void deliverEntities(DeliveryExecutionContext context, List<String> samplePermIds) throws XMLStreamException {
        XMLStreamWriter writer = context.getWriter();
        String sessionToken = context.getSessionToken();
        Set<String> spaces = context.getSpaces();
        IApplicationServerApi v3api = this.getV3Api();
        List permIds = samplePermIds.stream().map(SamplePermId::new).collect(Collectors.toList());
        Collection fullSamples = v3api.getSamples(sessionToken, permIds, this.createFullFetchOptions()).values();
        int count = 0;
        for (Sample sample : fullSamples) {
            if (sample.getSpace() != null && !spaces.contains(sample.getSpace().getCode())) continue;
            String permId = sample.getPermId().getPermId();
            this.startUrlElement(writer, "SAMPLE", permId, sample.getModificationDate());
            this.startXdElement(writer);
            writer.writeAttribute("code", sample.getCode());
            this.addAttributeIfSet(writer, "frozen", sample.isFrozen());
            this.addAttributeIfSet(writer, "frozenForChildren", sample.isFrozenForChildren());
            this.addAttributeIfSet(writer, "frozenForParents", sample.isFrozenForParents());
            this.addAttributeIfSet(writer, "frozenForComponents", sample.isFrozenForComponents());
            this.addAttributeIfSet(writer, "frozenForDataSets", sample.isFrozenForDataSets());
            this.addExperiment(writer, sample.getExperiment());
            this.addKind(writer, EntityKind.SAMPLE);
            this.addModifier(writer, (IModifierHolder)sample);
            this.addProject(writer, sample.getProject());
            this.addRegistrationDate(writer, (IRegistrationDateHolder)sample);
            this.addRegistrator(writer, (IRegistratorHolder)sample);
            this.addSpace(writer, sample.getSpace());
            this.addType(writer, (ICodeHolder)sample.getType());
            this.addProperties(writer, sample.getProperties(), context);
            ConnectionsBuilder connectionsBuilder = new ConnectionsBuilder();
            connectionsBuilder.addConnections(sample.getDataSets());
            connectionsBuilder.addChildren(sample.getChildren());
            connectionsBuilder.addComponents(sample.getComponents());
            connectionsBuilder.writeTo(writer);
            this.addAttachments(writer, sample.getAttachments());
            writer.writeEndElement();
            writer.writeEndElement();
            ++count;
        }
        this.operationLog.info((Object)(count + " of " + samplePermIds.size() + " samples have been delivered."));
    }

    @Override
    protected List<String> getAllEntities(DeliveryExecutionContext executionContext, String sessionToken) {
        String sql = "select perm_id from samples where space_id is null";
        Set<String> spaces = executionContext.getSpaces();
        if (!spaces.isEmpty()) {
            CommaSeparatedListBuilder builder = new CommaSeparatedListBuilder();
            spaces.stream().forEach(space -> builder.append((Object)("'" + space + "'")));
            sql = sql + " or space_id in (select id from spaces where code in (" + builder + "))";
        }
        return super.getAllEntities(executionContext, sessionToken, sql);
    }

    private SampleFetchOptions createFullFetchOptions() {
        SampleFetchOptions fo = new SampleFetchOptions();
        fo.withRegistrator();
        fo.withModifier();
        fo.withProperties();
        fo.withDataSets();
        fo.withType();
        fo.withExperiment();
        fo.withProject();
        fo.withSpace();
        fo.withAttachments();
        fo.withChildren();
        fo.withComponents();
        fo.withDataSets();
        return fo;
    }
}

