/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource;

import ch.ethz.sis.openbis.generic.asapi.v3.IApplicationServerApi;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IRegistrationDateHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IRegistratorHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.Space;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.fetchoptions.SpaceFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.id.SpacePermId;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource.AbstractEntityWithPermIdDeliverer;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource.DeliveryContext;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.datasource.DeliveryExecutionContext;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class SpaceDeliverer
extends AbstractEntityWithPermIdDeliverer {
    SpaceDeliverer(DeliveryContext context) {
        super(context, "space", "spaces", "code");
    }

    @Override
    protected void deliverEntities(DeliveryExecutionContext context, List<String> allSpaces) throws XMLStreamException {
        XMLStreamWriter writer = context.getWriter();
        String sessionToken = context.getSessionToken();
        Set<String> spaces = context.getSpaces();
        IApplicationServerApi v3api = this.getV3Api();
        List permIds = allSpaces.stream().map(SpacePermId::new).collect(Collectors.toList());
        Collection fullSpaces = v3api.getSpaces(sessionToken, permIds, this.createSpaceFetchOptions()).values();
        int count = 0;
        for (Space space : fullSpaces) {
            String code = space.getCode();
            if (!spaces.contains(code)) continue;
            this.startUrlElement(writer, "SPACE", code, space.getModificationDate());
            this.startXdElement(writer);
            writer.writeAttribute("code", code);
            this.addAttributeAndExtractFilePaths(context, writer, "desc", space.getDescription());
            this.addAttributeIfSet(writer, "frozen", space.isFrozen());
            this.addAttributeIfSet(writer, "frozenForProjects", space.isFrozenForProjects());
            this.addAttributeIfSet(writer, "frozenForSamples", space.isFrozenForSamples());
            this.addKind(writer, "SPACE");
            this.addRegistrationDate(writer, (IRegistrationDateHolder)space);
            this.addRegistrator(writer, (IRegistratorHolder)space);
            writer.writeEndElement();
            writer.writeEndElement();
            ++count;
        }
        this.operationLog.info((Object)(count + " of " + allSpaces.size() + " spaces have been delivered."));
    }

    private SpaceFetchOptions createSpaceFetchOptions() {
        SpaceFetchOptions fetchOptions = new SpaceFetchOptions();
        fetchOptions.withRegistrator();
        return fetchOptions;
    }
}

