/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester;

import ch.ethz.sis.openbis.generic.asapi.v3.IApplicationServerApi;
import ch.ethz.sis.openbis.generic.dssapi.v3.IDataStoreServerApi;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.common.SyncEntityKind;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.config.ConfigReader;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.config.SyncConfig;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.config.SynchronizationConfigReader;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.EntitySynchronizer;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.SynchronizationContext;
import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.mail.EMailAddress;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.common.maintenance.IMaintenanceTask;
import ch.systemsx.cisd.common.parser.ILine;
import ch.systemsx.cisd.common.parser.filter.ILineFilter;
import ch.systemsx.cisd.openbis.dss.generic.shared.IConfigProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DssPropertyParametersUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class HarvesterMaintenanceTask<T extends DataSetInformation>
implements IMaintenanceTask {
    private static final String TIMESTAMPS_SECTION_HEADER = "TIMESTAMPS";
    private static final String LAST_FULL_SYNC_TIMESTAMP = "last-full-sync-timestamp";
    private static final String LAST_INCREMENTAL_SYNC_TIMESTAMP = "last-incremental-sync-timestamp";
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, HarvesterMaintenanceTask.class);
    private static final String HARVESTER_CONFIG_FILE_PROPERTY_NAME = "harvester-config-file";
    private static final String DEFAULT_HARVESTER_CONFIG_FILE_NAME = "../../harvester-config.txt";
    private File storeRoot;
    private IEncapsulatedOpenBISService service;
    private IApplicationServerApi v3Api;
    private IDataStoreServerApi v3DssApi;
    private File harvesterConfigFile;
    private IMailClient mailClient;
    private String dataStoreCode;

    public void setUp(String pluginName, Properties properties) {
        this.service = ServiceProvider.getOpenBISService();
        this.v3Api = ServiceProvider.getV3ApplicationService();
        this.v3DssApi = ServiceProvider.getDssServiceInternalV3();
        this.dataStoreCode = this.getConfigProvider().getDataStoreCode();
        this.storeRoot = new File(DssPropertyParametersUtil.loadServiceProperties().getProperty("storeroot-dir"));
        this.mailClient = ServiceProvider.getDataStoreService().createEMailClient();
        String configFileProperty = properties.getProperty(HARVESTER_CONFIG_FILE_PROPERTY_NAME);
        this.harvesterConfigFile = configFileProperty == null ? new File(this.getConfigProvider().getStoreRoot(), DEFAULT_HARVESTER_CONFIG_FILE_NAME) : new File(configFileProperty);
    }

    private IConfigProvider getConfigProvider() {
        return ServiceProvider.getConfigProvider();
    }

    public void execute() {
        operationLog.info((Object)(this.getClass() + " started."));
        try {
            for (SyncConfig config : SynchronizationConfigReader.readConfiguration(this.harvesterConfigFile)) {
                boolean dryRun = config.isDryRun();
                Logger logger = this.createLogger(config);
                try {
                    config.setDryRun(true);
                    this.synchronize(config, logger);
                    if (!dryRun) {
                        config.setDryRun(false);
                        this.synchronize(config, logger);
                    }
                }
                catch (Exception e) {
                    String dryRunNote = config.isDryRun() ? "(dry run) " : "";
                    logger.error((Object)("Sync " + dryRunNote + "failed: "), (Throwable)e);
                    this.sendErrorEmail(config, "Synchronization " + dryRunNote + "failed");
                }
                logger.removeAllAppenders();
            }
        }
        catch (Exception e) {
            operationLog.error((Object)"", (Throwable)e);
            return;
        }
        operationLog.info((Object)(this.getClass() + " finished executing."));
    }

    private void synchronize(SyncConfig config, Logger logger) throws IOException, ParseException, Exception {
        logger.info((Object)("====================== Running synchronization from data source: " + config.getDataSourceOpenbisURL() + " for user " + config.getUser()));
        logger.info((Object)((config.isDryRun() ? "DRY RUN" : "SYNC") + " Mode"));
        this.checkAlias(config);
        logger.info((Object)("verbose = " + config.isVerbose()));
        String fileName = config.getLastSyncTimestampFileName();
        File lastSyncTimestampFile = new File(fileName);
        Timestamps timestamps = this.loadCutOffTimeStamps(lastSyncTimestampFile);
        Date cutOffTimestamp = timestamps.lastIncSyncTimestamp;
        boolean isFullSync = !lastSyncTimestampFile.exists() || this.isTimeForFullSync(config, timestamps.lastFullSyncTimestamp);
        logger.info((Object)("Last incremental sync timestamp: " + timestamps.lastIncSyncTimestamp));
        logger.info((Object)("Last full sync timestamp: " + timestamps.lastFullSyncTimestamp));
        if (isFullSync) {
            cutOffTimestamp = new Date(0L);
            if (!lastSyncTimestampFile.exists()) {
                logger.info((Object)"Performing a full initial sync");
            } else {
                logger.info((Object)("Performing a full sync as a minimum of " + config.getFullSyncInterval() + " day(s) have elapsed since last full sync."));
            }
        } else {
            logger.info((Object)"Performing an incremental sync");
        }
        String notSyncedEntitiesFileName = config.getNotSyncedEntitiesFileName();
        Set<String> notSyncedDataSetCodes = this.getNotSyncedDataSetCodes(notSyncedEntitiesFileName);
        Set<String> notSyncedAttachmentHolderCodes = this.getNotSyncedAttachmentHolderCodes(notSyncedEntitiesFileName);
        Set<String> blackListedDataSetCodes = this.getBlackListedDataSetCodes(notSyncedEntitiesFileName);
        Date newCutOffTimestamp = new Date();
        SynchronizationContext syncContext = new SynchronizationContext();
        syncContext.setService(this.service);
        syncContext.setV3Api(this.v3Api);
        syncContext.setV3DssApi(this.v3DssApi);
        syncContext.setDataStoreCode(this.dataStoreCode);
        syncContext.setStoreRoot(this.storeRoot);
        syncContext.setLastSyncTimestamp(cutOffTimestamp);
        syncContext.setLastIncSyncTimestamp(timestamps.lastIncSyncTimestamp);
        syncContext.setDataSetsCodesToRetry(notSyncedDataSetCodes);
        syncContext.setBlackListedDataSetCodes(blackListedDataSetCodes);
        syncContext.setAttachmentHolderCodesToRetry(notSyncedAttachmentHolderCodes);
        syncContext.setConfig(config);
        syncContext.setOperationLog(logger);
        EntitySynchronizer synchronizer = new EntitySynchronizer(syncContext);
        Date resourceListTimestamp = synchronizer.synchronizeEntities();
        if (resourceListTimestamp.before(newCutOffTimestamp)) {
            newCutOffTimestamp = resourceListTimestamp;
        }
        Date newLastIncSyncTimestamp = newCutOffTimestamp;
        Date newLastFullSyncTimestamp = timestamps.lastFullSyncTimestamp;
        if (isFullSync) {
            newLastFullSyncTimestamp = newCutOffTimestamp;
        }
        if (config.isDryRun()) {
            logger.info((Object)"Dry run finished");
        } else {
            logger.info((Object)"Saving the timestamp of sync start to file");
            this.saveSyncTimestamp(lastSyncTimestampFile, newLastIncSyncTimestamp, newLastFullSyncTimestamp);
        }
    }

    private void checkAlias(SyncConfig config) throws UserFailureException {
        if (config.isTranslateUsingDataSourceAlias() && StringUtils.isBlank((CharSequence)config.getDataSourceAlias())) {
            throw new UserFailureException("Please specify a data source alias in the config file to be used in name translations.");
        }
    }

    private Logger createLogger(SyncConfig config) {
        String name;
        Logger logger = Logger.getLogger((String)(LogFactory.getLoggerName((LogCategory)LogCategory.OPERATION, EntitySynchronizer.class) + "." + config.getDataSourceAlias()));
        if (logger.getAppender(name = "bdfile") == null) {
            FileAppender appender = new FileAppender();
            appender.setName(name);
            appender.setLayout((Layout)new PatternLayout("%d %-5p %m%n"));
            appender.setFile(config.getLogFilePath());
            appender.activateOptions();
            logger.addAppender((Appender)appender);
            logger.setAdditivity(false);
        }
        return logger;
    }

    private Timestamps loadCutOffTimeStamps(File lastSyncTimestampFile) throws IOException, ParseException {
        if (!lastSyncTimestampFile.exists()) {
            return new Timestamps(new Date(0L), new Date(0L));
        }
        ConfigReader reader = new ConfigReader(lastSyncTimestampFile);
        String incSyncTimestampStr = reader.getString(TIMESTAMPS_SECTION_HEADER, LAST_INCREMENTAL_SYNC_TIMESTAMP, null, true);
        String fullSyncTimestampStr = reader.getString(TIMESTAMPS_SECTION_HEADER, LAST_FULL_SYNC_TIMESTAMP, incSyncTimestampStr, false);
        SimpleDateFormat format = this.createDateFormat();
        return new Timestamps(format.parse(incSyncTimestampStr), format.parse(fullSyncTimestampStr));
    }

    private boolean isTimeForFullSync(SyncConfig config, Date lastFullSyncTimestamp) throws IOException, ParseException {
        if (config.isFullSyncEnabled()) {
            Integer fullSyncInterval = config.getFullSyncInterval();
            Date now = new Date();
            long diff = now.getTime() - lastFullSyncTimestamp.getTime();
            long days = TimeUnit.MILLISECONDS.toDays(diff);
            return days >= (long)fullSyncInterval.intValue();
        }
        return false;
    }

    private Set<String> getLinesFromNotSyncedEntitiesFile(String fileName, ILineFilter linefilter) {
        File notSyncedEntitiesFile = new File(fileName);
        if (notSyncedEntitiesFile.exists()) {
            List list = FileUtilities.loadToStringList((File)notSyncedEntitiesFile, (ILineFilter)linefilter);
            return new LinkedHashSet<String>(list);
        }
        return new LinkedHashSet<String>();
    }

    private Set<String> getNotSyncedDataSetCodes(String fileName) {
        return this.getDataSetCodeLines(fileName, "DATA_SET");
    }

    private LinkedHashSet<String> getDataSetCodeLines(String fileName, final String prefix) {
        Set<String> lines = this.getLinesFromNotSyncedEntitiesFile(fileName, new ILineFilter(){

            public <E> boolean acceptLine(ILine<E> line) {
                assert (line != null) : "Unspecified line";
                String trimmed = line.getText().trim();
                return trimmed.length() > 0 && trimmed.startsWith(prefix);
            }
        });
        LinkedHashSet<String> dataSetCodes = new LinkedHashSet<String>();
        for (String line : lines) {
            dataSetCodes.add(line.substring(prefix.length() + 1));
        }
        return dataSetCodes;
    }

    private Set<String> getNotSyncedAttachmentHolderCodes(String fileName) {
        return this.getLinesFromNotSyncedEntitiesFile(fileName, new ILineFilter(){

            public <E> boolean acceptLine(ILine<E> line) {
                assert (line != null) : "Unspecified line";
                String trimmed = line.getText().trim();
                return trimmed.length() > 0 && !trimmed.startsWith("#") && (trimmed.startsWith(SyncEntityKind.SAMPLE.toString()) || trimmed.startsWith(SyncEntityKind.EXPERIMENT.toString()) || trimmed.startsWith(SyncEntityKind.PROJECT.toString()));
            }
        });
    }

    private Set<String> getBlackListedDataSetCodes(String fileName) {
        return this.getDataSetCodeLines(fileName, "#DATA_SET");
    }

    private void sendErrorEmail(SyncConfig config, String subject) {
        if (config.getLogFilePath() != null) {
            DataSource dataSource = this.createDataSource(config.getLogFilePath());
            for (EMailAddress recipient : config.getEmailAddresses()) {
                this.mailClient.sendEmailMessageWithAttachment(subject, "See the attached file for details.", "", new DataHandler(dataSource), null, null, new EMailAddress[]{recipient});
            }
        } else {
            for (EMailAddress recipient : config.getEmailAddresses()) {
                this.mailClient.sendEmailMessage(subject, "See the data store server log for details.", null, null, new EMailAddress[]{recipient});
            }
        }
    }

    private DataSource createDataSource(String filePath) {
        try {
            return new ByteArrayDataSource((InputStream)new FileInputStream(filePath), "text/plain");
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }

    private void saveSyncTimestamp(File lastSyncTimestampFile, Date newLastIncSyncTimestamp, Date newLastFullSyncTimestamp) {
        SimpleDateFormat formatter = this.createDateFormat();
        FileUtilities.writeToFile((File)lastSyncTimestampFile, (String)"[TIMESTAMPS]");
        FileUtilities.appendToFile((File)lastSyncTimestampFile, (String)"\n", (boolean)true);
        FileUtilities.appendToFile((File)lastSyncTimestampFile, (String)("last-incremental-sync-timestamp = " + formatter.format(newLastIncSyncTimestamp)), (boolean)true);
        FileUtilities.appendToFile((File)lastSyncTimestampFile, (String)("last-full-sync-timestamp = " + formatter.format(newLastFullSyncTimestamp)), (boolean)true);
    }

    private SimpleDateFormat createDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    private static class Timestamps {
        final Date lastIncSyncTimestamp;
        final Date lastFullSyncTimestamp;

        Timestamps(Date lastIncSyncTimestamp, Date lastFullSyncTimestamp) {
            this.lastIncSyncTimestamp = lastIncSyncTimestamp;
            this.lastFullSyncTimestamp = lastFullSyncTimestamp;
        }
    }
}

