/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.config;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ConfigReader {
    private static final String IGNORE_LINE_CHAR = "#";
    private Pattern sectionRegex = Pattern.compile("\\s*\\[([^]]*)\\]\\s*");
    private Pattern keyValueRegex = Pattern.compile("\\s*([^=]*)=(.*)");
    private Map<String, Map<String, String>> entries = new LinkedHashMap<String, Map<String, String>>();

    public ConfigReader(String path) throws IOException {
        this.load(path);
    }

    public ConfigReader(File file) throws IOException {
        this.loadFile(file);
    }

    public int getSectionCount() {
        return this.entries.keySet().size();
    }

    public String getSection(int index) {
        if (index > this.getSectionCount()) {
            throw new RuntimeException("Section with index " + index + " does not exist.");
        }
        return this.entries.keySet().toArray(new String[this.entries.keySet().size()])[index];
    }

    public boolean sectionExists(String name) {
        Map<String, String> kvMap = this.entries.get(name);
        return kvMap != null;
    }

    public void loadFile(File file) throws IOException {
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String line;
            String section = null;
            while ((line = br.readLine()) != null) {
                Matcher m = this.sectionRegex.matcher(line);
                if (m.matches()) {
                    section = m.group(1).trim();
                    continue;
                }
                if (section == null || !(m = this.keyValueRegex.matcher(line)).matches() || line.startsWith(IGNORE_LINE_CHAR)) continue;
                String key = m.group(1).trim();
                String value = m.group(2).trim();
                Map<String, String> map = this.entries.get(section);
                if (map == null) {
                    map = new HashMap<String, String>();
                    this.entries.put(section, map);
                }
                map.put(key, value);
            }
        }
    }

    public void load(String path) throws IOException {
        this.loadFile(new File(path));
    }

    public List<String> getStrings(String section, String key, List<String> defaultStrings) {
        String strings = this.getValue(section, key);
        if (strings == null) {
            return defaultStrings;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String string : strings.split(",")) {
            result.add(string.trim());
        }
        return result;
    }

    public String getString(String section, String key, String defaultvalue, boolean mandatory) {
        String val = this.getValue(section, key);
        if (val == null) {
            if (mandatory) {
                throw new ConfigurationFailureException("Property '" + key + "' in section '" + section + "'  is mandatory.");
            }
            return defaultvalue;
        }
        return val;
    }

    private String getValue(String section, String key) throws ConfigurationFailureException {
        Map<String, String> map = this.entries.get(section);
        if (map == null) {
            throw new ConfigurationFailureException("Section '" + section + " does not exist.");
        }
        String val = map.get(key);
        if (StringUtils.isBlank((CharSequence)val)) {
            return null;
        }
        return val.trim();
    }

    public Integer getInt(String section, String key, Integer defaultvalue, boolean mandatory) {
        String val = this.getValue(section, key);
        if (val == null) {
            if (mandatory) {
                throw new ConfigurationFailureException("Property '" + key + "' in section '" + section + "'  is mandatory.");
            }
            return defaultvalue;
        }
        return Integer.parseInt(val);
    }

    public double getDouble(String section, String key, double defaultvalue, boolean mandatory) {
        String val = this.getValue(section, key);
        if (val == null) {
            if (mandatory) {
                throw new ConfigurationFailureException("Property '" + key + "' in section '" + section + "'  is mandatory.");
            }
            return defaultvalue;
        }
        return Double.parseDouble(val);
    }

    public boolean getBoolean(String section, String key, boolean defaultvalue) {
        String val = this.getValue(section, key);
        return val == null ? defaultvalue : Boolean.parseBoolean(val);
    }
}

