/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.config;

import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.config.BasicAuthCredentials;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.config.ParallelizedExecutionPreferences;
import ch.systemsx.cisd.common.mail.EMailAddress;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SyncConfig {
    private String dataSourceURI;
    private BasicAuthCredentials authCredentials;
    private ParallelizedExecutionPreferences parallelizedExecutionPrefs;
    private String harvesterUser = "system";
    private String harvesterPass;
    private String dataSourceOpenbisURL;
    private String dataSourceDSSURL;
    private String lastSyncTimestampFileName;
    private String notSyncedEntitiesFileName;
    private String dataSourceAlias;
    private boolean translateUsingDataSourceAlias;
    private boolean fullSyncEnabled;
    private Integer fullSyncInterval;
    private boolean dryRun;
    private boolean verbose;
    private boolean masterDataUpdateAllowed;
    private boolean propertyUnassignmentAllowed;
    private boolean deletionAllowed;
    private boolean keepOriginalTimestampsAndUsers;
    private boolean keepOriginalFrozenFlags;
    private List<String> dataSourceSpaces = new ArrayList<String>();
    private List<String> harvesterSpaces = new ArrayList<String>();
    private String harvesterTempDir;
    private String fileServiceReporitoryPath;
    private List<EMailAddress> emailAddresses = new ArrayList<EMailAddress>();
    private String logFilePath;
    private static final String SEPARATOR = ",";
    private HashMap<String, String> spaceMappings = new HashMap();
    private Integer wishedNumberOfStreams;
    private List<String> spaceBlackList = new ArrayList<String>();
    private List<String> spaceWhiteList = new ArrayList<String>();

    public String getDataSourceURI() {
        return this.dataSourceURI;
    }

    public void setDataSourceURI(String dataSourceURI) {
        this.dataSourceURI = dataSourceURI;
    }

    public String getDataSourceOpenbisURL() {
        return this.dataSourceOpenbisURL;
    }

    public void setDataSourceOpenbisURL(String dataSourceOpenbisURL) {
        this.dataSourceOpenbisURL = dataSourceOpenbisURL;
    }

    public String getDataSourceDSSURL() {
        return this.dataSourceDSSURL;
    }

    public void setDataSourceDSSURL(String dataSourceDSSURL) {
        this.dataSourceDSSURL = dataSourceDSSURL;
    }

    public String getLastSyncTimestampFileName() {
        return this.lastSyncTimestampFileName;
    }

    public void setLastSyncTimestampFileName(String lastSyncTimestampFileName) {
        this.lastSyncTimestampFileName = lastSyncTimestampFileName;
    }

    public String getNotSyncedEntitiesFileName() {
        return this.notSyncedEntitiesFileName;
    }

    public void setNotSyncedDataSetsFileName(String notSyncedEntitiesFileName) {
        this.notSyncedEntitiesFileName = notSyncedEntitiesFileName;
    }

    public String getDataSourceAlias() {
        return this.dataSourceAlias;
    }

    public void setDataSourceAlias(String dataSourceAlias) {
        this.dataSourceAlias = dataSourceAlias;
    }

    public List<String> getDataSourceSpaces() {
        return this.dataSourceSpaces;
    }

    public void setDataSourceSpaces(String dataSourceSpaces) {
        if (dataSourceSpaces == null) {
            return;
        }
        for (String token : dataSourceSpaces.split(SEPARATOR)) {
            this.dataSourceSpaces.add(token.trim());
        }
    }

    public List<String> getHarvesterSpaces() {
        return this.harvesterSpaces;
    }

    public void setHarvesterSpaces(String harvesterSpaces) {
        if (harvesterSpaces == null) {
            return;
        }
        for (String token : harvesterSpaces.split(SEPARATOR)) {
            this.harvesterSpaces.add(token.trim());
        }
    }

    public String getFileServiceReporitoryPath() {
        return this.fileServiceReporitoryPath;
    }

    public void setFileServiceReporitoryPath(String fileServiceReporitoryPath) {
        this.fileServiceReporitoryPath = fileServiceReporitoryPath;
    }

    public String getHarvesterTempDir() {
        return this.harvesterTempDir;
    }

    public void setHarvesterTempDir(String harvesterTempDir) {
        this.harvesterTempDir = harvesterTempDir;
    }

    public String getHarvesterUser() {
        return this.harvesterUser;
    }

    public void setHarvesterUser(String harvesterUser) {
        this.harvesterUser = harvesterUser;
    }

    public String getHarvesterPass() {
        return this.harvesterPass;
    }

    public void setHarvesterPass(String harvesterPass) {
        this.harvesterPass = harvesterPass;
    }

    public void printConfig() {
        for (Field field : this.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            String name = field.getName();
            try {
                Object value = field.get(this);
                System.out.printf("%s : %s%n", name, value);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public HashMap<String, String> getSpaceMappings() {
        return this.spaceMappings;
    }

    public String getLogFilePath() {
        return this.logFilePath;
    }

    public void setLogFilePath(String logFilePath) {
        this.logFilePath = logFilePath;
    }

    public List<EMailAddress> getEmailAddresses() {
        return this.emailAddresses;
    }

    public void setEmailAddresses(String emailAddresses) {
        for (String token : emailAddresses.split(SEPARATOR)) {
            this.emailAddresses.add(new EMailAddress(token.trim()));
        }
    }

    public void setAuthCredentials(String realm, String user, String pass) {
        this.authCredentials = new BasicAuthCredentials(realm, user, pass);
    }

    public BasicAuthCredentials getAuthenticationCredentials() {
        return this.authCredentials;
    }

    public String getUser() {
        return this.authCredentials.getUser();
    }

    public String getPassword() {
        return this.authCredentials.getPassword();
    }

    public boolean isTranslateUsingDataSourceAlias() {
        return this.translateUsingDataSourceAlias;
    }

    public void setTranslateUsingDataSourceAlias(boolean translateUsingDataSourceAlias) {
        this.translateUsingDataSourceAlias = translateUsingDataSourceAlias;
    }

    public boolean isFullSyncEnabled() {
        return this.fullSyncEnabled;
    }

    public void setFullSyncEnabled(boolean fullSync) {
        this.fullSyncEnabled = fullSync;
    }

    public Integer getFullSyncInterval() {
        return this.fullSyncInterval;
    }

    public void setFullSyncInterval(Integer fullSyncInterval) {
        this.fullSyncInterval = fullSyncInterval;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isMasterDataUpdateAllowed() {
        return this.masterDataUpdateAllowed;
    }

    public void setMasterDataUpdateAllowed(boolean masterDataUpdate) {
        this.masterDataUpdateAllowed = masterDataUpdate;
    }

    public boolean isPropertyUnassignmentAllowed() {
        return this.propertyUnassignmentAllowed;
    }

    public void setPropertyUnassignmentAllowed(boolean propertyUnassignmentAllowed) {
        this.propertyUnassignmentAllowed = propertyUnassignmentAllowed;
    }

    public boolean isDeletionAllowed() {
        return this.deletionAllowed;
    }

    public void setDeletionAllowed(boolean deletionAllowed) {
        this.deletionAllowed = deletionAllowed;
    }

    public boolean keepOriginalTimestampsAndUsers() {
        return this.keepOriginalTimestampsAndUsers;
    }

    public void setKeepOriginalTimestampsAndUsers(boolean keepOriginalTimestampsAndUsers) {
        this.keepOriginalTimestampsAndUsers = keepOriginalTimestampsAndUsers;
    }

    public boolean keepOriginalFrozenFlags() {
        return this.keepOriginalFrozenFlags;
    }

    public void setKeepOriginalFrozenFlags(boolean keepOriginalFrozenFlags) {
        this.keepOriginalFrozenFlags = keepOriginalFrozenFlags;
    }

    public void setParallelizedExecutionPrefs(double machineLoad, int maxThreads, int retriesOnFailure, boolean stopOnFailure) {
        this.parallelizedExecutionPrefs = new ParallelizedExecutionPreferences(machineLoad, maxThreads, retriesOnFailure, stopOnFailure);
    }

    public ParallelizedExecutionPreferences getParallelizedExecutionPrefs() {
        return this.parallelizedExecutionPrefs;
    }

    public Integer getWishedNumberOfStreams() {
        return this.wishedNumberOfStreams;
    }

    public void setWishedNumberOfStreams(Integer wishedNumberOfStreams) {
        this.wishedNumberOfStreams = wishedNumberOfStreams;
    }

    public List<String> getSpaceBlackList() {
        return this.spaceBlackList;
    }

    public void setSpaceBlackList(List<String> spaceBlackList) {
        this.spaceBlackList = spaceBlackList;
    }

    public List<String> getSpaceWhiteList() {
        return this.spaceWhiteList;
    }

    public void setSpaceWhiteList(List<String> spaceWhiteList) {
        this.spaceWhiteList = spaceWhiteList;
    }
}

