/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer;

import ch.ethz.sis.openbis.generic.asapi.v3.IApplicationServerApi;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.SearchResult;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.ContentCopy;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.DataSet;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.DataSetKind;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.LinkedData;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.create.ContentCopyCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.create.DataSetCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.create.LinkedDataCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.delete.DataSetDeletionOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.fetchoptions.DataSetFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.DataSetPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.IContentCopyId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.IDataSetId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.update.DataSetUpdate;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.update.LinkedDataUpdate;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.deletion.id.IDeletionId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.delete.ExperimentDeletionOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.ExperimentPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.delete.MaterialDeletionOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.id.MaterialPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.create.PersonCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.fetchoptions.PersonFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.id.PersonPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.delete.ProjectDeletionOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.id.ProjectPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.Sample;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.delete.SampleDeletionOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.fetchoptions.SampleFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.ISampleId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.SamplePermId;
import ch.ethz.sis.openbis.generic.dssapi.v3.IDataStoreServerApi;
import ch.ethz.sis.openbis.generic.dssapi.v3.dto.dataset.create.FullDataSetCreation;
import ch.ethz.sis.openbis.generic.dssapi.v3.dto.datasetfile.DataSetFile;
import ch.ethz.sis.openbis.generic.dssapi.v3.dto.datasetfile.fetchoptions.DataSetFileFetchOptions;
import ch.ethz.sis.openbis.generic.dssapi.v3.dto.datasetfile.search.DataSetFileSearchCriteria;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.common.SkinnyEntityRetriever;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.common.SyncEntityKind;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.common.entitygraph.EntityGraph;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.common.entitygraph.INode;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.config.ParallelizedExecutionPreferences;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.config.SyncConfig;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.AbstractTimestampsAndUserHolder;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.Connection;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.IHarvesterQuery;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.IncomingDataSet;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.IncomingEntity;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.IncomingExperiment;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.IncomingMaterial;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.IncomingProject;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.IncomingSample;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.IncomingSpace;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.MasterData;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.MasterDataSynchronizer;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.MaterialTypeRecord;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.PersonRecord;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.RegistrationDTO;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.ResourceListParser;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.ResourceListParserData;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.SynchronizationContext;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.datasourceconnector.DataSourceConnector;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.parallelizedExecutor.AttachmentSynchronizationSummary;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.parallelizedExecutor.AttachmentsSynchronizer;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.parallelizedExecutor.DataSetRegistrationTaskExecutor;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.parallelizedExecutor.DataSetSynchronizationSummary;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.translator.DefaultNameTranslator;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.translator.INameTranslator;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.translator.PrefixBasedNameTranslator;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.util.DSPropertyUtils;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.util.Monitor;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.util.ServiceUtils;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.util.SummaryUtils;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.util.V3Facade;
import ch.systemsx.cisd.common.concurrent.ITaskExecutor;
import ch.systemsx.cisd.common.concurrent.ParallelizedExecutor;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.common.logging.Log4jSimpleLogger;
import ch.systemsx.cisd.etlserver.registrator.api.v1.impl.ConversionUtils;
import ch.systemsx.cisd.etlserver.registrator.api.v1.impl.DataSetUpdatable;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetDirectoryProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetProcessingContext;
import ch.systemsx.cisd.openbis.dss.generic.shared.IConfigProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetDirectoryProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.IShareIdManager;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.SegmentedStoreUtils;
import ch.systemsx.cisd.openbis.generic.server.batch.BatchOperationExecutor;
import ch.systemsx.cisd.openbis.generic.server.batch.IBatchOperation;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractProjectUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.GenericEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDatasetLocation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewExperiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewMaterial;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewMaterialWithType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewProject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSpace;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PhysicalDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import ch.systemsx.cisd.openbis.generic.shared.dto.AtomicEntityOperationDetails;
import ch.systemsx.cisd.openbis.generic.shared.dto.AtomicEntityOperationResult;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetBatchUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialUpdateDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewContainerDataSet;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewExternalData;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.builders.AtomicEntityOperationDetailsBuilder;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import javax.xml.xpath.XPathExpressionException;
import net.lemnik.eodsql.QueryTool;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class EntitySynchronizer {
    private final String dataStoreCode;
    private final File storeRoot;
    private final IEncapsulatedOpenBISService service;
    private final IApplicationServerApi v3Api;
    private final IDataStoreServerApi v3DssApi;
    private final Date lastSyncTimestamp;
    private final Date lastIncSyncTimestamp;
    private final Set<String> dataSetsCodesToRetry;
    private final Set<String> attachmentHolderCodesToRetry;
    private final SyncConfig config;
    private final Logger operationLog;
    private final Set<String> blackListedDataSetCodes;

    public EntitySynchronizer(SynchronizationContext synContext) {
        this.service = synContext.getService();
        this.v3Api = synContext.getV3Api();
        this.v3DssApi = synContext.getV3DssApi();
        this.dataStoreCode = synContext.getDataStoreCode();
        this.storeRoot = synContext.getStoreRoot();
        this.lastSyncTimestamp = synContext.getLastSyncTimestamp();
        this.lastIncSyncTimestamp = synContext.getLastIncSyncTimestamp();
        this.dataSetsCodesToRetry = synContext.getDataSetsCodesToRetry();
        this.attachmentHolderCodesToRetry = synContext.getAttachmentHolderCodesToRetry();
        this.blackListedDataSetCodes = synContext.getBlackListedDataSetCodes();
        this.config = synContext.getConfig();
        this.operationLog = synContext.getOperationLog();
    }

    public Date synchronizeEntities() throws Exception {
        Document doc = this.getResourceList();
        ResourceListParserData data = this.parseResourceList(doc);
        if (this.config.isDeletionAllowed()) {
            this.processDeletions(data);
        }
        this.registerMasterData(data.getMasterData());
        MultiKeyMap<String, String> newEntities = this.registerEntities(data);
        this.registerAttachments(data, newEntities);
        this.populateFileServiceRepository(data);
        this.registerDataSets(data);
        if (this.config.keepOriginalTimestampsAndUsers()) {
            this.updateTimestampsAndUsers(data);
        }
        if (this.config.keepOriginalFrozenFlags()) {
            this.updateFrozenFlags(data);
        }
        return data.getResourceListTimestamp();
    }

    private void updateTimestampsAndUsers(ResourceListParserData data) {
        Monitor monitor = new Monitor("Update timestamps and users", this.operationLog);
        SummaryUtils.printShortSummaryHeader(this.operationLog);
        this.createMissingUsers(data, monitor);
        DataSource dataSource = ServiceProvider.getDataSourceProvider().getDataSource("openbis-db");
        IHarvesterQuery query = (IHarvesterQuery)QueryTool.getQuery((DataSource)dataSource, IHarvesterQuery.class);
        Map<String, Long> userTechIdsByUserId = this.getUserTechIds(query);
        this.updateSpaces(data.getRelevantSpacesToProcess(), query, userTechIdsByUserId, monitor);
        this.updateProjects(data.getProjectsToProcess().values(), query, userTechIdsByUserId, monitor);
        this.updateExperiments(data.getExperimentsToProcess().values(), query, userTechIdsByUserId, monitor);
        this.updateSamples(data.getSamplesToProcess().values(), query, userTechIdsByUserId, monitor);
        this.updateDataSets(data.getDataSetsToProcess().values(), query, userTechIdsByUserId, monitor);
        this.updateMaterials(data.getMaterialsToProcess().values(), query, userTechIdsByUserId, monitor);
        SummaryUtils.printShortSummaryFooter(this.operationLog);
    }

    private Map<String, Long> getUserTechIds(IHarvesterQuery query) {
        HashMap<String, Long> userTechIdsByUserId = new HashMap<String, Long>();
        List<PersonRecord> allUsers = query.listAllUsers();
        for (PersonRecord personRecord : allUsers) {
            userTechIdsByUserId.put(personRecord.userId, personRecord.id);
        }
        return userTechIdsByUserId;
    }

    private void createMissingUsers(ResourceListParserData data, Monitor monitor) {
        HashSet<String> users = new HashSet<String>();
        this.addUsers(users, data.getMaterialsToProcess().values());
        this.addUsers(users, data.getProjectsToProcess().values());
        this.addUsers(users, data.getExperimentsToProcess().values());
        this.addUsers(users, data.getSamplesToProcess().values());
        this.addUsers(users, data.getDataSetsToProcess().values());
        Set knownPersons = this.v3Api.getPersons(this.service.getSessionToken(), users.stream().map(PersonPermId::new).collect(Collectors.toList()), new PersonFetchOptions()).keySet().stream().map(p -> p.toString()).collect(Collectors.toSet());
        ArrayList<PersonCreation> personCreations = new ArrayList<PersonCreation>();
        for (String user : users) {
            if (knownPersons.contains(user)) continue;
            PersonCreation personCreation = new PersonCreation();
            personCreation.setUserId(user);
            personCreations.add(personCreation);
        }
        SummaryUtils.printShortAddedSummary(this.operationLog, personCreations.size(), "users");
        if (!personCreations.isEmpty() && !this.config.isDryRun()) {
            this.v3Api.createPersons(this.service.getSessionToken(), personCreations);
        }
    }

    private void updateMaterials(Collection<IncomingMaterial> materials, IHarvesterQuery query, Map<String, Long> userTechIdsByUserId, Monitor monitor) {
        if (!this.config.isDryRun()) {
            List<MaterialTypeRecord> listAllMaterialTypes = query.listAllMaterialTypes();
            HashMap<String, Long> materialTypeIdsByCode = new HashMap<String, Long>();
            for (MaterialTypeRecord materialTypeRecord : listAllMaterialTypes) {
                materialTypeIdsByCode.put(materialTypeRecord.code, materialTypeRecord.id);
            }
            ArrayList<RegistrationDTO> registrations = new ArrayList<RegistrationDTO>();
            for (IncomingMaterial incomingMaterial : materials) {
                NewMaterialWithType material = incomingMaterial.getMaterial();
                Long typeId = (Long)materialTypeIdsByCode.get(material.getType());
                this.addRegistration(registrations, material.getCode(), typeId, incomingMaterial, userTechIdsByUserId);
            }
            query.updateMaterialRegistrations(registrations);
        }
        SummaryUtils.printShortUpdatedSummary(this.operationLog, materials.size(), "materials");
    }

    private void updateSpaces(Collection<IncomingSpace> spaces, IHarvesterQuery query, Map<String, Long> userTechIdsByUserId, Monitor monitor) {
        if (!this.config.isDryRun()) {
            ArrayList<RegistrationDTO> registrations = new ArrayList<RegistrationDTO>();
            for (IncomingSpace incomingSpace : spaces) {
                this.addRegistration(registrations, incomingSpace.getPermID(), incomingSpace, userTechIdsByUserId);
            }
            query.updateSpaceRegistrations(registrations);
        }
        SummaryUtils.printShortUpdatedSummary(this.operationLog, spaces.size(), "spaces");
    }

    private void updateProjects(Collection<IncomingProject> projects, IHarvesterQuery query, Map<String, Long> userTechIdsByUserId, Monitor monitor) {
        if (!this.config.isDryRun()) {
            ArrayList<RegistrationDTO> registrations = new ArrayList<RegistrationDTO>();
            for (IncomingProject incomingProject : projects) {
                this.addRegistration(registrations, incomingProject.getPermID(), incomingProject, userTechIdsByUserId);
            }
            query.updateProjectRegistrations(registrations);
        }
        SummaryUtils.printShortUpdatedSummary(this.operationLog, projects.size(), "projects");
    }

    private void updateExperiments(Collection<IncomingExperiment> experiments, IHarvesterQuery query, Map<String, Long> userTechIdsByUserId, Monitor monitor) {
        if (!this.config.isDryRun()) {
            ArrayList<RegistrationDTO> registrations = new ArrayList<RegistrationDTO>();
            for (IncomingExperiment incomingExperiment : experiments) {
                this.addRegistration(registrations, incomingExperiment.getPermID(), incomingExperiment, userTechIdsByUserId);
            }
            query.updateExperimentRegistrations(registrations);
        }
        SummaryUtils.printShortUpdatedSummary(this.operationLog, experiments.size(), "experiments");
    }

    private void updateSamples(final Collection<IncomingSample> samples, final IHarvesterQuery query, final Map<String, Long> userTechIdsByUserId, Monitor monitor) {
        if (!this.config.isDryRun()) {
            BatchOperationExecutor.executeInBatches((IBatchOperation)new IBatchOperation<IncomingSample>(){

                public List<IncomingSample> getAllEntities() {
                    return new ArrayList<IncomingSample>(samples);
                }

                public void execute(List<IncomingSample> samples2) {
                    ArrayList<RegistrationDTO> registrations = new ArrayList<RegistrationDTO>();
                    for (IncomingSample incomingSamples : samples2) {
                        EntitySynchronizer.this.addRegistration(registrations, incomingSamples.getPermID(), incomingSamples, userTechIdsByUserId);
                    }
                    query.updateSampleRegistrations(registrations);
                }

                public String getEntityName() {
                    return "sample";
                }

                public String getOperationName() {
                    return "update registration";
                }
            });
        }
        SummaryUtils.printShortUpdatedSummary(this.operationLog, samples.size(), "samples");
    }

    private void updateDataSets(final Collection<IncomingDataSet> dataSets, final IHarvesterQuery query, final Map<String, Long> userTechIdsByUserId, Monitor monitor) {
        if (!this.config.isDryRun()) {
            BatchOperationExecutor.executeInBatches((IBatchOperation)new IBatchOperation<IncomingDataSet>(){

                public List<IncomingDataSet> getAllEntities() {
                    return new ArrayList<IncomingDataSet>(dataSets);
                }

                public void execute(List<IncomingDataSet> dataSets2) {
                    ArrayList<RegistrationDTO> registrations = new ArrayList<RegistrationDTO>();
                    for (IncomingDataSet incomingDataSet : dataSets2) {
                        EntitySynchronizer.this.addRegistration(registrations, incomingDataSet.getFullDataSet().getMetadataCreation().getCode(), incomingDataSet, userTechIdsByUserId);
                    }
                    query.updateDataSetRegistrations(registrations);
                }

                public String getEntityName() {
                    return "data set";
                }

                public String getOperationName() {
                    return "update registration";
                }
            });
        }
        SummaryUtils.printShortUpdatedSummary(this.operationLog, dataSets.size(), "data sets");
    }

    private void addRegistration(List<RegistrationDTO> registrations, String permID, AbstractTimestampsAndUserHolder entity, Map<String, Long> userTechIdsByUserId) {
        this.addRegistration(registrations, permID, null, entity, userTechIdsByUserId);
    }

    private void addRegistration(List<RegistrationDTO> registrations, String permID, Long typeId, AbstractTimestampsAndUserHolder entity, Map<String, Long> userTechIdsByUserId) {
        Long registratorId = userTechIdsByUserId.get(entity.getRegistrator());
        if (registratorId != null) {
            RegistrationDTO registration = new RegistrationDTO();
            registration.setPermId(permID);
            registration.setTypeId(typeId);
            registration.setModificationTimestamp(entity.getLastModificationDate());
            registration.setModifierId(userTechIdsByUserId.get(entity.getModifier()));
            registration.setRegistrationTimestamp(entity.getRegistrationTimestamp());
            registration.setRegistratorId(registratorId);
            registrations.add(registration);
        }
    }

    private void addUsers(Set<String> users, Collection<? extends AbstractTimestampsAndUserHolder> timestampsAndUserHolders) {
        for (AbstractTimestampsAndUserHolder abstractTimestampsAndUserHolder : timestampsAndUserHolders) {
            users.add(abstractTimestampsAndUserHolder.getRegistrator());
            String modifier = abstractTimestampsAndUserHolder.getModifier();
            if (modifier == null) continue;
            users.add(modifier);
        }
    }

    private void updateFrozenFlags(ResourceListParserData data) {
        Monitor monitor = new Monitor("Update frozen flags", this.operationLog);
        DataSource dataSource = ServiceProvider.getDataSourceProvider().getDataSource("openbis-db");
        IHarvesterQuery query = (IHarvesterQuery)QueryTool.getQuery((DataSource)dataSource, IHarvesterQuery.class);
        SummaryUtils.printShortSummaryHeader(this.operationLog);
        this.updateSpaceFrozenFlags(data.getRelevantSpacesToProcess(), query, monitor);
        this.updateProjectFrozenFlags(data.getProjectsToProcess().values(), query, monitor);
        this.updateExperimentFrozenFlags(data.getExperimentsToProcess().values(), query, monitor);
        this.updateSampleFrozenFlags(data.getSamplesToProcess().values(), query, monitor);
        this.updateDataSetFrozenFlags(data.getDataSetsToProcess().values(), query, monitor);
        SummaryUtils.printShortSummaryFooter(this.operationLog);
    }

    private void updateSpaceFrozenFlags(Collection<IncomingSpace> spaces, IHarvesterQuery query, Monitor monitor) {
        if (!this.config.isDryRun()) {
            query.updateSpaceFrozenFlags(spaces.stream().map(IncomingEntity::getFrozenFlags).collect(Collectors.toList()));
        }
        SummaryUtils.printShortUpdatedSummary(this.operationLog, spaces.size(), "spaces");
    }

    private void updateProjectFrozenFlags(Collection<IncomingProject> projects, IHarvesterQuery query, Monitor monitor) {
        if (!this.config.isDryRun()) {
            query.updateProjectFrozenFlags(projects.stream().map(IncomingEntity::getFrozenFlags).collect(Collectors.toList()));
        }
        SummaryUtils.printShortUpdatedSummary(this.operationLog, projects.size(), "projects");
    }

    private void updateExperimentFrozenFlags(Collection<IncomingExperiment> experiments, IHarvesterQuery query, Monitor monitor) {
        if (!this.config.isDryRun()) {
            query.updateExperimentFrozenFlags(experiments.stream().map(IncomingEntity::getFrozenFlags).collect(Collectors.toList()));
        }
        SummaryUtils.printShortUpdatedSummary(this.operationLog, experiments.size(), "experiments");
    }

    private void updateSampleFrozenFlags(final Collection<IncomingSample> samples, final IHarvesterQuery query, Monitor monitor) {
        if (!this.config.isDryRun()) {
            BatchOperationExecutor.executeInBatches((IBatchOperation)new IBatchOperation<IncomingSample>(){

                public List<IncomingSample> getAllEntities() {
                    return new ArrayList<IncomingSample>(samples);
                }

                public void execute(List<IncomingSample> samples2) {
                    query.updateSampleFrozenFlags(samples2.stream().map(IncomingEntity::getFrozenFlags).collect(Collectors.toList()));
                }

                public String getEntityName() {
                    return "sample";
                }

                public String getOperationName() {
                    return "update frozen flags";
                }
            });
        }
        SummaryUtils.printShortUpdatedSummary(this.operationLog, samples.size(), "samples");
    }

    private void updateDataSetFrozenFlags(final Collection<IncomingDataSet> dataSets, final IHarvesterQuery query, Monitor monitor) {
        if (!this.config.isDryRun()) {
            BatchOperationExecutor.executeInBatches((IBatchOperation)new IBatchOperation<IncomingDataSet>(){

                public List<IncomingDataSet> getAllEntities() {
                    return new ArrayList<IncomingDataSet>(dataSets);
                }

                public void execute(List<IncomingDataSet> dataSets2) {
                    query.updateDataSetFrozenFlags(dataSets2.stream().map(IncomingDataSet::getFrozenFlags).collect(Collectors.toList()));
                }

                public String getEntityName() {
                    return "data set";
                }

                public String getOperationName() {
                    return "update frozen flags";
                }
            });
        }
        SummaryUtils.printShortUpdatedSummary(this.operationLog, dataSets.size(), "dataSets");
    }

    private void registerDataSets(ResourceListParserData data) throws IOException {
        Monitor monitor = new Monitor("Register data sets", this.operationLog);
        this.operationLog.info((Object)"Registering data sets...");
        this.registerLinkDataSets(data, monitor);
        Map<String, IncomingDataSet> physicalDSMap = data.filterByDataSetKindAndLastModificationDate(DataSetKind.PHYSICAL, this.lastSyncTimestamp, this.dataSetsCodesToRetry, this.blackListedDataSetCodes);
        DataSetSynchronizationSummary summary = this.registerPhysicalDataSets(physicalDSMap);
        if (this.config.isVerbose()) {
            Collections.sort(summary.createdDataSets);
            this.printSummary(summary.createdDataSets, "PHYSICAL DATA SETS");
            Collections.sort(summary.updatedDataSets);
            SummaryUtils.printUpdatedSummary(this.operationLog, summary.updatedDataSets, "PHYSICAL DATA SETS");
        }
        List<String> notRegisteredDataSetCodes = summary.notRegisteredDataSetCodes;
        this.saveFailedEntitiesFile(summary.createdDataSets);
        SummaryUtils.printShortSummaryHeader(this.operationLog);
        SummaryUtils.printShortAddedSummary(this.operationLog, summary.createdDataSets.size(), "PHYSICAL DATA SETS");
        if (!notRegisteredDataSetCodes.isEmpty()) {
            SummaryUtils.printShortSummary(this.operationLog, notRegisteredDataSetCodes.size(), "PHYSICAL DATA SETS", "FAILED to register.");
        }
        SummaryUtils.printShortUpdatedSummary(this.operationLog, summary.updatedDataSets.size(), "PHYSICAL DATA SETS");
        if (!this.blackListedDataSetCodes.isEmpty()) {
            SummaryUtils.printShortSummary(this.operationLog, this.blackListedDataSetCodes.size(), "PHYSICAL DATA SETS", "were skipped because they were BLACK-LISTED.");
        }
        SummaryUtils.printShortSummaryFooter(this.operationLog);
        ArrayList<String> skippedDataSets = new ArrayList<String>();
        skippedDataSets.addAll(notRegisteredDataSetCodes);
        skippedDataSets.addAll(this.blackListedDataSetCodes);
        Set<String> containerDataSets = data.filterByDataSetKindAndLastModificationDate(DataSetKind.CONTAINER, this.lastSyncTimestamp, this.dataSetsCodesToRetry, this.blackListedDataSetCodes).keySet();
        this.establishDataSetRelationships(data.getDataSetsToProcess(), skippedDataSets, containerDataSets);
        monitor.log();
    }

    private void registerLinkDataSets(ResourceListParserData data, Monitor monitor) {
        Map<String, IncomingDataSet> linkDataSets = data.filterByDataSetKindAndLastModificationDate(DataSetKind.LINK, this.lastSyncTimestamp, this.dataSetsCodesToRetry, this.blackListedDataSetCodes);
        monitor.log("Register " + linkDataSets.size() + " link data sets");
        Collection<IncomingDataSet> values = linkDataSets.values();
        List dataSetIds = values.stream().map(ds -> new DataSetPermId(ds.getFullDataSet().getMetadataCreation().getCode())).collect(Collectors.toList());
        DataSetFetchOptions fetchOptions = new DataSetFetchOptions();
        fetchOptions.withLinkedData();
        Map existingDataSets = this.v3Api.getDataSets(this.service.getSessionToken(), dataSetIds, fetchOptions);
        ArrayList<DataSetUpdate> updates = new ArrayList<DataSetUpdate>();
        ArrayList<FullDataSetCreation> creations = new ArrayList<FullDataSetCreation>();
        for (IncomingDataSet incomingDataSet : values) {
            FullDataSetCreation fullDataSet = incomingDataSet.getFullDataSet();
            DataSetCreation dataSet = fullDataSet.getMetadataCreation();
            DataSetPermId permId = new DataSetPermId(dataSet.getCode());
            if (existingDataSets.containsKey(permId)) {
                updates.add(this.createLinkDataUpdate(existingDataSets, dataSet, permId));
                continue;
            }
            creations.add(fullDataSet);
        }
        if (!updates.isEmpty() && !this.config.isDryRun()) {
            this.v3Api.updateDataSets(this.service.getSessionToken(), updates);
        }
        if (!creations.isEmpty() && !this.config.isDryRun()) {
            this.v3DssApi.createDataSets(this.service.getSessionToken(), creations);
        }
        if (this.config.isVerbose()) {
            this.printSummary(creations, "LINK DATA SETS");
            this.printLinkDataSetUpdatesSummary(updates);
        }
        SummaryUtils.printShortSummaryHeader(this.operationLog);
        SummaryUtils.printShortAddedSummary(this.operationLog, creations.size(), "LINK DATA SETS");
        SummaryUtils.printShortUpdatedSummary(this.operationLog, updates.size(), "LINK DATA SETS");
        SummaryUtils.printShortSummaryFooter(this.operationLog);
    }

    private DataSetUpdate createLinkDataUpdate(Map<IDataSetId, DataSet> existingDataSets, DataSetCreation dataSet, DataSetPermId permId) {
        DataSetUpdate update = new DataSetUpdate();
        update.setDataSetId((IDataSetId)permId);
        update.setProperties(dataSet.getProperties());
        LinkedDataCreation linkedDataCreation = dataSet.getLinkedData();
        if (linkedDataCreation != null) {
            LinkedData linkedData = existingDataSets.get(permId).getLinkedData();
            Map<String, ContentCopy> existingContentCopies = this.getExistingContentCopies(linkedData);
            LinkedDataUpdate linkedDataUpdate = new LinkedDataUpdate();
            for (ContentCopyCreation cc : linkedDataCreation.getContentCopies()) {
                String key = cc.getPath() + "," + cc.getGitCommitHash() + "," + cc.getGitRepositoryId();
                if (existingContentCopies.remove(key) != null) continue;
                linkedDataUpdate.getContentCopies().add((Object[])new ContentCopyCreation[]{cc});
            }
            linkedDataUpdate.getContentCopies().remove((Object[])existingContentCopies.values().stream().map(ContentCopy::getId).collect(Collectors.toList()).toArray(new IContentCopyId[0]));
            update.setLinkedData(linkedDataUpdate);
        }
        return update;
    }

    private Map<String, ContentCopy> getExistingContentCopies(LinkedData linkedData) {
        HashMap<String, ContentCopy> result = new HashMap<String, ContentCopy>();
        for (ContentCopy cc : linkedData.getContentCopies()) {
            result.put(cc.getPath() + "," + cc.getGitCommitHash() + "," + cc.getGitRepositoryId(), cc);
        }
        return result;
    }

    private void registerAttachments(ResourceListParserData data, MultiKeyMap<String, String> newEntities) {
        Monitor monitor = new Monitor("Register attachments", this.operationLog);
        this.operationLog.info((Object)"Processing attachments...");
        List<IncomingEntity<?>> attachmentHoldersToProcess = data.filterAttachmentHoldersByLastModificationDate(this.lastSyncTimestamp, this.attachmentHolderCodesToRetry);
        monitor.log(attachmentHoldersToProcess.size() + " to process");
        AttachmentSynchronizationSummary syncSummary = this.processAttachments(attachmentHoldersToProcess, monitor);
        SummaryUtils.printShortSummaryHeader(this.operationLog);
        SummaryUtils.printShortAddedSummary(this.operationLog, syncSummary.addedCount.intValue(), "attachments");
        SummaryUtils.printShortUpdatedSummary(this.operationLog, syncSummary.updatedCount.intValue(), "attachments");
        SummaryUtils.printShortRemovedSummary(this.operationLog, syncSummary.deletedCount.intValue(), "attachments");
        SummaryUtils.printShortSummaryFooter(this.operationLog);
        monitor.log();
    }

    private void populateFileServiceRepository(ResourceListParserData data) {
        Monitor monitor = new Monitor("Populate file service repository", this.operationLog);
        this.operationLog.info((Object)"Processing files...");
        File fileRepo = new File(this.config.getFileServiceReporitoryPath());
        int count = 0;
        long totalSize = 0L;
        for (Map.Entry<String, byte[]> entry : data.getFileToProcess().entrySet()) {
            String path = entry.getKey();
            byte[] fileContent = entry.getValue();
            if (!this.config.isDryRun()) {
                File file = new File(fileRepo, path);
                file.getParentFile().mkdirs();
                FileUtilities.writeToFile((File)file, (byte[])fileContent);
            }
            if (this.config.isVerbose()) {
                this.operationLog.info((Object)String.format("%10d bytes, file: %s", fileContent.length, path));
            }
            ++count;
            totalSize += (long)fileContent.length;
        }
        SummaryUtils.printShortSummaryHeader(this.operationLog);
        this.operationLog.info((Object)("| " + count + " files (total size: " + FileUtilities.byteCountToDisplaySize((long)totalSize) + ") have been saved."));
        SummaryUtils.printShortSummaryFooter(this.operationLog);
        monitor.log();
    }

    private MultiKeyMap<String, String> registerEntities(ResourceListParserData data) {
        Monitor monitor = new Monitor("Register entities", this.operationLog);
        AtomicEntityOperationDetails details = this.createEntityOperationDetails(data, monitor);
        MultiKeyMap<String, String> newEntities = new MultiKeyMap<String, String>();
        if (!this.config.isDryRun()) {
            AtomicEntityOperationResult operationResult = this.service.performEntityOperations(details);
            newEntities = this.getNewEntities(details);
            this.operationLog.info((Object)("Entity operation result: " + operationResult));
        }
        if (this.config.isVerbose()) {
            this.printSummary(details);
        }
        this.printShortSummary(details);
        monitor.log();
        return newEntities;
    }

    private AtomicEntityOperationDetails createEntityOperationDetails(ResourceListParserData data, Monitor monitor) {
        AtomicEntityOperationDetailsBuilder builder = new AtomicEntityOperationDetailsBuilder();
        builder.user(this.config.getHarvesterUser());
        this.processSpaces(data, builder);
        this.processProjects(data, builder);
        this.processExperiments(data, builder);
        this.processSamples(data, builder, monitor);
        this.processMaterials(data, builder);
        return builder.getDetails();
    }

    private void processSpaces(ResourceListParserData data, AtomicEntityOperationDetailsBuilder builder) {
        List<IncomingSpace> list = data.getRelevantSpacesToProcess();
        for (IncomingSpace incomingSpace : list) {
            String spaceCode = incomingSpace.getPermID();
            Space space = this.service.tryGetSpace(new SpaceIdentifier(spaceCode));
            if (space != null) continue;
            builder.space((NewSpace)incomingSpace.getEntity());
        }
    }

    private ResourceListParserData parseResourceList(Document doc) throws XPathExpressionException {
        Monitor monitor = new Monitor("Parsing resource list", this.operationLog);
        this.operationLog.info((Object)"Parsing the resource list xml document...");
        INameTranslator nameTranslator = new DefaultNameTranslator();
        if (this.config.isTranslateUsingDataSourceAlias()) {
            nameTranslator = new PrefixBasedNameTranslator(this.config.getDataSourceAlias());
        }
        ResourceListParser parser = ResourceListParser.create(nameTranslator, this.dataStoreCode);
        ResourceListParserData data = parser.parseResourceListDocument(doc, monitor);
        monitor.log();
        return data;
    }

    private Document getResourceList() throws Exception {
        Monitor monitor = new Monitor("Retrieving resoure list", this.operationLog);
        DataSourceConnector dataSourceConnector = new DataSourceConnector(this.config.getDataSourceURI(), this.config.getAuthenticationCredentials(), this.operationLog);
        this.operationLog.info((Object)"Retrieving the resource list...");
        Document doc = dataSourceConnector.getResourceListAsXMLDoc(this.config.getSpaceBlackList(), this.config.getSpaceWhiteList());
        monitor.log();
        return doc;
    }

    private MultiKeyMap<String, String> getNewEntities(AtomicEntityOperationDetails details) {
        MultiKeyMap newEntities = new MultiKeyMap();
        List sampleRegistrations = details.getSampleRegistrations();
        for (Object newSample : sampleRegistrations) {
            newEntities.put((Object)SyncEntityKind.SAMPLE.toString(), (Object)newSample.getPermID(), (Object)newSample.getIdentifier());
        }
        List experimentRegistrations = details.getExperimentRegistrations();
        for (NewExperiment newExperiment : experimentRegistrations) {
            newEntities.put((Object)SyncEntityKind.EXPERIMENT.toString(), (Object)newExperiment.getPermID(), (Object)newExperiment.getIdentifier());
        }
        List projectRegistrations = details.getProjectRegistrations();
        for (NewProject newProject : projectRegistrations) {
            newEntities.put((Object)SyncEntityKind.PROJECT.toString(), (Object)newProject.getPermID(), (Object)newProject.getIdentifier());
        }
        return newEntities;
    }

    private void printShortSummary(AtomicEntityOperationDetails details) {
        SummaryUtils.printShortSummaryHeader(this.operationLog);
        SummaryUtils.printShortAddedSummary(this.operationLog, details.getSpaceRegistrations().size(), "SPACES");
        SummaryUtils.printShortAddedSummary(this.operationLog, details.getProjectRegistrations().size(), "PROJECTS");
        SummaryUtils.printShortUpdatedSummary(this.operationLog, details.getProjectUpdates().size(), "PROJECTS");
        SummaryUtils.printShortAddedSummary(this.operationLog, details.getExperimentRegistrations().size(), "EXPERIMENTS");
        SummaryUtils.printShortUpdatedSummary(this.operationLog, details.getExperimentUpdates().size(), "EXPERIMENTS");
        SummaryUtils.printShortAddedSummary(this.operationLog, details.getSampleRegistrations().size(), "SAMPLES");
        SummaryUtils.printShortUpdatedSummary(this.operationLog, details.getSampleUpdates().size(), "SAMPLE");
        SummaryUtils.printShortAddedSummary(this.operationLog, details.getMaterialRegistrations().size(), "MATERIALS");
        SummaryUtils.printShortUpdatedSummary(this.operationLog, details.getMaterialUpdates().size(), "MATERIALS");
        SummaryUtils.printShortSummaryFooter(this.operationLog);
    }

    private void printSummary(AtomicEntityOperationDetails details) {
        this.printSummary(details.getSpaceRegistrations(), "SPACES");
        this.printSummary(details.getProjectRegistrations(), "PROJECTS");
        this.printProjectUpdatesSummary(details.getProjectUpdates());
        this.printSummary(details.getExperimentRegistrations(), "EXPERIMENTS");
        this.printExperimentUpdatesSummary(details.getExperimentUpdates());
        this.printSummary(details.getSampleRegistrations(), "SAMPLES");
        this.printSampleUpdatesSummary(details.getSampleUpdates());
        this.printMaterialsSummary(details.getMaterialRegistrations());
        this.printMaterialUpdatesSummary(details.getMaterialUpdates());
    }

    private void printSummary(List<?> items, String type) {
        List<String> identifiers = items.stream().map(Object::toString).collect(Collectors.toList());
        Collections.sort(identifiers);
        SummaryUtils.printAddedSummary(this.operationLog, identifiers, type);
    }

    private void printProjectUpdatesSummary(List<ProjectUpdatesDTO> updates) {
        List<String> identifiers = updates.stream().map(AbstractProjectUpdates::getIdentifier).collect(Collectors.toList());
        Collections.sort(identifiers);
        SummaryUtils.printUpdatedSummary(this.operationLog, identifiers, "PROJECTS");
    }

    private void printExperimentUpdatesSummary(List<ExperimentUpdatesDTO> updates) {
        List<String> identifiers = updates.stream().map(u -> u.getProjectIdentifier().asProjectIdentifierString()).collect(Collectors.toList());
        Collections.sort(identifiers);
        SummaryUtils.printUpdatedSummary(this.operationLog, identifiers, "EXPERIMENTS");
    }

    private void printSampleUpdatesSummary(List<SampleUpdatesDTO> updates) {
        List<String> identifiers = updates.stream().map(u -> u.getSampleIdentifier().toString()).collect(Collectors.toList());
        Collections.sort(identifiers);
        SummaryUtils.printUpdatedSummary(this.operationLog, identifiers, "SAMPLES");
    }

    private void printDataSetUpdatesSummary(List<DataSetBatchUpdatesDTO> updates) {
        List<String> identifiers = updates.stream().map(u -> u.getCode()).collect(Collectors.toList());
        Collections.sort(identifiers);
        SummaryUtils.printUpdatedSummary(this.operationLog, identifiers, "DATA SETS");
    }

    private void printLinkDataSetUpdatesSummary(List<DataSetUpdate> updates) {
        List<String> identifiers = updates.stream().map(u -> u.getDataSetId().toString()).collect(Collectors.toList());
        Collections.sort(identifiers);
        SummaryUtils.printUpdatedSummary(this.operationLog, identifiers, "LINK DATA SETS");
    }

    private void printMaterialsSummary(Map<String, List<NewMaterial>> materials) {
        ArrayList<String> details = new ArrayList<String>();
        for (Map.Entry<String, List<NewMaterial>> entry : materials.entrySet()) {
            String typeCode = entry.getKey();
            for (NewMaterial material : entry.getValue()) {
                details.add(MaterialIdentifier.print((String)material.getCode(), (String)typeCode));
            }
        }
        Collections.sort(details);
        SummaryUtils.printAddedSummary(this.operationLog, details, "MATERIALS");
    }

    private void printMaterialUpdatesSummary(List<MaterialUpdateDTO> materialUpdates) {
        if (!materialUpdates.isEmpty()) {
            SummaryUtils.printUpdatedSummary(this.operationLog, Arrays.asList(materialUpdates.size() + " materials"), "MATERIALS");
        }
    }

    private AttachmentSynchronizationSummary processAttachments(List<IncomingEntity<?>> attachmentHoldersToProcess, Monitor monitor) {
        AttachmentSynchronizationSummary synchronizationSummary = new AttachmentSynchronizationSummary();
        ParallelizedExecutionPreferences preferences = this.config.getParallelizedExecutionPrefs();
        monitor.log("Services for accessing data source established");
        List<List<IncomingEntity<?>>> attachmentHoldersChunks = this.chunk(attachmentHoldersToProcess);
        IApplicationServerApi v3apiDataSource = ServiceUtils.createAsV3Api(this.config.getDataSourceOpenbisURL());
        String sessionTokenDataSource = v3apiDataSource.login(this.config.getUser(), this.config.getPassword());
        ParallelizedExecutor.process(attachmentHoldersChunks, (ITaskExecutor)new AttachmentsSynchronizer(this.v3Api, this.service.getSessionToken(), v3apiDataSource, sessionTokenDataSource, this.lastSyncTimestamp, synchronizationSummary, this.config.isDryRun(), monitor), (double)preferences.getMachineLoad(), (int)preferences.getMaxThreads(), (String)"process attachments", (int)preferences.getRetriesOnFail(), (boolean)preferences.isStopOnFailure());
        return synchronizationSummary;
    }

    private List<List<IncomingEntity<?>>> chunk(List<IncomingEntity<?>> entities) {
        ArrayList chunks = new ArrayList();
        ArrayList chunk = null;
        for (IncomingEntity<?> incomingEntity : entities) {
            if (chunk == null || chunk.size() >= 1000) {
                chunk = new ArrayList();
                chunks.add(chunk);
            }
            chunk.add(incomingEntity);
        }
        return chunks;
    }

    private void establishDataSetRelationships(Map<String, IncomingDataSet> dataSetsToProcess, List<String> skippedDataSets, Set<String> containerDataSets) {
        NewExternalData dataSet;
        AtomicEntityOperationDetailsBuilder builder = new AtomicEntityOperationDetailsBuilder();
        HashMap<String, NewExternalData> datasetsToUpdate = new HashMap<String, NewExternalData>();
        HashMap<String, Set<String>> dsToParents = new HashMap<String, Set<String>>();
        HashMap dsToContained = new HashMap();
        for (IncomingDataSet dsWithConn : dataSetsToProcess.values()) {
            dataSet = dsWithConn.getDataSet();
            for (Connection conn : dsWithConn.getConnections()) {
                NewExternalData componentDataSet;
                IncomingDataSet dataSet2 = dataSetsToProcess.get(conn.getToPermId());
                if (dataSet2 == null) continue;
                if (conn.getType().equals("Child")) {
                    if (skippedDataSets.contains(dataSet.getCode())) continue;
                    NewExternalData childDataSet = dataSet2.getDataSet();
                    List parentDataSetCodes = childDataSet.getParentDataSetCodes();
                    parentDataSetCodes.add(dataSet.getCode());
                    dsToParents.put(childDataSet.getCode(), new HashSet(parentDataSetCodes));
                    continue;
                }
                if (!conn.getType().equals("Component") || skippedDataSets.contains((componentDataSet = dataSet2.getDataSet()).getCode())) continue;
                NewContainerDataSet containerDataSet = (NewContainerDataSet)dataSet;
                List containedDataSetCodes = containerDataSet.getContainedDataSetCodes();
                containedDataSetCodes.add(componentDataSet.getCode());
                dsToContained.put(dataSet.getCode(), new HashSet(containedDataSetCodes));
            }
        }
        for (IncomingDataSet dsWithConn : dataSetsToProcess.values()) {
            dataSet = dsWithConn.getDataSet();
            if (!dsWithConn.getLastModificationDate().after(this.lastSyncTimestamp) && !this.dataSetsCodesToRetry.contains(dataSet.getCode()) && !this.isParentModified(dsToParents, dataSet) || this.blackListedDataSetCodes.contains(dataSet.getCode())) continue;
            if (containerDataSets.contains(dataSet.getCode()) && this.service.tryGetDataSet(dataSet.getCode()) == null) {
                builder.dataSet(dataSet);
                continue;
            }
            datasetsToUpdate.put(dataSet.getCode(), dataSet);
        }
        for (NewExternalData dataSet2 : datasetsToUpdate.values()) {
            AbstractExternalData dsInHarvester = this.service.tryGetDataSet(dataSet2.getCode());
            if (dsInHarvester == null) continue;
            DataSetBatchUpdatesDTO dsBatchUpdatesDTO = this.createDataSetBatchUpdateDTO(dataSet2, dsInHarvester);
            Set<String> resetPropertyList = this.getResetPropertyList(DSPropertyUtils.convertToEntityProperty(dataSet2.getDataSetProperties()), dsInHarvester.getProperties());
            Set propertiesToUpdate = dsBatchUpdatesDTO.getDetails().getPropertiesToUpdate();
            propertiesToUpdate.addAll(resetPropertyList);
            dsBatchUpdatesDTO.getDetails().setPropertiesToUpdate(propertiesToUpdate);
            if (dataSet2 instanceof NewContainerDataSet) {
                NewContainerDataSet containerDS = (NewContainerDataSet)dataSet2;
                if (dsToContained.containsKey(containerDS.getCode())) {
                    dsBatchUpdatesDTO.setModifiedContainedDatasetCodesOrNull(((Set)dsToContained.get(dataSet2.getCode())).toArray(new String[containerDS.getContainedDataSetCodes().size()]));
                } else {
                    dsBatchUpdatesDTO.setModifiedContainedDatasetCodesOrNull(new String[0]);
                }
                dsBatchUpdatesDTO.getDetails().setContainerUpdateRequested(true);
            }
            if (dsToParents.containsKey(dataSet2.getCode())) {
                dsBatchUpdatesDTO.setModifiedParentDatasetCodesOrNull(((Set)dsToParents.get(dataSet2.getCode())).toArray(new String[dataSet2.getParentDataSetCodes().size()]));
            } else {
                dsBatchUpdatesDTO.setModifiedParentDatasetCodesOrNull(new String[0]);
            }
            dsBatchUpdatesDTO.getDetails().setParentsUpdateRequested(true);
            SampleIdentifier sampleIdentifier = dataSet2.getSampleIdentifierOrNull();
            if (sampleIdentifier != null) {
                dsBatchUpdatesDTO.setSampleIdentifierOrNull(sampleIdentifier);
            } else {
                dsBatchUpdatesDTO.setSampleIdentifierOrNull(null);
            }
            dsBatchUpdatesDTO.getDetails().setSampleUpdateRequested(true);
            ExperimentIdentifier expIdentifier = dataSet2.getExperimentIdentifierOrNull();
            if (expIdentifier != null) {
                dsBatchUpdatesDTO.setExperimentIdentifierOrNull(expIdentifier);
            } else {
                dsBatchUpdatesDTO.setExperimentIdentifierOrNull(null);
            }
            dsBatchUpdatesDTO.getDetails().setExperimentUpdateRequested(true);
            builder.dataSetUpdate(dsBatchUpdatesDTO);
        }
        AtomicEntityOperationDetails details = builder.getDetails();
        if (!this.config.isDryRun()) {
            AtomicEntityOperationResult operationResult = this.service.performEntityOperations(details);
            this.operationLog.info((Object)("entity operation result: " + operationResult));
        }
        if (this.config.isVerbose()) {
            this.printSummary(details.getDataSetRegistrations(), "CONTAINER DATA SETS");
            this.printDataSetUpdatesSummary(details.getDataSetUpdates());
        }
        SummaryUtils.printShortSummaryHeader(this.operationLog);
        SummaryUtils.printShortAddedSummary(this.operationLog, details.getDataSetRegistrations().size(), "CONTAINER DATA SETS");
        SummaryUtils.printShortUpdatedSummary(this.operationLog, details.getDataSetUpdates().size(), "DATA SETS");
        SummaryUtils.printShortSummaryFooter(this.operationLog);
    }

    private boolean isParentModified(Map<String, Set<String>> dsToParents, NewExternalData dataSet) {
        Set<String> parents = dsToParents.get(dataSet.getCode());
        if (parents == null) {
            return false;
        }
        for (String parentDSCode : parents) {
            if (!this.dataSetsCodesToRetry.contains(parentDSCode)) continue;
            return true;
        }
        return false;
    }

    private DataSetSynchronizationSummary registerPhysicalDataSets(Map<String, IncomingDataSet> physicalDSMap) throws IOException {
        List dsList = new ArrayList<IncomingDataSet>(physicalDSMap.values()).stream().map(IncomingDataSet::getFullDataSet).map(FullDataSetCreation::getMetadataCreation).collect(Collectors.toList());
        DataSetSynchronizationSummary dataSetSynchronizationSummary = new DataSetSynchronizationSummary();
        ParallelizedExecutionPreferences preferences = this.config.getParallelizedExecutionPrefs();
        String sessionToken = this.service.getSessionToken();
        DataSetProcessingContext context = new DataSetProcessingContext(null, null, null, null, null, null, sessionToken);
        ParallelizedExecutor.process(dsList, (ITaskExecutor)new DataSetRegistrationTaskExecutor(dataSetSynchronizationSummary, this.operationLog, this.storeRoot, context, this.config), (double)preferences.getMachineLoad(), (int)preferences.getMaxThreads(), (String)"register data sets", (int)preferences.getRetriesOnFail(), (boolean)preferences.isStopOnFailure());
        return dataSetSynchronizationSummary;
    }

    private void saveFailedEntitiesFile(List<String> notRegisteredDataSetCodes) throws IOException {
        File notSyncedEntitiesFile = new File(this.config.getNotSyncedEntitiesFileName());
        if (notSyncedEntitiesFile.exists()) {
            this.backupAndResetNotSyncedDataSetsFile(notSyncedEntitiesFile);
        }
        for (String dsCode : notRegisteredDataSetCodes) {
            FileUtilities.appendToFile((File)notSyncedEntitiesFile, (String)((Object)((Object)SyncEntityKind.DATA_SET) + "-" + dsCode), (boolean)true);
        }
        for (String dsCode : this.blackListedDataSetCodes) {
            FileUtilities.appendToFile((File)notSyncedEntitiesFile, (String)("#" + (Object)((Object)SyncEntityKind.DATA_SET) + "-" + dsCode), (boolean)true);
        }
    }

    private void backupAndResetNotSyncedDataSetsFile(File notSyncedDataSetsFile) throws IOException {
        File backupLastSyncTimeStampFile = new File(this.config.getNotSyncedEntitiesFileName() + ".bk");
        FileUtils.copyFile((File)notSyncedDataSetsFile, (File)backupLastSyncTimeStampFile);
        FileUtilities.writeToFile((File)notSyncedDataSetsFile, (String)"");
    }

    private void registerMasterData(MasterData masterData) {
        Monitor monitor = new Monitor("Register master data", this.operationLog);
        this.operationLog.info((Object)"Registering master data...");
        MasterDataSynchronizer masterDataSynchronizer = new MasterDataSynchronizer(this.config, this.operationLog);
        masterDataSynchronizer.synchronizeMasterData(masterData, monitor);
        monitor.log();
    }

    private void processDeletions(ResourceListParserData data) throws Exception {
        Monitor monitor = new Monitor("Delete entities", this.operationLog);
        String sessionToken = this.service.getSessionToken();
        SkinnyEntityRetriever entityRetriever = SkinnyEntityRetriever.createWithSessionToken(this.v3Api, sessionToken);
        Set<String> incomingProjectPermIds = data.getProjectsToProcess().keySet();
        Set<String> incomingExperimentPermIds = data.getExperimentsToProcess().keySet();
        Set<String> incomingSamplePermIds = data.getSamplesToProcess().keySet();
        Set<String> incomingDataSetCodes = data.getDataSetsToProcess().keySet();
        MultiKeyMap<String, IncomingMaterial> incomingMaterials = data.getMaterialsToProcess();
        HashMap<ProjectPermId, String> projectsToDelete = new HashMap<ProjectPermId, String>();
        HashMap<ExperimentPermId, String> experimentsToDelete = new HashMap<ExperimentPermId, String>();
        HashMap<SamplePermId, String> samplesToDelete = new HashMap<SamplePermId, String>();
        HashMap<DataSetPermId, String> dataSetsToDelete = new HashMap<DataSetPermId, String>();
        HashMap<MaterialPermId, String> materialsToDelete = new HashMap<MaterialPermId, String>();
        HashSet<PhysicalDataSet> physicalDataSetsDelete = new HashSet<PhysicalDataSet>();
        for (String string : data.getHarvesterSpaceList()) {
            EntityGraph<INode> harvesterEntityGraph = entityRetriever.getEntityGraph(string);
            List<INode> entities = harvesterEntityGraph.getNodes();
            for (INode entity : entities) {
                String permId = entity.getPermId();
                String identifier = entity.getIdentifier().getEntityIdentifier();
                String typeCodeOrNull = entity.getTypeCodeOrNull();
                if (entity.getEntityKind().equals((Object)SyncEntityKind.PROJECT)) {
                    if (incomingProjectPermIds.contains(permId)) continue;
                    ProjectPermId projectPermId = new ProjectPermId(permId);
                    projectsToDelete.put(projectPermId, identifier);
                    continue;
                }
                if (entity.getEntityKind().equals((Object)SyncEntityKind.EXPERIMENT)) {
                    ExperimentPermId experimentPermId = new ExperimentPermId(permId);
                    if (!incomingExperimentPermIds.contains(permId)) {
                        experimentsToDelete.put(experimentPermId, identifier);
                        continue;
                    }
                    NewExperiment exp = data.getExperimentsToProcess().get(permId).getExperiment();
                    if (typeCodeOrNull.equals(exp.getExperimentTypeCode())) continue;
                    experimentsToDelete.put(experimentPermId, identifier);
                    continue;
                }
                if (entity.getEntityKind().equals((Object)SyncEntityKind.SAMPLE)) {
                    SamplePermId samplePermId = new SamplePermId(permId);
                    if (!incomingSamplePermIds.contains(permId)) {
                        samplesToDelete.put(samplePermId, identifier);
                        continue;
                    }
                    NewSample smp = data.getSamplesToProcess().get(permId).getSample();
                    if (typeCodeOrNull.equals(smp.getSampleType().getCode())) continue;
                    samplesToDelete.put(samplePermId, identifier);
                    continue;
                }
                if (!entity.getEntityKind().equals((Object)SyncEntityKind.DATA_SET)) continue;
                DataSetPermId dataSetPermId = new DataSetPermId(permId);
                if (!incomingDataSetCodes.contains(permId)) {
                    dataSetsToDelete.put(dataSetPermId, dataSetPermId.getPermId());
                    continue;
                }
                boolean sameDS = true;
                IncomingDataSet dsWithConns = data.getDataSetsToProcess().get(permId);
                NewExternalData ds = dsWithConns.getDataSet();
                if (!typeCodeOrNull.equals(ds.getDataSetType().getCode())) {
                    sameDS = false;
                } else if (dsWithConns.getKind() == DataSetKind.PHYSICAL && dsWithConns.getLastModificationDate().after(this.lastIncSyncTimestamp)) {
                    PhysicalDataSet physicalDS = this.service.tryGetDataSet(permId).tryGetAsDataSet();
                    sameDS = this.deepCompareDataSets(permId);
                    if (!sameDS) {
                        physicalDataSetsDelete.add(physicalDS);
                    }
                }
                if (sameDS) continue;
                dataSetsToDelete.put(dataSetPermId, dataSetPermId.getPermId());
            }
        }
        List<ch.ethz.sis.openbis.generic.asapi.v3.dto.material.Material> materials = entityRetriever.fetchMaterials();
        for (ch.ethz.sis.openbis.generic.asapi.v3.dto.material.Material material : materials) {
            if (incomingMaterials.containsKey((Object)material.getCode(), (Object)material.getType().getCode())) continue;
            MaterialPermId materialPermId = new MaterialPermId(material.getCode(), material.getType().getCode());
            materialsToDelete.put(materialPermId, materialPermId.getCode());
        }
        this.operationLog.info((Object)"-------Processing deletions-------");
        if (this.config.isVerbose()) {
            if (!(dataSetsToDelete.isEmpty() && samplesToDelete.isEmpty() && experimentsToDelete.isEmpty() && projectsToDelete.isEmpty() && materialsToDelete.isEmpty())) {
                this.operationLog.info((Object)"!!!!!!!!!!!!!The following will be PERMAMENTLY removed from openbis!!!!!!!!!!!!!");
            }
            this.verboseLogDeletions(dataSetsToDelete.values(), "data sets");
            this.verboseLogDeletions(samplesToDelete.values(), "samples");
            this.verboseLogDeletions(experimentsToDelete.values(), "experiments");
            this.verboseLogDeletions(projectsToDelete.values(), "projects");
            this.verboseLogDeletions(materialsToDelete.values(), "materials");
        }
        if (this.config.isDryRun()) {
            monitor.log();
            return;
        }
        DataSetDeletionOptions dataSetDeletionOptions = new DataSetDeletionOptions();
        String reasonDetail = " from data source : " + this.config.getDataSourceAlias();
        dataSetDeletionOptions.setReason("sync data set deletions" + reasonDetail);
        IDeletionId dsDeletionId = this.v3Api.deleteDataSets(sessionToken, new ArrayList(dataSetsToDelete.keySet()), dataSetDeletionOptions);
        SampleDeletionOptions sampleDeletionOptions = new SampleDeletionOptions();
        sampleDeletionOptions.setReason("sync sample deletions" + reasonDetail);
        IDeletionId smpDeletionId = this.v3Api.deleteSamples(sessionToken, new ArrayList(samplesToDelete.keySet()), sampleDeletionOptions);
        ExperimentDeletionOptions expDeletionOpts = new ExperimentDeletionOptions();
        expDeletionOpts.setReason("sync experiment deletions" + reasonDetail);
        IDeletionId expDeletionId = this.v3Api.deleteExperiments(sessionToken, new ArrayList(experimentsToDelete.keySet()), expDeletionOpts);
        this.v3Api.confirmDeletions(sessionToken, Collections.singletonList(dsDeletionId));
        this.v3Api.confirmDeletions(sessionToken, Collections.singletonList(smpDeletionId));
        this.v3Api.confirmDeletions(sessionToken, Collections.singletonList(expDeletionId));
        ProjectDeletionOptions prjDeletionOpts = new ProjectDeletionOptions();
        prjDeletionOpts.setReason("Sync projects" + reasonDetail);
        this.v3Api.deleteProjects(sessionToken, new ArrayList(projectsToDelete.keySet()), prjDeletionOpts);
        MaterialDeletionOptions matDeletionOptions = new MaterialDeletionOptions();
        matDeletionOptions.setReason("sync materials" + reasonDetail);
        try {
            this.v3Api.deleteMaterials(sessionToken, new ArrayList(materialsToDelete.keySet()), matDeletionOptions);
        }
        catch (Exception e) {
            this.operationLog.warn((Object)("One or more materials could not be deleted due to: " + e.getMessage()));
        }
        StringBuffer summary = new StringBuffer();
        if (projectsToDelete.size() > 0) {
            summary.append(projectsToDelete.size() + " projects,");
        }
        if (materialsToDelete.size() > 0) {
            summary.append(materialsToDelete.size() + " materials,");
        }
        if (expDeletionId != null) {
            summary.append(experimentsToDelete.size() + " experiments,");
        }
        if (smpDeletionId != null) {
            summary.append(samplesToDelete.size() + " samples,");
        }
        if (dsDeletionId != null) {
            summary.append(dataSetsToDelete.size() + " data sets");
        }
        if (summary.length() > 0) {
            this.operationLog.info((Object)(summary.substring(0, summary.length() - 1) + " have been deleted:"));
        } else {
            this.operationLog.info((Object)"Nothing has been deleted:");
        }
        for (PhysicalDataSet physicalDS : physicalDataSetsDelete) {
            this.operationLog.info((Object)("Is going to delete the location: " + physicalDS.getLocation()));
            File datasetDir = this.getDirectoryProvider().getDataSetDirectory((IDatasetLocation)physicalDS);
            SegmentedStoreUtils.deleteDataSetInstantly(physicalDS.getCode(), datasetDir, (ISimpleLogger)new Log4jSimpleLogger(this.operationLog));
        }
        monitor.log();
    }

    private void verboseLogDeletions(Collection<String> identifiers, String entityKind) {
        if (identifiers.isEmpty()) {
            return;
        }
        this.operationLog.info((Object)(identifiers.size() + " " + entityKind + " with the following identifiers:"));
        for (String identifier : identifiers) {
            this.operationLog.info((Object)identifier);
        }
    }

    private void processExperiments(ResourceListParserData data, AtomicEntityOperationDetailsBuilder builder) {
        Map<String, IncomingExperiment> experimentsToProcess = data.getExperimentsToProcess();
        for (IncomingExperiment exp : experimentsToProcess.values()) {
            NewExperiment incomingExp = exp.getExperiment();
            if (!exp.getLastModificationDate().after(this.lastSyncTimestamp)) continue;
            Experiment experiment = this.findExperiment(incomingExp);
            if (experiment == null) {
                builder.experiment(incomingExp);
                continue;
            }
            ExperimentUpdatesDTO expUpdate = this.createExperimentUpdateDTOs(incomingExp, experiment);
            builder.experimentUpdate(expUpdate);
        }
    }

    private Experiment findExperiment(NewExperiment incomingExp) {
        Experiment experiment = this.service.tryGetExperimentByPermId(incomingExp.getPermID());
        if (experiment != null) {
            return experiment;
        }
        return this.service.tryGetExperiment(ExperimentIdentifierFactory.parse((String)incomingExp.getIdentifier()));
    }

    private ExperimentUpdatesDTO createExperimentUpdateDTOs(NewExperiment incomingExp, Experiment experiment) {
        ExperimentUpdatesDTO expUpdate = new ExperimentUpdatesDTO();
        expUpdate.setProjectIdentifier((ProjectIdentifier)ExperimentIdentifierFactory.parse((String)incomingExp.getIdentifier()));
        expUpdate.setVersion(experiment.getVersion());
        List<IEntityProperty> newPropList = this.prepareUpdatedPropertyList(incomingExp.getProperties(), experiment.getProperties());
        expUpdate.setProperties(newPropList);
        expUpdate.setExperimentId(TechId.create((IIdHolder)experiment));
        expUpdate.setAttachments(Collections.emptyList());
        return expUpdate;
    }

    private void processMaterials(ResourceListParserData data, AtomicEntityOperationDetailsBuilder builder) {
        MultiKeyMap<String, IncomingMaterial> materialsToProcess = data.getMaterialsToProcess();
        for (IncomingMaterial newMaterialWithType : materialsToProcess.values()) {
            NewMaterialWithType incomingMaterial = newMaterialWithType.getMaterial();
            if (!newMaterialWithType.getLastModificationDate().after(this.lastSyncTimestamp)) continue;
            Material material = this.service.tryGetMaterial(new MaterialIdentifier(incomingMaterial.getCode(), incomingMaterial.getType()));
            if (material == null) {
                builder.material(incomingMaterial);
                continue;
            }
            List<IEntityProperty> newPropList = this.prepareUpdatedPropertyList(incomingMaterial.getProperties(), material.getProperties());
            MaterialUpdateDTO update = new MaterialUpdateDTO(TechId.create((IIdHolder)material), newPropList, material.getModificationDate());
            builder.materialUpdate(update);
        }
    }

    private void processProjects(ResourceListParserData data, AtomicEntityOperationDetailsBuilder builder) {
        Map<String, IncomingProject> projectsToProcess = data.getProjectsToProcess();
        for (IncomingProject prj : projectsToProcess.values()) {
            NewProject incomingProject = prj.getProject();
            if (!prj.getLastModificationDate().after(this.lastSyncTimestamp)) continue;
            Project project = this.findProject(incomingProject);
            if (project == null) {
                builder.project(incomingProject);
                continue;
            }
            builder.projectUpdate(this.createProjectUpdateDTO(incomingProject, project));
        }
    }

    private Project findProject(NewProject incomingProject) {
        Project project = this.service.tryGetProjectByPermId(incomingProject.getPermID());
        if (project != null) {
            return project;
        }
        return this.service.tryGetProject(ProjectIdentifierFactory.parse((String)incomingProject.getIdentifier()));
    }

    private ProjectUpdatesDTO createProjectUpdateDTO(NewProject incomingProject, Project project) {
        ProjectUpdatesDTO prjUpdate = new ProjectUpdatesDTO();
        prjUpdate.setVersion(project.getVersion());
        prjUpdate.setTechId(TechId.create((IIdHolder)project));
        prjUpdate.setDescription(incomingProject.getDescription());
        prjUpdate.setAttachments(Collections.emptyList());
        ProjectIdentifier projectIdentifier = ProjectIdentifierFactory.parse((String)incomingProject.getIdentifier());
        prjUpdate.setIdentifier(projectIdentifier.asProjectIdentifierString());
        prjUpdate.setSpaceCode(projectIdentifier.getSpaceCode());
        return prjUpdate;
    }

    private void processSamples(ResourceListParserData data, AtomicEntityOperationDetailsBuilder builder, Monitor monitor) {
        Map<String, IncomingSample> samplesToProcess = data.getSamplesToProcess();
        Map<String, Sample> knownSamplesByPermId = this.getKnownSamplesByPermId(samplesToProcess.keySet());
        Map<String, Sample> knownSamplesByIdentifier = this.getKnownSamplesByIdentifier(samplesToProcess);
        HashMap<SampleIdentifier, NewSample> samplesToUpdate = new HashMap<SampleIdentifier, NewSample>();
        HashSet<String> sampleWithUpdatedParents = new HashSet<String>();
        int count = 0;
        int n = samplesToProcess.size();
        for (IncomingSample sample : samplesToProcess.values()) {
            if (++count % 10000 == 0) {
                monitor.log(String.format("%7d/%d sample: %s", count, n, sample.getIdentifier()));
            }
            NewSample incomingSample = sample.getSample();
            if (sample.getLastModificationDate().after(this.lastSyncTimestamp)) {
                SampleIdentifier sampleIdentifier = SampleIdentifierFactory.parse((NewSample)incomingSample);
                Sample knownSample = this.findKnownSample(knownSamplesByPermId, knownSamplesByIdentifier, incomingSample);
                if (knownSample == null) {
                    builder.sample(incomingSample);
                } else {
                    samplesToUpdate.put(sampleIdentifier, incomingSample);
                    for (Sample child : knownSample.getChildren()) {
                        String childSampleIdentifier = child.getIdentifier().getIdentifier();
                        IncomingSample childSampleWithConns = this.findChildInSamplesToProcess(childSampleIdentifier, samplesToProcess);
                        if (childSampleWithConns == null) continue;
                        NewSample childSample = childSampleWithConns.getSample();
                        sampleWithUpdatedParents.add(childSample.getIdentifier());
                    }
                }
            }
            for (Connection conn : sample.getConnections()) {
                if (conn.getType().equals("Component")) {
                    NewSample containedSample = this.getRelated(samplesToProcess, conn).getSample();
                    containedSample.setContainerIdentifier(incomingSample.getIdentifier());
                    continue;
                }
                if (!conn.getType().equals("Child")) continue;
                NewSample childSample = this.getRelated(samplesToProcess, conn).getSample();
                String[] parents = childSample.getParentsOrNull();
                ArrayList<Object> parentIds = null;
                parentIds = parents == null ? new ArrayList<String>() : new ArrayList<String>(Arrays.asList(parents));
                parentIds.add(incomingSample.getIdentifier());
                childSample.setParentsOrNull(parentIds.toArray(new String[parentIds.size()]));
            }
        }
        this.createSampleUpdates(builder, samplesToUpdate, sampleWithUpdatedParents);
    }

    private Sample findKnownSample(Map<String, Sample> knownSamplesByPermId, Map<String, Sample> knownSamplesByIdentifier, NewSample incomingSample) {
        Sample knownSample = null;
        knownSample = knownSamplesByPermId.get(incomingSample.getPermID());
        if (knownSample == null) {
            knownSample = knownSamplesByIdentifier.get(incomingSample.getIdentifier());
        }
        return knownSample;
    }

    private void createSampleUpdates(AtomicEntityOperationDetailsBuilder builder, Map<SampleIdentifier, NewSample> samplesToUpdate, Set<String> sampleWithUpdatedParents) {
        for (SampleIdentifier sampleIdentifier : samplesToUpdate.keySet()) {
            NewSample incomingSmp = samplesToUpdate.get(sampleIdentifier);
            ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample sample = this.service.tryGetSampleByPermId(incomingSmp.getPermID());
            if (sample == null) {
                sample = this.service.tryGetSampleWithExperiment(sampleIdentifier);
            }
            TechId sampleId = TechId.create((IIdHolder)sample);
            ExperimentIdentifier experimentIdentifier = this.getExperimentIdentifier(incomingSmp);
            ProjectIdentifier projectIdentifier = this.getProjectIdentifier(incomingSmp);
            String[] modifiedParentIds = incomingSmp.getParentsOrNull();
            if (modifiedParentIds == null && sampleWithUpdatedParents.contains(incomingSmp.getIdentifier())) {
                modifiedParentIds = new String[]{};
            }
            String containerIdentifier = this.getContainerIdentifier(incomingSmp);
            List<IEntityProperty> newPropList = this.prepareUpdatedPropertyList(incomingSmp.getProperties(), sample.getProperties());
            SampleUpdatesDTO updates = new SampleUpdatesDTO(sampleId, newPropList, experimentIdentifier, projectIdentifier, Collections.emptyList(), sample.getVersion(), sampleIdentifier, containerIdentifier, modifiedParentIds);
            builder.sampleUpdate(updates);
        }
    }

    private IncomingSample getRelated(Map<String, IncomingSample> samplesToProcess, Connection conn) {
        String permId = conn.getToPermId();
        IncomingSample sample = samplesToProcess.get(permId);
        if (sample != null) {
            return sample;
        }
        throw new IllegalArgumentException("sample " + permId + " hasn't been provided by the data source.");
    }

    private Map<String, Sample> getKnownSamplesByPermId(Collection<String> samplePermIds) {
        List<ISampleId> sampleIds = samplePermIds.stream().map(SamplePermId::new).collect(Collectors.toList());
        HashMap<String, Sample> result = new HashMap<String, Sample>();
        for (Sample sample : this.getKnownSamples(sampleIds).values()) {
            result.put(sample.getPermId().getPermId(), sample);
        }
        return result;
    }

    private Map<String, Sample> getKnownSamplesByIdentifier(Map<String, IncomingSample> samples) {
        List<ISampleId> sampleIds = samples.values().stream().map(s -> new ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.SampleIdentifier(s.getIdentifier())).collect(Collectors.toList());
        HashMap<String, Sample> result = new HashMap<String, Sample>();
        for (Sample sample : this.getKnownSamples(sampleIds).values()) {
            result.put(sample.getIdentifier().getIdentifier(), sample);
        }
        return result;
    }

    private Map<ISampleId, Sample> getKnownSamples(List<ISampleId> sampleIds) {
        SampleFetchOptions fetchOptions = new SampleFetchOptions();
        fetchOptions.withChildren();
        String sessionToken = this.service.getSessionToken();
        Map samples = this.v3Api.getSamples(sessionToken, sampleIds, fetchOptions);
        return samples;
    }

    private List<IEntityProperty> prepareUpdatedPropertyList(IEntityProperty[] iEntityProperties, List<IEntityProperty> existingProperties) {
        ArrayList<IEntityProperty> incomingProperties = new ArrayList<IEntityProperty>(Arrays.asList(iEntityProperties));
        Set<String> existingPropertyNames = this.extractPropertyNames(existingProperties);
        Set<String> newPropertyNames = this.extractPropertyNames(incomingProperties);
        existingPropertyNames.removeAll(newPropertyNames);
        for (String propName : existingPropertyNames) {
            GenericEntityProperty property = new GenericEntityProperty();
            PropertyType propertyType = new PropertyType();
            propertyType.setCode(propName);
            property.setPropertyType(propertyType);
            property.setValue("");
            incomingProperties.add((IEntityProperty)property);
        }
        return incomingProperties;
    }

    private Set<String> getResetPropertyList(IEntityProperty[] iEntityProperties, List<IEntityProperty> existingProperties) {
        ArrayList<IEntityProperty> incomingProperties = new ArrayList<IEntityProperty>(Arrays.asList(iEntityProperties));
        Set<String> existingPropertyNames = this.extractPropertyNames(existingProperties);
        Set<String> newPropertyNames = this.extractPropertyNames(incomingProperties);
        existingPropertyNames.removeAll(newPropertyNames);
        return existingPropertyNames;
    }

    private Set<String> extractPropertyNames(List<IEntityProperty> existingProperties) {
        HashSet<String> existingPropertyNames = new HashSet<String>();
        for (IEntityProperty prop : existingProperties) {
            existingPropertyNames.add(prop.getPropertyType().getCode());
        }
        return existingPropertyNames;
    }

    private String getContainerIdentifier(NewSample newSmp) {
        String containerIdentifier = newSmp.getContainerIdentifier();
        return containerIdentifier == null ? null : containerIdentifier;
    }

    private ExperimentIdentifier getExperimentIdentifier(NewSample newSmp) {
        String expIdentifier = newSmp.getExperimentIdentifier();
        if (expIdentifier == null) {
            return null;
        }
        return ExperimentIdentifierFactory.parse((String)expIdentifier);
    }

    private ProjectIdentifier getProjectIdentifier(NewSample sample) {
        String projectIdentifier = sample.getProjectIdentifier();
        if (projectIdentifier == null) {
            return null;
        }
        return ProjectIdentifierFactory.parse((String)projectIdentifier);
    }

    private IncomingSample findChildInSamplesToProcess(String childSampleIdentifier, Map<String, IncomingSample> samplesToProcess) {
        for (IncomingSample sample : samplesToProcess.values()) {
            if (!sample.getSample().getIdentifier().equals(childSampleIdentifier)) continue;
            return sample;
        }
        return null;
    }

    private boolean deepCompareDataSets(String dataSetCode) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        V3Facade v3FacadeToDataSource = new V3Facade(this.config);
        DataSetFileSearchCriteria criteria = new DataSetFileSearchCriteria();
        criteria.withDataSet().withCode().thatEquals(dataSetCode);
        SearchResult<DataSetFile> result = v3FacadeToDataSource.searchFiles(criteria, new DataSetFileFetchOptions());
        IDataStoreServerApi dssharvester = (IDataStoreServerApi)ServiceProvider.getDssServiceV3().getService();
        SearchResult resultHarvester = dssharvester.searchFiles(ServiceProvider.getOpenBISService().getSessionToken(), criteria, new DataSetFileFetchOptions());
        if (result.getTotalCount() != resultHarvester.getTotalCount()) {
            return false;
        }
        List dsNodes = result.getObjects();
        List harvesterNodes = resultHarvester.getObjects();
        this.sortFileNodes(dsNodes);
        this.sortFileNodes(harvesterNodes);
        return this.calculateHash(dsNodes).equals(this.calculateHash(harvesterNodes));
    }

    private void sortFileNodes(List<DataSetFile> nodes) {
        Collections.sort(nodes, new Comparator<DataSetFile>(){

            @Override
            public int compare(DataSetFile dsFile1, DataSetFile dsFile2) {
                return dsFile1.getPath().compareTo(dsFile2.getPath());
            }
        });
    }

    private String calculateHash(List<DataSetFile> nodes) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        StringBuffer sb = new StringBuffer();
        for (DataSetFile dataSetFile : nodes) {
            sb.append(dataSetFile.getPath());
            sb.append(dataSetFile.getChecksumCRC32());
            sb.append(dataSetFile.getFileLength());
        }
        byte[] digest = MessageDigest.getInstance("MD5").digest(new String(sb).getBytes("UTF-8"));
        return new String(Hex.encodeHex((byte[])digest));
    }

    private DataSetBatchUpdatesDTO createDataSetBatchUpdateDTO(NewExternalData dataSet, AbstractExternalData dsInHarvester) {
        DataSetUpdatable updateUpdatable = new DataSetUpdatable(dsInHarvester, this.service);
        DataSetBatchUpdatesDTO dsBatchUpdatesDTO = ConversionUtils.convertToDataSetBatchUpdatesDTO(updateUpdatable);
        dsBatchUpdatesDTO.setDatasetId(TechId.create((IIdHolder)dsInHarvester));
        List<IEntityProperty> updatedProperties = this.prepareUpdatedPropertyList(DSPropertyUtils.convertToEntityProperty(dataSet.getDataSetProperties()), dsInHarvester.getProperties());
        dsBatchUpdatesDTO.setProperties(updatedProperties);
        return dsBatchUpdatesDTO;
    }

    private IDataSetDirectoryProvider getDirectoryProvider() {
        return new DataSetDirectoryProvider(this.getConfigProvider().getStoreRoot(), this.getShareIdManager());
    }

    private IConfigProvider getConfigProvider() {
        return ServiceProvider.getConfigProvider();
    }

    private IShareIdManager getShareIdManager() {
        return ServiceProvider.getShareIdManager();
    }
}

