/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.externaldms.ExternalDms;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.externaldms.ExternalDmsAddressType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.externaldms.id.ExternalDmsPermId;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.NameMapper;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.translator.DefaultNameTranslator;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.translator.INameTranslator;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.util.DSPropertyUtils;
import ch.systemsx.cisd.common.collection.SimpleComparator;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeConverter;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.FileFormatType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewETPTAssignment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewVocabulary;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Person;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PluginType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Script;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ScriptType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MasterDataParser {
    private static final SimpleComparator<NewETPTAssignment, Long> ASSIGNMENT_COMPARATOR_BY_ORDINAL = new SimpleComparator<NewETPTAssignment, Long>(){

        public Long evaluate(NewETPTAssignment item) {
            Long ordinal = item.getOrdinal();
            return ordinal == null ? -1L : ordinal;
        }
    };
    private final INameTranslator nameTranslator;
    private Map<String, Script> validationPlugins = new HashMap<String, Script>();
    private Map<String, ExternalDms> externalDataManagementSystems = new HashMap<String, ExternalDms>();
    private Map<String, FileFormatType> fileFormatTypes = new HashMap<String, FileFormatType>();
    private Map<String, PropertyType> propertyTypes = new HashMap<String, PropertyType>();
    private Map<String, SampleType> sampleTypes = new HashMap<String, SampleType>();
    private Map<String, DataSetType> dataSetTypes = new HashMap<String, DataSetType>();
    private Map<String, ExperimentType> experimentTypes = new HashMap<String, ExperimentType>();
    private Map<String, MaterialType> materialTypes = new HashMap<String, MaterialType>();
    private Map<String, NewVocabulary> vocabularies = new HashMap<String, NewVocabulary>();
    MultiKeyMap<String, List<NewETPTAssignment>> entityPropertyAssignments = new MultiKeyMap();
    private NameMapper vocabularyNameMapper;
    private NameMapper propertyTypeNameMapper;

    private MasterDataParser(INameTranslator nameTranslator) {
        this.nameTranslator = nameTranslator;
    }

    public static MasterDataParser create(INameTranslator nameTranslator) {
        if (nameTranslator == null) {
            return MasterDataParser.create();
        }
        return new MasterDataParser(nameTranslator);
    }

    public static MasterDataParser create() {
        return MasterDataParser.create(new DefaultNameTranslator());
    }

    public void parseMasterData(Document doc, XPath xpath, String uri) throws XPathExpressionException {
        XPathExpression expr = xpath.compile("//s:url/s:loc[normalize-space(.)='" + uri + "']//following-sibling::*[local-name() = 'masterData'][1]");
        Node xdNode = (Node)expr.evaluate(doc, XPathConstants.NODE);
        if (xdNode == null) {
            throw new XPathExpressionException("The master data resurce list should contain 1 master data element");
        }
        this.parseMasterDataElements((Element)xdNode);
    }

    private void parseMasterDataElements(Element docElement) throws XPathExpressionException {
        this.parseFileFormatTypes(docElement.getElementsByTagName("xmd:fileFormatTypes"));
        this.parseValidationPlugins(docElement.getElementsByTagName("xmd:validationPlugins"));
        this.vocabularyNameMapper = this.parseVocabularies(docElement.getElementsByTagName("xmd:controlledVocabularies"));
        this.propertyTypeNameMapper = this.parsePropertyTypes(docElement.getElementsByTagName("xmd:propertyTypes"));
        this.parseMaterialTypes(docElement.getElementsByTagName("xmd:materialTypes"));
        this.parseSampleTypes(docElement.getElementsByTagName("xmd:objectTypes"));
        this.parseDataSetTypes(docElement.getElementsByTagName("xmd:dataSetTypes"));
        this.parseExperimentTypes(docElement.getElementsByTagName("xmd:collectionTypes"));
        this.parseExternalDataManagementSystems(docElement.getElementsByTagName("xmd:externalDataManagementSystems"));
    }

    public Map<String, FileFormatType> getFileFormatTypes() {
        return this.fileFormatTypes;
    }

    public Map<String, Script> getValidationPlugins() {
        return this.validationPlugins;
    }

    public Map<String, NewVocabulary> getVocabularies() {
        return this.vocabularies;
    }

    public Map<String, PropertyType> getPropertyTypes() {
        return this.propertyTypes;
    }

    public MultiKeyMap<String, List<NewETPTAssignment>> getEntityPropertyAssignments() {
        return this.entityPropertyAssignments;
    }

    public Map<String, SampleType> getSampleTypes() {
        return this.sampleTypes;
    }

    public Map<String, DataSetType> getDataSetTypes() {
        return this.dataSetTypes;
    }

    public Map<String, ExperimentType> getExperimentTypes() {
        return this.experimentTypes;
    }

    public Map<String, MaterialType> getMaterialTypes() {
        return this.materialTypes;
    }

    public Map<String, ExternalDms> getExternalDataManagementSystems() {
        return this.externalDataManagementSystems;
    }

    public NameMapper getVocabularyNameMapper() {
        return this.vocabularyNameMapper;
    }

    public NameMapper getPropertyTypeNameMapper() {
        return this.propertyTypeNameMapper;
    }

    private void parseValidationPlugins(NodeList validationPluginsNode) throws XPathExpressionException {
        if (validationPluginsNode.getLength() == 0) {
            return;
        }
        this.validateElementNode(validationPluginsNode, "validationPlugins");
        Element validationPluginsElement = (Element)validationPluginsNode.item(0);
        NodeList pluginNodes = validationPluginsElement.getElementsByTagName("xmd:validationPlugin");
        for (int i = 0; i < pluginNodes.getLength(); ++i) {
            Element pluginElement = (Element)pluginNodes.item(i);
            Script plugin = new Script();
            plugin.setName(this.nameTranslator.translate(this.getAttribute(pluginElement, "name")));
            plugin.setDescription(this.getAttribute(pluginElement, "description"));
            String entityKind = this.getAttribute(pluginElement, "entityKind").trim();
            plugin.setScriptType(ScriptType.valueOf((String)this.getAttribute(pluginElement, "type")));
            plugin.setPluginType(PluginType.JYTHON);
            plugin.setRegistrationDate(DSPropertyUtils.convertFromW3CDate(this.getAttribute(pluginElement, "registration-timestamp")));
            plugin.setModificationDate(DSPropertyUtils.convertFromW3CDate(this.getAttribute(pluginElement, "modification-timestamp")));
            if (!entityKind.equals("") && !entityKind.equals("All")) {
                String[] splittedEntityKinds = entityKind.split(",");
                EntityKind[] entityKinds = new EntityKind[splittedEntityKinds.length];
                for (int j = 0; j < splittedEntityKinds.length; ++j) {
                    entityKinds[j] = EntityKind.valueOf((String)splittedEntityKinds[j].trim());
                }
                plugin.setEntityKind(entityKinds);
            }
            plugin.setScript(pluginElement.getTextContent());
            this.validationPlugins.put(plugin.getName(), plugin);
        }
    }

    private void parseExternalDataManagementSystems(NodeList edmsNode) throws XPathExpressionException {
        if (edmsNode.getLength() == 0) {
            return;
        }
        this.validateElementNode(edmsNode, "externalDataManagementSystems");
        NodeList edmsNodes = ((Element)edmsNode.item(0)).getElementsByTagName("xmd:externalDataManagementSystem");
        for (int i = 0; i < edmsNodes.getLength(); ++i) {
            Element element = (Element)edmsNodes.item(i);
            ExternalDms edms = new ExternalDms();
            String code = this.nameTranslator.translate(this.getAttribute(element, "code"));
            edms.setCode(code);
            edms.setPermId(new ExternalDmsPermId(code));
            edms.setLabel(this.getAttribute(element, "label"));
            edms.setAddressType(ExternalDmsAddressType.valueOf((String)this.getAttribute(element, "addressType")));
            edms.setAddress(this.getAttribute(element, "address"));
            this.externalDataManagementSystems.put(code, edms);
        }
    }

    private void parseFileFormatTypes(NodeList fileFormatTypesNode) throws XPathExpressionException {
        if (fileFormatTypesNode.getLength() == 0) {
            return;
        }
        this.validateElementNode(fileFormatTypesNode, "fileFormatTypes");
        Element fileFormatTypesElement = (Element)fileFormatTypesNode.item(0);
        NodeList fileFormatTypeNodes = fileFormatTypesElement.getElementsByTagName("xmd:fileFormatType");
        for (int i = 0; i < fileFormatTypeNodes.getLength(); ++i) {
            Element typeElement = (Element)fileFormatTypeNodes.item(i);
            FileFormatType type = new FileFormatType();
            String code = this.getAttribute(typeElement, "code");
            type.setCode(code);
            type.setDescription(this.getAttribute(typeElement, "description"));
            this.fileFormatTypes.put(code, type);
        }
    }

    private void validateElementNode(NodeList nodeList, String tagName) throws XPathExpressionException {
        if (nodeList.getLength() != 1) {
            throw new XPathExpressionException("Resource List should contain a single ' " + tagName + "' node");
        }
    }

    private NameMapper parseVocabularies(NodeList vocabulariesNode) throws XPathExpressionException {
        NameMapper nameMapper = new NameMapper(this.nameTranslator);
        if (vocabulariesNode.getLength() == 0) {
            return nameMapper;
        }
        this.validateElementNode(vocabulariesNode, "controlledVocabularies");
        Element vocabsElement = (Element)vocabulariesNode.item(0);
        NodeList vocabNodes = vocabsElement.getElementsByTagName("xmd:controlledVocabulary");
        for (int i = 0; i < vocabNodes.getLength(); ++i) {
            Element vocabElement = (Element)vocabNodes.item(i);
            Boolean managedInternally = Boolean.valueOf(this.getAttribute(vocabElement, "managedInternally"));
            String registratorId = this.getAttribute(vocabElement, "registrator");
            String code = this.nameTranslator.translate(nameMapper.registerName(this.getAttribute(vocabElement, "code"), managedInternally, registratorId));
            NewVocabulary newVocabulary = new NewVocabulary();
            newVocabulary.setCode(code);
            newVocabulary.setDescription(this.getAttribute(vocabElement, "description"));
            newVocabulary.setURLTemplate(this.getAttribute(vocabElement, "urlTemplate"));
            newVocabulary.setManagedInternally(managedInternally.booleanValue());
            newVocabulary.setChosenFromList(Boolean.valueOf(this.getAttribute(vocabElement, "chosenFromList")).booleanValue());
            newVocabulary.setRegistrationDate(DSPropertyUtils.convertFromW3CDate(this.getAttribute(vocabElement, "registration-timestamp")));
            Person registrator = new Person();
            registrator.setUserId(registratorId);
            newVocabulary.setRegistrator(registrator);
            newVocabulary.setModificationDate(DSPropertyUtils.convertFromW3CDate(this.getAttribute(vocabElement, "modification-timestamp")));
            this.vocabularies.put(CodeConverter.tryToBusinessLayer((String)newVocabulary.getCode(), (boolean)newVocabulary.isManagedInternally()), newVocabulary);
            this.parseVocabularyTerms(vocabElement, newVocabulary);
        }
        return nameMapper;
    }

    private void parseVocabularyTerms(Element vocabElement, NewVocabulary newVocabulary) {
        NodeList termNodes = vocabElement.getElementsByTagName("xmd:term");
        for (int i = 0; i < termNodes.getLength(); ++i) {
            Element termElement = (Element)termNodes.item(i);
            VocabularyTerm newVocabularyTerm = new VocabularyTerm();
            newVocabularyTerm.setCode(this.getAttribute(termElement, "code"));
            newVocabularyTerm.setLabel(this.getAttribute(termElement, "label"));
            newVocabularyTerm.setDescription(this.getAttribute(termElement, "description"));
            newVocabularyTerm.setOrdinal(Long.valueOf(this.getAttribute(termElement, "ordinal")));
            newVocabularyTerm.setUrl(this.getAttribute(termElement, "url"));
            newVocabularyTerm.setRegistrationDate(DSPropertyUtils.convertFromW3CDate(this.getAttribute(termElement, "registration-timestamp")));
            newVocabulary.getTerms().add(newVocabularyTerm);
        }
    }

    private String getAttribute(Element termElement, String attr) {
        Node node = termElement.getAttributes().getNamedItem(attr);
        return node != null ? node.getTextContent() : null;
    }

    private void parseMaterialTypes(NodeList matTypesNode) throws XPathExpressionException {
        if (matTypesNode.getLength() == 0) {
            return;
        }
        this.validateElementNode(matTypesNode, "materialTypes");
        Element matTypesElement = (Element)matTypesNode.item(0);
        NodeList matTypeNodes = matTypesElement.getElementsByTagName("xmd:materialType");
        for (int i = 0; i < matTypeNodes.getLength(); ++i) {
            Element materialTypeElement = (Element)matTypeNodes.item(i);
            MaterialType materialType = new MaterialType();
            materialType.setCode(this.nameTranslator.translate(this.getAttribute(materialTypeElement, "code")));
            materialType.setDescription(this.getAttribute(materialTypeElement, "description"));
            materialType.setValidationScript(this.getValidationPlugin(materialTypeElement));
            materialType.setModificationDate(DSPropertyUtils.convertFromW3CDate(this.getAttribute(materialTypeElement, "modification-timestamp")));
            this.materialTypes.put(materialType.getCode(), materialType);
            this.parsePropertyAssignments(EntityKind.MATERIAL, (EntityType)materialType, materialTypeElement, this.propertyTypeNameMapper);
        }
    }

    private void parseExperimentTypes(NodeList expTypesNode) throws XPathExpressionException {
        if (expTypesNode.getLength() == 0) {
            return;
        }
        this.validateElementNode(expTypesNode, "collectionTypes");
        Element expTypesElement = (Element)expTypesNode.item(0);
        NodeList expTypeNodes = expTypesElement.getElementsByTagName("xmd:collectionType");
        for (int i = 0; i < expTypeNodes.getLength(); ++i) {
            Element expTypeElement = (Element)expTypeNodes.item(i);
            ExperimentType expType = new ExperimentType();
            expType.setCode(this.nameTranslator.translate(this.getAttribute(expTypeElement, "code")));
            expType.setDescription(this.getAttribute(expTypeElement, "description"));
            expType.setModificationDate(DSPropertyUtils.convertFromW3CDate(this.getAttribute(expTypeElement, "modification-timestamp")));
            expType.setValidationScript(this.getValidationPlugin(expTypeElement));
            this.experimentTypes.put(expType.getCode(), expType);
            this.parsePropertyAssignments(EntityKind.EXPERIMENT, (EntityType)expType, expTypeElement, this.propertyTypeNameMapper);
        }
    }

    private void parseSampleTypes(NodeList sampleTypesNode) throws XPathExpressionException {
        if (sampleTypesNode.getLength() == 0) {
            return;
        }
        this.validateElementNode(sampleTypesNode, "objectTypes");
        Element sampleTypesElement = (Element)sampleTypesNode.item(0);
        NodeList sampleTypeNodes = sampleTypesElement.getElementsByTagName("xmd:objectType");
        for (int i = 0; i < sampleTypeNodes.getLength(); ++i) {
            Element sampleTypeElement = (Element)sampleTypeNodes.item(i);
            SampleType sampleType = new SampleType();
            sampleType.setCode(this.nameTranslator.translate(this.getAttribute(sampleTypeElement, "code")));
            sampleType.setDescription(this.getAttribute(sampleTypeElement, "description"));
            sampleType.setListable(Boolean.valueOf(this.getAttribute(sampleTypeElement, "listable")).booleanValue());
            sampleType.setShowContainer(Boolean.valueOf(this.getAttribute(sampleTypeElement, "showContainer")).booleanValue());
            sampleType.setShowParents(Boolean.valueOf(this.getAttribute(sampleTypeElement, "showParents")).booleanValue());
            sampleType.setShowParentMetadata(Boolean.valueOf(this.getAttribute(sampleTypeElement, "showParentMetadata")).booleanValue());
            sampleType.setSubcodeUnique(Boolean.valueOf(this.getAttribute(sampleTypeElement, "subcodeUnique")).booleanValue());
            sampleType.setAutoGeneratedCode(Boolean.valueOf(this.getAttribute(sampleTypeElement, "autoGeneratedCode")).booleanValue());
            sampleType.setGeneratedCodePrefix(this.getAttribute(sampleTypeElement, "generatedCodePrefix"));
            sampleType.setModificationDate(DSPropertyUtils.convertFromW3CDate(this.getAttribute(sampleTypeElement, "modification-timestamp")));
            sampleType.setValidationScript(this.getValidationPlugin(sampleTypeElement));
            this.sampleTypes.put(sampleType.getCode(), sampleType);
            this.parsePropertyAssignments(EntityKind.SAMPLE, (EntityType)sampleType, sampleTypeElement, this.propertyTypeNameMapper);
        }
    }

    private void parseDataSetTypes(NodeList dataSetTypesNode) throws XPathExpressionException {
        if (dataSetTypesNode.getLength() == 0) {
            return;
        }
        this.validateElementNode(dataSetTypesNode, "dataSetTypes");
        Element dataSetTypesElement = (Element)dataSetTypesNode.item(0);
        NodeList dataSetTypeNodes = dataSetTypesElement.getElementsByTagName("xmd:dataSetType");
        for (int i = 0; i < dataSetTypeNodes.getLength(); ++i) {
            String mainDataSetPath;
            Element dataSetTypeElement = (Element)dataSetTypeNodes.item(i);
            DataSetType dataSetType = new DataSetType();
            dataSetType.setCode(this.nameTranslator.translate(this.getAttribute(dataSetTypeElement, "code")));
            dataSetType.setDescription(this.getAttribute(dataSetTypeElement, "description"));
            String mainDataSetPattern = this.getAttribute(dataSetTypeElement, "mainDataSetPattern");
            if (StringUtils.isNotBlank((CharSequence)mainDataSetPattern)) {
                dataSetType.setMainDataSetPattern(mainDataSetPattern);
            }
            if (StringUtils.isNotBlank((CharSequence)(mainDataSetPath = this.getAttribute(dataSetTypeElement, "mainDataSetPath")))) {
                dataSetType.setMainDataSetPath(mainDataSetPath);
            }
            dataSetType.setDeletionDisallow(Boolean.valueOf(this.getAttribute(dataSetTypeElement, "deletionDisallowed")).booleanValue());
            dataSetType.setModificationDate(DSPropertyUtils.convertFromW3CDate(this.getAttribute(dataSetTypeElement, "modification-timestamp")));
            dataSetType.setValidationScript(this.getValidationPlugin(dataSetTypeElement));
            this.dataSetTypes.put(dataSetType.getCode(), dataSetType);
            this.parsePropertyAssignments(EntityKind.DATA_SET, (EntityType)dataSetType, dataSetTypeElement, this.propertyTypeNameMapper);
        }
    }

    private Script getValidationPlugin(Element element) {
        String name = this.getAttribute(element, "validationPlugin");
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        return this.validationPlugins.get(this.nameTranslator.translate(name));
    }

    private void parsePropertyAssignments(EntityKind entityKind, EntityType entityType, Element entityTypeElement, NameMapper propertyTypeNameMapper) throws XPathExpressionException {
        NodeList propertyAssignmentsNode = entityTypeElement.getElementsByTagName("xmd:propertyAssignments");
        if (propertyAssignmentsNode.getLength() == 0) {
            return;
        }
        this.validateElementNode(propertyAssignmentsNode, "propertyAssignments");
        ArrayList<NewETPTAssignment> list = new ArrayList<NewETPTAssignment>();
        Element propertyAssignmentsElement = (Element)propertyAssignmentsNode.item(0);
        NodeList propertyAssignmentNodes = propertyAssignmentsElement.getElementsByTagName("xmd:propertyAssignment");
        for (int i = 0; i < propertyAssignmentNodes.getLength(); ++i) {
            Element propertyAssignmentElement = (Element)propertyAssignmentNodes.item(i);
            String propertyTypeCode = this.getAttribute(propertyAssignmentElement, "propertyTypeCode");
            NewETPTAssignment assignment = new NewETPTAssignment();
            assignment.setPropertyTypeCode(propertyTypeNameMapper.getHarvesterName(propertyTypeCode));
            assignment.setEntityKind(entityType.getEntityKind());
            assignment.setEntityTypeCode(entityType.getCode());
            assignment.setMandatory(Boolean.valueOf(this.getAttribute(propertyAssignmentElement, "mandatory")).booleanValue());
            assignment.setSection(this.getAttribute(propertyAssignmentElement, "section"));
            assignment.setOrdinal(Long.valueOf(Long.valueOf(this.getAttribute(propertyAssignmentElement, "ordinal")) - 1L));
            assignment.setShownInEditView(Boolean.valueOf(this.getAttribute(propertyAssignmentElement, "showInEdit")).booleanValue());
            assignment.setModificationDate(DSPropertyUtils.convertFromW3CDate(this.getAttribute(propertyAssignmentElement, "registration-timestamp")));
            String pluginId = this.getAttribute(propertyAssignmentElement, "plugin");
            if (pluginId != null) {
                assignment.setScriptName(this.nameTranslator.translate(pluginId));
                String pluginType = this.getAttribute(propertyAssignmentElement, "pluginType");
                assignment.setDynamic(ch.ethz.sis.openbis.generic.asapi.v3.dto.plugin.PluginType.DYNAMIC_PROPERTY.toString().equals(pluginType));
                assignment.setManaged(ch.ethz.sis.openbis.generic.asapi.v3.dto.plugin.PluginType.MANAGED_PROPERTY.toString().equals(pluginType));
            }
            list.add(assignment);
        }
        Collections.sort(list, ASSIGNMENT_COMPARATOR_BY_ORDINAL);
        this.entityPropertyAssignments.put((Object)entityType.getEntityKind().name(), (Object)entityType.getCode(), list);
    }

    private NameMapper parsePropertyTypes(NodeList propertyTypesNode) throws XPathExpressionException {
        NameMapper nameMapper = new NameMapper(this.nameTranslator);
        if (propertyTypesNode.getLength() == 0) {
            return nameMapper;
        }
        this.validateElementNode(propertyTypesNode, "propertyTypes");
        Element propertyTypesElement = (Element)propertyTypesNode.item(0);
        NodeList propertyTypeNodes = propertyTypesElement.getElementsByTagName("xmd:propertyType");
        for (int i = 0; i < propertyTypeNodes.getLength(); ++i) {
            Element propertyTypeElement = (Element)propertyTypeNodes.item(i);
            PropertyType newPropertyType = new PropertyType();
            Boolean managedInternally = Boolean.valueOf(this.getAttribute(propertyTypeElement, "managedInternally"));
            String registratorId = this.getAttribute(propertyTypeElement, "registrator");
            String code = this.nameTranslator.translate(nameMapper.registerName(this.getAttribute(propertyTypeElement, "code"), managedInternally, registratorId));
            newPropertyType.setCode(code);
            newPropertyType.setLabel(this.getAttribute(propertyTypeElement, "label"));
            DataTypeCode dataTypeCode = DataTypeCode.valueOf((String)this.getAttribute(propertyTypeElement, "dataType"));
            newPropertyType.setDataType(new DataType(dataTypeCode));
            newPropertyType.setDescription(this.getAttribute(propertyTypeElement, "description"));
            newPropertyType.setManagedInternally(managedInternally.booleanValue());
            Person registrator = new Person();
            registrator.setUserId(registratorId);
            newPropertyType.setRegistrator(registrator);
            newPropertyType.setModificationDate(DSPropertyUtils.convertFromW3CDate(this.getAttribute(propertyTypeElement, "registration-timestamp")));
            this.propertyTypes.put(CodeConverter.tryToBusinessLayer((String)newPropertyType.getCode(), (boolean)managedInternally), newPropertyType);
            if (dataTypeCode.equals((Object)DataTypeCode.CONTROLLEDVOCABULARY)) {
                String vocabularyCode = this.vocabularyNameMapper.getHarvesterName(this.getAttribute(propertyTypeElement, "vocabulary"));
                NewVocabulary vocabulary = new NewVocabulary();
                vocabulary.setInternalNamespace(CodeConverter.isInternalNamespace((String)vocabularyCode));
                vocabulary.setCode(CodeConverter.tryToDatabase((String)vocabularyCode));
                newPropertyType.setVocabulary((Vocabulary)vocabulary);
                continue;
            }
            if (!dataTypeCode.equals((Object)DataTypeCode.MATERIAL)) continue;
            String materialCode = this.getAttribute(propertyTypeElement, "material");
            if (StringUtils.isBlank((CharSequence)materialCode)) {
                newPropertyType.setMaterialType(null);
                continue;
            }
            MaterialType materialType = new MaterialType();
            materialType.setCode(this.nameTranslator.translate(materialCode));
            newPropertyType.setMaterialType(materialType);
        }
        return nameMapper;
    }
}

