/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer;

import ch.ethz.sis.openbis.generic.asapi.v3.IApplicationServerApi;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.externaldms.ExternalDms;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.externaldms.create.ExternalDmsCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.externaldms.fetchoptions.ExternalDmsFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.externaldms.id.ExternalDmsPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.externaldms.id.IExternalDmsId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.externaldms.update.ExternalDmsUpdate;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.common.ServiceFinderUtils;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.config.SyncConfig;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.ISynchronizerFacade;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.MasterData;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.SynchronizerFacade;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.translator.INameTranslator;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.util.Monitor;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeConverter;
import ch.systemsx.cisd.openbis.generic.shared.basic.ICodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.FileFormatType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewETPTAssignment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewVocabulary;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Script;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ScriptType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.Diff;
import org.apache.commons.lang3.builder.DiffBuilder;
import org.apache.commons.lang3.builder.DiffResult;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.log4j.Logger;

public class MasterDataSynchronizer {
    private final ISynchronizerFacade synchronizerFacade;
    private final ICommonServer commonServer;
    private final String sessionToken;
    private final IApplicationServerApi v3api;
    private final SyncConfig config;
    private final StringWriter errors = new StringWriter();
    private final PrintWriter errorsOut = new PrintWriter(this.errors);

    public MasterDataSynchronizer(SyncConfig config, Logger operationLog) {
        this(config, new SynchronizerFacade(ServiceProvider.getConfigProvider().getOpenBisServerUrl(), config.getHarvesterUser(), config.getHarvesterPass(), config.isDryRun(), config.isVerbose(), operationLog), ServiceFinderUtils.getCommonServer(ServiceProvider.getConfigProvider().getOpenBisServerUrl()), ServiceProvider.getV3ApplicationService());
    }

    MasterDataSynchronizer(SyncConfig config, ISynchronizerFacade synchronizerFacade, ICommonServer commonServer, IApplicationServerApi v3api) {
        this.config = config;
        this.synchronizerFacade = synchronizerFacade;
        this.commonServer = commonServer;
        this.sessionToken = ServiceFinderUtils.login(commonServer, config.getHarvesterUser(), config.getHarvesterPass());
        this.v3api = v3api;
    }

    public void synchronizeMasterData(MasterData masterData, Monitor monitor) {
        MultiKeyMap<String, List<NewETPTAssignment>> propertyAssignmentsToProcess = masterData.getPropertyAssignmentsToProcess();
        monitor.log("process file format types");
        this.processFileFormatTypes(masterData.getFileFormatTypesToProcess());
        monitor.log("process validation plugins");
        this.processValidationPlugins(masterData.getValidationPluginsToProcess());
        monitor.log("process vocabularies");
        this.processVocabularies(masterData.getVocabulariesToProcess(), masterData.getNameTranslator());
        monitor.log("process material types");
        this.processEntityTypes(masterData.getMaterialTypesToProcess(), propertyAssignmentsToProcess);
        monitor.log("process property types");
        this.processPropertyTypes(masterData.getPropertyTypesToProcess(), masterData.getNameTranslator());
        monitor.log("process sample types");
        this.processEntityTypes(masterData.getSampleTypesToProcess(), propertyAssignmentsToProcess);
        monitor.log("process data set types");
        this.processEntityTypes(masterData.getDataSetTypesToProcess(), propertyAssignmentsToProcess);
        monitor.log("process experiment types");
        this.processEntityTypes(masterData.getExperimentTypesToProcess(), propertyAssignmentsToProcess);
        monitor.log("process material type property assignments");
        this.processDeferredMaterialTypePropertyAssignments(propertyAssignmentsToProcess);
        monitor.log("process external data management systems");
        this.processExternalDataManagementSystems(masterData.getExternalDataManagementSystemsToProcess());
        this.synchronizerFacade.printSummary();
        if (this.errors.toString().length() > 0) {
            throw new RuntimeException("Master data can not be synchronization because of the following reasons:\n" + this.errors);
        }
    }

    private void processDeferredMaterialTypePropertyAssignments(MultiKeyMap<String, List<NewETPTAssignment>> propertyAssignmentsToProcess) {
        List<? extends EntityType> existingEntityTypes = this.getExistingEntityTypes(EntityKind.MATERIAL);
        for (EntityType entityType : existingEntityTypes) {
            List list = (List)propertyAssignmentsToProcess.get((Object)EntityKind.MATERIAL.name(), (Object)entityType.getCode());
            if (list == null) continue;
            this.processPropertyAssignments(entityType, list);
        }
    }

    private void processValidationPlugins(Map<String, Script> pluginsToProcess) {
        List existingPlugins = this.commonServer.listScripts(this.sessionToken, null, null);
        HashMap<String, Script> pluginMap = new HashMap<String, Script>();
        for (Script type : existingPlugins) {
            pluginMap.put(type.getName(), type);
        }
        for (String name : pluginsToProcess.keySet()) {
            Script incomingplugin = pluginsToProcess.get(name);
            Script existingPluginOrNull = (Script)pluginMap.get(name);
            if (existingPluginOrNull != null) {
                String diff = this.calculateDiff(existingPluginOrNull, incomingplugin);
                if (!StringUtils.isNotBlank((CharSequence)diff) || !this.config.isMasterDataUpdateAllowed()) continue;
                incomingplugin.setModificationDate(existingPluginOrNull.getModificationDate());
                incomingplugin.setId(existingPluginOrNull.getId());
                this.synchronizerFacade.updateValidationPlugin(incomingplugin, diff);
                continue;
            }
            this.synchronizerFacade.registerValidationPlugin(incomingplugin);
        }
    }

    private String calculateDiff(Script existingPlugin, Script incomingPlugin) {
        String incomingScript;
        DiffBuilder diffBuilder = new DiffBuilder((Object)existingPlugin, (Object)incomingPlugin, ToStringStyle.SHORT_PREFIX_STYLE, false).append("description", (Object)existingPlugin.getDescription(), (Object)incomingPlugin.getDescription());
        String existingScript = existingPlugin.getScript();
        int indexOfDifference = StringUtils.indexOfDifference((CharSequence)existingScript, (CharSequence)(incomingScript = incomingPlugin.getScript()));
        if (indexOfDifference >= 0) {
            String existingSnippet = StringUtils.left((String)existingScript.substring(indexOfDifference), (int)20);
            String incommingSnippet = StringUtils.left((String)incomingScript.substring(indexOfDifference), (int)20);
            diffBuilder.append("script", (Object)existingSnippet, (Object)incommingSnippet);
        }
        return MasterDataSynchronizer.render(diffBuilder.build(), existingPlugin, incomingPlugin);
    }

    private void processExternalDataManagementSystems(Map<String, ExternalDms> externalDataManagementSystems) {
        List ids = externalDataManagementSystems.keySet().stream().map(ExternalDmsPermId::new).collect(Collectors.toList());
        Map existingDmss = this.v3api.getExternalDataManagementSystems(this.sessionToken, ids, new ExternalDmsFetchOptions());
        ArrayList<ExternalDmsCreation> creations = new ArrayList<ExternalDmsCreation>();
        ArrayList<ExternalDmsUpdate> updates = new ArrayList<ExternalDmsUpdate>();
        for (ExternalDms externalDms : externalDataManagementSystems.values()) {
            if (existingDmss.containsKey(externalDms.getPermId())) {
                ExternalDmsUpdate update = new ExternalDmsUpdate();
                update.setExternalDmsId((IExternalDmsId)externalDms.getPermId());
                update.setAddress(externalDms.getAddress());
                update.setLabel(externalDms.getLabel());
                updates.add(update);
                continue;
            }
            ExternalDmsCreation creation = new ExternalDmsCreation();
            creation.setCode(externalDms.getCode());
            creation.setLabel(externalDms.getLabel());
            creation.setAddress(externalDms.getAddress());
            creation.setAddressType(externalDms.getAddressType());
            creations.add(creation);
        }
        if (!creations.isEmpty()) {
            this.synchronizerFacade.createExternalDataManagementSystems(creations);
        }
        if (!updates.isEmpty()) {
            this.synchronizerFacade.updateExternalDataManagementSystems(updates);
        }
    }

    private void processFileFormatTypes(Map<String, FileFormatType> fileFormatTypesToProcess) {
        List fileFormatTypes = this.commonServer.listFileFormatTypes(this.sessionToken);
        HashMap<String, FileFormatType> typeMap = new HashMap<String, FileFormatType>();
        for (FileFormatType type : fileFormatTypes) {
            typeMap.put(type.getCode(), type);
        }
        for (String typeCode : fileFormatTypesToProcess.keySet()) {
            FileFormatType incomingType = fileFormatTypesToProcess.get(typeCode);
            FileFormatType existingTypeOrNull = (FileFormatType)typeMap.get(typeCode);
            if (existingTypeOrNull != null) {
                if (StringUtils.equals((CharSequence)existingTypeOrNull.getDescription(), (CharSequence)incomingType.getDescription())) continue;
                existingTypeOrNull.setDescription(incomingType.getDescription());
                this.synchronizerFacade.updateFileFormatType((AbstractType)existingTypeOrNull);
                continue;
            }
            this.synchronizerFacade.registerFileFormatType(incomingType);
        }
    }

    private void processVocabularies(Map<String, NewVocabulary> vocabulariesToProcess, INameTranslator nameTranslator) {
        List existingVocabularies = this.commonServer.listVocabularies(this.sessionToken, true, false);
        HashMap<String, Vocabulary> existingVocabularyMap = new HashMap<String, Vocabulary>();
        for (Vocabulary vocabulary : existingVocabularies) {
            existingVocabularyMap.put(vocabulary.getCode(), vocabulary);
        }
        for (NewVocabulary newVocabulary : vocabulariesToProcess.values()) {
            boolean newIsInternal = this.isInternallyManagedBySystem((Vocabulary)newVocabulary);
            Vocabulary existingVocabulary = this.getExisting(existingVocabularyMap, newVocabulary, nameTranslator);
            if (existingVocabulary != null) {
                boolean existingIsInternal = this.isInternallyManagedBySystem(existingVocabulary);
                String diff = this.calculateDiff(existingVocabulary, newVocabulary);
                if (StringUtils.isNotBlank((CharSequence)diff) && this.config.isMasterDataUpdateAllowed() && !existingIsInternal) {
                    newVocabulary.setModificationDate(existingVocabulary.getModificationDate());
                    newVocabulary.setId(existingVocabulary.getId());
                    this.synchronizerFacade.updateVocabulary((Vocabulary)newVocabulary, diff);
                }
                this.processVocabularyTerms(this.sessionToken, this.commonServer, newVocabulary, existingVocabulary);
                continue;
            }
            if (newIsInternal) {
                this.errorsOut.println("There is no internal vocabulary " + this.getCode(newVocabulary, nameTranslator) + ".");
                continue;
            }
            newVocabulary.setManagedInternally(false);
            this.synchronizerFacade.registerVocabulary(newVocabulary);
        }
    }

    private Vocabulary getExisting(Map<String, Vocabulary> existingVocabularyMap, NewVocabulary newVocabulary, INameTranslator nameTranslator) {
        return existingVocabularyMap.get(this.getCode(newVocabulary, nameTranslator));
    }

    private String getCode(NewVocabulary newVocabulary, INameTranslator nameTranslator) {
        String originalCode = newVocabulary.getCode();
        boolean internal = this.isInternallyManagedBySystem((Vocabulary)newVocabulary);
        if (internal) {
            originalCode = nameTranslator.translateBack(originalCode);
        }
        return CodeConverter.tryToBusinessLayer((String)originalCode, (boolean)internal);
    }

    private boolean isInternallyManagedBySystem(Vocabulary vocabulary) {
        return vocabulary.isManagedInternally() && this.isSystem(vocabulary.getRegistrator().getUserId());
    }

    private boolean isSystem(String userId) {
        return "system".equals(userId);
    }

    private String calculateDiff(Vocabulary existingVocabulary, NewVocabulary newVocabulary) {
        DiffBuilder diffBuilder = new DiffBuilder((Object)existingVocabulary, (Object)newVocabulary, ToStringStyle.SHORT_PREFIX_STYLE, false).append("description", (Object)existingVocabulary.getDescription(), (Object)newVocabulary.getDescription()).append("urlTemplate", (Object)existingVocabulary.getURLTemplate(), (Object)newVocabulary.getURLTemplate()).append("managedInternally", existingVocabulary.isManagedInternally(), newVocabulary.isManagedInternally()).append("chosenFromList", existingVocabulary.isChosenFromList(), newVocabulary.isChosenFromList());
        DiffResult diffResult = diffBuilder.build();
        return MasterDataSynchronizer.render(diffResult, existingVocabulary, newVocabulary);
    }

    private void processVocabularyTerms(String sessionToken, ICommonServer commonServer, NewVocabulary newVocabulary, Vocabulary existingVocabulary) {
        Map<String, VocabularyTerm> existingTerms = this.getTermsByCode(existingVocabulary);
        ArrayList<VocabularyTerm> termsToBeAdded = new ArrayList<VocabularyTerm>();
        for (VocabularyTerm incomingTerm : newVocabulary.getTerms()) {
            VocabularyTerm existingTerm = existingTerms.get(incomingTerm.getCode());
            if (existingTerm == null) {
                termsToBeAdded.add(incomingTerm);
                continue;
            }
            String diff = this.calculateDiff(existingTerm, incomingTerm);
            if (!StringUtils.isNotBlank((CharSequence)diff) || !this.config.isMasterDataUpdateAllowed() || this.isInternallyManagedBySystem(existingVocabulary)) continue;
            incomingTerm.setModificationDate(existingTerm.getModificationDate());
            incomingTerm.setId(existingTerm.getId());
            this.synchronizerFacade.updateVocabularyTerm(existingVocabulary.getCode(), incomingTerm, diff);
        }
        this.synchronizerFacade.addVocabularyTerms(existingVocabulary.getCode(), new TechId(existingVocabulary.getId()), termsToBeAdded);
    }

    private String calculateDiff(VocabularyTerm existingTerm, VocabularyTerm incomingTerm) {
        DiffBuilder diffBuilder = new DiffBuilder((Object)existingTerm, (Object)incomingTerm, ToStringStyle.SHORT_PREFIX_STYLE, false).append("label", (Object)existingTerm.getLabel(), (Object)incomingTerm.getLabel()).append("description", (Object)existingTerm.getDescription(), (Object)incomingTerm.getDescription()).append("url", (Object)existingTerm.getUrl(), (Object)incomingTerm.getUrl());
        DiffResult diffResult = diffBuilder.build();
        return MasterDataSynchronizer.render(diffResult, existingTerm, incomingTerm);
    }

    private Map<String, VocabularyTerm> getTermsByCode(Vocabulary vocabulary) {
        TreeMap<String, VocabularyTerm> result = new TreeMap<String, VocabularyTerm>();
        for (VocabularyTerm vocabularyTerm : vocabulary.getTerms()) {
            result.put(vocabularyTerm.getCode(), vocabularyTerm);
        }
        return result;
    }

    private void processEntityTypes(Map<String, ? extends EntityType> entityTypesToProcess, MultiKeyMap<String, List<NewETPTAssignment>> propertyAssignmentsToProcess) {
        if (entityTypesToProcess.keySet().size() == 0) {
            return;
        }
        EntityKind entityKind = ((EntityType)entityTypesToProcess.values().toArray()[0]).getEntityKind();
        List<? extends EntityType> existingEntityTypes = this.getExistingEntityTypes(entityKind);
        HashMap<String, EntityType> existingEntityTypesMap = new HashMap<String, EntityType>();
        for (EntityType entityType : existingEntityTypes) {
            existingEntityTypesMap.put(entityType.getCode(), entityType);
        }
        for (String string : entityTypesToProcess.keySet()) {
            EntityType existingEntityType = (EntityType)existingEntityTypesMap.get(string);
            EntityType incomingEntityType = entityTypesToProcess.get(string);
            List list = (List)propertyAssignmentsToProcess.get((Object)entityKind.name(), (Object)string);
            if (existingEntityType != null) {
                String diff = this.calculateDiff(entityKind, existingEntityType, incomingEntityType);
                if (StringUtils.isNotBlank((CharSequence)diff) && this.config.isMasterDataUpdateAllowed()) {
                    incomingEntityType.setModificationDate(existingEntityType.getModificationDate());
                    this.updateEntityType(entityKind, incomingEntityType, diff);
                }
                if (list == null || entityKind == EntityKind.MATERIAL) continue;
                this.processPropertyAssignments(existingEntityType, list);
                continue;
            }
            this.registerEntityType(entityKind, incomingEntityType);
            if (list == null || entityKind == EntityKind.MATERIAL) continue;
            this.assignProperties(list);
        }
    }

    private void assignProperties(List<NewETPTAssignment> list) {
        for (NewETPTAssignment newETPTAssignment : list) {
            this.synchronizerFacade.assignPropertyType(newETPTAssignment);
        }
    }

    private void processPropertyAssignments(EntityType existingEntityType, List<NewETPTAssignment> incomingAssignmentsList) {
        assert (incomingAssignmentsList != null) : "Null assignments list";
        List assignedPropertyTypes = existingEntityType.getAssignedPropertyTypes();
        for (NewETPTAssignment newETPTAssignment : incomingAssignmentsList) {
            EntityTypePropertyType foundType = this.findInExistingPropertyAssignments(newETPTAssignment, assignedPropertyTypes);
            if (foundType != null) {
                String diff = this.calculateDiff(foundType, newETPTAssignment);
                if (!StringUtils.isNotBlank((CharSequence)diff) || !this.config.isMasterDataUpdateAllowed()) continue;
                newETPTAssignment.setModificationDate(foundType.getModificationDate());
                this.synchronizerFacade.updatePropertyTypeAssignment(newETPTAssignment, diff);
                continue;
            }
            this.synchronizerFacade.assignPropertyType(newETPTAssignment);
        }
        if (this.config.isPropertyUnassignmentAllowed()) {
            for (EntityTypePropertyType etpt : assignedPropertyTypes) {
                if (this.findInIncomingPropertyAssignments(etpt, incomingAssignmentsList)) continue;
                this.synchronizerFacade.unassignPropertyType(existingEntityType.getEntityKind(), etpt.getPropertyType().getCode(), etpt.getEntityType().getCode());
            }
        }
    }

    private String calculateDiff(EntityTypePropertyType existingAssignment, NewETPTAssignment incomingAssignment) {
        ScriptType existingPluginType;
        DiffBuilder diffBuilder = new DiffBuilder((Object)existingAssignment, (Object)incomingAssignment, ToStringStyle.SHORT_PREFIX_STYLE, false).append("mandatory", existingAssignment.isMandatory(), incomingAssignment.isMandatory()).append("section", (Object)existingAssignment.getSection(), (Object)incomingAssignment.getSection()).append("ordinal", (Object)new Long(existingAssignment.getOrdinal() - 1L), (Object)incomingAssignment.getOrdinal()).append("showInEdit", existingAssignment.isShownInEditView(), incomingAssignment.isDynamic() ? false : incomingAssignment.isShownInEditView()).append("plugin", (Object)this.getPluginName(existingAssignment.getScript()), (Object)incomingAssignment.getScriptName());
        Script plugin = existingAssignment.getScript();
        ScriptType scriptType = existingPluginType = plugin == null ? null : plugin.getScriptType();
        ScriptType incomingPluginType = incomingAssignment.isDynamic() ? ScriptType.DYNAMIC_PROPERTY : (incomingAssignment.isManaged() ? ScriptType.MANAGED_PROPERTY : null);
        diffBuilder.append("pluginType", (Object)existingPluginType, (Object)incomingPluginType);
        DiffResult diffResult = diffBuilder.build();
        return MasterDataSynchronizer.render(diffResult, existingAssignment, incomingAssignment);
    }

    private boolean findInIncomingPropertyAssignments(EntityTypePropertyType existingEtpt, List<NewETPTAssignment> incomingAssignmentsList) {
        for (NewETPTAssignment newETPTAssignment : incomingAssignmentsList) {
            if (!newETPTAssignment.getPropertyTypeCode().equals(existingEtpt.getPropertyType().getCode())) continue;
            return true;
        }
        return false;
    }

    private EntityTypePropertyType findInExistingPropertyAssignments(NewETPTAssignment incomingETPTAssignment, List<? extends EntityTypePropertyType> assignedPropertyTypes) {
        for (EntityTypePropertyType entityTypePropertyType : assignedPropertyTypes) {
            if (!entityTypePropertyType.getPropertyType().getCode().equals(incomingETPTAssignment.getPropertyTypeCode())) continue;
            return entityTypePropertyType;
        }
        return null;
    }

    private void registerEntityType(EntityKind entityKind, EntityType incomingEntityType) {
        switch (entityKind) {
            case SAMPLE: {
                this.synchronizerFacade.registerSampleType((SampleType)incomingEntityType);
                break;
            }
            case DATA_SET: {
                this.synchronizerFacade.registerDataSetType((DataSetType)incomingEntityType);
                break;
            }
            case EXPERIMENT: {
                this.synchronizerFacade.registerExperimentType((ExperimentType)incomingEntityType);
                break;
            }
            case MATERIAL: {
                this.synchronizerFacade.registerMaterialType((MaterialType)incomingEntityType);
                break;
            }
            default: {
                throw new UserFailureException("register not implemented for entity kind: " + entityKind.name());
            }
        }
    }

    private void updateEntityType(EntityKind entityKind, EntityType incomingEntityType, String diff) {
        switch (entityKind) {
            case SAMPLE: {
                this.synchronizerFacade.updateSampleType(incomingEntityType, diff);
                break;
            }
            case DATA_SET: {
                this.synchronizerFacade.updateDataSetType(incomingEntityType, diff);
                break;
            }
            case EXPERIMENT: {
                this.synchronizerFacade.updateExperimentType(incomingEntityType, diff);
                break;
            }
            case MATERIAL: {
                this.synchronizerFacade.updateMaterialType(incomingEntityType, diff);
                break;
            }
            default: {
                throw new UserFailureException("update not implemented for entity kind: " + entityKind.name());
            }
        }
    }

    private String calculateDiff(EntityKind entityKind, EntityType existingEntityType, EntityType incomingEntityType) {
        DiffBuilder diffBuilder = new DiffBuilder((Object)existingEntityType, (Object)incomingEntityType, ToStringStyle.SHORT_PREFIX_STYLE, false).append("description", (Object)existingEntityType.getDescription(), (Object)incomingEntityType.getDescription()).append("validationPlugin", (Object)this.getPluginName(existingEntityType), (Object)this.getPluginName(incomingEntityType));
        switch (entityKind) {
            case SAMPLE: {
                this.appendToDiffBuilder(diffBuilder, (SampleType)existingEntityType, (SampleType)incomingEntityType);
                break;
            }
            case DATA_SET: {
                this.appendToDiffBuilder(diffBuilder, (DataSetType)existingEntityType, (DataSetType)incomingEntityType);
                break;
            }
            case EXPERIMENT: {
                this.appendToDiffBuilder(diffBuilder, (ExperimentType)existingEntityType, (ExperimentType)incomingEntityType);
                break;
            }
            case MATERIAL: {
                this.appendToDiffBuilder(diffBuilder, (MaterialType)existingEntityType, (MaterialType)incomingEntityType);
                break;
            }
            default: {
                throw new UserFailureException("update not implemented for entity kind: " + entityKind.name());
            }
        }
        DiffResult diffResult = diffBuilder.build();
        return MasterDataSynchronizer.render(diffResult, existingEntityType, incomingEntityType);
    }

    private String getPluginName(EntityType entityType) {
        return this.getPluginName(entityType.getValidationScript());
    }

    private String getPluginName(Script plugin) {
        return plugin == null ? null : plugin.getName();
    }

    private static String render(DiffResult<?> diffResult, Object existing, Object incoming) {
        List diffs = diffResult.getDiffs();
        if (diffs.isEmpty()) {
            return "";
        }
        ToStringBuilder builderExisting = new ToStringBuilder(existing, diffResult.getToStringStyle());
        ToStringBuilder builderIncoming = new ToStringBuilder(incoming, diffResult.getToStringStyle());
        for (Diff diff : diffs) {
            builderExisting.append(diff.getFieldName(), diff.getLeft());
            builderIncoming.append(diff.getFieldName(), diff.getRight());
        }
        return "incoming " + builderIncoming.build() + " differs from existing " + builderExisting.build();
    }

    private void appendToDiffBuilder(DiffBuilder<?> diffBuilder, SampleType existingType, SampleType incomingType) {
        diffBuilder.append("generatedCodePrefix", (Object)existingType.getGeneratedCodePrefix(), (Object)incomingType.getGeneratedCodePrefix()).append("listable", existingType.isListable(), incomingType.isListable()).append("showContainer", existingType.isShowContainer(), incomingType.isShowContainer()).append("showParents", existingType.isShowParents(), incomingType.isShowParents()).append("showParentMetadata", existingType.isShowParentMetadata(), incomingType.isShowParentMetadata()).append("subcodeUnique", existingType.isSubcodeUnique(), incomingType.isSubcodeUnique()).append("autoGeneratedCode", existingType.isAutoGeneratedCode(), incomingType.isAutoGeneratedCode());
    }

    private void appendToDiffBuilder(DiffBuilder<?> diffBuilder, DataSetType existingType, DataSetType incomingType) {
        diffBuilder.append("mainDataSetPattern", (Object)existingType.getMainDataSetPattern(), (Object)incomingType.getMainDataSetPattern()).append("mainDataSetPath", (Object)existingType.getMainDataSetPath(), (Object)incomingType.getMainDataSetPath());
    }

    private void appendToDiffBuilder(DiffBuilder<?> diffBuilder, ExperimentType existingType, ExperimentType incomingType) {
    }

    private void appendToDiffBuilder(DiffBuilder<?> diffBuilder, MaterialType existingType, MaterialType incomingType) {
    }

    private List<? extends EntityType> getExistingEntityTypes(EntityKind entityKind) {
        switch (entityKind) {
            case SAMPLE: {
                return this.commonServer.listSampleTypes(this.sessionToken);
            }
            case DATA_SET: {
                return this.commonServer.listDataSetTypes(this.sessionToken);
            }
            case EXPERIMENT: {
                return this.commonServer.listExperimentTypes(this.sessionToken);
            }
            case MATERIAL: {
                return this.commonServer.listMaterialTypes(this.sessionToken);
            }
        }
        return null;
    }

    private void processPropertyTypes(Map<String, PropertyType> propertyTypesToProcess, INameTranslator nameTranslator) {
        List propertyTypes = this.commonServer.listPropertyTypes(this.sessionToken, false);
        HashMap<String, PropertyType> propertyTypeMap = new HashMap<String, PropertyType>();
        for (PropertyType propertyType : propertyTypes) {
            propertyTypeMap.put(propertyType.getCode(), propertyType);
        }
        for (PropertyType incomingPropertyType : propertyTypesToProcess.values()) {
            boolean incomingIsInternal = this.isInternallyManagedBySystem(incomingPropertyType);
            PropertyType existingPropertyType = this.getExisting(propertyTypeMap, incomingPropertyType, nameTranslator);
            if (existingPropertyType != null) {
                boolean existentIsInternal = this.isInternallyManagedBySystem(existingPropertyType);
                if (!existentIsInternal) {
                    String diff = this.calculateDiff(existingPropertyType, incomingPropertyType);
                    if (!StringUtils.isNotBlank((CharSequence)diff) || !this.config.isMasterDataUpdateAllowed()) continue;
                    incomingPropertyType.setModificationDate(existingPropertyType.getModificationDate());
                    incomingPropertyType.setId(existingPropertyType.getId());
                    this.synchronizerFacade.updatePropertyType(incomingPropertyType, diff);
                    continue;
                }
                if (this.getType(existingPropertyType).equals((Object)this.getType(incomingPropertyType))) continue;
                this.errorsOut.println("The internal property type " + this.getCode(incomingPropertyType, nameTranslator) + " is not of data type " + this.getType(incomingPropertyType) + " but " + this.getType(existingPropertyType) + ".");
                continue;
            }
            if (incomingIsInternal) {
                this.errorsOut.println("There is no internal property type " + this.getCode(incomingPropertyType, nameTranslator) + ".");
                continue;
            }
            incomingPropertyType.setManagedInternally(false);
            this.synchronizerFacade.registerPropertyType(incomingPropertyType);
        }
    }

    private PropertyType getExisting(Map<String, PropertyType> propertyTypeMap, PropertyType incomingPropertyType, INameTranslator nameTranslator) {
        return propertyTypeMap.get(this.getCode(incomingPropertyType, nameTranslator));
    }

    private String getCode(PropertyType propertyType, INameTranslator nameTranslator) {
        String originalCode = propertyType.getCode();
        boolean internal = this.isInternallyManagedBySystem(propertyType);
        if (internal) {
            originalCode = nameTranslator.translateBack(originalCode);
        }
        return CodeConverter.tryToBusinessLayer((String)originalCode, (boolean)internal);
    }

    private boolean isInternallyManagedBySystem(PropertyType propertyType) {
        return propertyType.isManagedInternally() && this.isSystem(propertyType.getRegistrator().getUserId());
    }

    private String calculateDiff(PropertyType existingPropertyType, PropertyType incomingPropertyType) {
        DiffBuilder diffBuilder = new DiffBuilder((Object)existingPropertyType, (Object)incomingPropertyType, ToStringStyle.SHORT_PREFIX_STYLE, false).append("label", (Object)existingPropertyType.getLabel(), (Object)incomingPropertyType.getLabel()).append("dataType", (Object)this.getType(existingPropertyType), (Object)this.getType(incomingPropertyType)).append("description", (Object)existingPropertyType.getDescription(), (Object)incomingPropertyType.getDescription()).append("managedInternally", existingPropertyType.isManagedInternally(), incomingPropertyType.isManagedInternally()).append("vocabulary", (Object)this.getCode(existingPropertyType.getVocabulary()), (Object)this.getCode(incomingPropertyType.getVocabulary())).append("material", (Object)this.getCode((ICodeHolder)existingPropertyType.getMaterialType()), (Object)this.getCode((ICodeHolder)incomingPropertyType.getMaterialType()));
        DiffResult diffResult = diffBuilder.build();
        return MasterDataSynchronizer.render(diffResult, existingPropertyType, incomingPropertyType);
    }

    private DataTypeCode getType(PropertyType propertyType) {
        return propertyType.getDataType().getCode();
    }

    private String getCode(Vocabulary vocabulary) {
        if (vocabulary == null) {
            return null;
        }
        String code = vocabulary.getCode();
        if (vocabulary.isManagedInternally() && !code.startsWith("$")) {
            code = "$" + code;
        }
        return code;
    }

    private String getCode(ICodeHolder codeHolder) {
        return codeHolder == null ? null : codeHolder.getCode();
    }
}

