/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer;

import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.translator.INameTranslator;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeConverter;
import java.util.HashMap;
import java.util.Map;

class NameMapper {
    private final INameTranslator nameTranslator;
    private final Map<String, String> harvesterNameByDataSourceName = new HashMap<String, String>();

    NameMapper(INameTranslator nameTranslator) {
        this.nameTranslator = nameTranslator;
    }

    String registerName(String originalDataSourceName, Boolean managedInternally, String registrator) {
        boolean internalNamespace = Boolean.TRUE.equals(managedInternally);
        String dataSourceName = CodeConverter.tryToBusinessLayer((String)originalDataSourceName, (boolean)internalNamespace);
        String harvesterName = internalNamespace && "system".equals(registrator) ? dataSourceName : this.nameTranslator.translate(originalDataSourceName);
        String previous = this.harvesterNameByDataSourceName.put(dataSourceName, harvesterName);
        System.out.println(dataSourceName + "=" + harvesterName + " " + previous);
        if (previous != null) {
            throw new IllegalArgumentException("There is already a mapping defined for " + dataSourceName);
        }
        return originalDataSourceName;
    }

    String getHarvesterName(String originalDataSourceName) {
        String harvesterName = this.harvesterNameByDataSourceName.get(originalDataSourceName);
        if (harvesterName == null) {
            throw new IllegalArgumentException("No mapping found for " + originalDataSourceName + ".");
        }
        return harvesterName;
    }
}

