/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.create.ContentCopyCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.create.DataSetCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.create.LinkedDataCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.datastore.id.DataStorePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.datastore.id.IDataStoreId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.EntityKind;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.id.EntityTypePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.id.IEntityTypeId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.ExperimentIdentifier;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.IExperimentId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.externaldms.id.ExternalDmsPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.externaldms.id.IExternalDmsId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.ISampleId;
import ch.ethz.sis.openbis.generic.dssapi.v3.dto.dataset.create.FullDataSetCreation;
import ch.ethz.sis.openbis.generic.dssapi.v3.dto.datasetfile.create.DataSetFileCreation;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.common.SyncEntityKind;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.AbstractTimestampsAndUserHolder;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.Connection;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.FrozenFlags;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.FrozenForType;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.IncomingDataSet;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.IncomingExperiment;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.IncomingMaterial;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.IncomingProject;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.IncomingSample;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.IncomingSpace;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.MasterData;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.MasterDataParser;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.ResourceListParserData;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.translator.DefaultNameTranslator;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.translator.INameTranslator;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.util.DSPropertyUtils;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.util.Monitor;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewExperiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewMaterialWithType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewProject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSpace;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewContainerDataSet;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewExternalData;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewProperty;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResourceListParser {
    private final ResourceListParserData data;
    private final INameTranslator nameTranslator;
    private final String dataStoreCode;

    public INameTranslator getNameTranslator() {
        return this.nameTranslator;
    }

    private ResourceListParser(INameTranslator nameTranslator, String dataStoreCode) {
        this.data = new ResourceListParserData(nameTranslator);
        this.nameTranslator = nameTranslator;
        this.dataStoreCode = dataStoreCode;
    }

    public static ResourceListParser create(INameTranslator nameTranslator, String dataStoreCode) {
        if (nameTranslator == null) {
            return ResourceListParser.create(dataStoreCode);
        }
        return new ResourceListParser(nameTranslator, dataStoreCode);
    }

    private static ResourceListParser create(String dataStoreCode) {
        return ResourceListParser.create(new DefaultNameTranslator(), dataStoreCode);
    }

    public ResourceListParserData parseResourceListDocument(Document doc, Monitor monitor) throws XPathExpressionException {
        XPath xpath = this.createXPath();
        Date resourceListTimestamp = this.getResourceListTimestamp(doc, xpath);
        this.data.setResourceListTimestamp(resourceListTimestamp);
        monitor.log();
        NodeList nodes = doc.getDocumentElement().getChildNodes();
        this.parseMasterData(doc, xpath, nodes);
        this.parseData(nodes, monitor);
        return this.data;
    }

    private void parseMasterData(Document doc, XPath xpath, NodeList nodes) throws XPathExpressionException {
        for (int i = 0; i < nodes.getLength(); ++i) {
            String uri;
            Node node = nodes.item(i);
            Map<String, List<Node>> childrenByType = this.getChildrenByType(node);
            List<Node> locNodes = childrenByType.get("loc");
            if (locNodes == null || !(uri = locNodes.get(0).getTextContent()).endsWith("MASTER_DATA/MASTER_DATA/M")) continue;
            this.parseMasterData(doc, xpath, uri);
        }
    }

    private void parseData(NodeList nodes, Monitor monitor) throws XPathExpressionException {
        int n = nodes.getLength();
        for (int i = 0; i < n; ++i) {
            List<Node> lastmodNodes;
            String uri;
            Node node = nodes.item(i);
            Map<String, List<Node>> childrenByType = this.getChildrenByType(node);
            List<Node> locNodes = childrenByType.get("loc");
            if (locNodes == null || (uri = locNodes.get(0).getTextContent()).endsWith("MASTER_DATA/MASTER_DATA/M") || !uri.endsWith("/M") || (lastmodNodes = childrenByType.get("lastmod")) == null) continue;
            String lastModDataStr = lastmodNodes.get(0).getTextContent().trim();
            try {
                Date lastModificationDate = DSPropertyUtils.convertFromW3CDate(lastModDataStr);
                List<Node> xdNodes = childrenByType.get("x:xd");
                if (xdNodes == null) continue;
                if ((i + 1) % 10000 == 0) {
                    monitor.log(String.format("%7d/%d uri: %s", i + 1, n, uri));
                }
                this.parseMetaData(uri, lastModificationDate, xdNodes.get(0));
                continue;
            }
            catch (Exception e) {
                throw new XPathExpressionException("Last modification date cannot be parsed:" + lastModDataStr);
            }
        }
    }

    private XPath createXPath() {
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                if (prefix == null) {
                    throw new NullPointerException("Null prefix");
                }
                if ("s".equals(prefix)) {
                    return "http://www.sitemaps.org/schemas/sitemap/0.9";
                }
                if ("rs".equals(prefix)) {
                    return "http://www.openarchives.org/rs/terms/";
                }
                if ("x".equals(prefix)) {
                    return "https://sis.id.ethz.ch/software/#openbis/xdterms/";
                }
                if ("xml".equals(prefix)) {
                    return "http://www.w3.org/XML/1998/namespace";
                }
                return "";
            }

            @Override
            public String getPrefix(String uri) {
                throw new UnsupportedOperationException("Not implemented!!!");
            }

            @Override
            public Iterator<String> getPrefixes(String uri) {
                throw new UnsupportedOperationException("Not implemented!!!");
            }
        });
        return xpath;
    }

    private Date getResourceListTimestamp(Document doc, XPath xpath) throws XPathExpressionException {
        XPathExpression expr = xpath.compile("*[name() = 'urlset']/*[name() = 'rs:md']");
        Node mdNode = (Node)expr.evaluate(doc, XPathConstants.NODE);
        String timestamp = mdNode.getAttributes().getNamedItem("at").getTextContent();
        try {
            return DSPropertyUtils.convertFromW3CDate(timestamp);
        }
        catch (Exception e) {
            throw new XPathExpressionException("Last modification date cannot be parsed:" + timestamp);
        }
    }

    private void parseMasterData(Document doc, XPath xpath, String uri) throws XPathExpressionException {
        MasterDataParser mdParser = MasterDataParser.create(this.nameTranslator);
        mdParser.parseMasterData(doc, xpath, uri);
        MasterData masterData = this.data.getMasterData();
        masterData.setFileFormatTypesToProcess(mdParser.getFileFormatTypes());
        masterData.setValidationPluginsToProcess(mdParser.getValidationPlugins());
        masterData.setVocabulariesToProcess(mdParser.getVocabularies());
        masterData.setPropertyTypesToProcess(mdParser.getPropertyTypes());
        masterData.setSampleTypesToProcess(mdParser.getSampleTypes());
        masterData.setDataSetTypesToProcess(mdParser.getDataSetTypes());
        masterData.setExperimentTypesToProcess(mdParser.getExperimentTypes());
        masterData.setMaterialTypesToProcess(mdParser.getMaterialTypes());
        masterData.setPropertyAssignmentsToProcess(mdParser.getEntityPropertyAssignments());
        masterData.setExternalDataManagementSystemsToProcess(mdParser.getExternalDataManagementSystems());
        masterData.setVocabularyNameMapper(mdParser.getVocabularyNameMapper());
        masterData.setPropertyTypeNameMapper(mdParser.getPropertyTypeNameMapper());
    }

    private void parseMetaData(String uri, Date lastModificationDate, Node xdNode) throws XPathExpressionException {
        String entityKind = xdNode.getAttributes().getNamedItem("kind").getTextContent();
        if (SyncEntityKind.SPACE.toString().equals(entityKind)) {
            this.parseSpaceMetaData(xdNode, lastModificationDate);
        } else if (SyncEntityKind.PROJECT.toString().equals(entityKind)) {
            this.parseProjectMetaData(this.extractPermIdFromURI(uri), xdNode, lastModificationDate);
        } else if (SyncEntityKind.EXPERIMENT.toString().equals(entityKind)) {
            this.parseExperimentMetaData(this.extractPermIdFromURI(uri), xdNode, lastModificationDate);
        } else if (SyncEntityKind.SAMPLE.toString().equals(entityKind)) {
            this.parseSampleMetaData(this.extractPermIdFromURI(uri), xdNode, lastModificationDate);
        } else if (SyncEntityKind.DATA_SET.toString().equals(entityKind)) {
            this.parseDataSetMetaData(this.extractDataSetCodeFromURI(uri), xdNode, lastModificationDate);
        } else if (SyncEntityKind.MATERIAL.toString().equals(entityKind)) {
            this.parseMaterialMetaData(this.extractMaterialCodeFromURI(uri), xdNode, lastModificationDate);
        } else if (SyncEntityKind.FILE.toString().equals(entityKind)) {
            this.parseFileData(xdNode, lastModificationDate);
        }
    }

    private Map<String, List<Node>> getChildrenByType(Node node) {
        TreeMap<String, List<Node>> result = new TreeMap<String, List<Node>>();
        if (node.hasChildNodes()) {
            NodeList childNodes = node.getChildNodes();
            int n = childNodes.getLength();
            for (int i = 0; i < n; ++i) {
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName().toLowerCase();
                ArrayList<Node> list = (ArrayList<Node>)result.get(nodeName);
                if (list == null) {
                    list = new ArrayList<Node>();
                    result.put(nodeName, list);
                }
                list.add(childNode);
            }
        }
        return result;
    }

    private void parseDataSetMetaData(String permId, Node xdNode, Date lastModificationDate) {
        ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier experimentId;
        FrozenFlags frozenFlags = this.extractFrozenFlags(permId, xdNode, FrozenForType.CHILDREN, FrozenForType.PARENTS, FrozenForType.COMPONENTS, FrozenForType.CONTAINERS);
        String code = this.extractCode(xdNode);
        String sampleIdentifier = this.extractAttribute(xdNode, "sample", true);
        String experimentIdentifier = this.extractAttribute(xdNode, "experiment", true);
        String type = this.extractType(xdNode);
        String dsKind = this.extractAttribute(xdNode, "dsKind");
        NewExternalData ds = new NewExternalData();
        FullDataSetCreation fullDataSet = new FullDataSetCreation();
        DataSetCreation dataSet = new DataSetCreation();
        fullDataSet.setMetadataCreation(dataSet);
        if (dsKind.equals(ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.DataSetKind.CONTAINER.toString())) {
            ds = new NewContainerDataSet();
            ds.setDataSetKind(DataSetKind.CONTAINER);
            dataSet.setDataSetKind(ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.DataSetKind.CONTAINER);
        } else if (dsKind.equals(ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.DataSetKind.LINK.toString())) {
            ds = new NewContainerDataSet();
            this.parseLinkDataMetaData(fullDataSet, xdNode);
        } else if (dsKind.equals(ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.DataSetKind.PHYSICAL.toString())) {
            ds.setDataSetKind(DataSetKind.PHYSICAL);
            dataSet.setDataSetKind(ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.DataSetKind.PHYSICAL);
        } else {
            throw new IllegalArgumentException(dsKind + " data sets are currently not supported");
        }
        ds.setCode(code);
        dataSet.setCode(code);
        ds.setDataSetType(new DataSetType(type));
        dataSet.setTypeId((IEntityTypeId)new EntityTypePermId(type, EntityKind.DATA_SET));
        ds.setDataStoreCode(this.dataStoreCode);
        dataSet.setDataStoreId((IDataStoreId)new DataStorePermId(this.dataStoreCode));
        SampleIdentifier sampleId = this.getSampleIdentifier(sampleIdentifier);
        if (sampleId != null) {
            ds.setSampleIdentifierOrNull(sampleId);
            dataSet.setSampleId((ISampleId)new ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.SampleIdentifier(sampleId.toString()));
        }
        if ((experimentId = this.getExperimentIdentifier(experimentIdentifier)) != null) {
            ds.setExperimentIdentifierOrNull(experimentId);
            dataSet.setExperimentId((IExperimentId)new ExperimentIdentifier(experimentId.toString()));
        }
        IncomingDataSet incomingDataSet = new IncomingDataSet(ds, frozenFlags, fullDataSet, lastModificationDate);
        this.setTimestampsAndUsers(xdNode, incomingDataSet);
        this.data.getDataSetsToProcess().put(permId, incomingDataSet);
        incomingDataSet.setConnections(this.parseConnections(xdNode));
        List<NewProperty> properties = this.parseDataSetProperties(xdNode);
        ds.setDataSetProperties(properties);
        HashMap<String, String> props = new HashMap<String, String>();
        for (NewProperty property : properties) {
            props.put(property.getPropertyCode(), property.getValue());
        }
        dataSet.setProperties(props);
    }

    public void parseLinkDataMetaData(FullDataSetCreation fullDataSet, Node xdNode) {
        DataSetCreation dataSet = fullDataSet.getMetadataCreation();
        dataSet.setDataSetKind(ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.DataSetKind.LINK);
        LinkedDataCreation linkedData = new LinkedDataCreation();
        Element docElement = (Element)xdNode;
        NodeList binaryDataNode = docElement.getElementsByTagName("x:binaryData");
        if (binaryDataNode.getLength() == 1) {
            Element binaryDataElement = (Element)binaryDataNode.item(0);
            linkedData.setContentCopies(this.parseContentCopies(binaryDataElement));
            fullDataSet.setFileMetadata(this.parseFileNodes(binaryDataElement));
        }
        dataSet.setLinkedData(linkedData);
    }

    public List<DataSetFileCreation> parseFileNodes(Element binaryDataElement) {
        ArrayList<DataSetFileCreation> fileCreations = new ArrayList<DataSetFileCreation>();
        NodeList fileNodes = binaryDataElement.getElementsByTagName("x:fileNode");
        for (int i = 0; i < fileNodes.getLength(); ++i) {
            String[] splittedChecksum;
            String checksum;
            Element fileElement = (Element)fileNodes.item(i);
            DataSetFileCreation fileCreation = new DataSetFileCreation();
            fileCreation.setPath(fileElement.getAttribute("path"));
            fileCreation.setFileLength(Long.valueOf(Long.parseLong(fileElement.getAttribute("length"))));
            String crc32Checksum = fileElement.getAttribute("crc32checksum");
            if (StringUtils.isNotBlank((CharSequence)crc32Checksum)) {
                fileCreation.setChecksumCRC32(Integer.valueOf(Integer.parseUnsignedInt(crc32Checksum)));
            }
            if (StringUtils.isNotBlank((CharSequence)(checksum = fileElement.getAttribute("checksum"))) && (splittedChecksum = checksum.split(":")).length == 2) {
                fileCreation.setChecksumType(splittedChecksum[0]);
                fileCreation.setChecksum(splittedChecksum[1]);
            }
            fileCreations.add(fileCreation);
        }
        return fileCreations;
    }

    public List<ContentCopyCreation> parseContentCopies(Element binaryDataElement) {
        NodeList contentCopyNodes = binaryDataElement.getElementsByTagName("x:contentCopy");
        ArrayList<ContentCopyCreation> contentCopyCreations = new ArrayList<ContentCopyCreation>();
        for (int i = 0; i < contentCopyNodes.getLength(); ++i) {
            Element contentCopyElement = (Element)contentCopyNodes.item(i);
            ContentCopyCreation contentCopyCreation = new ContentCopyCreation();
            contentCopyCreation.setExternalDmsId((IExternalDmsId)new ExternalDmsPermId(this.nameTranslator.translate(contentCopyElement.getAttribute("externalDMS"))));
            contentCopyCreation.setExternalId(this.getAttributeOrNull(contentCopyElement, "externalCode"));
            contentCopyCreation.setGitCommitHash(this.getAttributeOrNull(contentCopyElement, "gitCommitHash"));
            contentCopyCreation.setGitRepositoryId(this.getAttributeOrNull(contentCopyElement, "gitRepositoryId"));
            contentCopyCreation.setPath(this.getAttributeOrNull(contentCopyElement, "path"));
            contentCopyCreations.add(contentCopyCreation);
        }
        return contentCopyCreations;
    }

    private String getAttributeOrNull(Element contentCopyElement, String name) {
        String attribute = contentCopyElement.getAttribute(name);
        return StringUtils.isBlank((CharSequence)attribute) ? null : attribute;
    }

    private boolean extractBooleanAttribute(Node xdNode, String attrName) {
        return "true".equals(this.extractAttribute(xdNode, attrName, true));
    }

    private String extractAttribute(Node xdNode, String attrName, boolean nullAllowed) {
        Node item = xdNode.getAttributes().getNamedItem(attrName);
        if (item == null || StringUtils.isBlank((CharSequence)item.getTextContent())) {
            if (!nullAllowed) {
                throw new IllegalArgumentException(attrName + " cannot be empty in Resource List");
            }
            return null;
        }
        return item.getTextContent();
    }

    private String extractAttribute(Node xdNode, String attrName) throws IllegalArgumentException {
        return this.extractAttribute(xdNode, attrName, false);
    }

    private String extractCode(Node xdNode) {
        return this.extractAttribute(xdNode, "code");
    }

    private SampleIdentifier getSampleIdentifier(String sampleIdentifierStr) {
        if (sampleIdentifierStr == null) {
            return null;
        }
        SampleIdentifier sampleIdentifier = SampleIdentifierFactory.parse((String)sampleIdentifierStr);
        SpaceIdentifier spaceLevel = sampleIdentifier.getSpaceLevel();
        String originalSpaceCode = spaceLevel.getSpaceCode();
        SpaceIdentifier translatedSpaceIdentifier = new SpaceIdentifier(this.nameTranslator.translate(originalSpaceCode));
        if (sampleIdentifier.isProjectLevel()) {
            return new SampleIdentifier(new ProjectIdentifier(translatedSpaceIdentifier, sampleIdentifier.getProjectLevel().getProjectCode()), sampleIdentifier.getSampleCode());
        }
        return new SampleIdentifier(translatedSpaceIdentifier, sampleIdentifier.getSampleCode());
    }

    private ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier getExperimentIdentifier(String experimentIdentifierStr) {
        if (experimentIdentifierStr == null) {
            return null;
        }
        ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier experimentIdentifier = ExperimentIdentifierFactory.parse((String)experimentIdentifierStr);
        String originalSpaceCode = experimentIdentifier.getSpaceCode();
        String projectCode = experimentIdentifier.getProjectCode();
        String expCode = experimentIdentifier.getExperimentCode();
        return new ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier(new ProjectIdentifier(new SpaceIdentifier(this.nameTranslator.translate(originalSpaceCode)), projectCode), expCode);
    }

    private void parseFileData(Node xdNode, Date lastModificationDate) {
        String path = this.extractAttribute(xdNode, "path", false);
        String base64EncodedFileContent = xdNode.getTextContent();
        byte[] content = Base64.getDecoder().decode(base64EncodedFileContent);
        this.data.getFileToProcess().put(path, content);
    }

    private void parseSpaceMetaData(Node xdNode, Date lastModificationDate) {
        String code = this.nameTranslator.translate(this.extractCode(xdNode));
        FrozenFlags frozenFlags = this.extractFrozenFlags(code, xdNode, FrozenForType.PROJECTS, FrozenForType.SAMPLES);
        String desc = this.extractAttribute(xdNode, "desc", true);
        NewSpace space = new NewSpace(code, desc, null);
        IncomingSpace incomingSpace = new IncomingSpace(space, frozenFlags, lastModificationDate);
        this.data.getSpacesToProcess().add(incomingSpace);
        this.setTimestampsAndUsers(xdNode, incomingSpace);
    }

    private void parseProjectMetaData(String permId, Node xdNode, Date lastModificationDate) {
        FrozenFlags frozenFlags = this.extractFrozenFlags(permId, xdNode, FrozenForType.EXPERIMENTS, FrozenForType.SAMPLES);
        String code = this.extractCode(xdNode);
        String desc = this.extractAttribute(xdNode, "desc", true);
        String space = this.extractSpace(xdNode, false);
        ProjectIdentifier projectIdentifier = this.createProjectIdentifier(code, space);
        NewProject newProject = new NewProject(projectIdentifier.toString(), desc);
        newProject.setPermID(permId);
        IncomingProject incomingProject = new IncomingProject(newProject, frozenFlags, lastModificationDate);
        this.data.getProjectsToProcess().put(permId, incomingProject);
        incomingProject.setConnections(this.parseConnections(xdNode));
        incomingProject.setHasAttachments(this.hasAttachments(xdNode));
        this.setTimestampsAndUsers(xdNode, incomingProject);
    }

    private FrozenFlags extractFrozenFlags(String permId, Node xdNode, FrozenForType ... frozenForTypes) {
        FrozenFlags frozenFlags = new FrozenFlags(permId, this.extractBooleanAttribute(xdNode, "frozen"));
        for (FrozenForType type : frozenForTypes) {
            boolean value = this.extractBooleanAttribute(xdNode, type.getAttributeName());
            type.setFlag(frozenFlags, value);
        }
        return frozenFlags;
    }

    private ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier createExperimentIdentifier(String spaceId, String prjCode, String expCode) {
        return new ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier(this.createProjectIdentifier(prjCode, spaceId), expCode);
    }

    private ProjectIdentifier createProjectIdentifier(String code, String space) {
        return new ProjectIdentifier(this.createSpaceIdentifier(space), code);
    }

    private SampleIdentifier createSampleIdentifier(String code, String project, String space) {
        if (space == null) {
            return new SampleIdentifier(this.nameTranslator.translate(code));
        }
        if (project == null) {
            SpaceIdentifier spaceIdentifier = this.createSpaceIdentifier(space);
            return new SampleIdentifier(spaceIdentifier, code);
        }
        ProjectIdentifier projectIdentifier = this.createProjectIdentifier(project, space);
        return new SampleIdentifier(projectIdentifier, code);
    }

    private SpaceIdentifier createSpaceIdentifier(String space) {
        assert (space != null) : "Space id cannot be null";
        String translatedSpaceId = this.nameTranslator.translate(space);
        this.data.getHarvesterSpaceList().add(translatedSpaceId);
        return new SpaceIdentifier(translatedSpaceId);
    }

    private void parseMaterialMetaData(String permId, Node xdNode, Date lastModificationDate) {
        String code = this.nameTranslator.translate(this.extractCode(xdNode));
        String type = this.extractType(xdNode);
        NewMaterialWithType newMaterial = new NewMaterialWithType(code, type);
        IncomingMaterial incomingMaterial = new IncomingMaterial(newMaterial, lastModificationDate);
        this.setTimestampsAndUsers(xdNode, incomingMaterial);
        this.data.getMaterialsToProcess().put((Object)code, (Object)type, (Object)incomingMaterial);
        newMaterial.setProperties((IEntityProperty[])this.parseProperties(xdNode));
    }

    private List<Connection> parseConnections(Node xdNode) {
        ArrayList<Connection> conns = new ArrayList<Connection>();
        Element docElement = (Element)xdNode;
        NodeList connsNode = docElement.getElementsByTagName("x:connections");
        if (connsNode.getLength() == 1) {
            Element connsElement = (Element)connsNode.item(0);
            NodeList connNodes = connsElement.getElementsByTagName("x:connection");
            for (int i = 0; i < connNodes.getLength(); ++i) {
                String to = connNodes.item(i).getAttributes().getNamedItem("to").getTextContent();
                String type = connNodes.item(i).getAttributes().getNamedItem("type").getTextContent();
                conns.add(new Connection(to, type));
            }
        }
        return conns;
    }

    private boolean hasAttachments(Node xdNode) {
        Element docElement = (Element)xdNode;
        NodeList connsNode = docElement.getElementsByTagName("x:binaryData");
        return connsNode.getLength() == 1;
    }

    private List<NewProperty> parseDataSetProperties(Node xdNode) {
        EntityProperty[] entityProperties = this.parseProperties(xdNode);
        ArrayList<NewProperty> dsProperties = new ArrayList<NewProperty>();
        for (EntityProperty entityProperty : entityProperties) {
            dsProperties.add(new NewProperty(entityProperty.getPropertyType().getCode(), entityProperty.getValue()));
        }
        return dsProperties;
    }

    private EntityProperty[] parseProperties(Node xdNode) {
        ArrayList<EntityProperty> entityProperties = new ArrayList<EntityProperty>();
        Element docElement = (Element)xdNode;
        NodeList propsNode = docElement.getElementsByTagName("x:properties");
        if (propsNode.getLength() == 1) {
            Element propsElement = (Element)propsNode.item(0);
            NodeList propertyNodes = propsElement.getElementsByTagName("x:property");
            for (int i = 0; i < propertyNodes.getLength(); ++i) {
                Element propertyElement = (Element)propertyNodes.item(i);
                String code = propertyElement.getElementsByTagName("x:code").item(0).getTextContent();
                String val = propertyElement.getElementsByTagName("x:value").item(0).getTextContent();
                EntityProperty property = this.createEntityProperty(code, val);
                entityProperties.add(property);
            }
        }
        return entityProperties.toArray(new EntityProperty[entityProperties.size()]);
    }

    private EntityProperty createEntityProperty(String code, String val) {
        EntityProperty property = new EntityProperty();
        PropertyType propertyType = new PropertyType();
        String translatedCode = this.nameTranslator.translate(code);
        MasterData masterData = this.data.getMasterData();
        PropertyType pt = masterData.getPropertyTypesToProcess().get(translatedCode);
        if (pt.getDataType().getCode().equals((Object)DataTypeCode.MATERIAL) && val != null) {
            val = this.nameTranslator.translate(val);
            val = this.translateMaterialIdentifier(val);
        }
        propertyType.setCode(masterData.getPropertyTypeNameMapper().getHarvesterName(code));
        property.setPropertyType(propertyType);
        property.setValue(val);
        return property;
    }

    private String translateMaterialIdentifier(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        int typePrefix = value.indexOf(" (");
        if (typePrefix == -1) {
            return null;
        }
        String code = value.substring(0, typePrefix);
        String typeCode = this.nameTranslator.translate(value.substring(typePrefix + " (".length()));
        if (typeCode.endsWith(")")) {
            typeCode = typeCode.substring(0, typeCode.length() - ")".length());
        }
        return new MaterialIdentifier(code, typeCode).toString();
    }

    private void parseExperimentMetaData(String permId, Node xdNode, Date lastModificationDate) {
        FrozenFlags frozenFlags = this.extractFrozenFlags(permId, xdNode, FrozenForType.DATA_SETS, FrozenForType.SAMPLES);
        String code = this.extractCode(xdNode);
        String type = this.extractType(xdNode);
        String project = this.extractAttribute(xdNode, "project");
        String space = this.extractSpace(xdNode, false);
        ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier experimentIdentifier = this.createExperimentIdentifier(space, project, code);
        NewExperiment newExp = new NewExperiment(experimentIdentifier.toString(), type);
        newExp.setPermID(permId);
        IncomingExperiment incomingExperiment = new IncomingExperiment(newExp, frozenFlags, lastModificationDate);
        this.data.getExperimentsToProcess().put(permId, incomingExperiment);
        incomingExperiment.setConnections(this.parseConnections(xdNode));
        incomingExperiment.setHasAttachments(this.hasAttachments(xdNode));
        this.setTimestampsAndUsers(xdNode, incomingExperiment);
        newExp.setProperties((IEntityProperty[])this.parseProperties(xdNode));
    }

    private void parseSampleMetaData(String permId, Node xdNode, Date lastModificationDate) {
        FrozenFlags frozenFlags = this.extractFrozenFlags(permId, xdNode, FrozenForType.COMPONENTS, FrozenForType.CHILDREN, FrozenForType.PARENTS, FrozenForType.DATA_SETS);
        String code = this.extractCode(xdNode);
        String type = this.extractType(xdNode);
        String experiment = this.extractAttribute(xdNode, "experiment", true);
        String project = this.extractAttribute(xdNode, "project", true);
        String space = this.extractSpace(xdNode, true);
        SampleType sampleType = new SampleType();
        sampleType.setCode(type);
        if (!StringUtils.isBlank((CharSequence)project) && StringUtils.isBlank((CharSequence)space)) {
            throw new IllegalArgumentException("Sample with perm id '" + permId + "' has 'project' attribute specified but 'space' attribute empty");
        }
        SampleIdentifier identifier = this.createSampleIdentifier(code, project, space);
        String expIdentifier = null;
        ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier experimentIdentifier = this.getExperimentIdentifier(experiment);
        if (experimentIdentifier != null) {
            expIdentifier = experimentIdentifier.toString();
        }
        NewSample newSample = new NewSample(identifier.toString(), sampleType, null, null, expIdentifier, null, null, null, null);
        newSample.setPermID(permId);
        if (space == null) {
            newSample.setDefaultSpaceIdentifier(null);
        }
        if (space != null && project != null) {
            newSample.setProjectIdentifier(this.createProjectIdentifier(project, space).toString());
        }
        IncomingSample incomingSample = new IncomingSample(newSample, frozenFlags, lastModificationDate);
        this.data.getSamplesToProcess().put(permId, incomingSample);
        incomingSample.setHasAttachments(this.hasAttachments(xdNode));
        incomingSample.setConnections(this.parseConnections(xdNode));
        this.setTimestampsAndUsers(xdNode, incomingSample);
        newSample.setProperties((IEntityProperty[])this.parseProperties(xdNode));
    }

    private void setTimestampsAndUsers(Node xdNode, AbstractTimestampsAndUserHolder timestampsAndUserHolder) {
        timestampsAndUserHolder.setRegistrator(this.extractAttribute(xdNode, "registrator"));
        timestampsAndUserHolder.setModifier(this.extractAttribute(xdNode, "modifier", true));
        String registrationTimestampAsString = this.extractAttribute(xdNode, "registration-timestamp");
        try {
            timestampsAndUserHolder.setRegistrationTimestamp(DSPropertyUtils.convertFromW3CDate(registrationTimestampAsString));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid registration-timestamp: " + registrationTimestampAsString);
        }
    }

    private String extractType(Node xdNode) {
        return this.nameTranslator.translate(this.extractAttribute(xdNode, "type"));
    }

    private String extractSpace(Node xdNode, boolean nullAllowed) {
        return this.extractAttribute(xdNode, "space", nullAllowed);
    }

    private String extractPermIdFromURI(String uri) throws XPathExpressionException {
        Pattern pattern = Pattern.compile("([0-9\\-]{17,})");
        Matcher matcher = pattern.matcher(uri);
        if (matcher.find()) {
            return matcher.group(1);
        }
        throw new XPathExpressionException("Malformed resource url");
    }

    private String extractDataSetCodeFromURI(String uri) throws XPathExpressionException {
        Pattern pattern = Pattern.compile("(?<=DATA_SET\\/)(.*)(?=\\/M)");
        Matcher matcher = pattern.matcher(uri);
        if (matcher.find()) {
            return matcher.group(1);
        }
        throw new XPathExpressionException("Malformed resource url");
    }

    private String extractMaterialCodeFromURI(String uri) throws XPathExpressionException {
        String[] parts = uri.split("/");
        return parts[parts.length - 2];
    }
}

