/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.DataSetKind;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.IncomingDataSet;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.IncomingEntity;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.IncomingExperiment;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.IncomingMaterial;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.IncomingProject;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.IncomingSample;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.IncomingSpace;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.MasterData;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.translator.INameTranslator;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.map.MultiKeyMap;

public class ResourceListParserData {
    private Date resourceListTimestamp;
    private Set<String> harvesterSpaceList = new HashSet<String>();
    private MasterData masterData;
    private List<IncomingSpace> spacesToProcess = new ArrayList<IncomingSpace>();
    private Map<String, IncomingProject> projectsToProcess = new HashMap<String, IncomingProject>();
    private Map<String, IncomingExperiment> experimentsToProcess = new HashMap<String, IncomingExperiment>();
    private Map<String, IncomingSample> samplesToProcess = new HashMap<String, IncomingSample>();
    private Map<String, IncomingDataSet> dataSetsToProcess = new HashMap<String, IncomingDataSet>();
    private MultiKeyMap<String, IncomingMaterial> materialsToProcess = new MultiKeyMap();
    private Map<String, byte[]> filesToProcess = new HashMap<String, byte[]>();

    public ResourceListParserData(INameTranslator nameTranslator) {
        this.masterData = new MasterData(nameTranslator);
    }

    public MasterData getMasterData() {
        return this.masterData;
    }

    public Date getResourceListTimestamp() {
        return this.resourceListTimestamp;
    }

    public void setResourceListTimestamp(Date resourceListTimestamp) {
        this.resourceListTimestamp = resourceListTimestamp;
    }

    public Map<String, byte[]> getFileToProcess() {
        return this.filesToProcess;
    }

    public Set<String> getHarvesterSpaceList() {
        return this.harvesterSpaceList;
    }

    public List<IncomingSpace> getSpacesToProcess() {
        return this.spacesToProcess;
    }

    public List<IncomingSpace> getRelevantSpacesToProcess() {
        ArrayList<IncomingSpace> result = new ArrayList<IncomingSpace>();
        for (IncomingSpace incomingSpace : this.spacesToProcess) {
            if (!this.harvesterSpaceList.contains(incomingSpace.getPermID())) continue;
            result.add(incomingSpace);
        }
        return result;
    }

    public Map<String, IncomingProject> getProjectsToProcess() {
        return this.projectsToProcess;
    }

    public Map<String, IncomingExperiment> getExperimentsToProcess() {
        return this.experimentsToProcess;
    }

    public Map<String, IncomingSample> getSamplesToProcess() {
        return this.samplesToProcess;
    }

    public Map<String, IncomingDataSet> getDataSetsToProcess() {
        return this.dataSetsToProcess;
    }

    public MultiKeyMap<String, IncomingMaterial> getMaterialsToProcess() {
        return this.materialsToProcess;
    }

    public Map<String, IncomingDataSet> filterByDataSetKindAndLastModificationDate(DataSetKind dataSetKind, Date lastSyncDate, Set<String> dataSetsCodesToRetry, Set<String> blackListedDataSetCodes) {
        HashMap<String, IncomingDataSet> dsMap = new HashMap<String, IncomingDataSet>();
        for (String permId : this.dataSetsToProcess.keySet()) {
            IncomingDataSet ds = this.dataSetsToProcess.get(permId);
            String dataSetCode = ds.getDataSet().getCode();
            if (ds.getKind() != dataSetKind || !(ds.lastModificationDate.after(lastSyncDate) || dataSetsCodesToRetry.contains(dataSetCode)) || blackListedDataSetCodes.contains(dataSetCode)) continue;
            dsMap.put(permId, ds);
        }
        return dsMap;
    }

    public List<IncomingEntity<?>> filterAttachmentHoldersByLastModificationDate(Date lastSyncTimestamp, Set<String> attachmentHoldersToRetry) {
        ArrayList attachmentHoldersToProcess = new ArrayList();
        for (IncomingProject incomingProject : this.projectsToProcess.values()) {
            if (!this.syncAttachments(lastSyncTimestamp, attachmentHoldersToRetry, incomingProject)) continue;
            attachmentHoldersToProcess.add(incomingProject);
        }
        for (IncomingExperiment incomingExperiment : this.experimentsToProcess.values()) {
            if (!this.syncAttachments(lastSyncTimestamp, attachmentHoldersToRetry, incomingExperiment)) continue;
            attachmentHoldersToProcess.add(incomingExperiment);
        }
        for (IncomingSample incomingSample : this.samplesToProcess.values()) {
            if (!this.syncAttachments(lastSyncTimestamp, attachmentHoldersToRetry, incomingSample)) continue;
            attachmentHoldersToProcess.add(incomingSample);
        }
        return attachmentHoldersToProcess;
    }

    private boolean syncAttachments(Date lastSyncTimestamp, Set<String> attachmentHoldersToRetry, IncomingEntity<?> incomingEntity) {
        return incomingEntity.getLastModificationDate().after(lastSyncTimestamp) || attachmentHoldersToRetry.contains(incomingEntity.getEntityKind().toString() + "-" + incomingEntity.getPermID());
    }

    public Map<String, IncomingDataSet> filterContainerDataSets() {
        HashMap<String, IncomingDataSet> dsMap = new HashMap<String, IncomingDataSet>();
        for (String permId : this.dataSetsToProcess.keySet()) {
            IncomingDataSet ds = this.dataSetsToProcess.get(permId);
            if (ds.getKind() != DataSetKind.CONTAINER) continue;
            dsMap.put(permId, ds);
        }
        return dsMap;
    }
}

