/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer;

import ch.ethz.sis.openbis.generic.asapi.v3.IApplicationServerApi;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.externaldms.create.ExternalDmsCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.externaldms.update.ExternalDmsUpdate;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.common.ServiceFinderUtils;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.ISynchronizerFacade;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.util.SummaryUtils;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeConverter;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.FileFormatType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IPropertyTypeUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IScriptUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IVocabularyTermUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IVocabularyUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewETPTAssignment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewVocabulary;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Script;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class SynchronizerFacade
implements ISynchronizerFacade {
    private final String sessionToken;
    private final ICommonServer commonServer;
    private final IApplicationServerApi v3api;
    private final Logger operationLog;
    private Map<String, String> fileformatTypesToUpdate = new TreeMap<String, String>();
    private Set<String> fileformatTypesToAdd = new TreeSet<String>();
    private Map<String, String> propertyTypesToUpdate = new TreeMap<String, String>();
    private Set<String> propertyTypesToAdd = new TreeSet<String>();
    private Map<String, String> validationPluginsToUpdate = new TreeMap<String, String>();
    private Set<String> validationPluginsToAdd = new TreeSet<String>();
    private final boolean dryRun;
    private final boolean verbose;
    private Set<String> vocabulariesToAdd = new TreeSet<String>();
    private Map<String, UpdateSummary> vocabulariesToUpdate = new TreeMap<String, UpdateSummary>();
    private Set<String> sampleTypesToAdd = new TreeSet<String>();
    private Set<String> experimentTypesToAdd = new TreeSet<String>();
    private Set<String> dataSetTypesToAdd = new TreeSet<String>();
    private Set<String> materialTypesToAdd = new TreeSet<String>();
    private Map<String, UpdateSummary> sampleTypesToUpdate = new TreeMap<String, UpdateSummary>();
    private Map<String, UpdateSummary> experimentTypesToUpdate = new TreeMap<String, UpdateSummary>();
    private Map<String, UpdateSummary> dataSetTypesToUpdate = new TreeMap<String, UpdateSummary>();
    private Map<String, UpdateSummary> materialTypesToUpdate = new HashMap<String, UpdateSummary>();

    public SynchronizerFacade(String openBisServerUrl, String harvesterUser, String harvesterPassword, boolean dryRun, boolean verbose, Logger operationLog) {
        this.commonServer = ServiceFinderUtils.getCommonServer(openBisServerUrl);
        this.v3api = ServiceProvider.getV3ApplicationService();
        this.sessionToken = ServiceFinderUtils.login(this.commonServer, harvesterUser, harvesterPassword);
        this.dryRun = dryRun;
        this.verbose = verbose || dryRun;
        this.operationLog = operationLog;
    }

    @Override
    public void updateFileFormatType(AbstractType type) {
        this.fileformatTypesToUpdate.put(type.getCode(), "Description: " + type.getDescription());
        if (!this.dryRun) {
            this.commonServer.updateFileFormatType(this.sessionToken, type);
        }
    }

    @Override
    public void registerFileFormatType(FileFormatType type) {
        this.fileformatTypesToAdd.add(type.getCode());
        if (!this.dryRun) {
            this.commonServer.registerFileFormatType(this.sessionToken, type);
        }
    }

    @Override
    public void updatePropertyTypeAssignment(NewETPTAssignment newETPTAssignment, String diff) {
        Map<String, UpdateSummary> summaryMap = this.getEntityTypeSummaryMap(newETPTAssignment.getEntityKind());
        this.getEntityTypeSummary(summaryMap, newETPTAssignment.getEntityTypeCode()).update(newETPTAssignment.getPropertyTypeCode(), diff);
        if (!this.dryRun) {
            this.commonServer.updatePropertyTypeAssignment(this.sessionToken, newETPTAssignment);
        }
    }

    @Override
    public void assignPropertyType(NewETPTAssignment newETPTAssignment) {
        Map<String, UpdateSummary> summaryMap = this.getEntityTypeSummaryMap(newETPTAssignment.getEntityKind());
        this.getEntityTypeSummary(summaryMap, newETPTAssignment.getEntityTypeCode()).add(newETPTAssignment.getPropertyTypeCode());
        if (!this.dryRun) {
            this.commonServer.assignPropertyType(this.sessionToken, newETPTAssignment);
        }
    }

    @Override
    public void unassignPropertyType(EntityKind entityKind, String propertyTypeCode, String entityTypeCode) {
        this.getEntityTypeSummary(this.getEntityTypeSummaryMap(entityKind), entityTypeCode).remove(propertyTypeCode);
        if (!this.dryRun) {
            this.commonServer.unassignPropertyType(this.sessionToken, entityKind, propertyTypeCode, entityTypeCode);
        }
    }

    private Map<String, UpdateSummary> getEntityTypeSummaryMap(EntityKind entityKind) {
        switch (entityKind) {
            case SAMPLE: {
                return this.sampleTypesToUpdate;
            }
            case EXPERIMENT: {
                return this.experimentTypesToUpdate;
            }
            case DATA_SET: {
                return this.dataSetTypesToUpdate;
            }
            case MATERIAL: {
                return this.materialTypesToUpdate;
            }
        }
        throw new RuntimeException("Unknown entity kind: " + entityKind);
    }

    @Override
    public void updatePropertyType(PropertyType propertyType, String diff) {
        this.propertyTypesToUpdate.put(propertyType.getCode(), diff);
        if (!this.dryRun) {
            this.commonServer.updatePropertyType(this.sessionToken, (IPropertyTypeUpdates)propertyType);
        }
    }

    @Override
    public void registerPropertyType(PropertyType propertyType) {
        this.propertyTypesToAdd.add(propertyType.getCode());
        if (!this.dryRun) {
            this.commonServer.registerPropertyType(this.sessionToken, propertyType);
        }
    }

    @Override
    public void updateValidationPlugin(Script script, String diff) {
        this.validationPluginsToUpdate.put(script.getName(), diff);
        if (!this.dryRun) {
            this.commonServer.updateScript(this.sessionToken, (IScriptUpdates)script);
        }
    }

    @Override
    public void registerValidationPlugin(Script script) {
        this.validationPluginsToAdd.add(script.getName());
        if (!this.dryRun) {
            this.commonServer.registerScript(this.sessionToken, script);
        }
    }

    @Override
    public void registerVocabulary(NewVocabulary vocab) {
        String vocabCode = CodeConverter.tryToBusinessLayer((String)vocab.getCode(), (boolean)vocab.isManagedInternally());
        this.vocabulariesToAdd.add(vocabCode);
        if (!this.dryRun) {
            this.commonServer.registerVocabulary(this.sessionToken, vocab);
        }
    }

    @Override
    public void updateVocabulary(Vocabulary vocab, String diff) {
        String vocabCode = CodeConverter.tryToBusinessLayer((String)vocab.getCode(), (boolean)vocab.isManagedInternally());
        this.getVocabularySummary(vocabCode).update(diff);
        if (!this.dryRun) {
            this.commonServer.updateVocabulary(this.sessionToken, (IVocabularyUpdates)vocab);
        }
    }

    @Override
    public void updateVocabularyTerm(String vocabularyCode, VocabularyTerm term, String diff) {
        this.getVocabularySummary(vocabularyCode).update(term.getCode(), diff);
        if (!this.dryRun) {
            this.commonServer.updateVocabularyTerm(this.sessionToken, (IVocabularyTermUpdates)term);
        }
    }

    @Override
    public void registerSampleType(SampleType sampleType) {
        this.sampleTypesToAdd.add(sampleType.getCode());
        if (!this.dryRun) {
            this.commonServer.registerSampleType(this.sessionToken, sampleType);
        }
    }

    @Override
    public void registerDataSetType(DataSetType dataSetType) {
        this.dataSetTypesToAdd.add(dataSetType.getCode());
        if (!this.dryRun) {
            this.commonServer.registerDataSetType(this.sessionToken, dataSetType);
        }
    }

    @Override
    public void registerExperimentType(ExperimentType experimentType) {
        this.experimentTypesToAdd.add(experimentType.getCode());
        if (!this.dryRun) {
            this.commonServer.registerExperimentType(this.sessionToken, experimentType);
        }
    }

    @Override
    public void registerMaterialType(MaterialType materialType) {
        this.materialTypesToAdd.add(materialType.getCode());
        if (!this.dryRun) {
            this.commonServer.registerMaterialType(this.sessionToken, materialType);
        }
    }

    @Override
    public void updateSampleType(EntityType entityType, String diff) {
        this.getEntityTypeSummary(this.sampleTypesToUpdate, entityType.getCode()).update(diff);
        if (!this.dryRun) {
            this.commonServer.updateSampleType(this.sessionToken, entityType);
        }
    }

    @Override
    public void updateDataSetType(EntityType entityType, String diff) {
        this.getEntityTypeSummary(this.dataSetTypesToUpdate, entityType.getCode()).update(diff);
        if (!this.dryRun) {
            this.commonServer.updateDataSetType(this.sessionToken, entityType);
        }
    }

    @Override
    public void updateExperimentType(EntityType entityType, String diff) {
        this.getEntityTypeSummary(this.experimentTypesToUpdate, entityType.getCode()).update(diff);
        if (!this.dryRun) {
            this.commonServer.updateExperimentType(this.sessionToken, entityType);
        }
    }

    @Override
    public void updateMaterialType(EntityType entityType, String diff) {
        this.getEntityTypeSummary(this.materialTypesToUpdate, entityType.getCode()).update(diff);
        if (!this.dryRun) {
            this.commonServer.updateMaterialType(this.sessionToken, entityType);
        }
    }

    @Override
    public void addVocabularyTerms(String vocabularyCode, TechId techId, List<VocabularyTerm> termsToBeAdded) {
        for (VocabularyTerm vocabularyTerm : termsToBeAdded) {
            this.getVocabularySummary(vocabularyCode).add(vocabularyTerm.getCode());
        }
        if (!this.dryRun) {
            this.commonServer.addVocabularyTerms(this.sessionToken, techId, termsToBeAdded, null);
        }
    }

    @Override
    public void createExternalDataManagementSystems(List<ExternalDmsCreation> creations) {
        if (!this.dryRun) {
            this.v3api.createExternalDataManagementSystems(this.sessionToken, creations);
        }
    }

    @Override
    public void updateExternalDataManagementSystems(List<ExternalDmsUpdate> updates) {
        if (!this.dryRun) {
            this.v3api.updateExternalDataManagementSystems(this.sessionToken, updates);
        }
    }

    @Override
    public void printSummary() {
        if (this.verbose) {
            SummaryUtils.printAddedSummary(this.operationLog, this.fileformatTypesToAdd, "file format types");
            this.printUpdatedSummary(this.fileformatTypesToUpdate, "file format types");
            SummaryUtils.printAddedSummary(this.operationLog, this.validationPluginsToAdd, "validation plugins");
            this.printUpdatedSummary(this.validationPluginsToUpdate, "validation plugins");
            SummaryUtils.printAddedSummary(this.operationLog, this.vocabulariesToAdd, "vocabularies");
            this.printUpdateSummary(this.vocabulariesToAdd, this.vocabulariesToUpdate, "vocabularies");
            SummaryUtils.printAddedSummary(this.operationLog, this.propertyTypesToAdd, "property types");
            this.printUpdatedSummary(this.propertyTypesToUpdate, "property types");
            SummaryUtils.printAddedSummary(this.operationLog, this.experimentTypesToAdd, "experiment types");
            this.printUpdateSummary(this.experimentTypesToAdd, this.experimentTypesToUpdate, "experiment types");
            SummaryUtils.printAddedSummary(this.operationLog, this.sampleTypesToAdd, "sample types");
            this.printUpdateSummary(this.sampleTypesToAdd, this.sampleTypesToUpdate, "sample types");
            SummaryUtils.printAddedSummary(this.operationLog, this.dataSetTypesToAdd, "data set types");
            this.printUpdateSummary(this.dataSetTypesToAdd, this.dataSetTypesToUpdate, "data set types");
            SummaryUtils.printAddedSummary(this.operationLog, this.materialTypesToAdd, "material types");
            this.printUpdateSummary(this.materialTypesToAdd, this.materialTypesToUpdate, "material types");
        }
        SummaryUtils.printShortSummaryHeader(this.operationLog);
        SummaryUtils.printShortAddedSummary(this.operationLog, this.fileformatTypesToAdd.size(), "file format types");
        SummaryUtils.printShortUpdatedSummary(this.operationLog, this.fileformatTypesToUpdate.size(), "file format types");
        SummaryUtils.printShortAddedSummary(this.operationLog, this.validationPluginsToAdd.size(), "validation plugins");
        SummaryUtils.printShortUpdatedSummary(this.operationLog, this.validationPluginsToUpdate.size(), "validation plugins");
        SummaryUtils.printShortAddedSummary(this.operationLog, this.vocabulariesToAdd.size(), "vocabularies");
        this.printShortSummary(this.vocabulariesToAdd, this.vocabulariesToUpdate, "vocabularies", "terms");
        SummaryUtils.printShortAddedSummary(this.operationLog, this.propertyTypesToAdd.size(), "property types");
        SummaryUtils.printShortUpdatedSummary(this.operationLog, this.propertyTypesToUpdate.size(), "property types");
        SummaryUtils.printShortAddedSummary(this.operationLog, this.experimentTypesToAdd.size(), "experiment types");
        this.printShortSummary(this.experimentTypesToAdd, this.experimentTypesToUpdate, "experiment types", "property assignments");
        SummaryUtils.printShortAddedSummary(this.operationLog, this.sampleTypesToAdd.size(), "sample types");
        this.printShortSummary(this.sampleTypesToAdd, this.sampleTypesToUpdate, "sample types", "property assignments");
        SummaryUtils.printShortAddedSummary(this.operationLog, this.dataSetTypesToAdd.size(), "data set types");
        this.printShortSummary(this.dataSetTypesToAdd, this.dataSetTypesToUpdate, "data set types", "property assignments");
        SummaryUtils.printShortAddedSummary(this.operationLog, this.materialTypesToAdd.size(), "material types");
        this.printShortSummary(this.materialTypesToAdd, this.materialTypesToUpdate, "material types", "property assignments");
        SummaryUtils.printShortSummaryFooter(this.operationLog);
    }

    private void printShortSummary(Set<String> added, Map<String, UpdateSummary> updates, String type, String subType) {
        int numberOfUpdates = 0;
        int numberOfAdds = 0;
        int numberOfRemoves = 0;
        int numberOfUpdatedItems = 0;
        for (UpdateSummary updateSummary : updates.values()) {
            if (added.contains(updateSummary.getItem())) continue;
            ++numberOfUpdatedItems;
            numberOfUpdates += updateSummary.getNumberOfUpdates();
            numberOfAdds += updateSummary.getNumberOfAdds();
            numberOfRemoves += updateSummary.getNumberOfRemoves();
        }
        SummaryUtils.printShortUpdatedSummary(this.operationLog, numberOfUpdatedItems, type);
        SummaryUtils.printShortAddedSummaryDetail(this.operationLog, numberOfAdds, subType);
        SummaryUtils.printShortUpdatedSummaryDetail(this.operationLog, numberOfUpdates, subType);
        SummaryUtils.printShortRemovedSummaryDetail(this.operationLog, numberOfRemoves, subType);
    }

    private void printUpdateSummary(Set<String> addedEntityTypes, Map<String, UpdateSummary> summaries, String itemType) {
        LinkedList<String> details = new LinkedList<String>();
        for (Map.Entry<String, UpdateSummary> entry : summaries.entrySet()) {
            String entityType = entry.getKey();
            if (addedEntityTypes.contains(entityType)) continue;
            UpdateSummary summary = entry.getValue();
            String diff = summary.getDiff();
            details.add(entityType + " " + (diff == null ? "no basic changes" : diff));
            Map<String, String> assignmentChanges = summary.getChanges();
            for (Map.Entry<String, String> entry2 : assignmentChanges.entrySet()) {
                details.add("    " + entry2.getKey() + ": " + entry2.getValue());
            }
        }
        SummaryUtils.printUpdatedSummary(this.operationLog, details, itemType);
    }

    private void printUpdatedSummary(Map<String, String> map, String type) {
        LinkedList<String> details = new LinkedList<String>();
        for (String key : map.keySet()) {
            details.add(key + " - " + map.get(key));
        }
        SummaryUtils.printUpdatedSummary(this.operationLog, details, type);
    }

    private UpdateSummary getEntityTypeSummary(Map<String, UpdateSummary> summariesByType, String entityTypeCode) {
        UpdateSummary summary = summariesByType.get(entityTypeCode);
        if (summary == null) {
            summary = new UpdateSummary(entityTypeCode);
            summariesByType.put(entityTypeCode, summary);
        }
        return summary;
    }

    private UpdateSummary getVocabularySummary(String vocabularyCode) {
        UpdateSummary vocabularySummary = this.vocabulariesToUpdate.get(vocabularyCode);
        if (vocabularySummary == null) {
            vocabularySummary = new UpdateSummary(vocabularyCode);
            this.vocabulariesToUpdate.put(vocabularyCode, vocabularySummary);
        }
        return vocabularySummary;
    }

    private static final class UpdateSummary {
        private final String item;
        private String diff;
        private Map<String, String> changes = new TreeMap<String, String>();
        private int numberOfUpdates;
        private int numberOfAdds;
        private int numberOfRemoves;

        public UpdateSummary(String item) {
            this.item = item;
        }

        void update(String diff) {
            this.diff = diff;
        }

        void update(String item, String diff) {
            this.changes.put(item, diff);
            ++this.numberOfUpdates;
        }

        void add(String item) {
            this.changes.put(item, "ADDED");
            ++this.numberOfAdds;
        }

        void remove(String item) {
            this.changes.put(item, "REMOVED");
            ++this.numberOfRemoves;
        }

        public String getItem() {
            return this.item;
        }

        public String getDiff() {
            return this.diff;
        }

        public Map<String, String> getChanges() {
            return this.changes;
        }

        public int getNumberOfUpdates() {
            return this.numberOfUpdates;
        }

        public int getNumberOfAdds() {
            return this.numberOfAdds;
        }

        public int getNumberOfRemoves() {
            return this.numberOfRemoves;
        }
    }
}

