/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.parallelizedExecutor;

import ch.ethz.sis.openbis.generic.asapi.v3.IApplicationServerApi;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.attachment.Attachment;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.attachment.create.AttachmentCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.attachment.fetchoptions.AttachmentFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.attachment.id.AttachmentFileName;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.attachment.id.IAttachmentId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.attachment.update.AttachmentListUpdateValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IAttachmentsHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IPermIdHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.fetchoptions.ExperimentFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.ExperimentPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.IExperimentId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.update.ExperimentUpdate;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.fetchoptions.ProjectFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.id.IProjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.id.ProjectPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.update.ProjectUpdate;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.fetchoptions.SampleFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.ISampleId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.SamplePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.update.SampleUpdate;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.common.SyncEntityKind;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.IncomingEntity;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.parallelizedExecutor.AttachmentSynchronizationSummary;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.util.Monitor;
import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.concurrent.ITaskExecutor;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public class AttachmentsSynchronizer
implements ITaskExecutor<List<IncomingEntity<?>>> {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, AttachmentsSynchronizer.class);
    private Map<SyncEntityKind, AbstractHandler> handlersByEntityKind = new HashMap<SyncEntityKind, AbstractHandler>();

    public AttachmentsSynchronizer(IApplicationServerApi v3api, String sessionToken, IApplicationServerApi v3apiDataSource, String sessionTokenDataSource, Date lastSyncTimestamp, AttachmentSynchronizationSummary synchronizationSummary, boolean dryRun, Monitor monitor) {
        this.handlersByEntityKind.put(SyncEntityKind.PROJECT, new ProjectsHandler(dryRun));
        this.handlersByEntityKind.put(SyncEntityKind.EXPERIMENT, new ExperimentsHandler(dryRun));
        this.handlersByEntityKind.put(SyncEntityKind.SAMPLE, new SamplesHandler(dryRun));
        Collection<AbstractHandler> values = this.handlersByEntityKind.values();
        for (AbstractHandler handler : values) {
            handler.setV3api(v3api);
            handler.setSessionToken(sessionToken);
            handler.setV3apiDataSource(v3apiDataSource);
            handler.setSessionTokenDataSource(sessionTokenDataSource);
            handler.setLastSyncTimestamp(lastSyncTimestamp);
            handler.setSynchronizationSummary(synchronizationSummary);
            handler.setMonitor(monitor);
        }
    }

    public Status execute(List<IncomingEntity<?>> entities) {
        try {
            Map<SyncEntityKind, List<IncomingEntity<?>>> entitiesByEntityKind = this.segregateEntitiesByEntityKind(entities);
            Set<Map.Entry<SyncEntityKind, List<IncomingEntity<?>>>> entrySet = entitiesByEntityKind.entrySet();
            for (Map.Entry<SyncEntityKind, List<IncomingEntity<?>>> entry : entrySet) {
                this.handlersByEntityKind.get((Object)entry.getKey()).handle(entry.getValue());
            }
        }
        catch (Exception e) {
            operationLog.error((Object)"Attachment synchronization failed", (Throwable)e);
            return Status.createError((String)("Attachment synchronization failed: " + e.getMessage()));
        }
        return Status.OK;
    }

    private Map<SyncEntityKind, List<IncomingEntity<?>>> segregateEntitiesByEntityKind(List<IncomingEntity<?>> entities) {
        HashMap map = new HashMap();
        for (IncomingEntity<?> entity : entities) {
            ArrayList list = (ArrayList)map.get((Object)entity.getEntityKind());
            if (list == null) {
                list = new ArrayList();
                map.put(entity.getEntityKind(), list);
            }
            list.add(entity);
        }
        return map;
    }

    private static final class AttachmentChange {
        private Attachment attachment;
        private String permId;
        private boolean remove;
        private Integer version;

        AttachmentChange(Attachment attachment, String permId, boolean remove, Integer version) {
            this.attachment = attachment;
            this.permId = permId;
            this.remove = remove;
            this.version = version;
        }

        public Attachment getAttachment() {
            return this.attachment;
        }

        public String getPermId() {
            return this.permId;
        }

        public boolean isRemove() {
            return this.remove;
        }

        public Integer getVersion() {
            return this.version;
        }
    }

    private static final class SamplesHandler
    extends AbstractHandler {
        public SamplesHandler(boolean dryRun) {
            super(dryRun, SyncEntityKind.SAMPLE);
        }

        @Override
        protected <AH extends IPermIdHolder & IAttachmentsHolder> Collection<AH> getAttachments(IApplicationServerApi v3api, String sessionToken, List<String> permIds) {
            List ids = permIds.stream().map(SamplePermId::new).collect(Collectors.toList());
            SampleFetchOptions fetchOptions = new SampleFetchOptions();
            this.specifiyAttachmentFetchOptions(fetchOptions.withAttachments());
            return v3api.getSamples(sessionToken, ids, fetchOptions).values();
        }

        @Override
        protected void handleAttachments(Map<String, AttachmentListUpdateValue> attachmentsByPermId) {
            ArrayList<SampleUpdate> updates = new ArrayList<SampleUpdate>();
            for (Map.Entry<String, AttachmentListUpdateValue> entry : attachmentsByPermId.entrySet()) {
                SampleUpdate sampleUpdate = new SampleUpdate();
                sampleUpdate.setSampleId((ISampleId)new SamplePermId(entry.getKey()));
                sampleUpdate.getAttachments().setActions(entry.getValue().getActions());
                updates.add(sampleUpdate);
            }
            if (this.dryRun) {
                return;
            }
            this.v3api.updateSamples(this.sessionToken, updates);
        }
    }

    private static final class ExperimentsHandler
    extends AbstractHandler {
        public ExperimentsHandler(boolean dryRun) {
            super(dryRun, SyncEntityKind.EXPERIMENT);
        }

        @Override
        protected <AH extends IPermIdHolder & IAttachmentsHolder> Collection<AH> getAttachments(IApplicationServerApi v3api, String sessionToken, List<String> permIds) {
            List ids = permIds.stream().map(ExperimentPermId::new).collect(Collectors.toList());
            ExperimentFetchOptions fetchOptions = new ExperimentFetchOptions();
            this.specifiyAttachmentFetchOptions(fetchOptions.withAttachments());
            return v3api.getExperiments(sessionToken, ids, fetchOptions).values();
        }

        @Override
        protected void handleAttachments(Map<String, AttachmentListUpdateValue> attachmentsByPermId) {
            ArrayList<ExperimentUpdate> updates = new ArrayList<ExperimentUpdate>();
            for (Map.Entry<String, AttachmentListUpdateValue> entry : attachmentsByPermId.entrySet()) {
                ExperimentUpdate experimentUpdate = new ExperimentUpdate();
                experimentUpdate.setExperimentId((IExperimentId)new ExperimentPermId(entry.getKey()));
                experimentUpdate.getAttachments().setActions(entry.getValue().getActions());
                updates.add(experimentUpdate);
            }
            if (this.dryRun) {
                return;
            }
            this.v3api.updateExperiments(this.sessionToken, updates);
        }
    }

    private static final class ProjectsHandler
    extends AbstractHandler {
        public ProjectsHandler(boolean dryRun) {
            super(dryRun, SyncEntityKind.PROJECT);
        }

        @Override
        protected <AH extends IPermIdHolder & IAttachmentsHolder> Collection<AH> getAttachments(IApplicationServerApi v3api, String sessionToken, List<String> permIds) {
            List ids = permIds.stream().map(ProjectPermId::new).collect(Collectors.toList());
            ProjectFetchOptions fetchOptions = new ProjectFetchOptions();
            this.specifiyAttachmentFetchOptions(fetchOptions.withAttachments());
            return v3api.getProjects(sessionToken, ids, fetchOptions).values();
        }

        @Override
        protected void handleAttachments(Map<String, AttachmentListUpdateValue> attachmentsByPermId) {
            ArrayList<ProjectUpdate> updates = new ArrayList<ProjectUpdate>();
            for (Map.Entry<String, AttachmentListUpdateValue> entry : attachmentsByPermId.entrySet()) {
                ProjectUpdate projectUpdate = new ProjectUpdate();
                projectUpdate.setProjectId((IProjectId)new ProjectPermId(entry.getKey()));
                projectUpdate.getAttachments().setActions(entry.getValue().getActions());
                updates.add(projectUpdate);
            }
            if (this.dryRun) {
                return;
            }
            this.v3api.updateProjects(this.sessionToken, updates);
        }
    }

    private static abstract class AbstractHandler {
        protected IApplicationServerApi v3api;
        protected String sessionToken;
        protected IApplicationServerApi v3apiDataSource;
        protected String sessionTokenDataSource;
        protected Date lastSyncTimestamp;
        protected AttachmentSynchronizationSummary synchronizationSummary;
        protected Monitor monitor;
        protected SyncEntityKind entityKind;
        protected boolean dryRun;

        AbstractHandler(boolean dryRun, SyncEntityKind entityKind) {
            this.dryRun = dryRun;
            this.entityKind = entityKind;
        }

        public void setV3api(IApplicationServerApi v3api) {
            this.v3api = v3api;
        }

        public void setSessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
        }

        public void setV3apiDataSource(IApplicationServerApi v3apiDataSource) {
            this.v3apiDataSource = v3apiDataSource;
        }

        public void setSessionTokenDataSource(String sessionTokenDataSource) {
            this.sessionTokenDataSource = sessionTokenDataSource;
        }

        public void setLastSyncTimestamp(Date lastSyncTimestamp) {
            this.lastSyncTimestamp = lastSyncTimestamp;
        }

        public void setSynchronizationSummary(AttachmentSynchronizationSummary synchronizationSummary) {
            this.synchronizationSummary = synchronizationSummary;
        }

        public void setMonitor(Monitor monitor) {
            this.monitor = monitor;
        }

        private void log(List<IncomingEntity<?>> entities, int numberOfEntitiesWithAttachments, int totalNumberOfEntities, String description) {
            List ids = entities.stream().map(IncomingEntity::getIdentifier).collect(Collectors.toList());
            String idsAsString = CollectionUtils.abbreviate(ids, (int)20);
            this.monitor.log(String.format("%4d (of %4d) %ss %s. %s", new Object[]{numberOfEntitiesWithAttachments, totalNumberOfEntities, this.entityKind, description, idsAsString}));
        }

        public <AH extends IPermIdHolder & IAttachmentsHolder> void handle(List<IncomingEntity<?>> entities) {
            List<IncomingEntity<?>> filteredEntities = entities.stream().filter(e -> e.hasAttachments()).collect(Collectors.toList());
            if (filteredEntities.isEmpty()) {
                return;
            }
            this.log(filteredEntities, filteredEntities.size(), entities.size(), "with attachments on data source");
            Map<String, Map<String, Attachment>> existingAttachments = this.retrievAttachments(this.v3api, this.sessionToken, entities);
            this.log(entities, existingAttachments.size(), entities.size(), "on harvester");
            Map<String, Map<String, Attachment>> attachmentsFromDataSource = this.retrievAttachments(this.v3apiDataSource, this.sessionTokenDataSource, filteredEntities);
            ArrayList<AttachmentChange> attachmentChanges = new ArrayList<AttachmentChange>();
            for (Map.Entry<String, Map<String, Attachment>> entry : attachmentsFromDataSource.entrySet()) {
                String permId = entry.getKey();
                Map<String, Attachment> existingAttachmentsByFile = existingAttachments.get(permId);
                if (existingAttachmentsByFile == null) {
                    throw new RuntimeException("Severe error: Entity with permId " + permId + " should exist because it has been just registered on the harvester openBIS instance.");
                }
                Map<String, Attachment> attachmentsFromDataSourceByFile = entry.getValue();
                Collection<Attachment> values = attachmentsFromDataSourceByFile.values();
                for (Attachment attachmentFromDataSource : values) {
                    int version;
                    String fileName = attachmentFromDataSource.getFileName();
                    Attachment existingAttachment = existingAttachmentsByFile.get(fileName);
                    int n = version = existingAttachment == null ? 0 : existingAttachment.getVersion();
                    if (attachmentFromDataSource.getVersion() < version) {
                        attachmentChanges.add(new AttachmentChange(attachmentFromDataSource, permId, true, 0));
                        this.synchronizationSummary.updatedCount.getAndIncrement();
                        continue;
                    }
                    if (attachmentFromDataSource.getVersion() == version) {
                        if (!attachmentFromDataSource.getRegistrationDate().after(this.lastSyncTimestamp) && this.equals(attachmentFromDataSource.getTitle(), existingAttachment.getTitle()) && this.equals(attachmentFromDataSource.getDescription(), existingAttachment.getDescription())) continue;
                        attachmentChanges.add(new AttachmentChange(attachmentFromDataSource, permId, true, 0));
                        this.synchronizationSummary.updatedCount.getAndIncrement();
                        continue;
                    }
                    attachmentChanges.add(new AttachmentChange(attachmentFromDataSource, permId, false, version));
                    this.synchronizationSummary.addedCount.getAndIncrement();
                }
                for (Attachment existingAttachment : existingAttachmentsByFile.values()) {
                    if (attachmentsFromDataSourceByFile.get(existingAttachment.getFileName()) != null) continue;
                    attachmentChanges.add(new AttachmentChange(existingAttachment, permId, true, null));
                    this.synchronizationSummary.deletedCount.getAndIncrement();
                }
            }
            this.handleAttachmentChanges(attachmentChanges);
        }

        private <AH extends IPermIdHolder & IAttachmentsHolder> Map<String, Map<String, Attachment>> retrievAttachments(IApplicationServerApi v3api, String sessionToken, List<IncomingEntity<?>> entities) {
            List<String> ids = entities.stream().map(IncomingEntity::getPermID).collect(Collectors.toList());
            HashMap<String, Map<String, Attachment>> attachmentsByPermId = new HashMap<String, Map<String, Attachment>>();
            Collection<AH> attachmentHolders = this.getAttachments(v3api, sessionToken, ids);
            for (IPermIdHolder attachmentHolder : attachmentHolders) {
                attachmentsByPermId.put(attachmentHolder.getPermId().toString(), ((IAttachmentsHolder)attachmentHolder).getAttachments().stream().collect(Collectors.toMap(Attachment::getFileName, Function.identity())));
            }
            return attachmentsByPermId;
        }

        protected abstract <AH extends IPermIdHolder & IAttachmentsHolder> Collection<AH> getAttachments(IApplicationServerApi var1, String var2, List<String> var3);

        private void handleAttachmentChanges(List<AttachmentChange> attachmentChanges) {
            HashMap<String, AttachmentListUpdateValue> attachmentUpdatesByPermId = new HashMap<String, AttachmentListUpdateValue>();
            for (AttachmentChange attachmentChange : attachmentChanges) {
                Integer version;
                String permId = attachmentChange.getPermId();
                AttachmentListUpdateValue attachmentListUpdate = (AttachmentListUpdateValue)attachmentUpdatesByPermId.get(permId);
                if (attachmentListUpdate == null) {
                    attachmentListUpdate = new AttachmentListUpdateValue();
                    attachmentUpdatesByPermId.put(permId, attachmentListUpdate);
                }
                Attachment attachment = attachmentChange.getAttachment();
                if (attachmentChange.isRemove()) {
                    attachmentListUpdate.remove((Object[])new IAttachmentId[]{new AttachmentFileName(attachment.getFileName())});
                }
                if ((version = attachmentChange.getVersion()) == null) continue;
                this.addAttachments(attachmentListUpdate, attachment, version);
            }
            this.handleAttachments(attachmentUpdatesByPermId);
        }

        private void addAttachments(AttachmentListUpdateValue attachmentListUpdate, Attachment attachment, int fromVersion) {
            ArrayList<AttachmentCreation> attachmentCreations = new ArrayList<AttachmentCreation>();
            for (int i = attachment.getVersion().intValue(); i > fromVersion; --i) {
                AttachmentCreation attachmentCreation = new AttachmentCreation();
                attachmentCreation.setFileName(attachment.getFileName());
                attachmentCreation.setTitle(attachment.getTitle());
                attachmentCreation.setDescription(attachment.getDescription());
                attachmentCreation.setContent(attachment.getContent());
                attachmentCreations.add(attachmentCreation);
                if (!attachment.getFetchOptions().hasPreviousVersion()) continue;
                attachment = attachment.getPreviousVersion();
            }
            Collections.reverse(attachmentCreations);
            attachmentListUpdate.add((Object[])attachmentCreations.toArray(new AttachmentCreation[0]));
        }

        protected abstract void handleAttachments(Map<String, AttachmentListUpdateValue> var1);

        protected void specifiyAttachmentFetchOptions(AttachmentFetchOptions attachmentFetchOptions) {
            attachmentFetchOptions.withContent();
            attachmentFetchOptions.withPreviousVersion().withPreviousVersionUsing(attachmentFetchOptions);
            attachmentFetchOptions.withPreviousVersion().withContentUsing(attachmentFetchOptions.withContent());
        }

        private boolean equals(Object o1, Object o2) {
            return o1 == null ? o1 == o2 : o1.equals(o2);
        }
    }
}

