/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.parallelizedExecutor;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.create.DataSetCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.DataSetPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.IDataSetId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.id.EntityTypePermId;
import ch.ethz.sis.openbis.generic.dssapi.v3.dto.datasetfile.fastdownload.FastDownloadSession;
import ch.ethz.sis.openbis.generic.dssapi.v3.dto.datasetfile.fastdownload.FastDownloadSessionOptions;
import ch.ethz.sis.openbis.generic.dssapi.v3.dto.datasetfile.id.DataSetFilePermId;
import ch.ethz.sis.openbis.generic.dssapi.v3.fastdownload.FastDownloader;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.config.SyncConfig;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.util.DSPropertyUtils;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.util.V3Facade;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.etlserver.registrator.api.v2.IDataSet;
import ch.systemsx.cisd.etlserver.registrator.api.v2.IDataSetRegistrationTransactionV2;
import ch.systemsx.cisd.etlserver.registrator.api.v2.IDataSetUpdatable;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.IngestionService;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetProcessingContext;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.IExperimentImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.ISampleImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewProperty;
import ch.systemsx.cisd.openbis.generic.shared.util.IRowBuilder;
import ch.systemsx.cisd.openbis.generic.shared.util.SimpleTableModelBuilder;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.log4j.Logger;

class DataSetRegistrationIngestionService
extends IngestionService<DataSetInformation> {
    private static final long serialVersionUID = 1L;
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, DataSetRegistrationIngestionService.class);
    private final DataSetCreation dataSet;
    private final String harvesterTempDir;
    private SyncConfig config;

    public DataSetRegistrationIngestionService(SyncConfig config, File storeRoot, DataSetCreation dataSetCreation, Logger operationLog) {
        super(DataSetRegistrationIngestionService.createIngestionServiceProperties(), storeRoot);
        this.config = config;
        this.dataSet = dataSetCreation;
        this.harvesterTempDir = config.getHarvesterTempDir();
    }

    private static Properties createIngestionServiceProperties() {
        Properties properties = new Properties();
        properties.setProperty("do-not-create-original-dir", "true");
        return properties;
    }

    @Override
    protected TableModel process(IDataSetRegistrationTransactionV2 transaction, Map<String, Object> parameters, DataSetProcessingContext context) {
        ISampleImmutable sample = this.getSampleForUpdate(transaction);
        IExperimentImmutable experiment = this.getExperimentForUpdate(transaction);
        List<NewProperty> dataSetProperties = this.getProperties(this.dataSet);
        String dataSetCode = this.dataSet.getCode();
        if (transaction.getSearchService().getDataSet(dataSetCode) == null) {
            transaction.setUserId(this.config.getHarvesterUser());
            File storeRoot = transaction.getGlobalState().getStoreRootDir();
            File temp = new File(storeRoot, this.harvesterTempDir);
            temp.mkdirs();
            File dir = new File(temp, dataSetCode);
            dir.mkdirs();
            try {
                this.downloadDataSetFiles(temp, dataSetCode);
            }
            catch (Exception e) {
                return this.errorTableModel(parameters, e);
            }
            if (!this.config.isDryRun()) {
                String dataSetType = ((EntityTypePermId)this.dataSet.getTypeId()).getPermId();
                IDataSet ds = transaction.createNewDataSet(dataSetType, dataSetCode);
                ds.setDataSetKind(DataSetKind.valueOf((String)this.dataSet.getDataSetKind().toString()));
                ds.setSample(sample);
                ds.setExperiment(experiment);
                for (NewProperty newProperty : dataSetProperties) {
                    ds.setPropertyValue(newProperty.getPropertyCode(), newProperty.getValue());
                }
                for (File f : dir.listFiles()) {
                    transaction.moveFile(f.getAbsolutePath(), ds);
                }
            }
            return this.summaryTableModel(parameters, "Added");
        }
        if (!this.config.isDryRun()) {
            IDataSetUpdatable dataSetForUpdate = transaction.getDataSetForUpdate(dataSetCode);
            dataSetForUpdate.setSample(sample);
            dataSetForUpdate.setExperiment(experiment);
            List parentIds = this.dataSet.getParentIds();
            if (parentIds != null) {
                dataSetForUpdate.setParentDatasets(parentIds.stream().map(Object::toString).collect(Collectors.toList()));
            }
            List<String> existingPropertyCodes = dataSetForUpdate.getAllPropertyCodes();
            Set<String> newPropertyCodes = DSPropertyUtils.extractPropertyNames(dataSetProperties);
            for (NewProperty newProperty : dataSetProperties) {
                dataSetForUpdate.setPropertyValue(newProperty.getPropertyCode(), newProperty.getValue());
            }
            existingPropertyCodes.removeAll(newPropertyCodes);
            for (String propCode : existingPropertyCodes) {
                dataSetForUpdate.setPropertyValue(propCode, "");
            }
        }
        return this.summaryTableModel(parameters, "Updated");
    }

    private IExperimentImmutable getExperimentForUpdate(IDataSetRegistrationTransactionV2 transaction) {
        if (this.dataSet.getExperimentId() != null && !this.config.isDryRun()) {
            return transaction.getExperimentForUpdate(this.dataSet.getExperimentId().toString());
        }
        return null;
    }

    private ISampleImmutable getSampleForUpdate(IDataSetRegistrationTransactionV2 transaction) {
        if (this.dataSet.getSampleId() != null && !this.config.isDryRun()) {
            return transaction.getSampleForUpdate(this.dataSet.getSampleId().toString());
        }
        return null;
    }

    private List<NewProperty> getProperties(DataSetCreation metadata) {
        return metadata.getProperties().entrySet().stream().map(e -> new NewProperty((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
    }

    @Override
    protected TableModel errorTableModel(Map<String, Object> parameters, Throwable e) {
        operationLog.error((Object)("Error occurred while registering data set " + this.dataSet.getCode()), e);
        return super.errorTableModel(parameters, e);
    }

    private TableModel summaryTableModel(Map<String, Object> parameters, String summary) {
        SimpleTableModelBuilder builder = new SimpleTableModelBuilder(true);
        builder.addHeader("Parameters");
        builder.addHeader(summary);
        IRowBuilder row = builder.addRow();
        row.setCell("Parameters", parameters.toString());
        return builder.getTableModel();
    }

    private void downloadDataSetFiles(File dir, String dataSetCode) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        V3Facade v3Facade = new V3Facade(this.config);
        FastDownloadSessionOptions options = new FastDownloadSessionOptions();
        options.withWishedNumberOfStreams(this.config.getWishedNumberOfStreams());
        DataSetFilePermId filePermId = new DataSetFilePermId((IDataSetId)new DataSetPermId(dataSetCode));
        FastDownloadSession downloadSession = v3Facade.createFastDownloadSession(Arrays.asList(filePermId), options);
        new FastDownloader(downloadSession).downloadTo(dir);
        operationLog.info((Object)("Download time for data set " + dataSetCode + " to " + dir + ": " + stopWatch));
    }
}

