/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.parallelizedExecutor;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.create.DataSetCreation;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.config.SyncConfig;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.parallelizedExecutor.DataSetRegistrationIngestionService;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.parallelizedExecutor.DataSetSynchronizationSummary;
import ch.systemsx.cisd.common.concurrent.ITaskExecutor;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetProcessingContext;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelColumnHeader;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRow;
import java.io.File;
import java.util.HashMap;
import org.apache.log4j.Logger;

public final class DataSetRegistrationTaskExecutor
implements ITaskExecutor<DataSetCreation> {
    private final File storeRoot;
    private final DataSetProcessingContext context;
    private final Logger operationLog;
    private DataSetSynchronizationSummary dsRegistrationSummary;
    private final SyncConfig config;

    public DataSetRegistrationTaskExecutor(DataSetSynchronizationSummary dsRegSummary, Logger operationLog, File storeRoot, DataSetProcessingContext context, SyncConfig config) {
        this.dsRegistrationSummary = dsRegSummary;
        this.operationLog = operationLog;
        this.storeRoot = storeRoot;
        this.context = context;
        this.config = config;
    }

    public Status execute(DataSetCreation dataSet) {
        DataSetRegistrationIngestionService ingestionService = new DataSetRegistrationIngestionService(this.config, this.storeRoot, dataSet, this.operationLog);
        TableModel resultTable = ingestionService.createAggregationReport(new HashMap<String, Object>(), this.context);
        if (resultTable != null) {
            for (TableModelColumnHeader header : resultTable.getHeader()) {
                if (header.getTitle().startsWith("Error")) {
                    String message = ((TableModelRow)resultTable.getRows().get(0)).getValues().toString();
                    this.dsRegistrationSummary.notRegisteredDataSetCodes.add(dataSet.getCode());
                    this.operationLog.error((Object)("Registration for data set " + dataSet.getCode() + " failed: " + message + ", exp: " + dataSet.getExperimentId() + ", sample:" + dataSet.getSampleId()));
                    return Status.createError((String)message);
                }
                if (header.getTitle().startsWith("Added")) {
                    this.dsRegistrationSummary.createdDataSets.add(dataSet.getCode());
                    continue;
                }
                if (!header.getTitle().startsWith("Updated")) continue;
                this.dsRegistrationSummary.updatedDataSets.add(dataSet.getCode());
            }
        }
        return Status.OK;
    }
}

