/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.translator;

import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.translator.INameTranslator;
import org.apache.commons.lang3.StringUtils;

public class PrefixBasedNameTranslator
implements INameTranslator {
    private final String prefix;

    public PrefixBasedNameTranslator(String prefix) {
        this.prefix = prefix + "_";
    }

    private String translateInternal(String name) {
        return this.prefix + name;
    }

    private String translateBackInternal(String name) {
        return name.startsWith(this.prefix) ? name.substring(this.prefix.length()) : name;
    }

    @Override
    public String translate(String name) {
        assert (!StringUtils.isBlank((CharSequence)name)) : "Prefix translation can only be done for non-null values";
        if (name.startsWith("$")) {
            return "$" + this.translateInternal(name.substring("$".length()));
        }
        return this.translateInternal(name);
    }

    @Override
    public String translateBack(String name) {
        if (name.startsWith("$")) {
            return "$" + this.translateBackInternal(name.substring("$".length()));
        }
        return this.translateBackInternal(name);
    }
}

