/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.util;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.builders.PropertyBuilder;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewProperty;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;

public class DSPropertyUtils {
    public static Set<String> extractPropertyNames(List<NewProperty> dataSetProperties) {
        HashSet<String> existingPropertyNames = new HashSet<String>();
        for (NewProperty prop : dataSetProperties) {
            existingPropertyNames.add(prop.getPropertyCode());
        }
        return existingPropertyNames;
    }

    public static IEntityProperty[] convertToEntityProperty(List<NewProperty> dataSetProperties) {
        ArrayList<EntityProperty> list = new ArrayList<EntityProperty>();
        for (NewProperty prop : dataSetProperties) {
            String propertyCode = prop.getPropertyCode();
            String value = prop.getValue();
            list.add(new PropertyBuilder(propertyCode).value(value).getProperty());
        }
        return list.toArray(new IEntityProperty[list.size()]);
    }

    public static Date convertFromW3CDate(String dateStr) {
        if (dateStr == null) {
            return null;
        }
        try {
            SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.US);
            df1.setTimeZone(TimeZone.getTimeZone("GMT"));
            return df1.parse(dateStr);
        }
        catch (ParseException e) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)e);
        }
    }
}

