/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.util;

import ch.systemsx.cisd.common.filesystem.FileUtilities;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.log4j.Logger;

public class Monitor {
    private String name;
    private Logger operationLog;
    private StopWatch stopWatch;

    public Monitor(String name, Logger operationLog) {
        this.name = name;
        this.operationLog = operationLog;
        this.stopWatch = new StopWatch();
        this.stopWatch.start();
        operationLog.info((Object)("-------- monitoring started for '" + name + "'."));
    }

    public void log() {
        this.logInfo(this.createReport());
    }

    public void log(String message) {
        this.logInfo(this.createReport() + " " + message);
    }

    private void logInfo(String info) {
        this.operationLog.info((Object)("[" + this.name + "] " + info));
    }

    private String createReport() {
        Runtime runtime = Runtime.getRuntime();
        String max = FileUtilities.byteCountToDisplaySize((long)runtime.maxMemory());
        String free = FileUtilities.byteCountToDisplaySize((long)runtime.freeMemory());
        String used = FileUtilities.byteCountToDisplaySize((long)(runtime.maxMemory() - runtime.freeMemory()));
        long time = this.stopWatch.getTime(TimeUnit.SECONDS);
        return String.format("[time: %5d sec, used: %9s, free: %9s, max: %9s]", time, used, free, max);
    }
}

