/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.util;

import ch.ethz.sis.openbis.generic.asapi.v3.IApplicationServerApi;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.attachment.Attachment;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.SearchResult;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.Experiment;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.fetchoptions.ExperimentFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.IExperimentId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.Project;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.fetchoptions.ProjectFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.id.IProjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.Sample;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.fetchoptions.SampleFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.ISampleId;
import ch.ethz.sis.openbis.generic.dssapi.v3.IDataStoreServerApi;
import ch.ethz.sis.openbis.generic.dssapi.v3.dto.datasetfile.DataSetFile;
import ch.ethz.sis.openbis.generic.dssapi.v3.dto.datasetfile.download.DataSetFileDownloadOptions;
import ch.ethz.sis.openbis.generic.dssapi.v3.dto.datasetfile.fastdownload.FastDownloadSession;
import ch.ethz.sis.openbis.generic.dssapi.v3.dto.datasetfile.fastdownload.FastDownloadSessionOptions;
import ch.ethz.sis.openbis.generic.dssapi.v3.dto.datasetfile.fetchoptions.DataSetFileFetchOptions;
import ch.ethz.sis.openbis.generic.dssapi.v3.dto.datasetfile.id.IDataSetFileId;
import ch.ethz.sis.openbis.generic.dssapi.v3.dto.datasetfile.search.DataSetFileSearchCriteria;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.config.SyncConfig;
import ch.ethz.sis.openbis.generic.server.dss.plugins.sync.harvester.synchronizer.util.ServiceUtils;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class V3Facade {
    private final IDataStoreServerApi dss;
    private final IApplicationServerApi as;
    private final String sessionToken;

    public V3Facade(SyncConfig config) {
        this.as = ServiceUtils.createAsV3Api(config.getDataSourceOpenbisURL());
        this.dss = ServiceUtils.createDssV3Api(config.getDataSourceDSSURL());
        this.sessionToken = this.as.login(config.getUser(), config.getPassword());
    }

    public SearchResult<DataSetFile> searchFiles(DataSetFileSearchCriteria criteria, DataSetFileFetchOptions dsFileFetchOptions) {
        return this.dss.searchFiles(this.sessionToken, criteria, dsFileFetchOptions);
    }

    public SearchResult<DataSetFile> searchWithDataSetCode(String dataSetCode, DataSetFileFetchOptions dsFileFetchOptions) {
        DataSetFileSearchCriteria criteria = new DataSetFileSearchCriteria();
        criteria.withDataSet().withCode().thatEquals(dataSetCode);
        return this.searchFiles(criteria, dsFileFetchOptions);
    }

    public List<Attachment> getExperimentAttachments(IExperimentId experimentId) {
        ExperimentFetchOptions fetchOptions = new ExperimentFetchOptions();
        fetchOptions.withAttachments().withContent();
        fetchOptions.withAttachments().withPreviousVersion().withPreviousVersionUsing(fetchOptions.withAttachments());
        fetchOptions.withAttachments().withPreviousVersion().withContentUsing(fetchOptions.withAttachments().withContent());
        Map experiments = this.as.getExperiments(this.sessionToken, Arrays.asList(experimentId), fetchOptions);
        if (experiments.size() == 1) {
            Experiment experiment = (Experiment)experiments.get(experimentId);
            return experiment.getAttachments();
        }
        return null;
    }

    public List<Attachment> getSampleAttachments(ISampleId sampleId) {
        SampleFetchOptions fetchOptions = new SampleFetchOptions();
        fetchOptions.withAttachments().withContent();
        fetchOptions.withAttachments().withPreviousVersion().withPreviousVersionUsing(fetchOptions.withAttachments());
        fetchOptions.withAttachments().withPreviousVersion().withContentUsing(fetchOptions.withAttachments().withContent());
        Map samples = this.as.getSamples(this.sessionToken, Arrays.asList(sampleId), fetchOptions);
        if (samples.size() == 1) {
            Sample sample = (Sample)samples.get(sampleId);
            return sample.getAttachments();
        }
        return null;
    }

    public List<Attachment> getProjectAttachments(IProjectId projectId) {
        ProjectFetchOptions fetchOptions = new ProjectFetchOptions();
        fetchOptions.withAttachments().withContent();
        fetchOptions.withAttachments().withPreviousVersion().withPreviousVersionUsing(fetchOptions.withAttachments());
        fetchOptions.withAttachments().withPreviousVersion().withContentUsing(fetchOptions.withAttachments().withContent());
        Map projects = this.as.getProjects(this.sessionToken, Arrays.asList(projectId), fetchOptions);
        if (projects.size() == 1) {
            Project project = (Project)projects.get(projectId);
            return project.getAttachments();
        }
        return null;
    }

    public InputStream downloadFiles(List<IDataSetFileId> fileIds, DataSetFileDownloadOptions options) {
        return this.dss.downloadFiles(this.sessionToken, fileIds, options);
    }

    public FastDownloadSession createFastDownloadSession(List<? extends IDataSetFileId> fileIds, FastDownloadSessionOptions options) {
        return this.dss.createFastDownloadSession(this.sessionToken, fileIds, options);
    }
}

