/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.dssapi.v3;

import ch.ethz.sis.openbis.generic.asapi.v3.IApplicationServerApi;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.SearchOperator;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.SearchResult;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.DataSet;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.create.DataSetCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.fetchoptions.DataSetFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.DataSetPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.IDataSetId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.search.DataSetSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.datastore.id.DataStorePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.datastore.id.IDataStoreId;
import ch.ethz.sis.openbis.generic.dssapi.v3.IDataStoreServerApi;
import ch.ethz.sis.openbis.generic.dssapi.v3.dto.dataset.create.FullDataSetCreation;
import ch.ethz.sis.openbis.generic.dssapi.v3.dto.dataset.create.UploadedDataSetCreation;
import ch.ethz.sis.openbis.generic.dssapi.v3.dto.datasetfile.DataSetFile;
import ch.ethz.sis.openbis.generic.dssapi.v3.dto.datasetfile.download.DataSetFileDownloadOptions;
import ch.ethz.sis.openbis.generic.dssapi.v3.dto.datasetfile.fastdownload.FastDownloadSession;
import ch.ethz.sis.openbis.generic.dssapi.v3.dto.datasetfile.fastdownload.FastDownloadSessionOptions;
import ch.ethz.sis.openbis.generic.dssapi.v3.dto.datasetfile.fetchoptions.DataSetFileFetchOptions;
import ch.ethz.sis.openbis.generic.dssapi.v3.dto.datasetfile.id.DataSetFilePermId;
import ch.ethz.sis.openbis.generic.dssapi.v3.dto.datasetfile.id.IDataSetFileId;
import ch.ethz.sis.openbis.generic.dssapi.v3.dto.datasetfile.search.DataSetFileSearchCriteria;
import ch.ethz.sis.openbis.generic.server.dssapi.v3.DataStoreServerApiLogger;
import ch.ethz.sis.openbis.generic.server.dssapi.v3.Utils;
import ch.ethz.sis.openbis.generic.server.dssapi.v3.download.DataSetFileDownloadInputStream;
import ch.ethz.sis.openbis.generic.server.dssapi.v3.executor.ICreateUploadedDataSetExecutor;
import ch.ethz.sis.openbis.generic.server.dssapi.v3.pathinfo.PathInfoFeeder;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.filesystem.IFreeSpaceProvider;
import ch.systemsx.cisd.common.filesystem.SimpleFreeSpaceProvider;
import ch.systemsx.cisd.etlserver.path.IPathsInfoDAO;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.common.spring.IInvocationLoggerContext;
import ch.systemsx.cisd.openbis.dss.generic.server.AbstractDssServiceRpc;
import ch.systemsx.cisd.openbis.dss.generic.server.IStreamRepository;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks.IPluginTaskInfoProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IConfigProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IShareIdManager;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.authorization.DssSessionAuthorizationHolder;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.PathInfoDataSourceProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.RolesAllowed;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.plugin.query.shared.api.v1.IQueryApiServer;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import net.lemnik.eodsql.QueryTool;
import org.apache.commons.collections4.iterators.IteratorChain;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="data-store-server_INTERNAL")
public class DataStoreServerApi
extends AbstractDssServiceRpc<IDataStoreServerApi>
implements IDataStoreServerApi {
    @Autowired
    private IConfigProvider configProvider;
    @Autowired
    private IApplicationServerApi as;
    @Autowired
    private ICreateUploadedDataSetExecutor createUploadedDataSetExecutor;

    @Autowired
    public DataStoreServerApi(IEncapsulatedOpenBISService openBISService, IQueryApiServer apiServer, IPluginTaskInfoProvider infoProvider) {
        this(openBISService, apiServer, infoProvider, (IFreeSpaceProvider)new SimpleFreeSpaceProvider(), null, null);
    }

    DataStoreServerApi(IEncapsulatedOpenBISService openBISService, IQueryApiServer apiServer, IPluginTaskInfoProvider infoProvider, IFreeSpaceProvider freeSpaceProvider, IShareIdManager shareIdManager, IHierarchicalContentProvider contentProvider) {
        this(openBISService, apiServer, infoProvider, null, freeSpaceProvider, shareIdManager, contentProvider);
    }

    public DataStoreServerApi(IEncapsulatedOpenBISService openBISService, IQueryApiServer apiServer, IPluginTaskInfoProvider infoProvider, IStreamRepository streamRepository, IFreeSpaceProvider freeSpaceProvider, IShareIdManager shareIdManager, IHierarchicalContentProvider contentProvider) {
        super(openBISService, streamRepository, shareIdManager, contentProvider);
        this.operationLog.info((Object)"[rpc] Started DSS API V3 service.");
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    public SearchResult<DataSetFile> searchFiles(String sessionToken, DataSetFileSearchCriteria searchCriteria, DataSetFileFetchOptions fetchOptions) {
        this.getOpenBISService().checkSession(sessionToken);
        ArrayList<DataSetFile> result = new ArrayList<DataSetFile>();
        Collection criteria = searchCriteria.getCriteria();
        HashSet<String> resultDataSets = null;
        HashMap<String, DataSet> dataSetMap = new HashMap<String, DataSet>();
        String dataStoreCode = this.configProvider.getDataStoreCode();
        for (ISearchCriteria iSearchCriterion : criteria) {
            if (!(iSearchCriterion instanceof DataSetSearchCriteria)) continue;
            DataSetFetchOptions fo = new DataSetFetchOptions();
            fo.withDataStore();
            SearchResult searchResult = this.as.searchDataSets(sessionToken, (DataSetSearchCriteria)iSearchCriterion, fo);
            List dataSets = searchResult.getObjects();
            HashSet<String> codes = new HashSet<String>();
            for (DataSet dataSet : dataSets) {
                if (!dataStoreCode.equals(dataSet.getDataStore().getCode())) continue;
                codes.add(dataSet.getCode());
                dataSetMap.put(dataSet.getCode(), dataSet);
            }
            if (resultDataSets == null) {
                resultDataSets = codes;
                continue;
            }
            if (searchCriteria.getOperator().equals((Object)SearchOperator.OR)) {
                resultDataSets.addAll(codes);
                continue;
            }
            resultDataSets.retainAll(codes);
        }
        if (resultDataSets != null) {
            for (String code : resultDataSets) {
                IHierarchicalContent content = this.getHierarchicalContentProvider(sessionToken).asContent(code);
                for (IHierarchicalContentNode node : this.iterate(content.getRootNode())) {
                    DataSet dataSet = (DataSet)dataSetMap.get(code);
                    result.add(Utils.createDataSetFile(code, node, dataSet.getDataStore()));
                }
            }
        }
        return new SearchResult(result, result.size());
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    public FastDownloadSession createFastDownloadSession(String sessionToken, List<? extends IDataSetFileId> fileIds, FastDownloadSessionOptions options) {
        this.getOpenBISService().checkSession(sessionToken);
        ArrayList files = new ArrayList();
        for (Map.Entry<String, Set<String>> entry : this.sortFilesByDataSets(fileIds).entrySet()) {
            String dataSetCode = entry.getKey();
            DataSetPermId dataSetId = new DataSetPermId(dataSetCode);
            Status authorizationStatus = DssSessionAuthorizationHolder.getAuthorizer().checkDatasetAccess(sessionToken, dataSetCode);
            if (!authorizationStatus.isOK()) continue;
            files.addAll(entry.getValue().stream().map(p -> new DataSetFilePermId((IDataSetId)dataSetId, p)).collect(Collectors.toList()));
        }
        return new FastDownloadSession(this.getDownloadUrl(), sessionToken, files, options);
    }

    private String getDownloadUrl() {
        Properties serviceProperties = (Properties)ServiceProvider.getApplicationContext().getBean("configProperties");
        return serviceProperties.getProperty("download-url") + "/" + "datastore_server" + "/" + "file-transfer";
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    public InputStream downloadFiles(String sessionToken, List<? extends IDataSetFileId> fileIds, DataSetFileDownloadOptions downloadOptions) {
        this.getOpenBISService().checkSession(sessionToken);
        Map<String, Set<String>> filesByDataSet = this.sortFilesByDataSets(fileIds);
        IHierarchicalContentProvider contentProvider = this.getHierarchicalContentProvider(sessionToken);
        LinkedHashMap<IHierarchicalContentNode, String> contentNodes = new LinkedHashMap<IHierarchicalContentNode, String>();
        boolean recursive = downloadOptions.isRecursive();
        for (Map.Entry<String, Set<String>> entry : filesByDataSet.entrySet()) {
            String dataSetCode = entry.getKey();
            Status authorizationStatus = DssSessionAuthorizationHolder.getAuthorizer().checkDatasetAccess(sessionToken, dataSetCode);
            if (!authorizationStatus.isOK()) continue;
            IHierarchicalContent content = contentProvider.asContent(dataSetCode);
            IHierarchicalContentNode rootNode = content.getRootNode();
            TreeMap<String, IHierarchicalContentNode> nodesByPath = new TreeMap<String, IHierarchicalContentNode>();
            Set<String> paths = entry.getValue();
            this.populate(nodesByPath, rootNode, paths);
            for (String path : paths) {
                IHierarchicalContentNode node = (IHierarchicalContentNode)nodesByPath.get(path);
                if (node.isDirectory() && recursive) {
                    for (IHierarchicalContentNode child : this.iterate(node)) {
                        contentNodes.put(child, dataSetCode);
                    }
                    continue;
                }
                contentNodes.put(node, dataSetCode);
            }
        }
        return new DataSetFileDownloadInputStream(contentNodes);
    }

    private void populate(Map<String, IHierarchicalContentNode> nodesByPath, IHierarchicalContentNode node, Set<String> paths) {
        if (paths.contains(node.getRelativePath())) {
            nodesByPath.put(node.getRelativePath(), node);
        }
        if (node.isDirectory()) {
            List childNodes = node.getChildNodes();
            for (IHierarchicalContentNode childNode : childNodes) {
                this.populate(nodesByPath, childNode, paths);
            }
        }
    }

    private Map<String, Set<String>> sortFilesByDataSets(List<? extends IDataSetFileId> fileIds) {
        TreeMap<String, Set<String>> filesByDataSet = new TreeMap<String, Set<String>>();
        for (IDataSetFileId iDataSetFileId : fileIds) {
            String filePath;
            if (!(iDataSetFileId instanceof DataSetFilePermId)) {
                throw new IllegalArgumentException("Unsupported fileId: " + iDataSetFileId);
            }
            DataSetFilePermId filePermId = (DataSetFilePermId)iDataSetFileId;
            if (!(filePermId.getDataSetId() instanceof DataSetPermId)) {
                throw new IllegalArgumentException("Unsupported dataSetId: " + filePermId.getDataSetId());
            }
            String dataSetCode = ((DataSetPermId)filePermId.getDataSetId()).getPermId();
            TreeSet<String> ids = (TreeSet<String>)filesByDataSet.get(dataSetCode);
            if (ids == null) {
                ids = new TreeSet<String>();
                filesByDataSet.put(dataSetCode, ids);
            }
            ids.add((filePath = filePermId.getFilePath()) == null ? "" : filePath);
        }
        return filesByDataSet;
    }

    private Iterable<IHierarchicalContentNode> iterate(final IHierarchicalContentNode node) {
        return new Iterable<IHierarchicalContentNode>(){

            @Override
            public Iterator<IHierarchicalContentNode> iterator() {
                IteratorChain chain = new IteratorChain(Collections.singleton(node).iterator());
                if (node.isDirectory()) {
                    for (IHierarchicalContentNode child : node.getChildNodes()) {
                        chain.addIterator(DataStoreServerApi.this.iterate(child).iterator());
                    }
                }
                return chain;
            }
        };
    }

    public int getMajorVersion() {
        return 3;
    }

    public int getMinorVersion() {
        return 5;
    }

    public IDataStoreServerApi createLogger(IInvocationLoggerContext context) {
        return new DataStoreServerApiLogger(context);
    }

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_USER})
    public DataSetPermId createUploadedDataSet(String sessionToken, UploadedDataSetCreation creation) {
        return this.createUploadedDataSetExecutor.create(sessionToken, creation);
    }

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public List<DataSetPermId> createDataSets(String sessionToken, List<FullDataSetCreation> newDataSets) {
        if (!PathInfoDataSourceProvider.isDataSourceDefined()) {
            throw new IllegalStateException("Pathinfo DB not configured - cannot store dataset file information");
        }
        this.injectDataStoreIdAndCodesIfNeeded(newDataSets);
        IPathsInfoDAO dao = (IPathsInfoDAO)QueryTool.getQuery((DataSource)PathInfoDataSourceProvider.getDataSource(), IPathsInfoDAO.class);
        for (int i = 0; i < newDataSets.size(); ++i) {
            FullDataSetCreation fullDataSetCreation = newDataSets.get(i);
            List files = fullDataSetCreation.getFileMetadata();
            long dataSetId = dao.createDataSet(fullDataSetCreation.getMetadataCreation().getCode(), "");
            String dataSetCode = fullDataSetCreation.getMetadataCreation().getCode();
            PathInfoFeeder feeder = new PathInfoFeeder(dataSetId, dataSetCode, files);
            try {
                feeder.storeFilesWith(dao);
                continue;
            }
            catch (IllegalArgumentException e) {
                dao.rollback();
                dao.close();
                throw new UserFailureException(e.getMessage());
            }
        }
        dao.commit();
        dao.close();
        ArrayList<DataSetCreation> metadata = new ArrayList<DataSetCreation>();
        for (int i = 0; i < newDataSets.size(); ++i) {
            DataSetCreation creation = newDataSets.get(i).getMetadataCreation();
            metadata.add(creation);
        }
        return this.as.createDataSets(sessionToken, metadata);
    }

    private void injectDataStoreIdAndCodesIfNeeded(List<FullDataSetCreation> newDataSets) {
        String dataStoreCode = this.configProvider.getDataStoreCode();
        DataStorePermId dataStoreId = new DataStorePermId(dataStoreCode);
        int numberOfPermIdsToGenerate = 0;
        for (int i = 0; i < newDataSets.size(); ++i) {
            String code;
            FullDataSetCreation fullDataSetCreation = newDataSets.get(i);
            DataSetCreation metadataCreation = fullDataSetCreation.getMetadataCreation();
            IDataStoreId dsid = metadataCreation.getDataStoreId();
            if (dsid != null && dsid instanceof DataStorePermId && !dataStoreCode.equals(code = ((DataStorePermId)dsid).getPermId())) {
                throw new UserFailureException("Data store id specified for creation object with index " + i + " is '" + code + "' instead of '" + dataStoreCode + "' or undefined.");
            }
            metadataCreation.setDataStoreId((IDataStoreId)dataStoreId);
            if (metadataCreation.isAutoGeneratedCode()) {
                ++numberOfPermIdsToGenerate;
                continue;
            }
            if (StringUtils.isBlank((CharSequence)metadataCreation.getCode())) {
                throw new UserFailureException("Neither code nor auto generating code specified in creation object with index " + i);
            }
            metadataCreation.setCode(StringUtils.upperCase((String)metadataCreation.getCode()));
        }
        if (numberOfPermIdsToGenerate > 0) {
            List<String> permIds = this.getOpenBISService().createPermIds(numberOfPermIdsToGenerate);
            for (FullDataSetCreation newDataSet : newDataSets) {
                DataSetCreation metadataCreation = newDataSet.getMetadataCreation();
                if (!metadataCreation.isAutoGeneratedCode()) continue;
                metadataCreation.setCode(permIds.remove(0));
                metadataCreation.setAutoGeneratedCode(false);
            }
        }
    }
}

