/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.dssapi.v3;

import ch.ethz.sis.filetransfer.Chunk;
import ch.ethz.sis.filetransfer.DefaultSerializerProvider;
import ch.ethz.sis.filetransfer.DownloadException;
import ch.ethz.sis.filetransfer.DownloadItemId;
import ch.ethz.sis.filetransfer.DownloadItemNotFoundException;
import ch.ethz.sis.filetransfer.DownloadPreferences;
import ch.ethz.sis.filetransfer.DownloadRange;
import ch.ethz.sis.filetransfer.DownloadServer;
import ch.ethz.sis.filetransfer.DownloadServerConfig;
import ch.ethz.sis.filetransfer.DownloadSession;
import ch.ethz.sis.filetransfer.DownloadSessionId;
import ch.ethz.sis.filetransfer.DownloadState;
import ch.ethz.sis.filetransfer.DownloadStreamId;
import ch.ethz.sis.filetransfer.FileChunk;
import ch.ethz.sis.filetransfer.IChunkProvider;
import ch.ethz.sis.filetransfer.IConcurrencyProvider;
import ch.ethz.sis.filetransfer.IDownloadItemId;
import ch.ethz.sis.filetransfer.IDownloadServer;
import ch.ethz.sis.filetransfer.ILogger;
import ch.ethz.sis.filetransfer.ISerializerProvider;
import ch.ethz.sis.filetransfer.IUserSessionId;
import ch.ethz.sis.filetransfer.IUserSessionManager;
import ch.ethz.sis.filetransfer.InvalidUserSessionException;
import ch.ethz.sis.filetransfer.LogLevel;
import ch.ethz.sis.filetransfer.UserSessionId;
import ch.ethz.sis.openbis.generic.dssapi.v3.dto.datasetfile.fastdownload.FastDownloadMethod;
import ch.ethz.sis.openbis.generic.dssapi.v3.dto.datasetfile.fastdownload.FastDownloadParameter;
import ch.ethz.sis.openbis.generic.dssapi.v3.fastdownload.FastDownloadUtils;
import ch.ethz.sis.openbis.generic.server.dssapi.v3.Log4jBaseFileTransferLogger;
import ch.systemsx.cisd.common.action.IDelegatedAction;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.reflection.ClassUtils;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.generic.server.ApplicationContext;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataStoreServiceInternal;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.authorization.DssSessionAuthorizationHolder;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class FileTransferServerServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String SERVLET_NAME = "file-transfer";
    private static final String MAXIMUM_NUMBER_OF_ALLOWED_STREAMS_PROPERTY = "api.v3.fast-download.maximum-number-of-allowed-streams";
    private static final int DEFAULT_MAXIMUM_NUMBER_OF_ALLOWED_STREAMS = 50;
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, FileTransferServerServlet.class);
    private IDownloadServer downloadServer;
    private JsonFactory jsonFactory;
    private IDataStoreServiceInternal dataStoreService;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        ServletContext context = servletConfig.getServletContext();
        ApplicationContext applicationContext = (ApplicationContext)context.getAttribute("application-context");
        DownloadServerConfig config = new DownloadServerConfig();
        Log4jBaseFileTransferLogger logger = new Log4jBaseFileTransferLogger();
        config.setLogger((ILogger)logger);
        config.setSessionManager(new IUserSessionManager(){

            public void validateDuringDownload(IUserSessionId userSessionId) throws InvalidUserSessionException {
            }

            public void validateBeforeDownload(IUserSessionId userSessionId) throws InvalidUserSessionException {
            }
        });
        Properties properties = applicationContext.getConfigParameters().getProperties();
        config.setChunkProvider((IChunkProvider)new DataSetChunkProvider(applicationContext, 0x100000L, logger));
        config.setConcurrencyProvider((IConcurrencyProvider)new ConcurrencyProvider(properties));
        config.setSerializerProvider((ISerializerProvider)new DefaultSerializerProvider((ILogger)logger));
        this.downloadServer = new DownloadServer(config);
        this.jsonFactory = new JsonFactory();
        this.dataStoreService = ServiceProvider.getDataStoreService();
        operationLog.info((Object)"Servlet initialized");
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block6: {
            try {
                Map parameterMap = request.getParameterMap();
                String method = request.getParameter(FastDownloadParameter.METHOD_PARAMETER.getParameterName());
                if (FastDownloadMethod.START_DOWNLOAD_SESSION_METHOD.getMethodName().equals(method)) {
                    this.handleStartDownloadSession(parameterMap, response);
                    break block6;
                }
                if (FastDownloadMethod.QUEUE_METHOD.getMethodName().equals(method)) {
                    this.handleQueue(parameterMap, response);
                    break block6;
                }
                if (FastDownloadMethod.DOWNLOAD_METHOD.getMethodName().equals(method)) {
                    this.handleDownload(parameterMap, response);
                    break block6;
                }
                if (FastDownloadMethod.FINISH_DOWNLOAD_SESSION_METHOD.getMethodName().equals(method)) {
                    this.handleFinishDownloadSession(parameterMap, response);
                    break block6;
                }
                throw new IllegalArgumentException("Unknown method '" + method + "'.");
            }
            catch (Exception e) {
                response.setContentType("application/json");
                JsonGenerator jsonGenerator = this.jsonFactory.createGenerator((Writer)response.getWriter());
                FastDownloadUtils.renderAsJson((JsonGenerator)jsonGenerator, (Throwable)e);
                operationLog.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void handleStartDownloadSession(Map<String, String[]> parameterMap, HttpServletResponse response) throws ServletException, IOException {
        IUserSessionId userSessionId = this.getUserSessionId(parameterMap);
        String sessionToken = userSessionId.getId();
        List<IDownloadItemId> itemIds = this.filterByAccessRights(this.getDownloadItemIds(parameterMap), sessionToken);
        Integer wishedNumberOfStreams = this.getInteger(parameterMap, FastDownloadParameter.WISHED_NUMBER_OF_STREAMS_PARAMETER);
        DownloadPreferences preferences = new DownloadPreferences(wishedNumberOfStreams);
        DownloadSession downloadSession = this.downloadServer.startDownloadSession(userSessionId, itemIds, preferences);
        this.addCleanupAction(sessionToken, downloadSession);
        response.setContentType("application/json");
        JsonGenerator jsonGenerator = this.jsonFactory.createGenerator((Writer)response.getWriter());
        jsonGenerator.setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
        jsonGenerator.writeStartObject();
        jsonGenerator.writeObjectField(FastDownloadParameter.DOWNLOAD_SESSION_ID_PARAMETER.getParameterName(), (Object)downloadSession.getDownloadSessionId().getId());
        jsonGenerator.writeObjectFieldStart(FastDownloadParameter.RANGES_PARAMETER.getParameterName());
        for (Map.Entry entry : downloadSession.getRanges().entrySet()) {
            IDownloadItemId downloadItemId = (IDownloadItemId)entry.getKey();
            DownloadRange downloadRange = (DownloadRange)entry.getValue();
            jsonGenerator.writeObjectField(downloadItemId.getId(), (Object)(downloadRange.getStart() + ":" + downloadRange.getEnd()));
        }
        jsonGenerator.writeEndObject();
        jsonGenerator.writeArrayFieldStart("streamIds");
        for (DownloadStreamId streamId : downloadSession.getStreamIds()) {
            jsonGenerator.writeObject((Object)streamId.getId());
        }
        jsonGenerator.writeEndArray();
        jsonGenerator.writeEndObject();
        jsonGenerator.flush();
    }

    private void addCleanupAction(String sessionToken, DownloadSession downloadSession) {
        final DownloadSessionId downloadSessionId = downloadSession.getDownloadSessionId();
        this.dataStoreService.addCleanupAction(sessionToken, new IDelegatedAction(){

            public void execute() {
                FileTransferServerServlet.this.downloadServer.finishDownloadSession(downloadSessionId);
            }
        });
    }

    private List<IDownloadItemId> filterByAccessRights(List<IDownloadItemId> itemIds, String sessionToken) {
        ArrayList<IDownloadItemId> filteredIds = new ArrayList<IDownloadItemId>();
        HashSet<String> alreadyAccessApprovedDataSets = new HashSet<String>();
        for (IDownloadItemId itemId : itemIds) {
            String[] splitted = itemId.getId().split("/", 2);
            if (!this.canAccess(alreadyAccessApprovedDataSets, splitted[0], sessionToken)) continue;
            filteredIds.add(itemId);
        }
        return filteredIds;
    }

    private boolean canAccess(Set<String> alreadyAccessApprovedDataSets, String dataSetCode, String sessionToken) {
        if (alreadyAccessApprovedDataSets.contains(dataSetCode)) {
            return true;
        }
        Status authorizationStatus = DssSessionAuthorizationHolder.getAuthorizer().checkDatasetAccess(sessionToken, dataSetCode);
        if (!authorizationStatus.isOK()) {
            return false;
        }
        alreadyAccessApprovedDataSets.add(dataSetCode);
        return true;
    }

    private void handleQueue(Map<String, String[]> parameterMap, HttpServletResponse response) throws ServletException {
        DownloadSessionId downloadSessionId = this.getDownloadSessionId(parameterMap);
        ArrayList<DownloadRange> ranges = new ArrayList<DownloadRange>();
        for (String range : this.getParameters(parameterMap, FastDownloadParameter.RANGES_PARAMETER)) {
            try {
                String[] splitted = range.split(":");
                int start = Integer.parseInt(splitted[0]);
                int end = splitted.length == 1 ? start : Integer.parseInt(splitted[1]);
                ranges.add(new DownloadRange(start, end));
            }
            catch (NumberFormatException e) {
                throw new ServletException("Invalid range in parameter '" + FastDownloadParameter.RANGES_PARAMETER.getParameterName() + "': " + range);
            }
        }
        this.downloadServer.queue(downloadSessionId, ranges);
    }

    private void handleDownload(Map<String, String[]> parameterMap, HttpServletResponse response) throws ServletException, IOException {
        DownloadSessionId downloadSessionId = this.getDownloadSessionId(parameterMap);
        DownloadStreamId streamId = new DownloadStreamId();
        ClassUtils.setFieldValue((Object)streamId, (String)"id", (Object)this.getParameters(parameterMap, FastDownloadParameter.DOWNLOAD_STREAM_ID_PARAMETER).get(0));
        Integer numberOfChunksOrNull = this.getInteger(parameterMap, FastDownloadParameter.NUMBER_OF_CHUNKS_PARAMETER);
        InputStream stream = this.downloadServer.download(downloadSessionId, streamId, numberOfChunksOrNull);
        response.setContentType("application/octet-stream");
        IOUtils.copyLarge((InputStream)stream, (OutputStream)response.getOutputStream());
    }

    private void handleFinishDownloadSession(Map<String, String[]> parameterMap, HttpServletResponse response) throws ServletException {
        this.downloadServer.finishDownloadSession(this.getDownloadSessionId(parameterMap));
    }

    private IUserSessionId getUserSessionId(Map<String, String[]> parameterMap) throws ServletException {
        return new UserSessionId(this.getParameters(parameterMap, FastDownloadParameter.USER_SESSION_ID_PARAMETER).get(0));
    }

    private List<IDownloadItemId> getDownloadItemIds(Map<String, String[]> parameterMap) throws ServletException {
        return this.getParameters(parameterMap, FastDownloadParameter.DOWNLOAD_ITEM_IDS_PARAMETER).stream().map(DownloadItemId::new).collect(Collectors.toList());
    }

    private DownloadSessionId getDownloadSessionId(Map<String, String[]> parameterMap) throws ServletException {
        DownloadSessionId downloadSessionId = new DownloadSessionId();
        ClassUtils.setFieldValue((Object)downloadSessionId, (String)"id", (Object)this.getParameters(parameterMap, FastDownloadParameter.DOWNLOAD_SESSION_ID_PARAMETER).get(0));
        return downloadSessionId;
    }

    private List<String> getParameters(Map<String, String[]> parameterMap, FastDownloadParameter parameter) throws ServletException {
        String parameterName = parameter.getParameterName();
        String[] items = parameterMap.get(parameterName);
        if (items == null) {
            throw new ServletException("Unspecified parameter '" + parameterName + "'.");
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String item : items) {
            String[] splitted;
            for (String element : splitted = item.split(",")) {
                result.add(element.trim());
            }
        }
        return result;
    }

    private Integer getInteger(Map<String, String[]> parameterMap, FastDownloadParameter parameter) throws ServletException {
        String parameterName = parameter.getParameterName();
        String[] parameters = parameterMap.get(parameterName);
        if (parameters == null) {
            return null;
        }
        try {
            return new Integer(parameters[0]);
        }
        catch (NumberFormatException e) {
            throw new ServletException("Parameter '" + parameterName + "' is not an integer: " + parameters[0]);
        }
    }

    private static class InputStreamBasedChunk
    extends Chunk {
        private InputStream inputStream;
        private ILogger logger;

        public InputStreamBasedChunk(int sequenceNumber, IDownloadItemId downloadItemId, String filePath, long fileOffset, int payloadLength, InputStream inputStream, ILogger logger) {
            super(sequenceNumber, downloadItemId, false, filePath, fileOffset, payloadLength);
            this.inputStream = inputStream;
            this.logger = logger;
        }

        public InputStream getPayload() throws DownloadException {
            try {
                this.inputStream.skip(this.getFileOffset());
                int payloadLength = this.getPayloadLength();
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream(payloadLength);
                this.copyLarge(this.inputStream, outputStream, payloadLength, new byte[payloadLength]);
                return new ByteArrayInputStream(outputStream.toByteArray());
            }
            catch (IOException e) {
                DownloadException downloadException = new DownloadException("Can not get payload for chunk " + this.getSequenceNumber() + " staring at " + this.getFileOffset() + " of " + this.getFilePath(), (Throwable)e, Boolean.valueOf(false));
                this.logger.log(InputStreamBasedChunk.class, LogLevel.ERROR, downloadException.getMessage());
                throw downloadException;
            }
        }

        private long copyLarge(InputStream input, OutputStream output, long length, byte[] buffer) throws IOException {
            int read;
            int bufferLength;
            if (length == 0L) {
                return 0L;
            }
            int bytesToRead = bufferLength = buffer.length;
            if (length > 0L && length < (long)bufferLength) {
                bytesToRead = (int)length;
            }
            long totalRead = 0L;
            while (bytesToRead > 0 && -1 != (read = input.read(buffer, 0, bytesToRead))) {
                output.write(buffer, 0, read);
                totalRead += (long)read;
                if (length <= 0L) continue;
                bytesToRead = (int)Math.min(length - totalRead, (long)bufferLength);
            }
            return totalRead;
        }
    }

    private final class DataSetChunkProvider
    implements IChunkProvider {
        private final ILogger logger;
        private final ApplicationContext applicationContext;
        private long chunkSize;

        private DataSetChunkProvider(ApplicationContext applicationContext, long chunkSize, ILogger logger) {
            this.applicationContext = applicationContext;
            this.chunkSize = chunkSize;
            this.logger = logger;
        }

        public Map<IDownloadItemId, List<Chunk>> getChunks(List<IDownloadItemId> itemIds) throws DownloadItemNotFoundException, DownloadException {
            IHierarchicalContentProvider contentProvider = this.applicationContext.getHierarchicalContentProvider(null);
            HashMap<IDownloadItemId, List<Chunk>> result = new HashMap<IDownloadItemId, List<Chunk>>();
            AtomicInteger sequenceNumber = new AtomicInteger(0);
            for (IDownloadItemId itemId : itemIds) {
                String[] splitted = itemId.getId().split("/", 2);
                String dataSetCode = splitted[0];
                IHierarchicalContent content = contentProvider.asContent(dataSetCode);
                String path = splitted[1];
                IHierarchicalContentNode node = content.getNode(path);
                ArrayList<Chunk> chunks = new ArrayList<Chunk>();
                this.addChunks(chunks, sequenceNumber, node, itemId);
                result.put(itemId, chunks);
            }
            return result;
        }

        private void addChunks(List<Chunk> chunks, AtomicInteger sequenceNumber, IHierarchicalContentNode node, IDownloadItemId itemId) {
            boolean directory = node.isDirectory();
            boolean isH5ar = node.getName().endsWith(".h5ar");
            if (directory && !isH5ar) {
                for (IHierarchicalContentNode childNode : node.getChildNodes()) {
                    this.addChunks(chunks, sequenceNumber, childNode, itemId);
                }
            } else {
                long fileSize = isH5ar ? node.getFile().length() : node.getFileLength();
                long fileOffset = 0L;
                do {
                    int payloadLength = (int)(Math.min(fileOffset + this.chunkSize, fileSize) - fileOffset);
                    File file = node.tryGetFile();
                    Object chunk = file != null ? new FileChunk(sequenceNumber.getAndIncrement(), itemId, node.getRelativePath(), fileOffset, payloadLength, file.toPath(), this.logger) : new InputStreamBasedChunk(sequenceNumber.getAndIncrement(), itemId, node.getRelativePath(), fileOffset, payloadLength, node.getInputStream(), this.logger);
                    chunks.add((Chunk)chunk);
                } while ((fileOffset += this.chunkSize) < fileSize);
            }
        }
    }

    private final class ConcurrencyProvider
    implements IConcurrencyProvider {
        private int maximumNumberOfAllowedStreams;

        private ConcurrencyProvider(Properties properties) {
            this.maximumNumberOfAllowedStreams = PropertyUtils.getInt((Properties)properties, (String)FileTransferServerServlet.MAXIMUM_NUMBER_OF_ALLOWED_STREAMS_PROPERTY, (int)50);
            operationLog.info((Object)("max number of allowed streams: " + this.maximumNumberOfAllowedStreams));
        }

        public int getAllowedNumberOfStreams(IUserSessionId userSessionId, Integer wishedNumberOfStreams, List<DownloadState> downloadStates) throws DownloadException {
            int currentNumberOfStreams = downloadStates.stream().collect(Collectors.summingInt(DownloadState::getCurrentNumberOfStreams));
            int freeNumberOfStreams = this.maximumNumberOfAllowedStreams - currentNumberOfStreams;
            int allowedNumberOfStreams = freeNumberOfStreams / 2;
            if (wishedNumberOfStreams != null && wishedNumberOfStreams < allowedNumberOfStreams) {
                allowedNumberOfStreams = wishedNumberOfStreams;
            }
            operationLog.info((Object)("current number of streams: " + currentNumberOfStreams + ", wished number of streams: " + (wishedNumberOfStreams == null ? "unspecified" : wishedNumberOfStreams) + ", allowed number of streams: " + allowedNumberOfStreams));
            return allowedNumberOfStreams;
        }
    }
}

