/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.dssapi.v3.download;

import ch.ethz.sis.openbis.generic.dssapi.v3.dto.datasetfile.DataSetFile;
import ch.ethz.sis.openbis.generic.server.dssapi.v3.Utils;
import ch.systemsx.cisd.openbis.common.io.ConcatenatedContentInputStream;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;

public class DataSetFileDownloadInputStream
extends ConcatenatedContentInputStream {
    private Map<IHierarchicalContentNode, String> contentNodes;

    public DataSetFileDownloadInputStream(Map<IHierarchicalContentNode, String> contentNodes) {
        super(true, new ArrayList<IHierarchicalContentNode>(contentNodes.keySet()));
        this.contentNodes = contentNodes;
    }

    protected InputStream createHeaderSizeStream(IHierarchicalContentNode contentOrNull) throws IOException {
        if (contentOrNull == null) {
            return new ByteArrayInputStream(this.longToBytes(0L));
        }
        byte[] bytes = this.objectToBytes(this.createDto(contentOrNull));
        return new ByteArrayInputStream(this.longToBytes(bytes.length));
    }

    protected InputStream createHeaderStream(IHierarchicalContentNode contentOrNull) throws IOException {
        if (contentOrNull == null) {
            return DataSetFileDownloadInputStream.createEmptyStream();
        }
        byte[] bytes = this.objectToBytes(this.createDto(contentOrNull));
        return new ByteArrayInputStream(bytes);
    }

    private DataSetFile createDto(IHierarchicalContentNode content) {
        return Utils.createDataSetFile(this.contentNodes.get(content), content, null);
    }
}

