/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.dssapi.v3.executor;

import ch.ethz.sis.openbis.generic.asapi.v3.IApplicationServerApi;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.SearchResult;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.DataSet;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.DataSetType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.fetchoptions.DataSetFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.fetchoptions.DataSetTypeFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.DataSetPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.IDataSetId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.search.DataSetTypeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.Experiment;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.fetchoptions.ExperimentFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.Sample;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.fetchoptions.SampleFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.ObjectNotFoundException;
import ch.ethz.sis.openbis.generic.dssapi.v3.dto.dataset.create.UploadedDataSetCreation;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.OperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.utils.ExceptionUtils;
import ch.ethz.sis.openbis.generic.server.dssapi.v3.executor.ICreateUploadedDataSetExecutor;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.etlserver.api.v1.PutDataSetService;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.FileInfoDssDTO;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.NewDataSetDTO;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class CreateUploadedDataSetExecutor
implements ICreateUploadedDataSetExecutor {
    @Override
    public DataSetPermId create(String sessionToken, UploadedDataSetCreation creation) {
        try {
            this.getOpenBIService().checkSession(sessionToken);
            NewDataSetDTO newDataset = this.getNewDataSet(sessionToken, creation);
            List<DataSetInformation> dataSetInfos = this.getPutService().putDataSet(sessionToken, newDataset, creation.getUploadId());
            if (dataSetInfos != null && !dataSetInfos.isEmpty()) {
                return new DataSetPermId(dataSetInfos.get(0).getDataSetCode());
            }
            return null;
        }
        catch (IOException e) {
            throw ExceptionUtils.create((IOperationContext)new OperationContext(null), (Throwable)e);
        }
    }

    private NewDataSetDTO getNewDataSet(String sessionToken, UploadedDataSetCreation creation) throws IOException {
        NewDataSetDTO.DataSetOwner owner;
        NewDataSetDTO.DataSetOwnerType ownerType;
        SearchResult searchResult;
        ArrayList<String> parentCodes = new ArrayList<String>();
        if (creation.getTypeId() != null) {
            DataSetTypeSearchCriteria criteria = new DataSetTypeSearchCriteria();
            criteria.withId().thatEquals((IObjectId)creation.getTypeId());
            searchResult = this.getApplicationServerApi().searchDataSetTypes(sessionToken, criteria, new DataSetTypeFetchOptions());
            if (searchResult.getObjects() == null || searchResult.getObjects().isEmpty()) {
                throw new ObjectNotFoundException((IObjectId)creation.getTypeId());
            }
        } else {
            throw new UserFailureException("A dataset needs a type.");
        }
        DataSetType type = (DataSetType)searchResult.getObjects().get(0);
        String typeCode = type.getCode();
        if (creation.getSampleId() != null) {
            Map samples = this.getApplicationServerApi().getSamples(sessionToken, Arrays.asList(creation.getSampleId()), new SampleFetchOptions());
            Sample sample = (Sample)samples.get(creation.getSampleId());
            if (sample == null) {
                throw new ObjectNotFoundException((IObjectId)creation.getSampleId());
            }
            ownerType = NewDataSetDTO.DataSetOwnerType.SAMPLE;
            owner = new NewDataSetDTO.DataSetOwner(ownerType, sample.getIdentifier().getIdentifier());
        } else if (creation.getExperimentId() != null) {
            Map experiments = this.getApplicationServerApi().getExperiments(sessionToken, Arrays.asList(creation.getExperimentId()), new ExperimentFetchOptions());
            Experiment experiment = (Experiment)experiments.get(creation.getExperimentId());
            if (experiment == null) {
                throw new ObjectNotFoundException((IObjectId)creation.getExperimentId());
            }
            ownerType = NewDataSetDTO.DataSetOwnerType.EXPERIMENT;
            owner = new NewDataSetDTO.DataSetOwner(ownerType, experiment.getIdentifier().getIdentifier());
        } else {
            throw new UserFailureException("A dataset needs either a sample or an experiment as an owner.");
        }
        if (creation.getParentIds() != null && !creation.getParentIds().isEmpty()) {
            Map parents = this.getApplicationServerApi().getDataSets(sessionToken, creation.getParentIds(), new DataSetFetchOptions());
            for (IDataSetId parentId : creation.getParentIds()) {
                DataSet parent = (DataSet)parents.get(parentId);
                if (parent == null) {
                    throw new ObjectNotFoundException((IObjectId)parentId);
                }
                parentCodes.add(parent.getCode());
            }
        }
        NewDataSetDTO newDataSet = new NewDataSetDTO(typeCode, owner, null, new ArrayList<FileInfoDssDTO>());
        newDataSet.setProperties(creation.getProperties());
        newDataSet.setParentDataSetCodes(parentCodes);
        return newDataSet;
    }

    private IApplicationServerApi getApplicationServerApi() {
        return ServiceProvider.getV3ApplicationService();
    }

    private IEncapsulatedOpenBISService getOpenBIService() {
        return ServiceProvider.getOpenBISService();
    }

    private PutDataSetService getPutService() {
        return (PutDataSetService)ServiceProvider.getDataStoreService().getPutDataSetService();
    }
}

