/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.dssapi.v3.pathinfo;

import ch.ethz.sis.openbis.generic.server.dssapi.v3.pathinfo.DataSetContentNode;
import ch.ethz.sis.openbis.generic.server.dssapi.v3.pathinfo.FileNode;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

class DirectoryNode
implements DataSetContentNode {
    private final String parentPath;
    private final String name;
    private final String fullPath;
    private final Map<String, DataSetContentNode> children;

    public DirectoryNode(String parentPath, String name, Map<String, DataSetContentNode> children) {
        this.parentPath = parentPath;
        this.name = name;
        this.fullPath = parentPath == null ? name : parentPath + "/" + name;
        this.children = new HashMap<String, DataSetContentNode>();
        this.children.putAll(children);
    }

    public DirectoryNode(String parentPath, String name) {
        this(parentPath, name, new HashMap<String, DataSetContentNode>());
    }

    public DirectoryNode addFile(Path path, long length, Integer checksumCRC32, String checksum) {
        if (path.getParent() != null) {
            Path directoryName = path.getName(0);
            Path tail = path.subpath(1, path.getNameCount());
            DirectoryNode node = (DirectoryNode)this.children.get(directoryName.toString());
            if (node == null) {
                node = new DirectoryNode(this.getFullPath(), directoryName.toString());
            }
            return this.newNode(directoryName.toString(), node.addFile(tail, length, checksumCRC32, checksum));
        }
        if (this.children.containsKey(path.toString())) {
            throw new IllegalArgumentException("duplicate file: " + path.toString() + "/" + this.getFullPath());
        }
        return this.newNode(path.toString(), new FileNode(this.getFullPath(), path.toString(), length, checksumCRC32, checksum));
    }

    public DirectoryNode addDirectory(Path path) {
        if (path.getParent() != null) {
            Path directoryName = path.getName(0);
            Path tail = path.subpath(1, path.getNameCount());
            DirectoryNode node = (DirectoryNode)this.children.get(directoryName.toString());
            if (node == null) {
                node = new DirectoryNode(this.getFullPath(), directoryName.toString());
            }
            return this.newNode(directoryName.toString(), node.addDirectory(tail));
        }
        if (this.children.containsKey(path.toString())) {
            return this;
        }
        return this.newNode(path.toString(), new DirectoryNode(this.getFullPath(), path.toString()));
    }

    private DirectoryNode newNode(String nodeName, DataSetContentNode node) {
        HashMap<String, DataSetContentNode> newContent = new HashMap<String, DataSetContentNode>();
        newContent.putAll(this.children);
        newContent.put(nodeName, node);
        return new DirectoryNode(this.parentPath, this.name, newContent);
    }

    @Override
    public long getLength() {
        long result = 0L;
        for (DataSetContentNode node : this.children.values()) {
            result += node.getLength();
        }
        return result;
    }

    @Override
    public Integer getChecksumCRC32() {
        return null;
    }

    @Override
    public String getChecksum() {
        return null;
    }

    @Override
    public String getFullPath() {
        return this.fullPath;
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    Map<String, DataSetContentNode> getChildren() {
        return this.children;
    }
}

